/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import libcore.io.Memory;
import libcore.util.EmptyArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamClass
implements Serializable {
    private static final long serialVersionUID = -6120832682080437368L;
    private static final String UID_FIELD_NAME = "serialVersionUID";
    static final long CONSTRUCTOR_IS_NOT_RESOLVED = -1L;
    private static final int CLASS_MODIFIERS_MASK = 1553;
    private static final int FIELD_MODIFIERS_MASK = 223;
    private static final int METHOD_MODIFIERS_MASK = 3391;
    private static final Class<?>[] READ_PARAM_TYPES = new Class[]{ObjectInputStream.class};
    private static final Class<?>[] WRITE_PARAM_TYPES = new Class[]{ObjectOutputStream.class};
    public static final ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    static final Class<?> ARRAY_OF_FIELDS;
    private static final String CLINIT_NAME = "<clinit>";
    private static final int CLINIT_MODIFIERS = 8;
    private static final String CLINIT_SIGNATURE = "()V";
    private static final Class<Serializable> SERIALIZABLE;
    private static final Class<Externalizable> EXTERNALIZABLE;
    static final Class<String> STRINGCLASS;
    static final Class<?> CLASSCLASS;
    static final Class<ObjectStreamClass> OBJECTSTREAMCLASSCLASS;
    private transient Method methodWriteReplace;
    private transient Method methodReadResolve;
    private transient Method methodWriteObject;
    private transient Method methodReadObject;
    private transient Method methodReadObjectNoData;
    private transient boolean arePropertiesResolved;
    private transient boolean isSerializable;
    private transient boolean isExternalizable;
    private transient boolean isProxy;
    private transient boolean isEnum;
    private transient String className;
    private transient Class<?> resolvedClass;
    private transient Class<?> resolvedConstructorClass;
    private transient long resolvedConstructorMethodId;
    private transient long svUID;
    private transient byte flags;
    private transient ObjectStreamClass superclass;
    private transient ObjectStreamField[] fields;
    private transient ObjectStreamField[] loadFields;
    private transient HashMap<ObjectStreamField, Field> reflectionFields = new HashMap();
    private transient long constructor = -1L;
    private volatile transient List<ObjectStreamClass> cachedHierarchy;
    private static SoftReference<ThreadLocal<WeakHashMap<Class<?>, ObjectStreamClass>>> storage;

    void setConstructor(long newConstructor) {
        this.constructor = newConstructor;
    }

    long getConstructor() {
        return this.constructor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Field getReflectionField(ObjectStreamField osf) {
        Field field;
        HashMap<ObjectStreamField, Field> hashMap = this.reflectionFields;
        synchronized (hashMap) {
            field = this.reflectionFields.get(osf);
            if (field != null) {
                return field;
            }
        }
        try {
            Class<?> declaringClass = this.forClass();
            field = declaringClass.getDeclaredField(osf.getName());
            field.setAccessible(true);
            HashMap<ObjectStreamField, Field> hashMap2 = this.reflectionFields;
            synchronized (hashMap2) {
                this.reflectionFields.put(osf, field);
            }
            return this.reflectionFields.get(osf);
        }
        catch (NoSuchFieldException ex) {
            return null;
        }
    }

    ObjectStreamClass() {
    }

    private static ObjectStreamClass createClassDesc(Class<?> cl) {
        ObjectStreamClass result = new ObjectStreamClass();
        boolean isArray = cl.isArray();
        boolean serializable = ObjectStreamClass.isSerializable(cl);
        boolean externalizable = ObjectStreamClass.isExternalizable(cl);
        result.isSerializable = serializable;
        result.isExternalizable = externalizable;
        result.setName(cl.getName());
        result.setClass(cl);
        Class<?> superclass = cl.getSuperclass();
        if (superclass != null) {
            result.setSuperclass(ObjectStreamClass.lookup(superclass));
        }
        Field[] declaredFields = null;
        if (serializable || externalizable) {
            if (result.isEnum() || result.isProxy()) {
                result.setSerialVersionUID(0L);
            } else {
                declaredFields = cl.getDeclaredFields();
                result.setSerialVersionUID(ObjectStreamClass.computeSerialVersionUID(cl, declaredFields));
            }
        }
        if (serializable && !isArray) {
            if (declaredFields == null) {
                declaredFields = cl.getDeclaredFields();
            }
            result.buildFieldDescriptors(declaredFields);
        } else {
            result.setFields(NO_FIELDS);
        }
        ObjectStreamField[] fields = result.getFields();
        if (fields != null) {
            ObjectStreamField[] loadFields = new ObjectStreamField[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                loadFields[i] = new ObjectStreamField(fields[i].getName(), fields[i].getType(), fields[i].isUnshared());
                loadFields[i].getTypeString();
            }
            result.setLoadFields(loadFields);
        }
        byte flags = 0;
        if (externalizable) {
            flags = (byte)(flags | 4);
            flags = (byte)(flags | 8);
        } else if (serializable) {
            flags = (byte)(flags | 2);
        }
        result.methodWriteReplace = ObjectStreamClass.findMethod(cl, "writeReplace");
        result.methodReadResolve = ObjectStreamClass.findMethod(cl, "readResolve");
        result.methodWriteObject = ObjectStreamClass.findPrivateMethod(cl, "writeObject", WRITE_PARAM_TYPES);
        result.methodReadObject = ObjectStreamClass.findPrivateMethod(cl, "readObject", READ_PARAM_TYPES);
        result.methodReadObjectNoData = ObjectStreamClass.findPrivateMethod(cl, "readObjectNoData", EmptyArray.CLASS);
        if (result.hasMethodWriteObject()) {
            flags = (byte)(flags | 1);
        }
        result.setFlags(flags);
        return result;
    }

    void buildFieldDescriptors(Field[] declaredFields) {
        Field f = ObjectStreamClass.fieldSerialPersistentFields(this.forClass());
        boolean useReflectFields = f == null;
        Object[] _fields = null;
        if (!useReflectFields) {
            f.setAccessible(true);
            try {
                _fields = (ObjectStreamField[])f.get(null);
            }
            catch (IllegalAccessException ex) {
                throw new AssertionError((Object)ex);
            }
        } else {
            ArrayList<ObjectStreamField> serializableFields = new ArrayList<ObjectStreamField>(declaredFields.length);
            for (Field declaredField : declaredFields) {
                int modifiers = declaredField.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
                ObjectStreamField field = new ObjectStreamField(declaredField.getName(), declaredField.getType());
                serializableFields.add(field);
            }
            _fields = serializableFields.size() == 0 ? NO_FIELDS : serializableFields.toArray(new ObjectStreamField[serializableFields.size()]);
        }
        Arrays.sort(_fields);
        int primOffset = 0;
        int objectOffset = 0;
        for (int i = 0; i < _fields.length; ++i) {
            Class<?> type = ((ObjectStreamField)_fields[i]).getType();
            if (type.isPrimitive()) {
                ((ObjectStreamField)_fields[i]).offset = primOffset;
                primOffset += this.primitiveSize(type);
                continue;
            }
            ((ObjectStreamField)_fields[i]).offset = objectOffset++;
        }
        this.fields = _fields;
    }

    private static long computeSerialVersionUID(Class<?> cl, Field[] fields) {
        MessageDigest digest;
        for (int i = 0; i < fields.length; ++i) {
            int modifiers;
            Field field = fields[i];
            if (field.getType() != Long.TYPE || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isFinal(modifiers) || !UID_FIELD_NAME.equals(field.getName())) continue;
            field.setAccessible(true);
            try {
                return field.getLong(null);
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException("Error fetching SUID: " + iae);
            }
        }
        try {
            digest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        ByteArrayOutputStream sha = new ByteArrayOutputStream();
        try {
            Constructor<?>[] constructors;
            DataOutputStream output = new DataOutputStream(sha);
            output.writeUTF(cl.getName());
            int classModifiers = 0x611 & cl.getModifiers();
            boolean isArray = cl.isArray();
            if (isArray) {
                classModifiers |= 0x400;
            }
            if (cl.isInterface() && !Modifier.isPublic(classModifiers)) {
                classModifiers &= 0xFFFFFBFF;
            }
            output.writeInt(classModifiers);
            if (!isArray) {
                Class<?>[] interfaces = cl.getInterfaces();
                if (interfaces.length > 1) {
                    Comparator interfaceComparator = new Comparator<Class<?>>(){

                        @Override
                        public int compare(Class<?> itf1, Class<?> itf2) {
                            return itf1.getName().compareTo(itf2.getName());
                        }
                    };
                    Arrays.sort(interfaces, interfaceComparator);
                }
                for (int i = 0; i < interfaces.length; ++i) {
                    output.writeUTF(interfaces[i].getName());
                }
            }
            if (fields.length > 1) {
                Comparator<Field> fieldComparator = new Comparator<Field>(){

                    @Override
                    public int compare(Field field1, Field field2) {
                        return field1.getName().compareTo(field2.getName());
                    }
                };
                Arrays.sort(fields, fieldComparator);
            }
            for (int i = 0; i < fields.length; ++i) {
                boolean skip;
                Field field = fields[i];
                int modifiers = field.getModifiers() & 0xDF;
                boolean bl = skip = Modifier.isPrivate(modifiers) && (Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers));
                if (skip) continue;
                output.writeUTF(field.getName());
                output.writeInt(modifiers);
                output.writeUTF(ObjectStreamClass.descriptorForFieldSignature(ObjectStreamClass.getFieldSignature(field)));
            }
            if (ObjectStreamClass.hasClinit(cl)) {
                output.writeUTF(CLINIT_NAME);
                output.writeInt(8);
                output.writeUTF(CLINIT_SIGNATURE);
            }
            if ((constructors = cl.getDeclaredConstructors()).length > 1) {
                Comparator constructorComparator = new Comparator<Constructor<?>>(){

                    @Override
                    public int compare(Constructor<?> ctr1, Constructor<?> ctr2) {
                        return ObjectStreamClass.getConstructorSignature(ctr1).compareTo(ObjectStreamClass.getConstructorSignature(ctr2));
                    }
                };
                Arrays.sort(constructors, constructorComparator);
            }
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constructor = constructors[i];
                int modifiers = constructor.getModifiers() & 0xD3F;
                boolean isPrivate = Modifier.isPrivate(modifiers);
                if (isPrivate) continue;
                output.writeUTF("<init>");
                output.writeInt(modifiers);
                output.writeUTF(ObjectStreamClass.descriptorForSignature(ObjectStreamClass.getConstructorSignature(constructor)).replace('/', '.'));
            }
            Method[] methods = cl.getDeclaredMethods();
            if (methods.length > 1) {
                Comparator<Method> methodComparator = new Comparator<Method>(){

                    @Override
                    public int compare(Method m1, Method m2) {
                        int result = m1.getName().compareTo(m2.getName());
                        if (result == 0) {
                            return ObjectStreamClass.getMethodSignature(m1).compareTo(ObjectStreamClass.getMethodSignature(m2));
                        }
                        return result;
                    }
                };
                Arrays.sort(methods, methodComparator);
            }
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                int modifiers = method.getModifiers() & 0xD3F;
                boolean isPrivate = Modifier.isPrivate(modifiers);
                if (isPrivate) continue;
                output.writeUTF(method.getName());
                output.writeInt(modifiers);
                output.writeUTF(ObjectStreamClass.descriptorForSignature(ObjectStreamClass.getMethodSignature(method)).replace('/', '.'));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e + " computing SHA-1/SUID");
        }
        byte[] hash = digest.digest(sha.toByteArray());
        return Memory.peekLong(hash, 0, ByteOrder.LITTLE_ENDIAN);
    }

    private static String descriptorForFieldSignature(String signature) {
        return signature.replace('.', '/');
    }

    private static String descriptorForSignature(String signature) {
        return signature.substring(signature.indexOf("("));
    }

    static Field fieldSerialPersistentFields(Class<?> cl) {
        try {
            Field f = cl.getDeclaredField("serialPersistentFields");
            int modifiers = f.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isPrivate(modifiers) && Modifier.isFinal(modifiers) && f.getType() == ARRAY_OF_FIELDS) {
                return f;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    public Class<?> forClass() {
        return this.resolvedClass;
    }

    Object newInstance(Class<?> instantiationClass) throws InvalidClassException {
        this.resolveConstructorClass(instantiationClass);
        return ObjectStreamClass.newInstance(instantiationClass, this.resolvedConstructorMethodId);
    }

    private static native Object newInstance(Class<?> var0, long var1);

    private Class<?> resolveConstructorClass(Class<?> objectClass) throws InvalidClassException {
        boolean wasExternalizable;
        Class<?> constructorClass;
        boolean wasSerializable;
        if (this.resolvedConstructorClass != null) {
            return this.resolvedConstructorClass;
        }
        boolean bl = wasSerializable = (this.flags & 2) != 0;
        if (wasSerializable) {
            for (constructorClass = objectClass; constructorClass != null && ObjectStreamClass.isSerializable(constructorClass); constructorClass = constructorClass.getSuperclass()) {
            }
        }
        Constructor<?> constructor = null;
        if (constructorClass != null) {
            try {
                constructor = constructorClass.getDeclaredConstructor(EmptyArray.CLASS);
            }
            catch (NoSuchMethodException ignored) {
                // empty catch block
            }
        }
        if (constructor == null) {
            String className = constructorClass != null ? constructorClass.getName() : null;
            throw new InvalidClassException(className, "IllegalAccessException");
        }
        int constructorModifiers = constructor.getModifiers();
        boolean isPublic = Modifier.isPublic(constructorModifiers);
        boolean isProtected = Modifier.isProtected(constructorModifiers);
        boolean isPrivate = Modifier.isPrivate(constructorModifiers);
        boolean bl2 = wasExternalizable = (this.flags & 4) != 0;
        if (isPrivate || wasExternalizable && !isPublic) {
            throw new InvalidClassException(constructorClass.getName(), "IllegalAccessException");
        }
        if (!(isPublic || isProtected || this.inSamePackage(constructorClass, objectClass))) {
            throw new InvalidClassException(constructorClass.getName(), "IllegalAccessException");
        }
        this.resolvedConstructorClass = constructorClass;
        this.resolvedConstructorMethodId = ObjectStreamClass.getConstructorId(this.resolvedConstructorClass);
        return constructorClass;
    }

    private static native long getConstructorId(Class<?> var0);

    private boolean inSamePackage(Class<?> c1, Class<?> c2) {
        int indexDotC2;
        String nameC1 = c1.getName();
        String nameC2 = c2.getName();
        int indexDotC1 = nameC1.lastIndexOf(46);
        if (indexDotC1 != (indexDotC2 = nameC2.lastIndexOf(46))) {
            return false;
        }
        if (indexDotC1 == -1) {
            return true;
        }
        return nameC1.regionMatches(0, nameC2, 0, indexDotC1);
    }

    static native String getConstructorSignature(Constructor<?> var0);

    public ObjectStreamField getField(String name) {
        ObjectStreamField[] allFields = this.getFields();
        for (int i = 0; i < allFields.length; ++i) {
            ObjectStreamField f = allFields[i];
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    ObjectStreamField[] fields() {
        if (this.fields == null) {
            Class<?> forCl = this.forClass();
            if (forCl != null && this.isSerializable() && !forCl.isArray()) {
                this.buildFieldDescriptors(forCl.getDeclaredFields());
            } else {
                this.setFields(NO_FIELDS);
            }
        }
        return this.fields;
    }

    public ObjectStreamField[] getFields() {
        this.copyFieldAttributes();
        return this.loadFields == null ? (ObjectStreamField[])this.fields().clone() : (ObjectStreamField[])this.loadFields.clone();
    }

    List<ObjectStreamClass> getHierarchy() {
        List<ObjectStreamClass> result = this.cachedHierarchy;
        if (result == null) {
            this.cachedHierarchy = result = this.makeHierarchy();
        }
        return result;
    }

    private List<ObjectStreamClass> makeHierarchy() {
        ArrayList<ObjectStreamClass> result = new ArrayList<ObjectStreamClass>();
        for (ObjectStreamClass osc = this; osc != null; osc = osc.getSuperclass()) {
            result.add(0, osc);
        }
        return result;
    }

    private void copyFieldAttributes() {
        if (this.loadFields == null || this.fields == null) {
            return;
        }
        block0: for (int i = 0; i < this.loadFields.length; ++i) {
            ObjectStreamField loadField = this.loadFields[i];
            String name = loadField.getName();
            for (int j = 0; j < this.fields.length; ++j) {
                ObjectStreamField field = this.fields[j];
                if (!name.equals(field.getName())) continue;
                loadField.setUnshared(field.isUnshared());
                loadField.setOffset(field.getOffset());
                continue block0;
            }
        }
    }

    ObjectStreamField[] getLoadFields() {
        return this.loadFields;
    }

    private static native String getFieldSignature(Field var0);

    byte getFlags() {
        return this.flags;
    }

    static native String getMethodSignature(Method var0);

    public String getName() {
        return this.className;
    }

    public long getSerialVersionUID() {
        return this.svUID;
    }

    ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    private static native boolean hasClinit(Class<?> var0);

    static boolean isExternalizable(Class<?> cl) {
        return EXTERNALIZABLE.isAssignableFrom(cl);
    }

    static boolean isPrimitiveType(char typecode) {
        return typecode != '[' && typecode != 'L';
    }

    static boolean isSerializable(Class<?> cl) {
        return SERIALIZABLE.isAssignableFrom(cl);
    }

    private void resolveProperties() {
        if (this.arePropertiesResolved) {
            return;
        }
        Class<?> cl = this.forClass();
        this.isProxy = Proxy.isProxyClass(cl);
        this.isEnum = Enum.class.isAssignableFrom(cl);
        this.isSerializable = ObjectStreamClass.isSerializable(cl);
        this.isExternalizable = ObjectStreamClass.isExternalizable(cl);
        this.arePropertiesResolved = true;
    }

    boolean isSerializable() {
        this.resolveProperties();
        return this.isSerializable;
    }

    boolean isExternalizable() {
        this.resolveProperties();
        return this.isExternalizable;
    }

    boolean isProxy() {
        this.resolveProperties();
        return this.isProxy;
    }

    boolean isEnum() {
        this.resolveProperties();
        return this.isEnum;
    }

    public static ObjectStreamClass lookup(Class<?> cl) {
        ObjectStreamClass osc = ObjectStreamClass.lookupStreamClass(cl);
        return osc.isSerializable() || osc.isExternalizable() ? osc : null;
    }

    public static ObjectStreamClass lookupAny(Class<?> cl) {
        return ObjectStreamClass.lookupStreamClass(cl);
    }

    static ObjectStreamClass lookupStreamClass(Class<?> cl) {
        WeakHashMap<Class<?>, ObjectStreamClass> tlc = ObjectStreamClass.getCache();
        ObjectStreamClass cachedValue = tlc.get(cl);
        if (cachedValue == null) {
            cachedValue = ObjectStreamClass.createClassDesc(cl);
            tlc.put(cl, cachedValue);
        }
        return cachedValue;
    }

    private static WeakHashMap<Class<?>, ObjectStreamClass> getCache() {
        ThreadLocal tls = (ThreadLocal)storage.get();
        if (tls == null) {
            tls = new ThreadLocal<WeakHashMap<Class<?>, ObjectStreamClass>>(){

                @Override
                public WeakHashMap<Class<?>, ObjectStreamClass> initialValue() {
                    return new WeakHashMap();
                }
            };
            storage = new SoftReference<ThreadLocal>(tls);
        }
        return (WeakHashMap)tls.get();
    }

    static Method findMethod(Class<?> cl, String methodName) {
        Method method = null;
        for (Class<?> search = cl; search != null; search = search.getSuperclass()) {
            try {
                method = search.getDeclaredMethod(methodName, null);
                if (search != cl && (method.getModifiers() & 2) != 0) continue;
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException nsm) {
                // empty catch block
            }
        }
        return null;
    }

    static Method findPrivateMethod(Class<?> cl, String methodName, Class<?>[] param) {
        try {
            Method method = cl.getDeclaredMethod(methodName, param);
            if (Modifier.isPrivate(method.getModifiers()) && method.getReturnType() == Void.TYPE) {
                method.setAccessible(true);
                return method;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    boolean hasMethodWriteReplace() {
        return this.methodWriteReplace != null;
    }

    Method getMethodWriteReplace() {
        return this.methodWriteReplace;
    }

    boolean hasMethodReadResolve() {
        return this.methodReadResolve != null;
    }

    Method getMethodReadResolve() {
        return this.methodReadResolve;
    }

    boolean hasMethodWriteObject() {
        return this.methodWriteObject != null;
    }

    Method getMethodWriteObject() {
        return this.methodWriteObject;
    }

    boolean hasMethodReadObject() {
        return this.methodReadObject != null;
    }

    Method getMethodReadObject() {
        return this.methodReadObject;
    }

    boolean hasMethodReadObjectNoData() {
        return this.methodReadObjectNoData != null;
    }

    Method getMethodReadObjectNoData() {
        return this.methodReadObjectNoData;
    }

    void initPrivateFields(ObjectStreamClass desc) {
        this.methodWriteReplace = desc.methodWriteReplace;
        this.methodReadResolve = desc.methodReadResolve;
        this.methodWriteObject = desc.methodWriteObject;
        this.methodReadObject = desc.methodReadObject;
        this.methodReadObjectNoData = desc.methodReadObjectNoData;
    }

    void setClass(Class<?> c) {
        this.resolvedClass = c;
    }

    void setFields(ObjectStreamField[] f) {
        this.fields = f;
    }

    void setLoadFields(ObjectStreamField[] f) {
        this.loadFields = f;
    }

    void setFlags(byte b) {
        this.flags = b;
    }

    void setName(String newName) {
        this.className = newName;
    }

    void setSerialVersionUID(long l) {
        this.svUID = l;
    }

    void setSuperclass(ObjectStreamClass c) {
        this.superclass = c;
    }

    private int primitiveSize(Class<?> type) {
        if (type == Byte.TYPE || type == Boolean.TYPE) {
            return 1;
        }
        if (type == Short.TYPE || type == Character.TYPE) {
            return 2;
        }
        if (type == Integer.TYPE || type == Float.TYPE) {
            return 4;
        }
        if (type == Long.TYPE || type == Double.TYPE) {
            return 8;
        }
        throw new AssertionError();
    }

    public String toString() {
        return this.getName() + ": static final long serialVersionUID =" + this.getSerialVersionUID() + "L;";
    }

    static {
        try {
            ARRAY_OF_FIELDS = Class.forName("[Ljava.io.ObjectStreamField;");
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        SERIALIZABLE = Serializable.class;
        EXTERNALIZABLE = Externalizable.class;
        STRINGCLASS = String.class;
        CLASSCLASS = Class.class;
        OBJECTSTREAMCLASSCLASS = ObjectStreamClass.class;
        storage = new SoftReference<Object>(null);
    }
}

