/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FindBugsSuppressWarnings(value={"DM_NUMBER_CTOR"})
public final class Byte
extends Number
implements Comparable<Byte> {
    private static final long serialVersionUID = -7183698231559129828L;
    private final byte value;
    public static final byte MAX_VALUE = 127;
    public static final byte MIN_VALUE = -128;
    public static final int SIZE = 8;
    public static final Class<Byte> TYPE = byte[].class.getComponentType();
    private static final Byte[] VALUES = new Byte[256];

    public Byte(byte value) {
        this.value = value;
    }

    public Byte(String string2) throws NumberFormatException {
        this(Byte.parseByte(string2));
    }

    @Override
    public byte byteValue() {
        return this.value;
    }

    @Override
    public int compareTo(Byte object) {
        return Byte.compare(this.value, object.value);
    }

    public static int compare(byte lhs, byte rhs) {
        return lhs > rhs ? 1 : (lhs < rhs ? -1 : 0);
    }

    public static Byte decode(String string2) throws NumberFormatException {
        int intValue = Integer.decode(string2);
        byte result = (byte)intValue;
        if (result == intValue) {
            return result;
        }
        throw new NumberFormatException("Value out of range for byte: \"" + string2 + "\"");
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @FindBugsSuppressWarnings(value={"RC_REF_COMPARISON"})
    public boolean equals(Object object) {
        return object == this || object instanceof Byte && ((Byte)object).value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public static byte parseByte(String string2) throws NumberFormatException {
        return Byte.parseByte(string2, 10);
    }

    public static byte parseByte(String string2, int radix) throws NumberFormatException {
        int intValue = Integer.parseInt(string2, radix);
        byte result = (byte)intValue;
        if (result == intValue) {
            return result;
        }
        throw new NumberFormatException("Value out of range for byte: \"" + string2 + "\"");
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static String toHexString(byte b, boolean upperCase) {
        return IntegralToString.byteToHexString(b, upperCase);
    }

    public static String toString(byte value) {
        return Integer.toString(value);
    }

    public static Byte valueOf(String string2) throws NumberFormatException {
        return Byte.parseByte(string2);
    }

    public static Byte valueOf(String string2, int radix) throws NumberFormatException {
        return Byte.parseByte(string2, radix);
    }

    public static Byte valueOf(byte b) {
        return VALUES[b + 128];
    }

    static {
        for (int i = -128; i < 128; ++i) {
            Byte.VALUES[i + 128] = new Byte((byte)i);
        }
    }
}

