/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import com.android.dex.Dex;
import dalvik.system.VMStack;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import libcore.reflect.AnnotationAccess;
import libcore.reflect.GenericSignatureParser;
import libcore.reflect.InternalNames;
import libcore.reflect.Types;
import libcore.util.BasicLruCache;
import libcore.util.CollectionUtils;
import libcore.util.EmptyArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Class<T>
implements Serializable,
AnnotatedElement,
GenericDeclaration,
Type {
    private static final long serialVersionUID = 3206093459760846163L;
    private transient int dexClassDefIndex;
    private transient int dexTypeIndex;
    private volatile transient boolean dexIndicesInitialized;
    private transient String name;

    private Class() {
    }

    public native Dex getDex();

    private synchronized void computeDexIndices() {
        if (!this.dexIndicesInitialized) {
            Dex dex = this.getDex();
            this.dexTypeIndex = dex.findTypeIndex(InternalNames.getInternalName(this));
            if (this.dexTypeIndex < 0) {
                this.dexTypeIndex = -1;
                this.dexClassDefIndex = -1;
            } else {
                this.dexClassDefIndex = dex.findClassDefIndexFromTypeIndex(this.dexTypeIndex);
            }
            this.dexIndicesInitialized = true;
        }
    }

    public int getDexClassDefIndex() {
        if (!this.dexIndicesInitialized) {
            this.computeDexIndices();
        }
        return this.dexClassDefIndex;
    }

    public int getDexTypeIndex() {
        if (!this.dexIndicesInitialized) {
            this.computeDexIndices();
        }
        return this.dexTypeIndex;
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, VMStack.getCallingClassLoader());
    }

    public static Class<?> forName(String className, boolean shouldInitialize, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> result;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            result = Class.classForName(className, shouldInitialize, classLoader);
        }
        catch (ClassNotFoundException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ExceptionInInitializerError) {
                throw (ExceptionInInitializerError)cause;
            }
            throw e;
        }
        return result;
    }

    private static native Class<?> classForName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    public Class<?>[] getClasses() {
        Class<Object>[] result = Class.getDeclaredClasses(this, true);
        for (Class<T> c = this.getSuperclass(); c != null; c = c.getSuperclass()) {
            Class<T>[] temp = Class.getDeclaredClasses(c, true);
            if (temp.length == 0) continue;
            result = Class.arraycopy(new Class[result.length + temp.length], result, temp);
        }
        return result;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        A annotation = this.getDeclaredAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        if (annotationType.isAnnotationPresent(Inherited.class)) {
            for (Class<T> sup = this.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                annotation = super.getDeclaredAnnotation(annotationType);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        HashMap<Class<? extends Annotation>, Annotation> map = new HashMap<Class<? extends Annotation>, Annotation>();
        Annotation[] declaredAnnotations = this.getDeclaredAnnotations();
        for (int i = declaredAnnotations.length - 1; i >= 0; --i) {
            map.put(declaredAnnotations[i].annotationType(), declaredAnnotations[i]);
        }
        for (Class<T> sup = this.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
            declaredAnnotations = sup.getDeclaredAnnotations();
            for (int i = declaredAnnotations.length - 1; i >= 0; --i) {
                Class<? extends Annotation> clazz = declaredAnnotations[i].annotationType();
                if (map.containsKey(clazz) || !clazz.isAnnotationPresent(Inherited.class)) continue;
                map.put(clazz, declaredAnnotations[i]);
            }
        }
        Collection coll = map.values();
        return coll.toArray(new Annotation[coll.size()]);
    }

    public String getCanonicalName() {
        if (this.isLocalClass() || this.isAnonymousClass()) {
            return null;
        }
        if (this.isArray()) {
            String name = this.getComponentType().getCanonicalName();
            if (name != null) {
                return name + "[]";
            }
        } else if (this.isMemberClass()) {
            String name = this.getDeclaringClass().getCanonicalName();
            if (name != null) {
                return name + "." + this.getSimpleName();
            }
        } else {
            return this.getName();
        }
        return null;
    }

    public ClassLoader getClassLoader() {
        if (this.isPrimitive()) {
            return null;
        }
        ClassLoader loader = this.getClassLoaderImpl();
        if (loader == null) {
            loader = BootClassLoader.getInstance();
        }
        return loader;
    }

    ClassLoader getClassLoaderImpl() {
        ClassLoader loader = Class.getClassLoader(this);
        return loader == null ? BootClassLoader.getInstance() : loader;
    }

    private static native ClassLoader getClassLoader(Class<?> var0);

    public native Class<?> getComponentType();

    public Constructor<T> getConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException {
        return (Constructor)this.getConstructorOrMethod("<init>", false, true, parameterTypes);
    }

    private Member getConstructorOrMethod(String name, boolean searchSuperTypes, boolean publicOnly, Class<?>[] parameterTypes) throws NoSuchMethodException {
        Member result;
        if (searchSuperTypes && !publicOnly) {
            throw new AssertionError();
        }
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (parameterTypes == null) {
            parameterTypes = EmptyArray.CLASS;
        }
        for (Class<?> c : parameterTypes) {
            if (c != null) continue;
            throw new NoSuchMethodException("parameter type is null");
        }
        Member member = result = searchSuperTypes ? this.getPublicConstructorOrMethodRecursive(name, parameterTypes) : Class.getDeclaredConstructorOrMethod(this, name, parameterTypes);
        if (result == null || publicOnly && (result.getModifiers() & 1) == 0) {
            throw new NoSuchMethodException(name + " " + Arrays.toString(parameterTypes));
        }
        return result;
    }

    private Member getPublicConstructorOrMethodRecursive(String name, Class<?>[] parameterTypes) {
        Class<T> c;
        for (c = this; c != null; c = c.getSuperclass()) {
            Member result = Class.getDeclaredConstructorOrMethod(c, name, parameterTypes);
            if (result == null || (result.getModifiers() & 1) == 0) continue;
            return result;
        }
        for (c = this; c != null; c = c.getSuperclass()) {
            for (Class<?> ifc : c.getInterfaces()) {
                Member result = super.getPublicConstructorOrMethodRecursive(name, parameterTypes);
                if (result == null || (result.getModifiers() & 1) == 0) continue;
                return result;
            }
        }
        return null;
    }

    public Constructor<?>[] getConstructors() {
        return Class.getDeclaredConstructors(this, true);
    }

    @Override
    public native Annotation[] getDeclaredAnnotations();

    private native <A extends Annotation> A getDeclaredAnnotation(Class<A> var1);

    private native boolean isDeclaredAnnotationPresent(Class<? extends Annotation> var1);

    public Class<?>[] getDeclaredClasses() {
        return Class.getDeclaredClasses(this, false);
    }

    private static native Class<?>[] getDeclaredClasses(Class<?> var0, boolean var1);

    public Constructor<T> getDeclaredConstructor(Class<?> ... parameterTypes) throws NoSuchMethodException {
        return (Constructor)this.getConstructorOrMethod("<init>", false, false, parameterTypes);
    }

    public Constructor<?>[] getDeclaredConstructors() {
        return Class.getDeclaredConstructors(this, false);
    }

    private static native <T> Constructor<T>[] getDeclaredConstructors(Class<T> var0, boolean var1);

    public Field getDeclaredField(String name) throws NoSuchFieldException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        Field result = Class.getDeclaredField(this, name);
        if (result == null) {
            throw new NoSuchFieldException(name);
        }
        return result;
    }

    public Field[] getDeclaredFields() {
        return Class.getDeclaredFields(this, false);
    }

    static native Field[] getDeclaredFields(Class<?> var0, boolean var1);

    static native Field getDeclaredField(Class<?> var0, String var1);

    public Method getDeclaredMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Member member = this.getConstructorOrMethod(name, false, false, parameterTypes);
        if (member instanceof Constructor) {
            throw new NoSuchMethodException(name);
        }
        return (Method)member;
    }

    public Method[] getDeclaredMethods() {
        return Class.getDeclaredMethods(this, false);
    }

    static native Method[] getDeclaredMethods(Class<?> var0, boolean var1);

    static native Member getDeclaredConstructorOrMethod(Class var0, String var1, Class[] var2);

    public native Class<?> getDeclaringClass();

    public native Class<?> getEnclosingClass();

    public native Constructor<?> getEnclosingConstructor();

    public native Method getEnclosingMethod();

    public T[] getEnumConstants() {
        if (!this.isEnum()) {
            return null;
        }
        return (Object[])Enum.getSharedConstants((Class)this).clone();
    }

    public Field getField(String name) throws NoSuchFieldException {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        Field result = this.getPublicFieldRecursive(name);
        if (result == null) {
            throw new NoSuchFieldException(name);
        }
        return result;
    }

    private Field getPublicFieldRecursive(String name) {
        Class<T> c;
        for (c = this; c != null; c = c.getSuperclass()) {
            Field result = Class.getDeclaredField(c, name);
            if (result == null || (result.getModifiers() & 1) == 0) continue;
            return result;
        }
        for (c = this; c != null; c = c.getSuperclass()) {
            for (Class<?> ifc : c.getInterfaces()) {
                Field result = super.getPublicFieldRecursive(name);
                if (result == null || (result.getModifiers() & 1) == 0) continue;
                return result;
            }
        }
        return null;
    }

    public Field[] getFields() {
        ArrayList<Field> fields = new ArrayList<Field>();
        this.getPublicFieldsRecursive(fields);
        CollectionUtils.removeDuplicates(fields, Field.ORDER_BY_NAME_AND_DECLARING_CLASS);
        return fields.toArray(new Field[fields.size()]);
    }

    private void getPublicFieldsRecursive(List<Field> result) {
        Class<T> c;
        for (c = this; c != null; c = c.getSuperclass()) {
            for (AnnotatedElement annotatedElement : Class.getDeclaredFields(c, true)) {
                result.add((Field)annotatedElement);
            }
        }
        for (c = this; c != null; c = c.getSuperclass()) {
            for (AnnotatedElement annotatedElement : c.getInterfaces()) {
                super.getPublicFieldsRecursive(result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type[] getGenericInterfaces() {
        Type[] result;
        BasicLruCache basicLruCache = Caches.genericInterfaces;
        synchronized (basicLruCache) {
            result = (Type[])Caches.genericInterfaces.get(this);
            if (result == null) {
                String annotationSignature = AnnotationAccess.getSignature(this);
                if (annotationSignature == null) {
                    result = this.getInterfaces();
                } else {
                    GenericSignatureParser parser = new GenericSignatureParser(this.getClassLoader());
                    parser.parseForClass(this, annotationSignature);
                    result = Types.getTypeArray(parser.interfaceTypes, false);
                }
                Caches.genericInterfaces.put(this, result);
            }
        }
        return result.length == 0 ? result : (Type[])result.clone();
    }

    public Type getGenericSuperclass() {
        Type genericSuperclass = this.getSuperclass();
        if (genericSuperclass == null) {
            return null;
        }
        String annotationSignature = AnnotationAccess.getSignature(this);
        if (annotationSignature != null) {
            GenericSignatureParser parser = new GenericSignatureParser(this.getClassLoader());
            parser.parseForClass(this, annotationSignature);
            genericSuperclass = parser.superclassType;
        }
        return Types.getType(genericSuperclass);
    }

    public native Class<?>[] getInterfaces();

    public Method getMethod(String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Member member = this.getConstructorOrMethod(name, true, true, parameterTypes);
        if (member instanceof Constructor) {
            throw new NoSuchMethodException(name);
        }
        return (Method)member;
    }

    public Method[] getMethods() {
        ArrayList<Method> methods = new ArrayList<Method>();
        this.getPublicMethodsRecursive(methods);
        CollectionUtils.removeDuplicates(methods, Method.ORDER_BY_SIGNATURE);
        return methods.toArray(new Method[methods.size()]);
    }

    private void getPublicMethodsRecursive(List<Method> result) {
        Class<T> c;
        for (c = this; c != null; c = c.getSuperclass()) {
            for (AnnotatedElement annotatedElement : Class.getDeclaredMethods(c, true)) {
                result.add((Method)annotatedElement);
            }
        }
        for (c = this; c != null; c = c.getSuperclass()) {
            for (AnnotatedElement annotatedElement : c.getInterfaces()) {
                super.getPublicMethodsRecursive(result);
            }
        }
    }

    public int getModifiers() {
        return Class.getModifiers(this, false);
    }

    private static native int getModifiers(Class<?> var0, boolean var1);

    public String getName() {
        String result = this.name;
        return result == null ? (this.name = this.getNameNative()) : result;
    }

    private native String getNameNative();

    public String getSimpleName() {
        if (this.isArray()) {
            return this.getComponentType().getSimpleName() + "[]";
        }
        String name = this.getName();
        if (this.isAnonymousClass()) {
            return "";
        }
        if (this.isMemberClass() || this.isLocalClass()) {
            return this.getInnerClassName();
        }
        int dot = name.lastIndexOf(46);
        if (dot != -1) {
            return name.substring(dot + 1);
        }
        return name;
    }

    private native String getInnerClassName();

    public ProtectionDomain getProtectionDomain() {
        return null;
    }

    public URL getResource(String resourceName) {
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        } else {
            String pkg = this.getName();
            int dot = pkg.lastIndexOf(46);
            pkg = dot != -1 ? pkg.substring(0, dot).replace('.', '/') : "";
            resourceName = pkg + "/" + resourceName;
        }
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            return loader.getResource(resourceName);
        }
        return ClassLoader.getSystemResource(resourceName);
    }

    public InputStream getResourceAsStream(String resourceName) {
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        } else {
            String pkg = this.getName();
            int dot = pkg.lastIndexOf(46);
            pkg = dot != -1 ? pkg.substring(0, dot).replace('.', '/') : "";
            resourceName = pkg + "/" + resourceName;
        }
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            return loader.getResourceAsStream(resourceName);
        }
        return ClassLoader.getSystemResourceAsStream(resourceName);
    }

    public Object[] getSigners() {
        return null;
    }

    public native Class<? super T> getSuperclass();

    public synchronized TypeVariable<Class<T>>[] getTypeParameters() {
        String annotationSignature = AnnotationAccess.getSignature(this);
        if (annotationSignature == null) {
            return EmptyArray.TYPE_VARIABLE;
        }
        GenericSignatureParser parser = new GenericSignatureParser(this.getClassLoader());
        parser.parseForClass(this, annotationSignature);
        return parser.formalTypeParameters;
    }

    public boolean isAnnotation() {
        int ACC_ANNOTATION = 8192;
        int mod = Class.getModifiers(this, true);
        return (mod & 0x2000) != 0;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        if (this.isDeclaredAnnotationPresent(annotationType)) {
            return true;
        }
        if (super.isDeclaredAnnotationPresent(Inherited.class)) {
            for (Class<T> sup = this.getSuperclass(); sup != null; sup = sup.getSuperclass()) {
                if (!super.isDeclaredAnnotationPresent(annotationType)) continue;
                return true;
            }
        }
        return false;
    }

    public native boolean isAnonymousClass();

    public boolean isArray() {
        return this.getComponentType() != null;
    }

    public native boolean isAssignableFrom(Class<?> var1);

    public boolean isEnum() {
        if (this.getSuperclass() != Enum.class) {
            return false;
        }
        int mod = Class.getModifiers(this, true);
        return (mod & 0x4000) != 0;
    }

    public native boolean isInstance(Object var1);

    public native boolean isInterface();

    public boolean isLocalClass() {
        boolean enclosed = this.getEnclosingMethod() != null || this.getEnclosingConstructor() != null;
        return enclosed && !this.isAnonymousClass();
    }

    public boolean isMemberClass() {
        return this.getDeclaringClass() != null;
    }

    public native boolean isPrimitive();

    public boolean isSynthetic() {
        int ACC_SYNTHETIC = 4096;
        int mod = Class.getModifiers(this, true);
        return (mod & 0x1000) != 0;
    }

    public T newInstance() throws InstantiationException, IllegalAccessException {
        return this.newInstanceImpl();
    }

    private native T newInstanceImpl() throws IllegalAccessException, InstantiationException;

    public String toString() {
        if (this.isPrimitive()) {
            return this.getSimpleName();
        }
        return (this.isInterface() ? "interface " : "class ") + this.getName();
    }

    public Package getPackage() {
        ClassLoader loader = this.getClassLoader();
        if (loader != null) {
            String name = this.getName();
            int dot = name.lastIndexOf(46);
            return dot != -1 ? loader.getPackage(name.substring(0, dot)) : null;
        }
        return null;
    }

    public native boolean desiredAssertionStatus();

    public <U> Class<? extends U> asSubclass(Class<U> c) {
        if (c.isAssignableFrom(this)) {
            return this;
        }
        String actualClassName = this.getName();
        String desiredClassName = c.getName();
        throw new ClassCastException(actualClassName + " cannot be cast to " + desiredClassName);
    }

    public T cast(Object obj) {
        if (obj == null) {
            return null;
        }
        if (this.isInstance(obj)) {
            return (T)obj;
        }
        String actualClassName = obj.getClass().getName();
        String desiredClassName = this.getName();
        throw new ClassCastException(actualClassName + " cannot be cast to " + desiredClassName);
    }

    private static <T> T[] arraycopy(T[] result, T[] head, T[] tail) {
        System.arraycopy(head, 0, result, 0, head.length);
        System.arraycopy(tail, 0, result, head.length, tail.length);
        return result;
    }

    public int getDexAnnotationDirectoryOffset() {
        Dex dex = this.getDex();
        if (dex == null) {
            return 0;
        }
        int classDefIndex = this.getDexClassDefIndex();
        if (classDefIndex < 0) {
            return 0;
        }
        return dex.annotationDirectoryOffsetFromClassDefIndex(classDefIndex);
    }

    public Class<?> getDexCacheType(Dex dex, int typeIndex) {
        String internalName = dex.typeNames().get(typeIndex);
        return InternalNames.getClass(this.getClassLoader(), internalName);
    }

    public String getDexCacheString(Dex dex, int dexStringIndex) {
        return dex.strings().get(dexStringIndex);
    }

    private static class Caches {
        private static final BasicLruCache<Class, Type[]> genericInterfaces = new BasicLruCache(8);

        private Caches() {
        }
    }
}

