/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.system.PathClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoader {
    private ClassLoader parent;
    private Map<String, Package> packages = new HashMap<String, Package>();

    private static ClassLoader createSystemClassLoader() {
        String classPath = System.getProperty("java.class.path", ".");
        return new PathClassLoader(classPath, BootClassLoader.getInstance());
    }

    public static ClassLoader getSystemClassLoader() {
        return SystemClassLoader.loader;
    }

    public static URL getSystemResource(String resName) {
        return SystemClassLoader.loader.getResource(resName);
    }

    public static Enumeration<URL> getSystemResources(String resName) throws IOException {
        return SystemClassLoader.loader.getResources(resName);
    }

    public static InputStream getSystemResourceAsStream(String resName) {
        return SystemClassLoader.loader.getResourceAsStream(resName);
    }

    protected ClassLoader() {
        this(ClassLoader.getSystemClassLoader(), false);
    }

    protected ClassLoader(ClassLoader parentLoader) {
        this(parentLoader, false);
    }

    ClassLoader(ClassLoader parentLoader, boolean nullAllowed) {
        if (parentLoader == null && !nullAllowed) {
            throw new NullPointerException("parentLoader == null && !nullAllowed");
        }
        this.parent = parentLoader;
    }

    @Deprecated
    protected final Class<?> defineClass(byte[] classRep, int offset, int length) throws ClassFormatError {
        throw new UnsupportedOperationException("can't load this type of class file");
    }

    protected final Class<?> defineClass(String className, byte[] classRep, int offset, int length) throws ClassFormatError {
        throw new UnsupportedOperationException("can't load this type of class file");
    }

    protected final Class<?> defineClass(String className, byte[] classRep, int offset, int length, ProtectionDomain protectionDomain) throws ClassFormatError {
        throw new UnsupportedOperationException("can't load this type of class file");
    }

    protected final Class<?> defineClass(String name, ByteBuffer b, ProtectionDomain protectionDomain) throws ClassFormatError {
        byte[] temp = new byte[b.remaining()];
        b.get(temp);
        return this.defineClass(name, temp, 0, temp.length, protectionDomain);
    }

    protected Class<?> findClass(String className) throws ClassNotFoundException {
        throw new ClassNotFoundException(className);
    }

    protected final Class<?> findLoadedClass(String className) {
        ClassLoader loader = this == BootClassLoader.getInstance() ? null : this;
        return VMClassLoader.findLoadedClass(loader, className);
    }

    protected final Class<?> findSystemClass(String className) throws ClassNotFoundException {
        return Class.forName(className, false, ClassLoader.getSystemClassLoader());
    }

    public final ClassLoader getParent() {
        return this.parent;
    }

    public URL getResource(String resName) {
        URL resource = this.parent.getResource(resName);
        if (resource == null) {
            resource = this.findResource(resName);
        }
        return resource;
    }

    public Enumeration<URL> getResources(String resName) throws IOException {
        Enumeration<URL> first = this.parent.getResources(resName);
        Enumeration<URL> second = this.findResources(resName);
        return new TwoEnumerationsInOne(first, second);
    }

    public InputStream getResourceAsStream(String resName) {
        try {
            URL url = this.getResource(resName);
            if (url != null) {
                return url.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, false);
    }

    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(className);
        if (clazz == null) {
            try {
                clazz = this.parent.loadClass(className, false);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (clazz == null) {
                clazz = this.findClass(className);
            }
        }
        return clazz;
    }

    protected final void resolveClass(Class<?> clazz) {
    }

    protected URL findResource(String resName) {
        return null;
    }

    protected Enumeration<URL> findResources(String resName) throws IOException {
        return Collections.emptyEnumeration();
    }

    protected String findLibrary(String libName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package getPackage(String name) {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            return this.packages.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package[] getPackages() {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            Collection<Package> col = this.packages.values();
            Package[] result = new Package[col.size()];
            col.toArray(result);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) throws IllegalArgumentException {
        Map<String, Package> map = this.packages;
        synchronized (map) {
            if (this.packages.containsKey(name)) {
                throw new IllegalArgumentException("Package " + name + " already defined");
            }
            Package newPackage = new Package(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
            this.packages.put(name, newPackage);
            return newPackage;
        }
    }

    protected final void setSigners(Class<?> c, Object[] signers) {
    }

    public void setClassAssertionStatus(String cname, boolean enable) {
    }

    public void setPackageAssertionStatus(String pname, boolean enable) {
    }

    public void setDefaultAssertionStatus(boolean enable) {
    }

    public void clearAssertionStatus() {
    }

    static /* synthetic */ ClassLoader access$000() {
        return ClassLoader.createSystemClassLoader();
    }

    private static class SystemClassLoader {
        public static ClassLoader loader = ClassLoader.access$000();

        private SystemClassLoader() {
        }
    }
}

