/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class HexStringParser {
    private static final int DOUBLE_EXPONENT_WIDTH = 11;
    private static final int DOUBLE_MANTISSA_WIDTH = 52;
    private static final int FLOAT_EXPONENT_WIDTH = 8;
    private static final int FLOAT_MANTISSA_WIDTH = 23;
    private static final int HEX_RADIX = 16;
    private static final int MAX_SIGNIFICANT_LENGTH = 15;
    private static final String HEX_SIGNIFICANT = "0[xX](\\p{XDigit}+\\.?|\\p{XDigit}*\\.\\p{XDigit}+)";
    private static final String BINARY_EXPONENT = "[pP]([+-]?\\d+)";
    private static final String FLOAT_TYPE_SUFFIX = "[fFdD]?";
    private static final String HEX_PATTERN = "[\\x00-\\x20]*([+-]?)0[xX](\\p{XDigit}+\\.?|\\p{XDigit}*\\.\\p{XDigit}+)[pP]([+-]?\\d+)[fFdD]?[\\x00-\\x20]*";
    private static final Pattern PATTERN = Pattern.compile("[\\x00-\\x20]*([+-]?)0[xX](\\p{XDigit}+\\.?|\\p{XDigit}*\\.\\p{XDigit}+)[pP]([+-]?\\d+)[fFdD]?[\\x00-\\x20]*");
    private final int EXPONENT_WIDTH;
    private final int MANTISSA_WIDTH;
    private final long EXPONENT_BASE;
    private final long MAX_EXPONENT;
    private final long MIN_EXPONENT;
    private final long MANTISSA_MASK;
    private long sign;
    private long exponent;
    private long mantissa;
    private String abandonedNumber = "";

    public HexStringParser(int exponentWidth, int mantissaWidth) {
        this.EXPONENT_WIDTH = exponentWidth;
        this.MANTISSA_WIDTH = mantissaWidth;
        this.EXPONENT_BASE = -1L << exponentWidth - 1 ^ 0xFFFFFFFFFFFFFFFFL;
        this.MAX_EXPONENT = -1L << exponentWidth ^ 0xFFFFFFFFFFFFFFFFL;
        this.MIN_EXPONENT = -(this.MANTISSA_WIDTH + 1);
        this.MANTISSA_MASK = -1L << mantissaWidth ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static double parseDouble(String hexString) {
        HexStringParser parser = new HexStringParser(11, 52);
        long result = parser.parse(hexString, true);
        return Double.longBitsToDouble(result);
    }

    public static float parseFloat(String hexString) {
        HexStringParser parser = new HexStringParser(8, 23);
        int result = (int)parser.parse(hexString, false);
        return Float.intBitsToFloat(result);
    }

    private long parse(String hexString, boolean isDouble) {
        Matcher matcher = PATTERN.matcher(hexString);
        if (!matcher.matches()) {
            throw new NumberFormatException("Invalid hex " + (isDouble ? "double" : "float") + ":" + hexString);
        }
        String signStr = matcher.group(1);
        String significantStr = matcher.group(2);
        String exponentStr = matcher.group(3);
        this.parseHexSign(signStr);
        this.parseExponent(exponentStr);
        this.parseMantissa(significantStr);
        this.sign <<= this.MANTISSA_WIDTH + this.EXPONENT_WIDTH;
        this.exponent <<= this.MANTISSA_WIDTH;
        return this.sign | this.exponent | this.mantissa;
    }

    private void parseHexSign(String signStr) {
        this.sign = signStr.equals("-") ? 1L : 0L;
    }

    private void parseExponent(String exponentStr) {
        int expSign;
        char leadingChar = exponentStr.charAt(0);
        int n = expSign = leadingChar == '-' ? -1 : 1;
        if (!Character.isDigit(leadingChar)) {
            exponentStr = exponentStr.substring(1);
        }
        try {
            this.exponent = (long)expSign * Long.parseLong(exponentStr);
            this.checkedAddExponent(this.EXPONENT_BASE);
        }
        catch (NumberFormatException e) {
            this.exponent = (long)expSign * Long.MAX_VALUE;
        }
    }

    private void parseMantissa(String significantStr) {
        String strDecimalPart;
        String[] strings = significantStr.split("\\.");
        String strIntegerPart = strings[0];
        String significand = this.getNormalizedSignificand(strIntegerPart, strDecimalPart = strings.length > 1 ? strings[1] : "");
        if (significand.equals("0")) {
            this.setZero();
            return;
        }
        int offset = this.getOffset(strIntegerPart, strDecimalPart);
        this.checkedAddExponent(offset);
        if (this.exponent >= this.MAX_EXPONENT) {
            this.setInfinite();
            return;
        }
        if (this.exponent <= this.MIN_EXPONENT) {
            this.setZero();
            return;
        }
        if (significand.length() > 15) {
            this.abandonedNumber = significand.substring(15);
            significand = significand.substring(0, 15);
        }
        this.mantissa = Long.parseLong(significand, 16);
        if (this.exponent >= 1L) {
            this.processNormalNumber();
        } else {
            this.processSubNormalNumber();
        }
    }

    private void setInfinite() {
        this.exponent = this.MAX_EXPONENT;
        this.mantissa = 0L;
    }

    private void setZero() {
        this.exponent = 0L;
        this.mantissa = 0L;
    }

    private void checkedAddExponent(long offset) {
        long result = this.exponent + offset;
        int expSign = Long.signum(this.exponent);
        this.exponent = expSign * Long.signum(offset) > 0 && expSign * Long.signum(result) < 0 ? (long)expSign * Long.MAX_VALUE : result;
    }

    private void processNormalNumber() {
        int desiredWidth = this.MANTISSA_WIDTH + 2;
        this.fitMantissaInDesiredWidth(desiredWidth);
        this.round();
        this.mantissa &= this.MANTISSA_MASK;
    }

    private void processSubNormalNumber() {
        int desiredWidth = this.MANTISSA_WIDTH + 1;
        this.exponent = 0L;
        this.fitMantissaInDesiredWidth(desiredWidth += (int)this.exponent);
        this.round();
        this.mantissa &= this.MANTISSA_MASK;
    }

    private void fitMantissaInDesiredWidth(int desiredWidth) {
        int bitLength = this.countBitsLength(this.mantissa);
        if (bitLength > desiredWidth) {
            this.discardTrailingBits(bitLength - desiredWidth);
        } else {
            this.mantissa <<= desiredWidth - bitLength;
        }
    }

    private void discardTrailingBits(long num) {
        long mask = -1L << (int)num ^ 0xFFFFFFFFFFFFFFFFL;
        this.abandonedNumber = this.abandonedNumber + (this.mantissa & mask);
        this.mantissa >>= (int)num;
    }

    private void round() {
        String result = this.abandonedNumber.replaceAll("0+", "");
        boolean moreThanZero = result.length() > 0;
        int lastDiscardedBit = (int)(this.mantissa & 1L);
        this.mantissa >>= 1;
        int tailBitInMantissa = (int)(this.mantissa & 1L);
        if (lastDiscardedBit == 1 && (moreThanZero || tailBitInMantissa == 1)) {
            int oldLength = this.countBitsLength(this.mantissa);
            ++this.mantissa;
            int newLength = this.countBitsLength(this.mantissa);
            if (oldLength >= this.MANTISSA_WIDTH && newLength > oldLength) {
                this.checkedAddExponent(1L);
            }
        }
    }

    private String getNormalizedSignificand(String strIntegerPart, String strDecimalPart) {
        String significand = strIntegerPart + strDecimalPart;
        if ((significand = significand.replaceFirst("^0+", "")).length() == 0) {
            significand = "0";
        }
        return significand;
    }

    private int getOffset(String strIntegerPart, String strDecimalPart) {
        int i;
        if ((strIntegerPart = strIntegerPart.replaceFirst("^0+", "")).length() != 0) {
            String leadingNumber = strIntegerPart.substring(0, 1);
            return (strIntegerPart.length() - 1) * 4 + this.countBitsLength(Long.parseLong(leadingNumber, 16)) - 1;
        }
        for (i = 0; i < strDecimalPart.length() && strDecimalPart.charAt(i) == '0'; ++i) {
        }
        if (i == strDecimalPart.length()) {
            return 0;
        }
        String leadingNumber = strDecimalPart.substring(i, i + 1);
        return (-i - 1) * 4 + this.countBitsLength(Long.parseLong(leadingNumber, 16)) - 1;
    }

    private int countBitsLength(long value) {
        int leadingZeros = Long.numberOfLeadingZeros(value);
        return 64 - leadingZeros;
    }
}

