/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.system.VMStack;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package
implements AnnotatedElement {
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private final String name;
    private final String specTitle;
    private final String specVersion;
    private final String specVendor;
    private final String implTitle;
    private final String implVersion;
    private final String implVendor;
    private final URL sealBase;

    Package(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        this.name = name;
        this.specTitle = specTitle;
        this.specVersion = specVersion;
        this.specVendor = specVendor;
        this.implTitle = implTitle;
        this.implVersion = implVersion;
        this.implVendor = implVendor;
        this.sealBase = sealBase;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        for (Annotation annotation : this.getAnnotations()) {
            if (!annotationType.isInstance(annotation)) continue;
            return (A)annotation;
        }
        return null;
    }

    @Override
    public Annotation[] getAnnotations() {
        try {
            Class<?> c = Class.forName(this.getName() + ".package-info");
            return c.getAnnotations();
        }
        catch (Exception ex) {
            return NO_ANNOTATIONS;
        }
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation((Class)annotationType) != null;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getName() {
        return this.name;
    }

    public static Package getPackage(String packageName) {
        ClassLoader classloader = VMStack.getCallingClassLoader();
        if (classloader == null) {
            classloader = ClassLoader.getSystemClassLoader();
        }
        return classloader.getPackage(packageName);
    }

    public static Package[] getPackages() {
        ClassLoader classloader = VMStack.getCallingClassLoader();
        if (classloader == null) {
            classloader = ClassLoader.getSystemClassLoader();
        }
        return classloader.getPackages();
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isCompatibleWith(String version) throws NumberFormatException {
        String[] requested = version.split("\\.");
        String[] provided = this.specVersion.split("\\.");
        for (int i = 0; i < Math.min(requested.length, provided.length); ++i) {
            int provNum;
            int reqNum = Integer.parseInt(requested[i]);
            if (reqNum > (provNum = Integer.parseInt(provided[i]))) {
                return false;
            }
            if (reqNum >= provNum) continue;
            return true;
        }
        return requested.length <= provided.length;
    }

    public boolean isSealed() {
        return this.sealBase != null;
    }

    public boolean isSealed(URL url) {
        return this.sealBase != null && this.sealBase.sameFile(url);
    }

    public String toString() {
        return "package " + this.name;
    }
}

