/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import libcore.math.MathUtils;

final class RealToString {
    private static final ThreadLocal<RealToString> INSTANCE = new ThreadLocal<RealToString>(){

        @Override
        protected RealToString initialValue() {
            return new RealToString();
        }
    };
    private static final double invLogOfTenBaseTwo = Math.log(2.0) / Math.log(10.0);
    private int firstK;
    private final int[] digits = new int[64];
    private int digitCount;

    private RealToString() {
    }

    public static RealToString getInstance() {
        return INSTANCE.get();
    }

    private static String resultOrSideEffect(AbstractStringBuilder sb, String s) {
        if (sb != null) {
            sb.append0(s);
            return null;
        }
        return s;
    }

    public String doubleToString(double d) {
        return this.convertDouble(null, d);
    }

    public void appendDouble(AbstractStringBuilder sb, double d) {
        this.convertDouble(sb, d);
    }

    private String convertDouble(AbstractStringBuilder sb, double inputNumber) {
        AbstractStringBuilder dst;
        int pow;
        long inputNumberBits = Double.doubleToRawLongBits(inputNumber);
        boolean positive = (inputNumberBits & Long.MIN_VALUE) == 0L;
        int e = (int)((inputNumberBits & 0x7FF0000000000000L) >> 52);
        long f = inputNumberBits & 0xFFFFFFFFFFFFFL;
        boolean mantissaIsZero = f == 0L;
        String quickResult = null;
        if (e == 2047) {
            quickResult = mantissaIsZero ? (positive ? "Infinity" : "-Infinity") : "NaN";
        } else if (e == 0) {
            if (mantissaIsZero) {
                quickResult = positive ? "0.0" : "-0.0";
            } else if (f == 1L) {
                String string2 = quickResult = positive ? "4.9E-324" : "-4.9E-324";
            }
        }
        if (quickResult != null) {
            return RealToString.resultOrSideEffect(sb, quickResult);
        }
        int p = 1075;
        int numBits = 52;
        if (e == 0) {
            pow = 1 - p;
            long ff = f;
            while ((ff & 0x10000000000000L) == 0L) {
                ff <<= 1;
                --numBits;
            }
        } else {
            f |= 0x10000000000000L;
            pow = e - p;
        }
        this.digitCount = 0;
        this.firstK = 0;
        if (-59 < pow && pow < 6 || pow == -59 && !mantissaIsZero) {
            this.longDigitGenerator(f, pow, e == 0, mantissaIsZero, numBits);
        } else {
            this.bigIntDigitGenerator(f, pow, e == 0, numBits);
        }
        AbstractStringBuilder abstractStringBuilder = dst = sb != null ? sb : new StringBuilder(26);
        if (inputNumber >= 1.0E7 || inputNumber <= -1.0E7 || inputNumber > -0.001 && inputNumber < 0.001) {
            this.freeFormatExponential(dst, positive);
        } else {
            this.freeFormat(dst, positive);
        }
        return sb != null ? null : dst.toString();
    }

    public String floatToString(float f) {
        return this.convertFloat(null, f);
    }

    public void appendFloat(AbstractStringBuilder sb, float f) {
        this.convertFloat(sb, f);
    }

    public String convertFloat(AbstractStringBuilder sb, float inputNumber) {
        AbstractStringBuilder dst;
        int pow;
        int inputNumberBits = Float.floatToRawIntBits(inputNumber);
        boolean positive = (inputNumberBits & Integer.MIN_VALUE) == 0;
        int e = (inputNumberBits & 0x7F800000) >> 23;
        int f = inputNumberBits & 0x7FFFFF;
        boolean mantissaIsZero = f == 0;
        String quickResult = null;
        if (e == 255) {
            quickResult = mantissaIsZero ? (positive ? "Infinity" : "-Infinity") : "NaN";
        } else if (e == 0 && mantissaIsZero) {
            String string2 = quickResult = positive ? "0.0" : "-0.0";
        }
        if (quickResult != null) {
            return RealToString.resultOrSideEffect(sb, quickResult);
        }
        int p = 150;
        int numBits = 23;
        if (e == 0) {
            pow = 1 - p;
            if (f < 8) {
                f <<= 2;
                pow -= 2;
            }
            int ff = f;
            while ((ff & 0x800000) == 0) {
                ff <<= 1;
                --numBits;
            }
        } else {
            f |= 0x800000;
            pow = e - p;
        }
        this.digitCount = 0;
        this.firstK = 0;
        if (-59 < pow && pow < 35 || pow == -59 && !mantissaIsZero) {
            this.longDigitGenerator(f, pow, e == 0, mantissaIsZero, numBits);
        } else {
            this.bigIntDigitGenerator(f, pow, e == 0, numBits);
        }
        AbstractStringBuilder abstractStringBuilder = dst = sb != null ? sb : new StringBuilder(26);
        if (inputNumber >= 1.0E7f || inputNumber <= -1.0E7f || inputNumber > -0.001f && inputNumber < 0.001f) {
            this.freeFormatExponential(dst, positive);
        } else {
            this.freeFormat(dst, positive);
        }
        return sb != null ? null : dst.toString();
    }

    private void freeFormatExponential(AbstractStringBuilder sb, boolean positive) {
        int k;
        int digitIndex = 0;
        if (!positive) {
            sb.append0('-');
        }
        sb.append0((char)(48 + this.digits[digitIndex++]));
        sb.append0('.');
        int exponent = k = this.firstK;
        while (true) {
            --k;
            if (digitIndex >= this.digitCount) break;
            sb.append0((char)(48 + this.digits[digitIndex++]));
        }
        if (k == exponent - 1) {
            sb.append0('0');
        }
        sb.append0('E');
        IntegralToString.appendInt(sb, exponent);
    }

    private void freeFormat(AbstractStringBuilder sb, boolean positive) {
        int k;
        int digitIndex = 0;
        if (!positive) {
            sb.append0('-');
        }
        if ((k = this.firstK) < 0) {
            sb.append0('0');
            sb.append0('.');
            for (int i = k + 1; i < 0; ++i) {
                sb.append0('0');
            }
        }
        int U = this.digits[digitIndex++];
        do {
            if (U != -1) {
                sb.append0((char)(48 + U));
            } else if (k >= -1) {
                sb.append0('0');
            }
            if (k != 0) continue;
            sb.append0('.');
        } while ((U = digitIndex < this.digitCount ? this.digits[digitIndex++] : -1) != -1 || --k >= -1);
    }

    private native void bigIntDigitGenerator(long var1, int var3, boolean var4, int var5);

    private void longDigitGenerator(long f, int e, boolean isDenormalized, boolean mantissaIsZero, int p) {
        boolean high;
        boolean low;
        int U;
        long S;
        long R2;
        long M;
        if (e >= 0) {
            M = 1L << e;
            if (!mantissaIsZero) {
                R2 = f << e + 1;
                S = 2L;
            } else {
                R2 = f << e + 2;
                S = 4L;
            }
        } else {
            M = 1L;
            if (isDenormalized || !mantissaIsZero) {
                R2 = f << 1;
                S = 1L << 1 - e;
            } else {
                R2 = f << 2;
                S = 1L << 2 - e;
            }
        }
        int k = (int)Math.ceil((double)(e + p - 1) * invLogOfTenBaseTwo - 1.0E-10);
        if (k > 0) {
            S *= MathUtils.LONG_POWERS_OF_TEN[k];
        } else if (k < 0) {
            long scale = MathUtils.LONG_POWERS_OF_TEN[-k];
            R2 *= scale;
            long l = M = M == 1L ? scale : M * scale;
        }
        if (R2 + M > S) {
            this.firstK = k;
        } else {
            this.firstK = k - 1;
            R2 *= 10L;
            M *= 10L;
        }
        while (true) {
            U = 0;
            for (int i = 3; i >= 0; --i) {
                long remainder = R2 - (S << i);
                if (remainder < 0L) continue;
                R2 = remainder;
                U += 1 << i;
            }
            low = R2 < M;
            boolean bl = high = R2 + M > S;
            if (low || high) break;
            R2 *= 10L;
            M *= 10L;
            this.digits[this.digitCount++] = U;
        }
        this.digits[this.digitCount++] = low && !high ? U : (high && !low ? U + 1 : (R2 << 1 < S ? U : U + 1));
    }
}

