/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.system.BaseDexClassLoader;
import dalvik.system.VMDebug;
import dalvik.system.VMStack;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.FinalizerReference;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import libcore.io.IoUtils;
import libcore.io.Libcore;
import libcore.io.OsConstants;
import libcore.util.EmptyArray;

public class Runtime {
    private static final Runtime mRuntime = new Runtime();
    private final String[] mLibPaths = Runtime.initLibPaths();
    private List<Thread> shutdownHooks = new ArrayList<Thread>();
    private static boolean finalizeOnExit;
    private boolean shuttingDown;
    private boolean tracingMethods;

    private static String[] initLibPaths() {
        String javaLibraryPath = System.getProperty("java.library.path");
        if (javaLibraryPath == null) {
            return EmptyArray.STRING;
        }
        String[] paths = javaLibraryPath.split(":");
        for (int i = 0; i < paths.length; ++i) {
            if (paths[i].endsWith("/")) continue;
            int n = i;
            paths[n] = paths[n] + "/";
        }
        return paths;
    }

    private Runtime() {
    }

    public Process exec(String[] progArray) throws IOException {
        return this.exec(progArray, null, null);
    }

    public Process exec(String[] progArray, String[] envp) throws IOException {
        return this.exec(progArray, envp, null);
    }

    public Process exec(String[] progArray, String[] envp, File directory) throws IOException {
        return ProcessManager.getInstance().exec(progArray, envp, directory, false);
    }

    public Process exec(String prog) throws IOException {
        return this.exec(prog, null, null);
    }

    public Process exec(String prog, String[] envp) throws IOException {
        return this.exec(prog, envp, null);
    }

    public Process exec(String prog, String[] envp, File directory) throws IOException {
        if (prog == null) {
            throw new NullPointerException("prog == null");
        }
        if (prog.isEmpty()) {
            throw new IllegalArgumentException("prog is empty");
        }
        StringTokenizer tokenizer = new StringTokenizer(prog);
        int length = tokenizer.countTokens();
        String[] progArray = new String[length];
        for (int i = 0; i < length; ++i) {
            progArray[i] = tokenizer.nextToken();
        }
        return this.exec(progArray, envp, directory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit(int code) {
        Runtime runtime = this;
        synchronized (runtime) {
            if (!this.shuttingDown) {
                Thread[] hooks;
                this.shuttingDown = true;
                List<Thread> list = this.shutdownHooks;
                synchronized (list) {
                    hooks = new Thread[this.shutdownHooks.size()];
                    this.shutdownHooks.toArray(hooks);
                }
                for (Thread hook : hooks) {
                    hook.start();
                }
                for (Thread hook : hooks) {
                    try {
                        hook.join();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                }
                if (finalizeOnExit) {
                    this.runFinalization();
                }
                Runtime.nativeExit(code);
            }
        }
    }

    public native void gc();

    public static Runtime getRuntime() {
        return mRuntime;
    }

    public void load(String pathName) {
        this.load(pathName, VMStack.getCallingClassLoader());
    }

    void load(String pathName, ClassLoader loader) {
        if (pathName == null) {
            throw new NullPointerException("pathName == null");
        }
        String error = this.doLoad(pathName, loader);
        if (error != null) {
            throw new UnsatisfiedLinkError(error);
        }
    }

    public void loadLibrary(String libName) {
        this.loadLibrary(libName, VMStack.getCallingClassLoader());
    }

    void loadLibrary(String libraryName, ClassLoader loader) {
        if (loader != null) {
            String filename = loader.findLibrary(libraryName);
            if (filename == null) {
                throw new UnsatisfiedLinkError("Couldn't load " + libraryName + " from loader " + loader + ": findLibrary returned null");
            }
            String error = this.doLoad(filename, loader);
            if (error != null) {
                throw new UnsatisfiedLinkError(error);
            }
            return;
        }
        String filename = System.mapLibraryName(libraryName);
        ArrayList<String> candidates = new ArrayList<String>();
        String lastError = null;
        for (String directory : this.mLibPaths) {
            String candidate = directory + filename;
            candidates.add(candidate);
            if (!IoUtils.canOpenReadOnly(candidate)) continue;
            String error = this.doLoad(candidate, loader);
            if (error == null) {
                return;
            }
            lastError = error;
        }
        if (lastError != null) {
            throw new UnsatisfiedLinkError(lastError);
        }
        throw new UnsatisfiedLinkError("Library " + libraryName + " not found; tried " + candidates);
    }

    private static native void nativeExit(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doLoad(String name, ClassLoader loader) {
        String ldLibraryPath = null;
        if (loader != null && loader instanceof BaseDexClassLoader) {
            ldLibraryPath = ((BaseDexClassLoader)loader).getLdLibraryPath();
        }
        Runtime runtime = this;
        synchronized (runtime) {
            return Runtime.nativeLoad(name, loader, ldLibraryPath);
        }
    }

    private static native String nativeLoad(String var0, ClassLoader var1, String var2);

    public void runFinalization() {
        try {
            FinalizerReference.finalizeAllEnqueued();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean run) {
        finalizeOnExit = run;
    }

    public void traceInstructions(boolean enable) {
    }

    public void traceMethodCalls(boolean enable) {
        if (enable != this.tracingMethods) {
            if (enable) {
                VMDebug.startMethodTracing();
            } else {
                VMDebug.stopMethodTracing();
            }
            this.tracingMethods = enable;
        }
    }

    @Deprecated
    public InputStream getLocalizedInputStream(InputStream stream) {
        String encoding = System.getProperty("file.encoding", "UTF-8");
        if (!encoding.equals("UTF-8")) {
            throw new UnsupportedOperationException("Cannot localize " + encoding);
        }
        return stream;
    }

    @Deprecated
    public OutputStream getLocalizedOutputStream(OutputStream stream) {
        String encoding = System.getProperty("file.encoding", "UTF-8");
        if (!encoding.equals("UTF-8")) {
            throw new UnsupportedOperationException("Cannot localize " + encoding);
        }
        return stream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addShutdownHook(Thread hook) {
        if (hook == null) {
            throw new NullPointerException("hook == null");
        }
        if (this.shuttingDown) {
            throw new IllegalStateException("VM already shutting down");
        }
        if (hook.hasBeenStarted) {
            throw new IllegalArgumentException("Hook has already been started");
        }
        List<Thread> list = this.shutdownHooks;
        synchronized (list) {
            if (this.shutdownHooks.contains(hook)) {
                throw new IllegalArgumentException("Hook already registered.");
            }
            this.shutdownHooks.add(hook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeShutdownHook(Thread hook) {
        if (hook == null) {
            throw new NullPointerException("hook == null");
        }
        if (this.shuttingDown) {
            throw new IllegalStateException("VM already shutting down");
        }
        List<Thread> list = this.shutdownHooks;
        synchronized (list) {
            return this.shutdownHooks.remove(hook);
        }
    }

    public void halt(int code) {
        Runtime.nativeExit(code);
    }

    public int availableProcessors() {
        return (int)Libcore.os.sysconf(OsConstants._SC_NPROCESSORS_CONF);
    }

    public native long freeMemory();

    public native long totalMemory();

    public native long maxMemory();
}

