/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FindBugsSuppressWarnings(value={"DM_NUMBER_CTOR"})
public final class Short
extends Number
implements Comparable<Short> {
    private static final long serialVersionUID = 7515723908773894738L;
    private final short value;
    public static final short MAX_VALUE = Short.MAX_VALUE;
    public static final short MIN_VALUE = Short.MIN_VALUE;
    public static final int SIZE = 16;
    public static final Class<Short> TYPE = short[].class.getComponentType();
    private static final Short[] SMALL_VALUES = new Short[256];

    public Short(String string2) throws NumberFormatException {
        this(Short.parseShort(string2));
    }

    public Short(short value) {
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public int compareTo(Short object) {
        return Short.compare(this.value, object.value);
    }

    public static int compare(short lhs, short rhs) {
        return lhs > rhs ? 1 : (lhs < rhs ? -1 : 0);
    }

    public static Short decode(String string2) throws NumberFormatException {
        int intValue = Integer.decode(string2);
        short result = (short)intValue;
        if (result == intValue) {
            return result;
        }
        throw new NumberFormatException("Value out of range for short: \"" + string2 + "\"");
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Short && ((Short)object).value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    public static short parseShort(String string2) throws NumberFormatException {
        return Short.parseShort(string2, 10);
    }

    public static short parseShort(String string2, int radix) throws NumberFormatException {
        int intValue = Integer.parseInt(string2, radix);
        short result = (short)intValue;
        if (result == intValue) {
            return result;
        }
        throw new NumberFormatException("Value out of range for short: \"" + string2 + "\"");
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    public static String toString(short value) {
        return Integer.toString(value);
    }

    public static Short valueOf(String string2) throws NumberFormatException {
        return Short.parseShort(string2);
    }

    public static Short valueOf(String string2, int radix) throws NumberFormatException {
        return Short.parseShort(string2, radix);
    }

    public static short reverseBytes(short s) {
        return (short)(s << 8 | s >>> 8 & 0xFF);
    }

    public static Short valueOf(short s) {
        return s < -128 || s >= 128 ? new Short(s) : SMALL_VALUES[s + 128];
    }

    static {
        for (int i = -128; i < 128; ++i) {
            Short.SMALL_VALUES[i + 128] = new Short((short)i);
        }
    }
}

