/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.Charsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.Splitter;
import libcore.util.EmptyArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private static final long serialVersionUID = -6849794470754667710L;
    private static final char REPLACEMENT_CHAR = '\ufffd';
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator();
    private static final char[] ASCII = new char[128];
    private final char[] value;
    private final int offset;
    private final int count;
    private int hashCode;

    public String() {
        this.value = EmptyArray.CHAR;
        this.offset = 0;
        this.count = 0;
    }

    private String(String s, char c) {
        this.offset = 0;
        this.value = new char[s.count + 1];
        this.count = s.count + 1;
        System.arraycopy(s.value, s.offset, this.value, 0, s.count);
        this.value[s.count] = c;
    }

    @FindBugsSuppressWarnings(value={"DM_DEFAULT_ENCODING"})
    public String(byte[] data) {
        this(data, 0, data.length);
    }

    @Deprecated
    public String(byte[] data, int high) {
        this(data, high, 0, data.length);
    }

    public String(byte[] data, int offset, int byteCount) {
        this(data, offset, byteCount, Charset.defaultCharset());
    }

    @Deprecated
    public String(byte[] data, int high, int offset, int byteCount) {
        if ((offset | byteCount) < 0 || byteCount > data.length - offset) {
            throw this.failedBoundsCheck(data.length, offset, byteCount);
        }
        this.offset = 0;
        this.value = new char[byteCount];
        this.count = byteCount;
        high <<= 8;
        for (int i = 0; i < this.count; ++i) {
            this.value[i] = (char)(high + (data[offset++] & 0xFF));
        }
    }

    public String(byte[] data, int offset, int byteCount, String charsetName) throws UnsupportedEncodingException {
        this(data, offset, byteCount, Charset.forNameUEE(charsetName));
    }

    public String(byte[] data, String charsetName) throws UnsupportedEncodingException {
        this(data, 0, data.length, Charset.forNameUEE(charsetName));
    }

    public String(byte[] data, int offset, int byteCount, Charset charset) {
        if ((offset | byteCount) < 0 || byteCount > data.length - offset) {
            throw this.failedBoundsCheck(data.length, offset, byteCount);
        }
        String canonicalCharsetName = charset.name();
        if (canonicalCharsetName.equals("UTF-8")) {
            byte[] d = data;
            char[] v = new char[byteCount];
            int idx = offset;
            int last = offset + byteCount;
            int s = 0;
            block0: while (idx < last) {
                byte b0;
                if (((b0 = d[idx++]) & 0x80) == 0) {
                    int val = b0 & 0xFF;
                    v[s++] = (char)val;
                    continue;
                }
                if ((b0 & 0xE0) == 192 || (b0 & 0xF0) == 224 || (b0 & 0xF8) == 240 || (b0 & 0xFC) == 248 || (b0 & 0xFE) == 252) {
                    int utfCount = 1;
                    if ((b0 & 0xF0) == 224) {
                        utfCount = 2;
                    } else if ((b0 & 0xF8) == 240) {
                        utfCount = 3;
                    } else if ((b0 & 0xFC) == 248) {
                        utfCount = 4;
                    } else if ((b0 & 0xFE) == 252) {
                        utfCount = 5;
                    }
                    if (idx + utfCount > last) {
                        v[s++] = 65533;
                        continue;
                    }
                    int val = b0 & 31 >> utfCount - 1;
                    for (int i = 0; i < utfCount; ++i) {
                        byte b;
                        if (((b = d[idx++]) & 0xC0) != 128) {
                            v[s++] = 65533;
                            --idx;
                            continue block0;
                        }
                        val <<= 6;
                        val |= b & 0x3F;
                    }
                    if (utfCount != 2 && val >= 55296 && val <= 57343) {
                        v[s++] = 65533;
                        continue;
                    }
                    if (val > 0x10FFFF) {
                        v[s++] = 65533;
                        continue;
                    }
                    if (val < 65536) {
                        v[s++] = (char)val;
                        continue;
                    }
                    int x = val & 0xFFFF;
                    int u = val >> 16 & 0x1F;
                    int w = u - 1 & 0xFFFF;
                    int hi = 0xD800 | w << 6 | x >> 10;
                    int lo = 0xDC00 | x & 0x3FF;
                    v[s++] = (char)hi;
                    v[s++] = (char)lo;
                    continue;
                }
                v[s++] = 65533;
            }
            if (s == byteCount) {
                this.offset = 0;
                this.value = v;
                this.count = s;
            } else {
                this.offset = 0;
                this.value = new char[s];
                this.count = s;
                System.arraycopy(v, 0, this.value, 0, s);
            }
        } else if (canonicalCharsetName.equals("ISO-8859-1")) {
            this.offset = 0;
            this.value = new char[byteCount];
            this.count = byteCount;
            Charsets.isoLatin1BytesToChars(data, offset, byteCount, this.value);
        } else if (canonicalCharsetName.equals("US-ASCII")) {
            this.offset = 0;
            this.value = new char[byteCount];
            this.count = byteCount;
            Charsets.asciiBytesToChars(data, offset, byteCount, this.value);
        } else {
            CharBuffer cb = charset.decode(ByteBuffer.wrap(data, offset, byteCount));
            this.offset = 0;
            this.count = cb.length();
            if (this.count > 0) {
                this.value = new char[this.count];
                System.arraycopy(cb.array(), 0, this.value, 0, this.count);
            } else {
                this.value = EmptyArray.CHAR;
            }
        }
    }

    public String(byte[] data, Charset charset) {
        this(data, 0, data.length, charset);
    }

    public String(char[] data) {
        this(data, 0, data.length);
    }

    public String(char[] data, int offset, int charCount) {
        if ((offset | charCount) < 0 || charCount > data.length - offset) {
            throw this.failedBoundsCheck(data.length, offset, charCount);
        }
        this.offset = 0;
        this.value = new char[charCount];
        this.count = charCount;
        System.arraycopy(data, offset, this.value, 0, this.count);
    }

    String(int offset, int charCount, char[] chars) {
        this.value = chars;
        this.offset = offset;
        this.count = charCount;
    }

    public String(String toCopy) {
        this.value = toCopy.value.length == toCopy.count ? toCopy.value : Arrays.copyOfRange(toCopy.value, toCopy.offset, toCopy.offset + toCopy.length());
        this.offset = 0;
        this.count = this.value.length;
    }

    private String(String s1, String s2) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        this.count = s1.count + s2.count;
        this.value = new char[this.count];
        this.offset = 0;
        System.arraycopy(s1.value, s1.offset, this.value, 0, s1.count);
        System.arraycopy(s2.value, s2.offset, this.value, s1.count, s2.count);
    }

    private String(String s1, String s2, String s3) {
        if (s1 == null) {
            s1 = "null";
        }
        if (s2 == null) {
            s2 = "null";
        }
        if (s3 == null) {
            s3 = "null";
        }
        this.count = s1.count + s2.count + s3.count;
        this.value = new char[this.count];
        this.offset = 0;
        System.arraycopy(s1.value, s1.offset, this.value, 0, s1.count);
        System.arraycopy(s2.value, s2.offset, this.value, s1.count, s2.count);
        System.arraycopy(s3.value, s3.offset, this.value, s1.count + s2.count, s3.count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringBuffer) {
        this.offset = 0;
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            this.value = stringBuffer.shareValue();
            this.count = stringBuffer.length();
        }
    }

    public String(int[] codePoints, int offset, int count) {
        if (codePoints == null) {
            throw new NullPointerException("codePoints == null");
        }
        if ((offset | count) < 0 || count > codePoints.length - offset) {
            throw this.failedBoundsCheck(codePoints.length, offset, count);
        }
        this.offset = 0;
        this.value = new char[count * 2];
        int end = offset + count;
        int c = 0;
        for (int i = offset; i < end; ++i) {
            c += Character.toChars(codePoints[i], this.value, c);
        }
        this.count = c;
    }

    public String(StringBuilder stringBuilder) {
        if (stringBuilder == null) {
            throw new NullPointerException("stringBuilder == null");
        }
        this.offset = 0;
        this.count = stringBuilder.length();
        this.value = new char[this.count];
        stringBuilder.getChars(0, this.count, this.value, 0);
    }

    private String(String s1, int v1) {
        if (s1 == null) {
            s1 = "null";
        }
        String s2 = String.valueOf(v1);
        int len = s1.count + s2.count;
        this.value = new char[len];
        this.offset = 0;
        System.arraycopy(s1.value, s1.offset, this.value, 0, s1.count);
        System.arraycopy(s2.value, s2.offset, this.value, s1.count, s2.count);
        this.count = len;
    }

    @Override
    public char charAt(int index) {
        if (index < 0 || index >= this.count) {
            throw this.indexAndLength(index);
        }
        return this.value[this.offset + index];
    }

    private StringIndexOutOfBoundsException indexAndLength(int index) {
        throw new StringIndexOutOfBoundsException(this, index);
    }

    private StringIndexOutOfBoundsException startEndAndLength(int start, int end) {
        throw new StringIndexOutOfBoundsException(this, start, end - start);
    }

    private StringIndexOutOfBoundsException failedBoundsCheck(int arrayLength, int offset, int count) {
        throw new StringIndexOutOfBoundsException(arrayLength, offset, count);
    }

    private char foldCase(char ch) {
        if (ch < '\u0080') {
            if ('A' <= ch && ch <= 'Z') {
                return (char)(ch + 32);
            }
            return ch;
        }
        return Character.toLowerCase(Character.toUpperCase(ch));
    }

    @Override
    public native int compareTo(String var1);

    public int compareToIgnoreCase(String string2) {
        int o1 = this.offset;
        int o2 = string2.offset;
        int end = this.offset + (this.count < string2.count ? this.count : string2.count);
        char[] target = string2.value;
        while (o1 < end) {
            int result;
            char c2;
            char c1;
            if ((c1 = this.value[o1++]) == (c2 = target[o2++]) || (result = (c1 = this.foldCase(c1)) - (c2 = this.foldCase(c2))) == 0) continue;
            return result;
        }
        return this.count - string2.count;
    }

    public String concat(String string2) {
        if (string2.count > 0 && this.count > 0) {
            char[] buffer = new char[this.count + string2.count];
            System.arraycopy(this.value, this.offset, buffer, 0, this.count);
            System.arraycopy(string2.value, string2.offset, buffer, this.count, string2.count);
            return new String(0, buffer.length, buffer);
        }
        return this.count == 0 ? string2 : this;
    }

    public static String copyValueOf(char[] data) {
        return new String(data, 0, data.length);
    }

    public static String copyValueOf(char[] data, int start, int length) {
        return new String(data, start, length);
    }

    public boolean endsWith(String suffix) {
        return this.regionMatches(this.count - suffix.count, suffix, 0, suffix.count);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof String) {
            String s = (String)other;
            int count = this.count;
            if (s.count != count) {
                return false;
            }
            if (this.hashCode() != s.hashCode()) {
                return false;
            }
            char[] value1 = this.value;
            int offset1 = this.offset;
            char[] value2 = s.value;
            int offset2 = s.offset;
            int end = offset1 + count;
            while (offset1 < end) {
                if (value1[offset1] != value2[offset2]) {
                    return false;
                }
                ++offset1;
                ++offset2;
            }
            return true;
        }
        return false;
    }

    @FindBugsSuppressWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public boolean equalsIgnoreCase(String string2) {
        if (string2 == this) {
            return true;
        }
        if (string2 == null || this.count != string2.count) {
            return false;
        }
        int o1 = this.offset;
        int o2 = string2.offset;
        int end = this.offset + this.count;
        char[] target = string2.value;
        while (o1 < end) {
            char c2;
            char c1;
            if ((c1 = this.value[o1++]) == (c2 = target[o2++]) || this.foldCase(c1) == this.foldCase(c2)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public void getBytes(int start, int end, byte[] data, int index) {
        if (start >= 0 && start <= end && end <= this.count) {
            end += this.offset;
            try {
                for (int i = this.offset + start; i < end; ++i) {
                    data[index++] = (byte)this.value[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException ignored) {
                throw this.failedBoundsCheck(data.length, index, end - start);
            }
        } else {
            throw this.startEndAndLength(start, end);
        }
    }

    public byte[] getBytes() {
        return this.getBytes(Charset.defaultCharset());
    }

    public byte[] getBytes(String charsetName) throws UnsupportedEncodingException {
        return this.getBytes(Charset.forNameUEE(charsetName));
    }

    public byte[] getBytes(Charset charset) {
        String canonicalCharsetName = charset.name();
        if (canonicalCharsetName.equals("UTF-8")) {
            return Charsets.toUtf8Bytes(this.value, this.offset, this.count);
        }
        if (canonicalCharsetName.equals("ISO-8859-1")) {
            return Charsets.toIsoLatin1Bytes(this.value, this.offset, this.count);
        }
        if (canonicalCharsetName.equals("US-ASCII")) {
            return Charsets.toAsciiBytes(this.value, this.offset, this.count);
        }
        if (canonicalCharsetName.equals("UTF-16BE")) {
            return Charsets.toBigEndianUtf16Bytes(this.value, this.offset, this.count);
        }
        CharBuffer chars = CharBuffer.wrap(this.value, this.offset, this.count);
        ByteBuffer buffer = charset.encode(chars.asReadOnlyBuffer());
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    public void getChars(int start, int end, char[] buffer, int index) {
        if (start < 0 || start > end || end > this.count) {
            throw this.startEndAndLength(start, end);
        }
        System.arraycopy(this.value, start + this.offset, buffer, index, end - start);
    }

    void _getChars(int start, int end, char[] buffer, int index) {
        System.arraycopy(this.value, start + this.offset, buffer, index, end - start);
    }

    public int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            if (this.count == 0) {
                return 0;
            }
            int end = this.count + this.offset;
            char[] chars = this.value;
            for (int i = this.offset; i < end; ++i) {
                hash = 31 * hash + chars[i];
            }
            this.hashCode = hash;
        }
        return hash;
    }

    public int indexOf(int c) {
        if (c > 65535) {
            return this.indexOfSupplementary(c, 0);
        }
        return this.fastIndexOf(c, 0);
    }

    public int indexOf(int c, int start) {
        if (c > 65535) {
            return this.indexOfSupplementary(c, start);
        }
        return this.fastIndexOf(c, start);
    }

    private native int fastIndexOf(int var1, int var2);

    private int indexOfSupplementary(int c, int start) {
        if (!Character.isSupplementaryCodePoint(c)) {
            return -1;
        }
        char[] chars = Character.toChars(c);
        String needle = new String(0, chars.length, chars);
        return this.indexOf(needle, start);
    }

    public int indexOf(String string2) {
        int start = 0;
        int subCount = string2.count;
        int _count = this.count;
        if (subCount > 0) {
            if (subCount > _count) {
                return -1;
            }
            char[] target = string2.value;
            int subOffset = string2.offset;
            char firstChar = target[subOffset];
            int end = subOffset + subCount;
            while (true) {
                int i;
                if ((i = this.indexOf(firstChar, start)) == -1 || subCount + i > _count) {
                    return -1;
                }
                int o1 = this.offset + i;
                int o2 = subOffset;
                char[] _value = this.value;
                while (++o2 < end && _value[++o1] == target[o2]) {
                }
                if (o2 == end) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < _count ? start : _count;
    }

    public int indexOf(String subString, int start) {
        if (start < 0) {
            start = 0;
        }
        int subCount = subString.count;
        int _count = this.count;
        if (subCount > 0) {
            if (subCount + start > _count) {
                return -1;
            }
            char[] target = subString.value;
            int subOffset = subString.offset;
            char firstChar = target[subOffset];
            int end = subOffset + subCount;
            while (true) {
                int i;
                if ((i = this.indexOf(firstChar, start)) == -1 || subCount + i > _count) {
                    return -1;
                }
                int o1 = this.offset + i;
                int o2 = subOffset;
                char[] _value = this.value;
                while (++o2 < end && _value[++o1] == target[o2]) {
                }
                if (o2 == end) {
                    return i;
                }
                start = i + 1;
            }
        }
        return start < _count ? start : _count;
    }

    public native String intern();

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int lastIndexOf(int c) {
        if (c > 65535) {
            return this.lastIndexOfSupplementary(c, Integer.MAX_VALUE);
        }
        int _count = this.count;
        int _offset = this.offset;
        char[] _value = this.value;
        for (int i = _offset + _count - 1; i >= _offset; --i) {
            if (_value[i] != c) continue;
            return i - _offset;
        }
        return -1;
    }

    public int lastIndexOf(int c, int start) {
        if (c > 65535) {
            return this.lastIndexOfSupplementary(c, start);
        }
        int _count = this.count;
        int _offset = this.offset;
        char[] _value = this.value;
        if (start >= 0) {
            if (start >= _count) {
                start = _count - 1;
            }
            for (int i = _offset + start; i >= _offset; --i) {
                if (_value[i] != c) continue;
                return i - _offset;
            }
        }
        return -1;
    }

    private int lastIndexOfSupplementary(int c, int start) {
        if (!Character.isSupplementaryCodePoint(c)) {
            return -1;
        }
        char[] chars = Character.toChars(c);
        String needle = new String(0, chars.length, chars);
        return this.lastIndexOf(needle, start);
    }

    public int lastIndexOf(String string2) {
        return this.lastIndexOf(string2, this.count);
    }

    public int lastIndexOf(String subString, int start) {
        int subCount = subString.count;
        if (subCount <= this.count && start >= 0) {
            if (subCount > 0) {
                if (start > this.count - subCount) {
                    start = this.count - subCount;
                }
                char[] target = subString.value;
                int subOffset = subString.offset;
                char firstChar = target[subOffset];
                int end = subOffset + subCount;
                while (true) {
                    int i;
                    if ((i = this.lastIndexOf(firstChar, start)) == -1) {
                        return -1;
                    }
                    int o1 = this.offset + i;
                    int o2 = subOffset;
                    while (++o2 < end && this.value[++o1] == target[o2]) {
                    }
                    if (o2 == end) {
                        return i;
                    }
                    start = i - 1;
                }
            }
            return start < this.count ? start : this.count;
        }
        return -1;
    }

    @Override
    public int length() {
        return this.count;
    }

    public boolean regionMatches(int thisStart, String string2, int start, int length) {
        if (string2 == null) {
            throw new NullPointerException("string == null");
        }
        if (start < 0 || string2.count - start < length) {
            return false;
        }
        if (thisStart < 0 || this.count - thisStart < length) {
            return false;
        }
        if (length <= 0) {
            return true;
        }
        int o1 = this.offset + thisStart;
        int o2 = string2.offset + start;
        char[] value1 = this.value;
        char[] value2 = string2.value;
        for (int i = 0; i < length; ++i) {
            if (value1[o1 + i] == value2[o2 + i]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean ignoreCase, int thisStart, String string2, int start, int length) {
        if (!ignoreCase) {
            return this.regionMatches(thisStart, string2, start, length);
        }
        if (string2 == null) {
            throw new NullPointerException("string == null");
        }
        if (thisStart < 0 || length > this.count - thisStart) {
            return false;
        }
        if (start < 0 || length > string2.count - start) {
            return false;
        }
        start += string2.offset;
        int end = (thisStart += this.offset) + length;
        char[] target = string2.value;
        while (thisStart < end) {
            char c2;
            char c1;
            if ((c1 = this.value[thisStart++]) == (c2 = target[start++]) || this.foldCase(c1) == this.foldCase(c2)) continue;
            return false;
        }
        return true;
    }

    public String replace(char oldChar, char newChar) {
        char[] buffer = this.value;
        int _offset = this.offset;
        int _count = this.count;
        int last = _offset + _count;
        boolean copied = false;
        for (int idx = _offset; idx < last; ++idx) {
            if (buffer[idx] != oldChar) continue;
            if (!copied) {
                char[] newBuffer = new char[_count];
                System.arraycopy(buffer, _offset, newBuffer, 0, _count);
                buffer = newBuffer;
                idx -= _offset;
                last -= _offset;
                copied = true;
            }
            buffer[idx] = newChar;
        }
        return copied ? new String(0, this.count, buffer) : this;
    }

    public String replace(CharSequence target, CharSequence replacement) {
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        if (replacement == null) {
            throw new NullPointerException("replacement == null");
        }
        String targetString = ((Object)target).toString();
        int matchStart = this.indexOf(targetString, 0);
        if (matchStart == -1) {
            return this;
        }
        String replacementString = ((Object)replacement).toString();
        int targetLength = targetString.length();
        if (targetLength == 0) {
            int resultLength = this.count + (this.count + 1) * replacementString.length();
            StringBuilder result = new StringBuilder(resultLength);
            result.append(replacementString);
            int end = this.offset + this.count;
            for (int i = this.offset; i != end; ++i) {
                result.append(this.value[i]);
                result.append(replacementString);
            }
            return result.toString();
        }
        StringBuilder result = new StringBuilder(this.count);
        int searchStart = 0;
        do {
            result.append(this.value, this.offset + searchStart, matchStart - searchStart);
            result.append(replacementString);
        } while ((matchStart = this.indexOf(targetString, searchStart = matchStart + targetLength)) != -1);
        result.append(this.value, this.offset + searchStart, this.count - searchStart);
        return result.toString();
    }

    public boolean startsWith(String prefix) {
        return this.startsWith(prefix, 0);
    }

    public boolean startsWith(String prefix, int start) {
        return this.regionMatches(start, prefix, 0, prefix.count);
    }

    public String substring(int start) {
        if (start == 0) {
            return this;
        }
        if (start >= 0 && start <= this.count) {
            return new String(this.offset + start, this.count - start, this.value);
        }
        throw this.indexAndLength(start);
    }

    public String substring(int start, int end) {
        if (start == 0 && end == this.count) {
            return this;
        }
        if (start >= 0 && start <= end && end <= this.count) {
            return new String(this.offset + start, end - start, this.value);
        }
        throw this.startEndAndLength(start, end);
    }

    public char[] toCharArray() {
        char[] buffer = new char[this.count];
        System.arraycopy(this.value, this.offset, buffer, 0, this.count);
        return buffer;
    }

    public String toLowerCase() {
        return CaseMapper.toLowerCase(Locale.getDefault(), this, this.value, this.offset, this.count);
    }

    public String toLowerCase(Locale locale) {
        return CaseMapper.toLowerCase(locale, this, this.value, this.offset, this.count);
    }

    @Override
    public String toString() {
        return this;
    }

    public String toUpperCase() {
        return CaseMapper.toUpperCase(Locale.getDefault(), this, this.value, this.offset, this.count);
    }

    public String toUpperCase(Locale locale) {
        return CaseMapper.toUpperCase(locale, this, this.value, this.offset, this.count);
    }

    public String trim() {
        int start;
        int last;
        int end = last = this.offset + this.count - 1;
        for (start = this.offset; start <= end && this.value[start] <= ' '; ++start) {
        }
        while (end >= start && this.value[end] <= ' ') {
            --end;
        }
        if (start == this.offset && end == last) {
            return this;
        }
        return new String(start, end - start + 1, this.value);
    }

    public static String valueOf(char[] data) {
        return new String(data, 0, data.length);
    }

    public static String valueOf(char[] data, int start, int length) {
        return new String(data, start, length);
    }

    public static String valueOf(char value) {
        String s = value < '\u0080' ? new String(value, 1, ASCII) : new String(0, 1, new char[]{value});
        s.hashCode = value;
        return s;
    }

    public static String valueOf(double value) {
        return Double.toString(value);
    }

    public static String valueOf(float value) {
        return Float.toString(value);
    }

    public static String valueOf(int value) {
        return Integer.toString(value);
    }

    public static String valueOf(long value) {
        return Long.toString(value);
    }

    public static String valueOf(Object value) {
        return value != null ? value.toString() : "null";
    }

    public static String valueOf(boolean value) {
        return value ? "true" : "false";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer strbuf) {
        StringBuffer stringBuffer = strbuf;
        synchronized (stringBuffer) {
            int size = strbuf.length();
            if (this.count != size) {
                return false;
            }
            return this.regionMatches(0, new String(0, size, strbuf.getValue()), 0, size);
        }
    }

    public boolean contentEquals(CharSequence cs) {
        if (cs == null) {
            throw new NullPointerException("cs == null");
        }
        int len = cs.length();
        if (len != this.count) {
            return false;
        }
        if (len == 0 && this.count == 0) {
            return true;
        }
        return this.regionMatches(0, ((Object)cs).toString(), 0, len);
    }

    public boolean matches(String regularExpression) {
        return Pattern.matches(regularExpression, this);
    }

    public String replaceAll(String regularExpression, String replacement) {
        return Pattern.compile(regularExpression).matcher(this).replaceAll(replacement);
    }

    public String replaceFirst(String regularExpression, String replacement) {
        return Pattern.compile(regularExpression).matcher(this).replaceFirst(replacement);
    }

    public String[] split(String regularExpression) {
        return this.split(regularExpression, 0);
    }

    public String[] split(String regularExpression, int limit) {
        String[] result = Splitter.fastSplit(regularExpression, this, limit);
        return result != null ? result : Pattern.compile(regularExpression).split(this, limit);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.substring(start, end);
    }

    public int codePointAt(int index) {
        if (index < 0 || index >= this.count) {
            throw this.indexAndLength(index);
        }
        return Character.codePointAt(this.value, this.offset + index, this.offset + this.count);
    }

    public int codePointBefore(int index) {
        if (index < 1 || index > this.count) {
            throw this.indexAndLength(index);
        }
        return Character.codePointBefore(this.value, this.offset + index, this.offset);
    }

    public int codePointCount(int start, int end) {
        if (start < 0 || end > this.count || start > end) {
            throw this.startEndAndLength(start, end);
        }
        return Character.codePointCount(this.value, this.offset + start, end - start);
    }

    public boolean contains(CharSequence cs) {
        if (cs == null) {
            throw new NullPointerException("cs == null");
        }
        return this.indexOf(((Object)cs).toString()) >= 0;
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        int s = index + this.offset;
        int r = Character.offsetByCodePoints(this.value, this.offset, this.count, s, codePointOffset);
        return r - this.offset;
    }

    public static String format(String format, Object ... args) {
        return String.format(Locale.getDefault(), format, args);
    }

    public static String format(Locale locale, String format, Object ... args) {
        if (format == null) {
            throw new NullPointerException("format == null");
        }
        int bufferSize = format.length() + (args == null ? 0 : args.length * 10);
        Formatter f = new Formatter(new StringBuilder(bufferSize), locale);
        return f.format(format, args).toString();
    }

    @FindBugsSuppressWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"})
    private static int indexOf(String haystackString, String needleString, int cache, int md2, char lastChar) {
        char[] haystack = haystackString.value;
        int haystackOffset = haystackString.offset;
        int haystackLength = haystackString.count;
        char[] needle = needleString.value;
        int needleOffset = needleString.offset;
        int needleLength = needleString.count;
        int needleLengthMinus1 = needleLength - 1;
        int haystackEnd = haystackOffset + haystackLength;
        int i = haystackOffset + needleLengthMinus1;
        block0: while (i < haystackEnd) {
            if (lastChar == haystack[i]) {
                for (int j = 0; j < needleLengthMinus1; ++j) {
                    if (needle[j + needleOffset] == haystack[i + j - needleLengthMinus1]) continue;
                    int skip = 1;
                    if ((cache & '\u0001' << haystack[i]) == 0) {
                        skip += j;
                    }
                    i += Math.max(md2, skip);
                    continue block0;
                }
                return i - needleLengthMinus1 - haystackOffset;
            }
            if ((cache & '\u0001' << haystack[i]) == 0) {
                i += needleLengthMinus1;
            }
            ++i;
        }
        return -1;
    }

    static {
        for (int i = 0; i < ASCII.length; ++i) {
            String.ASCII[i] = (char)i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.compareToIgnoreCase(o2);
        }
    }
}

