/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.system.VMRuntime;
import dalvik.system.VMStack;
import java.io.BufferedInputStream;
import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.channels.Channel;
import java.nio.channels.spi.SelectorProvider;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import libcore.icu.ICU;
import libcore.io.ErrnoException;
import libcore.io.Libcore;
import libcore.io.StructPasswd;
import libcore.io.StructUtsname;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static final String lineSeparator;
    private static Properties systemProperties;
    private static final int ARRAYCOPY_SHORT_CHAR_ARRAY_THRESHOLD = 64;

    public static void setIn(InputStream newIn) {
        System.setFieldImpl("in", "Ljava/io/InputStream;", newIn);
    }

    public static void setOut(PrintStream newOut) {
        System.setFieldImpl("out", "Ljava/io/PrintStream;", newOut);
    }

    public static void setErr(PrintStream newErr) {
        System.setFieldImpl("err", "Ljava/io/PrintStream;", newErr);
    }

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static void arraycopy(char[] src, int srcPos, char[] dst, int dstPos, int length) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (dst == null) {
            throw new NullPointerException("dst == null");
        }
        if (srcPos < 0 || dstPos < 0 || length < 0 || srcPos > src.length - length || dstPos > dst.length - length) {
            throw new ArrayIndexOutOfBoundsException("src.length=" + src.length + " srcPos=" + srcPos + " dst.length=" + dst.length + " dstPos=" + dstPos + " length=" + length);
        }
        if (length <= 64) {
            if (src == dst && srcPos < dstPos && dstPos < srcPos + length) {
                for (int i = length - 1; i >= 0; --i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            } else {
                for (int i = 0; i < length; ++i) {
                    dst[dstPos + i] = src[srcPos + i];
                }
            }
        } else {
            System.arraycopyCharUnchecked(src, srcPos, dst, dstPos, length);
        }
    }

    private static native void arraycopyCharUnchecked(char[] var0, int var1, char[] var2, int var3, int var4);

    public static native long currentTimeMillis();

    public static native long nanoTime();

    public static void exit(int code) {
        Runtime.getRuntime().exit(code);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static String getenv(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        return Libcore.os.getenv(name);
    }

    public static Map<String, String> getenv() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String entry : Libcore.os.environ()) {
            int index = entry.indexOf(61);
            if (index == -1) continue;
            map.put(entry.substring(0, index), entry.substring(index + 1));
        }
        return new SystemEnvironment(map);
    }

    public static Channel inheritedChannel() throws IOException {
        return SelectorProvider.provider().inheritedChannel();
    }

    public static Properties getProperties() {
        if (systemProperties == null) {
            System.initSystemProperties();
        }
        return systemProperties;
    }

    private static void initSystemProperties() {
        VMRuntime runtime = VMRuntime.getRuntime();
        Properties p = new Properties();
        String projectUrl = "http://www.android.com/";
        String projectName = "The Android Project";
        p.put("java.boot.class.path", runtime.bootClassPath());
        p.put("java.class.path", runtime.classPath());
        p.put("java.class.version", "50.0");
        p.put("java.compiler", "");
        p.put("java.ext.dirs", "");
        p.put("java.version", "0");
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome == null) {
            javaHome = "/system";
        }
        p.put("java.home", javaHome);
        p.put("java.io.tmpdir", "/tmp");
        String ldLibraryPath = System.getenv("LD_LIBRARY_PATH");
        if (ldLibraryPath != null) {
            p.put("java.library.path", ldLibraryPath);
        }
        p.put("java.specification.name", "Dalvik Core Library");
        p.put("java.specification.vendor", projectName);
        p.put("java.specification.version", "0.9");
        p.put("java.vendor", projectName);
        p.put("java.vendor.url", projectUrl);
        p.put("java.vm.name", "Dalvik");
        p.put("java.vm.specification.name", "Dalvik Virtual Machine Specification");
        p.put("java.vm.specification.vendor", projectName);
        p.put("java.vm.specification.version", "0.9");
        p.put("java.vm.vendor", projectName);
        p.put("java.vm.version", runtime.vmVersion());
        p.put("file.separator", "/");
        p.put("line.separator", "\n");
        p.put("path.separator", ":");
        p.put("java.runtime.name", "Android Runtime");
        p.put("java.runtime.version", "0.9");
        p.put("java.vm.vendor.url", projectUrl);
        p.put("file.encoding", "UTF-8");
        p.put("user.language", "en");
        p.put("user.region", "US");
        try {
            StructPasswd passwd = Libcore.os.getpwuid(Libcore.os.getuid());
            p.put("user.home", passwd.pw_dir);
            p.put("user.name", passwd.pw_name);
        }
        catch (ErrnoException exception) {
            throw new AssertionError((Object)exception);
        }
        StructUtsname info = Libcore.os.uname();
        p.put("os.arch", info.machine);
        p.put("os.name", info.sysname);
        p.put("os.version", info.release);
        p.put("android.icu.library.version", ICU.getIcuVersion());
        p.put("android.icu.unicode.version", ICU.getUnicodeVersion());
        p.put("android.icu.cldr.version", ICU.getCldrVersion());
        System.parsePropertyAssignments(p, System.specialProperties());
        System.parsePropertyAssignments(p, runtime.properties());
        systemProperties = p;
    }

    private static native String[] specialProperties();

    private static void parsePropertyAssignments(Properties p, String[] assignments) {
        for (String assignment : assignments) {
            int split = assignment.indexOf(61);
            String key = assignment.substring(0, split);
            String value = assignment.substring(split + 1);
            p.put(key, value);
        }
    }

    public static String getProperty(String propertyName) {
        return System.getProperty(propertyName, null);
    }

    public static String getProperty(String name, String defaultValue) {
        System.checkPropertyName(name);
        return System.getProperties().getProperty(name, defaultValue);
    }

    public static String setProperty(String name, String value) {
        System.checkPropertyName(name);
        return (String)System.getProperties().setProperty(name, value);
    }

    public static String clearProperty(String name) {
        System.checkPropertyName(name);
        return (String)System.getProperties().remove(name);
    }

    private static void checkPropertyName(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("name is empty");
        }
    }

    public static Console console() {
        return Console.getConsole();
    }

    public static SecurityManager getSecurityManager() {
        return null;
    }

    public static native int identityHashCode(Object var0);

    public static String lineSeparator() {
        return lineSeparator;
    }

    public static void load(String pathName) {
        Runtime.getRuntime().load(pathName, VMStack.getCallingClassLoader());
    }

    public static void loadLibrary(String libName) {
        Runtime.getRuntime().loadLibrary(libName, VMStack.getCallingClassLoader());
    }

    public static void logE(String message) {
        System.log('E', message, null);
    }

    public static void logE(String message, Throwable th) {
        System.log('E', message, th);
    }

    public static void logI(String message) {
        System.log('I', message, null);
    }

    public static void logI(String message, Throwable th) {
        System.log('I', message, th);
    }

    public static void logW(String message) {
        System.log('W', message, null);
    }

    public static void logW(String message, Throwable th) {
        System.log('W', message, th);
    }

    private static native void log(char var0, String var1, Throwable var2);

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    @Deprecated
    public static void runFinalizersOnExit(boolean flag) {
        Runtime.runFinalizersOnExit(flag);
    }

    public static void setProperties(Properties p) {
        systemProperties = p;
    }

    public static void setSecurityManager(SecurityManager sm) {
        if (sm != null) {
            throw new SecurityException();
        }
    }

    public static native String mapLibraryName(String var0);

    private static native void setFieldImpl(String var0, String var1, Object var2);

    static {
        err = new PrintStream(new FileOutputStream(FileDescriptor.err));
        out = new PrintStream(new FileOutputStream(FileDescriptor.out));
        in = new BufferedInputStream(new FileInputStream(FileDescriptor.in));
        lineSeparator = System.getProperty("line.separator");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SystemEnvironment
    extends AbstractMap<String, String> {
        private final Map<String, String> map;

        public SystemEnvironment(Map<String, String> map) {
            this.map = Collections.unmodifiableMap(map);
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public String get(Object key) {
            return this.map.get(this.toNonNullString(key));
        }

        @Override
        public boolean containsKey(Object key) {
            return this.map.containsKey(this.toNonNullString(key));
        }

        @Override
        public boolean containsValue(Object value) {
            return this.map.containsValue(this.toNonNullString(value));
        }

        private String toNonNullString(Object o) {
            if (o == null) {
                throw new NullPointerException("o == null");
            }
            return (String)o;
        }
    }
}

