/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import dalvik.system.VMStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import libcore.util.EmptyArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Thread
implements Runnable {
    private static final int NANOS_PER_MILLI = 1000000;
    public static final int MAX_PRIORITY = 10;
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    volatile VMThread vmThread;
    volatile ThreadGroup group;
    volatile boolean daemon;
    volatile String name;
    volatile int priority;
    volatile long stackSize;
    Runnable target;
    private static int count = 0;
    private long id;
    ThreadLocal.Values localValues;
    ThreadLocal.Values inheritableValues;
    private final List<Runnable> interruptActions = new ArrayList<Runnable>();
    private ClassLoader contextClassLoader;
    private UncaughtExceptionHandler uncaughtHandler;
    private static UncaughtExceptionHandler defaultUncaughtHandler;
    boolean hasBeenStarted = false;
    private int parkState = 1;
    private Object parkBlocker;

    public Thread() {
        this.create(null, null, null, 0L);
    }

    public Thread(Runnable runnable) {
        this.create(null, runnable, null, 0L);
    }

    public Thread(Runnable runnable, String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(null, runnable, threadName, 0L);
    }

    public Thread(String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(null, null, threadName, 0L);
    }

    public Thread(ThreadGroup group, Runnable runnable) {
        this.create(group, runnable, null, 0L);
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(group, runnable, threadName, 0L);
    }

    public Thread(ThreadGroup group, String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(group, null, threadName, 0L);
    }

    public Thread(ThreadGroup group, Runnable runnable, String threadName, long stackSize) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.create(group, runnable, threadName, stackSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Thread(ThreadGroup group, String name, int priority, boolean daemon) {
        Class<Thread> clazz = Thread.class;
        synchronized (Thread.class) {
            this.id = ++count;
            // ** MonitorExit[var5_5] (shouldn't be in output)
            this.name = name == null ? "Thread-" + this.id : name;
            if (group == null) {
                throw new InternalError("group not specified");
            }
            this.group = group;
            this.target = null;
            this.stackSize = 0L;
            this.priority = priority;
            this.daemon = daemon;
            this.group.addThread(this);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create(ThreadGroup group, Runnable runnable, String threadName, long stackSize) {
        Thread currentThread = Thread.currentThread();
        if (group == null) {
            group = currentThread.getThreadGroup();
        }
        if (group.isDestroyed()) {
            throw new IllegalThreadStateException("Group already destroyed");
        }
        this.group = group;
        Class<Thread> clazz = Thread.class;
        synchronized (Thread.class) {
            this.id = ++count;
            // ** MonitorExit[var7_6] (shouldn't be in output)
            this.name = threadName == null ? "Thread-" + this.id : threadName;
            this.target = runnable;
            this.stackSize = stackSize;
            this.priority = currentThread.getPriority();
            this.contextClassLoader = currentThread.contextClassLoader;
            if (currentThread.inheritableValues != null) {
                this.inheritableValues = new ThreadLocal.Values(currentThread.inheritableValues);
            }
            this.group.addThread(this);
            return;
        }
    }

    public static int activeCount() {
        return Thread.currentThread().getThreadGroup().activeCount();
    }

    public final void checkAccess() {
    }

    @Deprecated
    public int countStackFrames() {
        return this.getStackTrace().length;
    }

    public static Thread currentThread() {
        return VMThread.currentThread();
    }

    @Deprecated
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    public static void dumpStack() {
        new Throwable("stack dump").printStackTrace();
    }

    public static int enumerate(Thread[] threads) {
        Thread thread = Thread.currentThread();
        return thread.getThreadGroup().enumerate(threads);
    }

    public static Map<Thread, StackTraceElement[]> getAllStackTraces() {
        HashMap<Thread, StackTraceElement[]> map = new HashMap<Thread, StackTraceElement[]>();
        int count = ThreadGroup.mSystem.activeCount();
        Thread[] threads = new Thread[count + count / 2];
        count = ThreadGroup.mSystem.enumerate(threads);
        for (int i = 0; i < count; ++i) {
            map.put(threads[i], threads[i].getStackTrace());
        }
        return map;
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }

    public static UncaughtExceptionHandler getDefaultUncaughtExceptionHandler() {
        return defaultUncaughtHandler;
    }

    public long getId() {
        return this.id;
    }

    public final String getName() {
        return this.name;
    }

    public final int getPriority() {
        return this.priority;
    }

    public StackTraceElement[] getStackTrace() {
        StackTraceElement[] ste = VMStack.getThreadStackTrace(this);
        return ste != null ? ste : EmptyArray.STACK_TRACE_ELEMENT;
    }

    public State getState() {
        int state;
        VMThread vmt = this.vmThread;
        VMThread thread = this.vmThread;
        if (thread != null && (state = thread.getStatus()) != -1) {
            return VMThread.STATE_MAP[state];
        }
        return this.hasBeenStarted ? State.TERMINATED : State.NEW;
    }

    public final ThreadGroup getThreadGroup() {
        if (this.getState() == State.TERMINATED) {
            return null;
        }
        return this.group;
    }

    public UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (this.uncaughtHandler != null) {
            return this.uncaughtHandler;
        }
        return this.group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        VMThread vmt = this.vmThread;
        if (vmt != null) {
            vmt.interrupt();
        }
        List<Runnable> list = this.interruptActions;
        synchronized (list) {
            for (int i = this.interruptActions.size() - 1; i >= 0; --i) {
                this.interruptActions.get(i).run();
            }
        }
    }

    public static boolean interrupted() {
        return VMThread.interrupted();
    }

    public final boolean isAlive() {
        return this.vmThread != null;
    }

    public final boolean isDaemon() {
        return this.daemon;
    }

    public boolean isInterrupted() {
        VMThread vmt = this.vmThread;
        if (vmt != null) {
            return vmt.isInterrupted();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join() throws InterruptedException {
        VMThread t = this.vmThread;
        if (t == null) {
            return;
        }
        VMThread vMThread = t;
        synchronized (vMThread) {
            while (this.isAlive()) {
                t.wait();
            }
        }
    }

    public final void join(long millis) throws InterruptedException {
        this.join(millis, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void join(long millis, int nanos) throws InterruptedException {
        boolean forever;
        if (millis < 0L || nanos < 0 || nanos >= 1000000) {
            throw new IllegalArgumentException("bad timeout: millis=" + millis + ",nanos=" + nanos);
        }
        boolean overflow = millis >= (Long.MAX_VALUE - (long)nanos) / 1000000L;
        boolean bl = forever = (millis | (long)nanos) == 0L;
        if (forever | overflow) {
            this.join();
            return;
        }
        VMThread t = this.vmThread;
        if (t == null) {
            return;
        }
        VMThread vMThread = t;
        synchronized (vMThread) {
            if (!this.isAlive()) {
                return;
            }
            long nanosToWait = millis * 1000000L + (long)nanos;
            long start = System.nanoTime();
            while (true) {
                long nanosElapsed;
                long nanosRemaining;
                t.wait(millis, nanos);
                if (!this.isAlive() || (nanosRemaining = nanosToWait - (nanosElapsed = System.nanoTime() - start)) <= 0L) break;
                millis = nanosRemaining / 1000000L;
                nanos = (int)(nanosRemaining - millis * 1000000L);
            }
        }
    }

    @Deprecated
    public final void resume() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void run() {
        if (this.target != null) {
            this.target.run();
        }
    }

    public void setContextClassLoader(ClassLoader cl) {
        this.contextClassLoader = cl;
    }

    public final void setDaemon(boolean isDaemon) {
        this.checkNotStarted();
        if (this.vmThread == null) {
            this.daemon = isDaemon;
        }
    }

    private void checkNotStarted() {
        if (this.hasBeenStarted) {
            throw new IllegalThreadStateException("Thread already started");
        }
    }

    public static void setDefaultUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        defaultUncaughtHandler = handler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushInterruptAction$(Runnable interruptAction) {
        List<Runnable> list = this.interruptActions;
        synchronized (list) {
            this.interruptActions.add(interruptAction);
        }
        if (interruptAction != null && this.isInterrupted()) {
            interruptAction.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void popInterruptAction$(Runnable interruptAction) {
        List<Runnable> list = this.interruptActions;
        synchronized (list) {
            Runnable removed = this.interruptActions.remove(this.interruptActions.size() - 1);
            if (interruptAction != removed) {
                throw new IllegalArgumentException("Expected " + interruptAction + " but was " + removed);
            }
        }
    }

    public final void setName(String threadName) {
        if (threadName == null) {
            throw new NullPointerException("threadName == null");
        }
        this.name = threadName;
        VMThread vmt = this.vmThread;
        if (vmt != null) {
            vmt.nameChanged(threadName);
        }
    }

    public final void setPriority(int priority) {
        if (priority < 1 || priority > 10) {
            throw new IllegalArgumentException("Priority out of range: " + priority);
        }
        if (priority > this.group.getMaxPriority()) {
            priority = this.group.getMaxPriority();
        }
        this.priority = priority;
        VMThread vmt = this.vmThread;
        if (vmt != null) {
            vmt.setPriority(priority);
        }
    }

    public void setUncaughtExceptionHandler(UncaughtExceptionHandler handler) {
        this.uncaughtHandler = handler;
    }

    public static void sleep(long time) throws InterruptedException {
        Thread.sleep(time, 0);
    }

    public static void sleep(long millis, int nanos) throws InterruptedException {
        VMThread.sleep(millis, nanos);
    }

    public synchronized void start() {
        this.checkNotStarted();
        this.hasBeenStarted = true;
        VMThread.create(this, this.stackSize);
    }

    @Deprecated
    public final void stop() {
        this.stop(new ThreadDeath());
    }

    @Deprecated
    public final synchronized void stop(Throwable throwable) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public final void suspend() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "Thread[" + this.name + "," + this.priority + "," + this.group.getName() + "]";
    }

    public static void yield() {
        VMThread.yield();
    }

    public static boolean holdsLock(Object object) {
        return Thread.currentThread().vmThread.holdsLock(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpark() {
        VMThread vmt = this.vmThread;
        if (vmt == null) {
            this.parkState = 2;
            return;
        }
        VMThread vMThread = vmt;
        synchronized (vMThread) {
            switch (this.parkState) {
                case 2: {
                    break;
                }
                case 1: {
                    this.parkState = 2;
                    break;
                }
                default: {
                    this.parkState = 1;
                    vmt.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parkFor(long nanos) {
        VMThread vmt = this.vmThread;
        if (vmt == null) {
            throw new AssertionError();
        }
        VMThread vMThread = vmt;
        synchronized (vMThread) {
            switch (this.parkState) {
                case 2: {
                    this.parkState = 1;
                    break;
                }
                case 1: {
                    long millis = nanos / 1000000L;
                    nanos %= 1000000L;
                    this.parkState = 3;
                    try {
                        try {
                            vmt.wait(millis, (int)nanos);
                        }
                        catch (InterruptedException ex) {
                            this.interrupt();
                            Object var9_6 = null;
                            if (this.parkState != 3) break;
                            this.parkState = 1;
                            break;
                        }
                        Object var9_5 = null;
                        if (this.parkState != 3) break;
                        this.parkState = 1;
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var9_7 = null;
                        if (this.parkState == 3) {
                            this.parkState = 1;
                        }
                        throw throwable;
                    }
                }
                default: {
                    throw new AssertionError((Object)"shouldn't happen: attempt to repark");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parkUntil(long time) {
        VMThread vmt = this.vmThread;
        if (vmt == null) {
            throw new AssertionError();
        }
        VMThread vMThread = vmt;
        synchronized (vMThread) {
            long delayMillis = time - System.currentTimeMillis();
            if (delayMillis <= 0L) {
                this.parkState = 1;
            } else {
                this.parkFor(delayMillis * 1000000L);
            }
        }
    }

    public static interface UncaughtExceptionHandler {
        public void uncaughtException(Thread var1, Throwable var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        RUNNABLE,
        BLOCKED,
        WAITING,
        TIMED_WAITING,
        TERMINATED;

    }

    private static class ParkState {
        private static final int UNPARKED = 1;
        private static final int PREEMPTIVELY_UNPARKED = 2;
        private static final int PARKED = 3;

        private ParkState() {
        }
    }
}

