/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Array {
    private Array() {
    }

    private static IllegalArgumentException notAnArray(Object o) {
        throw new IllegalArgumentException("Not an array: " + o.getClass());
    }

    private static IllegalArgumentException incompatibleType(Object o) {
        throw new IllegalArgumentException("Array has incompatible type: " + o.getClass());
    }

    private static RuntimeException badArray(Object array2) {
        if (array2 == null) {
            throw new NullPointerException("array == null");
        }
        if (!array2.getClass().isArray()) {
            throw Array.notAnArray(array2);
        }
        throw Array.incompatibleType(array2);
    }

    public static Object get(Object array2, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof Object[]) {
            return ((Object[])array2)[index];
        }
        if (array2 instanceof boolean[]) {
            return ((boolean[])array2)[index] ? Boolean.TRUE : Boolean.FALSE;
        }
        if (array2 instanceof byte[]) {
            return ((byte[])array2)[index];
        }
        if (array2 instanceof char[]) {
            return Character.valueOf(((char[])array2)[index]);
        }
        if (array2 instanceof short[]) {
            return ((short[])array2)[index];
        }
        if (array2 instanceof int[]) {
            return ((int[])array2)[index];
        }
        if (array2 instanceof long[]) {
            return ((long[])array2)[index];
        }
        if (array2 instanceof float[]) {
            return new Float(((float[])array2)[index]);
        }
        if (array2 instanceof double[]) {
            return new Double(((double[])array2)[index]);
        }
        if (array2 == null) {
            throw new NullPointerException("array == null");
        }
        throw Array.notAnArray(array2);
    }

    public static boolean getBoolean(Object array2, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof boolean[]) {
            return ((boolean[])array2)[index];
        }
        throw Array.badArray(array2);
    }

    public static byte getByte(Object array2, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof byte[]) {
            return ((byte[])array2)[index];
        }
        throw Array.badArray(array2);
    }

    public static char getChar(Object array2, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof char[]) {
            return ((char[])array2)[index];
        }
        throw Array.badArray(array2);
    }

    public static double getDouble(Object array2, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof double[]) {
            return ((double[])array2)[index];
        }
        if (array2 instanceof byte[]) {
            return ((byte[])array2)[index];
        }
        if (array2 instanceof char[]) {
            return ((char[])array2)[index];
        }
        if (array2 instanceof float[]) {
            return ((float[])array2)[index];
        }
        if (array2 instanceof int[]) {
            return ((int[])array2)[index];
        }
        if (array2 instanceof long[]) {
            return ((long[])array2)[index];
        }
        if (array2 instanceof short[]) {
            return ((short[])array2)[index];
        }
        throw Array.badArray(array2);
    }

    public static float getFloat(Object array2, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof float[]) {
            return ((float[])array2)[index];
        }
        if (array2 instanceof byte[]) {
            return ((byte[])array2)[index];
        }
        if (array2 instanceof char[]) {
            return ((char[])array2)[index];
        }
        if (array2 instanceof int[]) {
            return ((int[])array2)[index];
        }
        if (array2 instanceof long[]) {
            return ((long[])array2)[index];
        }
        if (array2 instanceof short[]) {
            return ((short[])array2)[index];
        }
        throw Array.badArray(array2);
    }

    public static int getInt(Object array2, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof int[]) {
            return ((int[])array2)[index];
        }
        if (array2 instanceof byte[]) {
            return ((byte[])array2)[index];
        }
        if (array2 instanceof char[]) {
            return ((char[])array2)[index];
        }
        if (array2 instanceof short[]) {
            return ((short[])array2)[index];
        }
        throw Array.badArray(array2);
    }

    public static int getLength(Object array2) {
        if (array2 instanceof Object[]) {
            return ((Object[])array2).length;
        }
        if (array2 instanceof boolean[]) {
            return ((boolean[])array2).length;
        }
        if (array2 instanceof byte[]) {
            return ((byte[])array2).length;
        }
        if (array2 instanceof char[]) {
            return ((char[])array2).length;
        }
        if (array2 instanceof double[]) {
            return ((double[])array2).length;
        }
        if (array2 instanceof float[]) {
            return ((float[])array2).length;
        }
        if (array2 instanceof int[]) {
            return ((int[])array2).length;
        }
        if (array2 instanceof long[]) {
            return ((long[])array2).length;
        }
        if (array2 instanceof short[]) {
            return ((short[])array2).length;
        }
        throw Array.badArray(array2);
    }

    public static long getLong(Object array2, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof long[]) {
            return ((long[])array2)[index];
        }
        if (array2 instanceof byte[]) {
            return ((byte[])array2)[index];
        }
        if (array2 instanceof char[]) {
            return ((char[])array2)[index];
        }
        if (array2 instanceof int[]) {
            return ((int[])array2)[index];
        }
        if (array2 instanceof short[]) {
            return ((short[])array2)[index];
        }
        throw Array.badArray(array2);
    }

    public static short getShort(Object array2, int index) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof short[]) {
            return ((short[])array2)[index];
        }
        if (array2 instanceof byte[]) {
            return ((byte[])array2)[index];
        }
        throw Array.badArray(array2);
    }

    public static Object newInstance(Class<?> componentType, int ... dimensions) throws NegativeArraySizeException, IllegalArgumentException {
        if (dimensions.length <= 0 || dimensions.length > 255) {
            throw new IllegalArgumentException("Bad number of dimensions: " + dimensions.length);
        }
        if (componentType == Void.TYPE) {
            throw new IllegalArgumentException("Can't allocate an array of void");
        }
        if (componentType == null) {
            throw new NullPointerException("componentType == null");
        }
        return Array.createMultiArray(componentType, dimensions);
    }

    private static native Object createMultiArray(Class<?> var0, int[] var1) throws NegativeArraySizeException;

    public static Object newInstance(Class<?> componentType, int size) throws NegativeArraySizeException {
        if (!componentType.isPrimitive()) {
            return Array.createObjectArray(componentType, size);
        }
        if (componentType == Boolean.TYPE) {
            return new boolean[size];
        }
        if (componentType == Byte.TYPE) {
            return new byte[size];
        }
        if (componentType == Character.TYPE) {
            return new char[size];
        }
        if (componentType == Short.TYPE) {
            return new short[size];
        }
        if (componentType == Integer.TYPE) {
            return new int[size];
        }
        if (componentType == Long.TYPE) {
            return new long[size];
        }
        if (componentType == Float.TYPE) {
            return new float[size];
        }
        if (componentType == Double.TYPE) {
            return new double[size];
        }
        if (componentType == Void.TYPE) {
            throw new IllegalArgumentException("Can't allocate an array of void");
        }
        throw new AssertionError();
    }

    private static native Object createObjectArray(Class<?> var0, int var1) throws NegativeArraySizeException;

    public static void set(Object array2, int index, Object value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (!array2.getClass().isArray()) {
            throw Array.notAnArray(array2);
        }
        if (array2 instanceof Object[]) {
            if (value != null && !array2.getClass().getComponentType().isInstance(value)) {
                throw Array.incompatibleType(array2);
            }
            ((Object[])array2)[index] = value;
        } else {
            if (value == null) {
                throw new IllegalArgumentException("Primitive array can't take null values.");
            }
            if (value instanceof Boolean) {
                Array.setBoolean(array2, index, (Boolean)value);
            } else if (value instanceof Byte) {
                Array.setByte(array2, index, (Byte)value);
            } else if (value instanceof Character) {
                Array.setChar(array2, index, ((Character)value).charValue());
            } else if (value instanceof Short) {
                Array.setShort(array2, index, (Short)value);
            } else if (value instanceof Integer) {
                Array.setInt(array2, index, (Integer)value);
            } else if (value instanceof Long) {
                Array.setLong(array2, index, (Long)value);
            } else if (value instanceof Float) {
                Array.setFloat(array2, index, ((Float)value).floatValue());
            } else if (value instanceof Double) {
                Array.setDouble(array2, index, (Double)value);
            }
        }
    }

    public static void setBoolean(Object array2, int index, boolean value) {
        if (!(array2 instanceof boolean[])) {
            throw Array.badArray(array2);
        }
        ((boolean[])array2)[index] = value;
    }

    public static void setByte(Object array2, int index, byte value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof byte[]) {
            ((byte[])array2)[index] = value;
        } else if (array2 instanceof double[]) {
            ((double[])array2)[index] = value;
        } else if (array2 instanceof float[]) {
            ((float[])array2)[index] = value;
        } else if (array2 instanceof int[]) {
            ((int[])array2)[index] = value;
        } else if (array2 instanceof long[]) {
            ((long[])array2)[index] = value;
        } else if (array2 instanceof short[]) {
            ((short[])array2)[index] = value;
        } else {
            throw Array.badArray(array2);
        }
    }

    public static void setChar(Object array2, int index, char value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof char[]) {
            ((char[])array2)[index] = value;
        } else if (array2 instanceof double[]) {
            ((double[])array2)[index] = value;
        } else if (array2 instanceof float[]) {
            ((float[])array2)[index] = value;
        } else if (array2 instanceof int[]) {
            ((int[])array2)[index] = value;
        } else if (array2 instanceof long[]) {
            ((long[])array2)[index] = value;
        } else {
            throw Array.badArray(array2);
        }
    }

    public static void setDouble(Object array2, int index, double value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (!(array2 instanceof double[])) {
            throw Array.badArray(array2);
        }
        ((double[])array2)[index] = value;
    }

    public static void setFloat(Object array2, int index, float value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof float[]) {
            ((float[])array2)[index] = value;
        } else if (array2 instanceof double[]) {
            ((double[])array2)[index] = value;
        } else {
            throw Array.badArray(array2);
        }
    }

    public static void setInt(Object array2, int index, int value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof int[]) {
            ((int[])array2)[index] = value;
        } else if (array2 instanceof double[]) {
            ((double[])array2)[index] = value;
        } else if (array2 instanceof float[]) {
            ((float[])array2)[index] = value;
        } else if (array2 instanceof long[]) {
            ((long[])array2)[index] = value;
        } else {
            throw Array.badArray(array2);
        }
    }

    public static void setLong(Object array2, int index, long value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof long[]) {
            ((long[])array2)[index] = value;
        } else if (array2 instanceof double[]) {
            ((double[])array2)[index] = value;
        } else if (array2 instanceof float[]) {
            ((float[])array2)[index] = value;
        } else {
            throw Array.badArray(array2);
        }
    }

    public static void setShort(Object array2, int index, short value) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (array2 instanceof short[]) {
            ((short[])array2)[index] = value;
        } else if (array2 instanceof double[]) {
            ((double[])array2)[index] = value;
        } else if (array2 instanceof float[]) {
            ((float[])array2)[index] = value;
        } else if (array2 instanceof int[]) {
            ((int[])array2)[index] = value;
        } else if (array2 instanceof long[]) {
            ((long[])array2)[index] = value;
        } else {
            throw Array.badArray(array2);
        }
    }
}

