/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Comparator;
import libcore.reflect.GenericSignatureParser;
import libcore.reflect.ListOfTypes;
import libcore.reflect.Types;
import libcore.util.EmptyArray;
import org.apache.harmony.kernel.vm.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Method
extends AccessibleObject
implements GenericDeclaration,
Member {
    public static final Comparator<Method> ORDER_BY_SIGNATURE = new Comparator<Method>(){

        @Override
        public int compare(Method a, Method b) {
            int comparison = a.name.compareTo(b.name);
            if (comparison != 0) {
                return comparison;
            }
            Class[] aParameters = a.parameterTypes;
            Class[] bParameters = b.parameterTypes;
            int length = Math.min(aParameters.length, bParameters.length);
            for (int i = 0; i < length; ++i) {
                comparison = aParameters[i].getName().compareTo(bParameters[i].getName());
                if (comparison == 0) continue;
                return comparison;
            }
            if (aParameters.length != bParameters.length) {
                return aParameters.length - bParameters.length;
            }
            return a.getReturnType().getName().compareTo(b.getReturnType().getName());
        }
    };
    private int slot;
    private final int methodDexIndex;
    private Class<?> declaringClass;
    private String name;
    private Class<?>[] parameterTypes;
    private Class<?>[] exceptionTypes;
    private Class<?> returnType;
    private ListOfTypes genericExceptionTypes;
    private ListOfTypes genericParameterTypes;
    private Type genericReturnType;
    private TypeVariable<Method>[] formalTypeParameters;
    private volatile boolean genericTypesAreInitialized = false;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];

    private synchronized void initGenericTypes() {
        if (!this.genericTypesAreInitialized) {
            String signatureAttribute = this.getSignatureAttribute();
            GenericSignatureParser parser = new GenericSignatureParser(this.declaringClass.getClassLoader());
            parser.parseForMethod(this, signatureAttribute, this.exceptionTypes);
            this.formalTypeParameters = parser.formalTypeParameters;
            this.genericParameterTypes = parser.parameterTypes;
            this.genericExceptionTypes = parser.exceptionTypes;
            this.genericReturnType = parser.returnType;
            this.genericTypesAreInitialized = true;
        }
    }

    private Method(Class<?> declaring, Class<?>[] paramTypes, Class<?>[] exceptTypes, Class<?> returnType, String name, int slot, int methodDexIndex) {
        this.declaringClass = declaring;
        this.name = name;
        this.slot = slot;
        this.parameterTypes = paramTypes;
        this.exceptionTypes = exceptTypes;
        this.returnType = returnType;
        this.methodDexIndex = methodDexIndex;
    }

    public int getDexMethodIndex() {
        return this.methodDexIndex;
    }

    public TypeVariable<Method>[] getTypeParameters() {
        this.initGenericTypes();
        return (TypeVariable[])this.formalTypeParameters.clone();
    }

    @Override
    String getSignatureAttribute() {
        Object[] annotation = Method.getSignatureAnnotation(this.declaringClass, this.slot);
        if (annotation == null) {
            return null;
        }
        return StringUtils.combineStrings(annotation);
    }

    static native Object[] getSignatureAnnotation(Class var0, int var1);

    public String toGenericString() {
        StringBuilder sb = new StringBuilder(80);
        this.initGenericTypes();
        int modifier = this.getModifiers();
        if (modifier != 0) {
            sb.append(Modifier.toString(modifier & 0xFFFFFF3F)).append(' ');
        }
        if (this.formalTypeParameters != null && this.formalTypeParameters.length > 0) {
            sb.append('<');
            for (int i = 0; i < this.formalTypeParameters.length; ++i) {
                this.appendGenericType(sb, this.formalTypeParameters[i]);
                if (i >= this.formalTypeParameters.length - 1) continue;
                sb.append(",");
            }
            sb.append("> ");
        }
        this.appendGenericType(sb, Types.getType(this.genericReturnType));
        sb.append(' ');
        this.appendTypeName(sb, this.getDeclaringClass());
        sb.append(".").append(this.getName());
        sb.append('(');
        this.appendArrayGenericType(sb, Types.getTypeArray(this.genericParameterTypes, false));
        sb.append(')');
        Type[] genericExceptionTypeArray = Types.getTypeArray(this.genericExceptionTypes, false);
        if (genericExceptionTypeArray.length > 0) {
            sb.append(" throws ");
            this.appendArrayGenericType(sb, genericExceptionTypeArray);
        }
        return sb.toString();
    }

    public Type[] getGenericParameterTypes() {
        this.initGenericTypes();
        return Types.getTypeArray(this.genericParameterTypes, true);
    }

    public Type[] getGenericExceptionTypes() {
        this.initGenericTypes();
        return Types.getTypeArray(this.genericExceptionTypes, true);
    }

    public Type getGenericReturnType() {
        this.initGenericTypes();
        return Types.getType(this.genericReturnType);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return Method.getDeclaredAnnotations(this.declaringClass, this.slot);
    }

    static native Annotation[] getDeclaredAnnotations(Class<?> var0, int var1);

    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return Method.getAnnotation(this.declaringClass, this.slot, annotationType);
    }

    static native <A extends Annotation> A getAnnotation(Class<?> var0, int var1, Class<A> var2);

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        if (annotationType == null) {
            throw new NullPointerException("annotationType == null");
        }
        return Method.isAnnotationPresent(this.declaringClass, this.slot, annotationType);
    }

    static native boolean isAnnotationPresent(Class<?> var0, int var1, Class<? extends Annotation> var2);

    static Annotation[][] noAnnotations(int size) {
        Annotation[][] annotations = new Annotation[size][];
        for (int i = 0; i < size; ++i) {
            annotations[i] = NO_ANNOTATIONS;
        }
        return annotations;
    }

    public Annotation[][] getParameterAnnotations() {
        Annotation[][] parameterAnnotations = Method.getParameterAnnotations(this.declaringClass, this.slot);
        if (parameterAnnotations.length == 0) {
            return Method.noAnnotations(this.parameterTypes.length);
        }
        return parameterAnnotations;
    }

    static native Annotation[][] getParameterAnnotations(Class var0, int var1);

    public boolean isVarArgs() {
        int modifiers = Method.getMethodModifiers(this.declaringClass, this.slot);
        return (modifiers & 0x80) != 0;
    }

    public boolean isBridge() {
        int modifiers = Method.getMethodModifiers(this.declaringClass, this.slot);
        return (modifiers & 0x40) != 0;
    }

    @Override
    public boolean isSynthetic() {
        int modifiers = Method.getMethodModifiers(this.declaringClass, this.slot);
        return (modifiers & 0x1000) != 0;
    }

    public Object getDefaultValue() {
        return this.getDefaultValue(this.declaringClass, this.slot);
    }

    private native Object getDefaultValue(Class var1, int var2);

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Method)) {
            return false;
        }
        Method rhs = (Method)object;
        return this.declaringClass.equals(rhs.declaringClass) && this.name.equals(rhs.name) && this.getModifiers() == rhs.getModifiers() && this.returnType.equals(rhs.returnType) && Arrays.equals(this.parameterTypes, rhs.parameterTypes);
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    public Class<?>[] getExceptionTypes() {
        if (this.exceptionTypes == null) {
            return EmptyArray.CLASS;
        }
        return (Class[])this.exceptionTypes.clone();
    }

    @Override
    public int getModifiers() {
        return Method.getMethodModifiers(this.declaringClass, this.slot);
    }

    static native int getMethodModifiers(Class<?> var0, int var1);

    @Override
    public String getName() {
        return this.name;
    }

    public Class<?>[] getParameterTypes() {
        return (Class[])this.parameterTypes.clone();
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public Object invoke(Object receiver, Object ... args) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (args == null) {
            args = EmptyArray.OBJECT;
        }
        return this.invokeNative(receiver, args, this.declaringClass, this.parameterTypes, this.returnType, this.slot, this.flag);
    }

    private native Object invokeNative(Object var1, Object[] var2, Class<?> var3, Class<?>[] var4, Class<?> var5, int var6, boolean var7) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public String toString() {
        StringBuilder result = new StringBuilder(Modifier.toString(this.getModifiers()));
        if (result.length() != 0) {
            result.append(' ');
        }
        result.append(this.returnType.getName());
        result.append(' ');
        result.append(this.declaringClass.getName());
        result.append('.');
        result.append(this.name);
        result.append("(");
        result.append(this.toString(this.parameterTypes));
        result.append(")");
        if (this.exceptionTypes != null && this.exceptionTypes.length != 0) {
            result.append(" throws ");
            result.append(this.toString(this.exceptionTypes));
        }
        return result.toString();
    }

    private String getSignature() {
        StringBuilder result = new StringBuilder();
        result.append('(');
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            result.append(this.getSignature(this.parameterTypes[i]));
        }
        result.append(')');
        result.append(this.getSignature(this.returnType));
        return result.toString();
    }
}

