/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteArrayBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DirectByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MemoryBlock;
import java.nio.NioUtils;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.util.Arrays;
import libcore.io.Memory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteBuffer
extends Buffer
implements Comparable<ByteBuffer> {
    ByteOrder order = ByteOrder.BIG_ENDIAN;

    public static ByteBuffer allocate(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        return new ByteArrayBuffer(new byte[capacity]);
    }

    public static ByteBuffer allocateDirect(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("capacity < 0: " + capacity);
        }
        return new DirectByteBuffer(MemoryBlock.allocate(capacity), capacity, 0, false, null);
    }

    public static ByteBuffer wrap(byte[] array2) {
        return new ByteArrayBuffer(array2);
    }

    public static ByteBuffer wrap(byte[] array2, int start, int byteCount) {
        Arrays.checkOffsetAndCount(array2.length, start, byteCount);
        ByteArrayBuffer buf = new ByteArrayBuffer(array2);
        buf.position = start;
        buf.limit = start + byteCount;
        return buf;
    }

    ByteBuffer(int capacity, long effectiveDirectAddress) {
        super(0, capacity, effectiveDirectAddress);
    }

    public final byte[] array() {
        return this.protectedArray();
    }

    @Override
    public final int arrayOffset() {
        return this.protectedArrayOffset();
    }

    public abstract CharBuffer asCharBuffer();

    public abstract DoubleBuffer asDoubleBuffer();

    public abstract FloatBuffer asFloatBuffer();

    public abstract IntBuffer asIntBuffer();

    public abstract LongBuffer asLongBuffer();

    public abstract ByteBuffer asReadOnlyBuffer();

    public abstract ShortBuffer asShortBuffer();

    public abstract ByteBuffer compact();

    @Override
    public int compareTo(ByteBuffer otherBuffer) {
        int thisPos = this.position;
        int otherPos = otherBuffer.position;
        for (int compareRemaining = this.remaining() < otherBuffer.remaining() ? this.remaining() : otherBuffer.remaining(); compareRemaining > 0; --compareRemaining) {
            byte otherByte;
            byte thisByte = this.get(thisPos);
            if (thisByte != (otherByte = otherBuffer.get(otherPos))) {
                return thisByte < otherByte ? -1 : 1;
            }
            ++thisPos;
            ++otherPos;
        }
        return this.remaining() - otherBuffer.remaining();
    }

    public abstract ByteBuffer duplicate();

    public boolean equals(Object other) {
        if (!(other instanceof ByteBuffer)) {
            return false;
        }
        ByteBuffer otherBuffer = (ByteBuffer)other;
        if (this.remaining() != otherBuffer.remaining()) {
            return false;
        }
        int myPosition = this.position;
        int otherPosition = otherBuffer.position;
        boolean equalSoFar = true;
        while (equalSoFar && myPosition < this.limit) {
            equalSoFar = this.get(myPosition++) == otherBuffer.get(otherPosition++);
        }
        return equalSoFar;
    }

    public abstract byte get();

    public ByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public ByteBuffer get(byte[] dst, int dstOffset, int byteCount) {
        Arrays.checkOffsetAndCount(dst.length, dstOffset, byteCount);
        if (byteCount > this.remaining()) {
            throw new BufferUnderflowException();
        }
        for (int i = dstOffset; i < dstOffset + byteCount; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public abstract byte get(int var1);

    public abstract char getChar();

    public abstract char getChar(int var1);

    public abstract double getDouble();

    public abstract double getDouble(int var1);

    public abstract float getFloat();

    public abstract float getFloat(int var1);

    public abstract int getInt();

    public abstract int getInt(int var1);

    public abstract long getLong();

    public abstract long getLong(int var1);

    public abstract short getShort();

    public abstract short getShort(int var1);

    @Override
    public final boolean hasArray() {
        return this.protectedHasArray();
    }

    public int hashCode() {
        int myPosition = this.position;
        int hash = 0;
        while (myPosition < this.limit) {
            hash += this.get(myPosition++);
        }
        return hash;
    }

    @Override
    public abstract boolean isDirect();

    public boolean isValid() {
        return true;
    }

    public final ByteOrder order() {
        return this.order;
    }

    public final ByteBuffer order(ByteOrder byteOrder) {
        if (byteOrder == null) {
            byteOrder = ByteOrder.LITTLE_ENDIAN;
        }
        this.order = byteOrder;
        return this;
    }

    abstract byte[] protectedArray();

    abstract int protectedArrayOffset();

    abstract boolean protectedHasArray();

    public abstract ByteBuffer put(byte var1);

    public final ByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        Arrays.checkOffsetAndCount(src.length, srcOffset, byteCount);
        if (byteCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        for (int i = srcOffset; i < srcOffset + byteCount; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public ByteBuffer put(ByteBuffer src) {
        ByteBuffer dst;
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (src == this) {
            throw new IllegalArgumentException("src == this");
        }
        int srcByteCount = src.remaining();
        if (srcByteCount > this.remaining()) {
            throw new BufferOverflowException();
        }
        Object srcObject = src.isDirect() ? src : (Object)NioUtils.unsafeArray(src);
        int srcOffset = src.position();
        if (!src.isDirect()) {
            srcOffset += NioUtils.unsafeArrayOffset(src);
        }
        Object dstObject = (dst = this).isDirect() ? dst : (Object)NioUtils.unsafeArray(dst);
        int dstOffset = dst.position();
        if (!dst.isDirect()) {
            dstOffset += NioUtils.unsafeArrayOffset(dst);
        }
        Memory.memmove(dstObject, dstOffset, srcObject, srcOffset, srcByteCount);
        src.position(src.limit());
        dst.position(dst.position() + srcByteCount);
        return this;
    }

    public abstract ByteBuffer put(int var1, byte var2);

    public abstract ByteBuffer putChar(char var1);

    public abstract ByteBuffer putChar(int var1, char var2);

    public abstract ByteBuffer putDouble(double var1);

    public abstract ByteBuffer putDouble(int var1, double var2);

    public abstract ByteBuffer putFloat(float var1);

    public abstract ByteBuffer putFloat(int var1, float var2);

    public abstract ByteBuffer putInt(int var1);

    public abstract ByteBuffer putInt(int var1, int var2);

    public abstract ByteBuffer putLong(long var1);

    public abstract ByteBuffer putLong(int var1, long var2);

    public abstract ByteBuffer putShort(short var1);

    public abstract ByteBuffer putShort(int var1, short var2);

    public abstract ByteBuffer slice();
}

