/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteBufferAsCharBuffer;
import java.nio.ByteBufferAsDoubleBuffer;
import java.nio.ByteBufferAsFloatBuffer;
import java.nio.ByteBufferAsIntBuffer;
import java.nio.ByteBufferAsLongBuffer;
import java.nio.ByteBufferAsShortBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.MemoryBlock;
import java.nio.ReadOnlyBufferException;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import libcore.io.Memory;

class DirectByteBuffer
extends MappedByteBuffer {
    protected final int offset;
    private boolean freed;
    private final boolean isReadOnly;

    protected DirectByteBuffer(MemoryBlock block, int capacity, int offset, boolean isReadOnly, FileChannel.MapMode mapMode) {
        super(block, capacity, mapMode, block.toLong() + (long)offset);
        long baseSize = block.getSize();
        if (baseSize >= 0L && (long)(capacity + offset) > baseSize) {
            throw new IllegalArgumentException("capacity + offset > baseSize");
        }
        this.offset = offset;
        this.isReadOnly = isReadOnly;
    }

    DirectByteBuffer(long address, int capacity) {
        this(MemoryBlock.wrapFromJni(address, capacity), capacity, 0, false, null);
    }

    private static DirectByteBuffer copy(DirectByteBuffer other, int markOfOther, boolean isReadOnly) {
        other.checkNotFreed();
        DirectByteBuffer buf = new DirectByteBuffer(other.block, other.capacity(), other.offset, isReadOnly, other.mapMode);
        buf.limit = other.limit;
        buf.position = other.position();
        buf.mark = markOfOther;
        return buf;
    }

    public ByteBuffer asReadOnlyBuffer() {
        return DirectByteBuffer.copy(this, this.mark, true);
    }

    public ByteBuffer compact() {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        Memory.memmove(this, 0, this, this.position, this.remaining());
        this.position = this.limit - this.position;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public ByteBuffer duplicate() {
        return DirectByteBuffer.copy(this, this.mark, this.isReadOnly);
    }

    public ByteBuffer slice() {
        this.checkNotFreed();
        return new DirectByteBuffer(this.block, this.remaining(), this.offset + this.position, this.isReadOnly, this.mapMode);
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    byte[] protectedArray() {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        byte[] array2 = this.block.array();
        if (array2 == null) {
            throw new UnsupportedOperationException();
        }
        return array2;
    }

    int protectedArrayOffset() {
        this.protectedArray();
        return this.offset;
    }

    boolean protectedHasArray() {
        return !this.isReadOnly && this.block.array() != null;
    }

    public final ByteBuffer get(byte[] dst, int dstOffset, int byteCount) {
        this.checkNotFreed();
        this.checkGetBounds(1, dst.length, dstOffset, byteCount);
        this.block.peekByteArray(this.offset + this.position, dst, dstOffset, byteCount);
        this.position += byteCount;
        return this;
    }

    final void get(char[] dst, int dstOffset, int charCount) {
        this.checkNotFreed();
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, charCount);
        this.block.peekCharArray(this.offset + this.position, dst, dstOffset, charCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(double[] dst, int dstOffset, int doubleCount) {
        this.checkNotFreed();
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, doubleCount);
        this.block.peekDoubleArray(this.offset + this.position, dst, dstOffset, doubleCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(float[] dst, int dstOffset, int floatCount) {
        this.checkNotFreed();
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, floatCount);
        this.block.peekFloatArray(this.offset + this.position, dst, dstOffset, floatCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(int[] dst, int dstOffset, int intCount) {
        this.checkNotFreed();
        int byteCount = this.checkGetBounds(4, dst.length, dstOffset, intCount);
        this.block.peekIntArray(this.offset + this.position, dst, dstOffset, intCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(long[] dst, int dstOffset, int longCount) {
        this.checkNotFreed();
        int byteCount = this.checkGetBounds(8, dst.length, dstOffset, longCount);
        this.block.peekLongArray(this.offset + this.position, dst, dstOffset, longCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void get(short[] dst, int dstOffset, int shortCount) {
        this.checkNotFreed();
        int byteCount = this.checkGetBounds(2, dst.length, dstOffset, shortCount);
        this.block.peekShortArray(this.offset + this.position, dst, dstOffset, shortCount, this.order.needsSwap);
        this.position += byteCount;
    }

    public final byte get() {
        this.checkNotFreed();
        if (this.position == this.limit) {
            throw new BufferUnderflowException();
        }
        return this.block.peekByte(this.offset + this.position++);
    }

    public final byte get(int index) {
        this.checkNotFreed();
        this.checkIndex(index);
        return this.block.peekByte(this.offset + index);
    }

    public final char getChar() {
        this.checkNotFreed();
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        char result = (char)this.block.peekShort(this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final char getChar(int index) {
        this.checkNotFreed();
        this.checkIndex(index, 2);
        return (char)this.block.peekShort(this.offset + index, this.order);
    }

    public final double getDouble() {
        this.checkNotFreed();
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        double result = Double.longBitsToDouble(this.block.peekLong(this.offset + this.position, this.order));
        this.position = newPosition;
        return result;
    }

    public final double getDouble(int index) {
        this.checkNotFreed();
        this.checkIndex(index, 8);
        return Double.longBitsToDouble(this.block.peekLong(this.offset + index, this.order));
    }

    public final float getFloat() {
        this.checkNotFreed();
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        float result = Float.intBitsToFloat(this.block.peekInt(this.offset + this.position, this.order));
        this.position = newPosition;
        return result;
    }

    public final float getFloat(int index) {
        this.checkNotFreed();
        this.checkIndex(index, 4);
        return Float.intBitsToFloat(this.block.peekInt(this.offset + index, this.order));
    }

    public final int getInt() {
        this.checkNotFreed();
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        int result = this.block.peekInt(this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final int getInt(int index) {
        this.checkNotFreed();
        this.checkIndex(index, 4);
        return this.block.peekInt(this.offset + index, this.order);
    }

    public final long getLong() {
        this.checkNotFreed();
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        long result = this.block.peekLong(this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final long getLong(int index) {
        this.checkNotFreed();
        this.checkIndex(index, 8);
        return this.block.peekLong(this.offset + index, this.order);
    }

    public final short getShort() {
        this.checkNotFreed();
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferUnderflowException();
        }
        short result = this.block.peekShort(this.offset + this.position, this.order);
        this.position = newPosition;
        return result;
    }

    public final short getShort(int index) {
        this.checkNotFreed();
        this.checkIndex(index, 2);
        return this.block.peekShort(this.offset + index, this.order);
    }

    public final boolean isDirect() {
        return true;
    }

    public final boolean isValid() {
        return !this.freed;
    }

    public final void free() {
        if (!this.freed) {
            this.block.free();
            this.freed = true;
        }
    }

    public final CharBuffer asCharBuffer() {
        this.checkNotFreed();
        return ByteBufferAsCharBuffer.asCharBuffer(this);
    }

    public final DoubleBuffer asDoubleBuffer() {
        this.checkNotFreed();
        return ByteBufferAsDoubleBuffer.asDoubleBuffer(this);
    }

    public final FloatBuffer asFloatBuffer() {
        this.checkNotFreed();
        return ByteBufferAsFloatBuffer.asFloatBuffer(this);
    }

    public final IntBuffer asIntBuffer() {
        this.checkNotFreed();
        return ByteBufferAsIntBuffer.asIntBuffer(this);
    }

    public final LongBuffer asLongBuffer() {
        this.checkNotFreed();
        return ByteBufferAsLongBuffer.asLongBuffer(this);
    }

    public final ShortBuffer asShortBuffer() {
        this.checkNotFreed();
        return ByteBufferAsShortBuffer.asShortBuffer(this);
    }

    public ByteBuffer put(byte value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        if (this.position == this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeByte(this.offset + this.position++, value);
        return this;
    }

    public ByteBuffer put(int index, byte value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index);
        this.block.pokeByte(this.offset + index, value);
        return this;
    }

    public ByteBuffer put(byte[] src, int srcOffset, int byteCount) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkPutBounds(1, src.length, srcOffset, byteCount);
        this.block.pokeByteArray(this.offset + this.position, src, srcOffset, byteCount);
        this.position += byteCount;
        return this;
    }

    final void put(char[] src, int srcOffset, int charCount) {
        this.checkNotFreed();
        int byteCount = this.checkPutBounds(2, src.length, srcOffset, charCount);
        this.block.pokeCharArray(this.offset + this.position, src, srcOffset, charCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(double[] src, int srcOffset, int doubleCount) {
        this.checkNotFreed();
        int byteCount = this.checkPutBounds(8, src.length, srcOffset, doubleCount);
        this.block.pokeDoubleArray(this.offset + this.position, src, srcOffset, doubleCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(float[] src, int srcOffset, int floatCount) {
        this.checkNotFreed();
        int byteCount = this.checkPutBounds(4, src.length, srcOffset, floatCount);
        this.block.pokeFloatArray(this.offset + this.position, src, srcOffset, floatCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(int[] src, int srcOffset, int intCount) {
        this.checkNotFreed();
        int byteCount = this.checkPutBounds(4, src.length, srcOffset, intCount);
        this.block.pokeIntArray(this.offset + this.position, src, srcOffset, intCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(long[] src, int srcOffset, int longCount) {
        this.checkNotFreed();
        int byteCount = this.checkPutBounds(8, src.length, srcOffset, longCount);
        this.block.pokeLongArray(this.offset + this.position, src, srcOffset, longCount, this.order.needsSwap);
        this.position += byteCount;
    }

    final void put(short[] src, int srcOffset, int shortCount) {
        this.checkNotFreed();
        int byteCount = this.checkPutBounds(2, src.length, srcOffset, shortCount);
        this.block.pokeShortArray(this.offset + this.position, src, srcOffset, shortCount, this.order.needsSwap);
        this.position += byteCount;
    }

    public ByteBuffer putChar(char value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeShort(this.offset + this.position, (short)value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putChar(int index, char value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 2);
        this.block.pokeShort(this.offset + index, (short)value, this.order);
        return this;
    }

    public ByteBuffer putDouble(double value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeLong(this.offset + this.position, Double.doubleToRawLongBits(value), this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putDouble(int index, double value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 8);
        this.block.pokeLong(this.offset + index, Double.doubleToRawLongBits(value), this.order);
        return this;
    }

    public ByteBuffer putFloat(float value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeInt(this.offset + this.position, Float.floatToRawIntBits(value), this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putFloat(int index, float value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 4);
        this.block.pokeInt(this.offset + index, Float.floatToRawIntBits(value), this.order);
        return this;
    }

    public ByteBuffer putInt(int value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 4;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeInt(this.offset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putInt(int index, int value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 4);
        this.block.pokeInt(this.offset + index, value, this.order);
        return this;
    }

    public ByteBuffer putLong(long value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 8;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeLong(this.offset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putLong(int index, long value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 8);
        this.block.pokeLong(this.offset + index, value, this.order);
        return this;
    }

    public ByteBuffer putShort(short value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        int newPosition = this.position + 2;
        if (newPosition > this.limit) {
            throw new BufferOverflowException();
        }
        this.block.pokeShort(this.offset + this.position, value, this.order);
        this.position = newPosition;
        return this;
    }

    public ByteBuffer putShort(int index, short value) {
        this.checkNotFreed();
        if (this.isReadOnly) {
            throw new ReadOnlyBufferException();
        }
        this.checkIndex(index, 2);
        this.block.pokeShort(this.offset + index, value, this.order);
        return this;
    }

    private void checkNotFreed() {
        if (this.freed) {
            throw new IllegalStateException("buffer was freed");
        }
    }
}

