/*
 * Decompiled with CFR 0.152.
 */
package java.security.spec;

import java.math.BigInteger;

public class ECPoint {
    public static final ECPoint POINT_INFINITY = new ECPoint();
    private final BigInteger affineX;
    private final BigInteger affineY;

    private ECPoint() {
        this.affineX = null;
        this.affineY = null;
    }

    public ECPoint(BigInteger affineX, BigInteger affineY) {
        this.affineX = affineX;
        if (this.affineX == null) {
            throw new NullPointerException("affineX == null");
        }
        this.affineY = affineY;
        if (this.affineY == null) {
            throw new NullPointerException("affineY == null");
        }
    }

    public BigInteger getAffineX() {
        return this.affineX;
    }

    public BigInteger getAffineY() {
        return this.affineY;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof ECPoint) {
            if (this.affineX != null) {
                ECPoint otherPoint = (ECPoint)other;
                return this.affineX.equals(otherPoint.affineX) && this.affineY.equals(otherPoint.affineY);
            }
            return other == POINT_INFINITY;
        }
        return false;
    }

    public int hashCode() {
        if (this.affineX != null) {
            return this.affineX.hashCode() * 31 + this.affineY.hashCode();
        }
        return 11;
    }
}

