/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.AttributedCharacterIterator;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.Locale;
import libcore.icu.LocaleData;
import libcore.icu.NativeDecimalFormat;

public class DecimalFormat
extends NumberFormat {
    private static final long serialVersionUID = 864413376551465018L;
    private transient DecimalFormatSymbols symbols;
    private transient NativeDecimalFormat ndf;
    private transient RoundingMode roundingMode = RoundingMode.HALF_EVEN;
    private static final Double NEGATIVE_ZERO_DOUBLE = new Double(-0.0);
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("positivePrefix", String.class), new ObjectStreamField("positiveSuffix", String.class), new ObjectStreamField("negativePrefix", String.class), new ObjectStreamField("negativeSuffix", String.class), new ObjectStreamField("posPrefixPattern", String.class), new ObjectStreamField("posSuffixPattern", String.class), new ObjectStreamField("negPrefixPattern", String.class), new ObjectStreamField("negSuffixPattern", String.class), new ObjectStreamField("multiplier", Integer.TYPE), new ObjectStreamField("groupingSize", Byte.TYPE), new ObjectStreamField("groupingUsed", Boolean.TYPE), new ObjectStreamField("decimalSeparatorAlwaysShown", Boolean.TYPE), new ObjectStreamField("parseBigDecimal", Boolean.TYPE), new ObjectStreamField("roundingMode", RoundingMode.class), new ObjectStreamField("symbols", DecimalFormatSymbols.class), new ObjectStreamField("useExponentialNotation", Boolean.TYPE), new ObjectStreamField("minExponentDigits", Byte.TYPE), new ObjectStreamField("maximumIntegerDigits", Integer.TYPE), new ObjectStreamField("minimumIntegerDigits", Integer.TYPE), new ObjectStreamField("maximumFractionDigits", Integer.TYPE), new ObjectStreamField("minimumFractionDigits", Integer.TYPE), new ObjectStreamField("serialVersionOnStream", Integer.TYPE)};

    public DecimalFormat() {
        Locale locale = Locale.getDefault();
        this.symbols = new DecimalFormatSymbols(locale);
        this.initNative(LocaleData.get((Locale)locale).numberPattern);
    }

    public DecimalFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public DecimalFormat(String pattern, DecimalFormatSymbols value) {
        this.symbols = (DecimalFormatSymbols)value.clone();
        this.initNative(pattern);
    }

    DecimalFormat(String pattern, Locale locale) {
        this.symbols = new DecimalFormatSymbols(locale);
        this.initNative(pattern);
    }

    private void initNative(String pattern) {
        try {
            this.ndf = new NativeDecimalFormat(pattern, this.symbols);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(pattern);
        }
        super.setMaximumFractionDigits(this.ndf.getMaximumFractionDigits());
        super.setMaximumIntegerDigits(this.ndf.getMaximumIntegerDigits());
        super.setMinimumFractionDigits(this.ndf.getMinimumFractionDigits());
        super.setMinimumIntegerDigits(this.ndf.getMinimumIntegerDigits());
    }

    public void applyLocalizedPattern(String pattern) {
        this.ndf.applyLocalizedPattern(pattern);
        this.updateFieldsFromNative();
    }

    public void applyPattern(String pattern) {
        this.ndf.applyPattern(pattern);
        this.updateFieldsFromNative();
    }

    private void updateFieldsFromNative() {
        this.maximumIntegerDigits = this.ndf.getMaximumIntegerDigits();
        this.minimumIntegerDigits = this.ndf.getMinimumIntegerDigits();
        this.maximumFractionDigits = this.ndf.getMaximumFractionDigits();
        this.minimumFractionDigits = this.ndf.getMinimumFractionDigits();
    }

    public Object clone() {
        DecimalFormat clone = (DecimalFormat)super.clone();
        clone.ndf = (NativeDecimalFormat)this.ndf.clone();
        clone.symbols = (DecimalFormatSymbols)this.symbols.clone();
        return clone;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DecimalFormat)) {
            return false;
        }
        DecimalFormat other = (DecimalFormat)object;
        return (this.ndf == null ? other.ndf == null : this.ndf.equals(other.ndf)) && this.getDecimalFormatSymbols().equals(other.getDecimalFormatSymbols());
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        if (object == null) {
            throw new NullPointerException("object == null");
        }
        if (this.roundingMode == RoundingMode.UNNECESSARY && (object instanceof Float || object instanceof Double)) {
            this.checkRoundingUnnecessary(((Number)object).doubleValue());
        }
        return this.ndf.formatToCharacterIterator(object);
    }

    private void checkBufferAndFieldPosition(StringBuffer buffer, FieldPosition position) {
        if (buffer == null) {
            throw new NullPointerException("buffer == null");
        }
        if (position == null) {
            throw new NullPointerException("position == null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRoundingUnnecessary(Object value) {
        try {
            this.setRoundingMode(RoundingMode.UP);
            String upResult = this.format(value, new StringBuffer(), new FieldPosition(0)).toString();
            this.setRoundingMode(RoundingMode.DOWN);
            String downResult = this.format(value, new StringBuffer(), new FieldPosition(0)).toString();
            if (!upResult.equals(downResult)) {
                throw new ArithmeticException("rounding mode UNNECESSARY but rounding required");
            }
            Object var5_4 = null;
            this.setRoundingMode(RoundingMode.UNNECESSARY);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.setRoundingMode(RoundingMode.UNNECESSARY);
            throw throwable;
        }
    }

    public StringBuffer format(double value, StringBuffer buffer, FieldPosition position) {
        this.checkBufferAndFieldPosition(buffer, position);
        if (this.roundingMode == RoundingMode.UNNECESSARY) {
            this.checkRoundingUnnecessary(value);
        }
        buffer.append(this.ndf.formatDouble(value, position));
        return buffer;
    }

    public StringBuffer format(long value, StringBuffer buffer, FieldPosition position) {
        this.checkBufferAndFieldPosition(buffer, position);
        if (this.roundingMode == RoundingMode.UNNECESSARY) {
            this.checkRoundingUnnecessary(value);
        }
        buffer.append(this.ndf.formatLong(value, position));
        return buffer;
    }

    public final StringBuffer format(Object number, StringBuffer buffer, FieldPosition position) {
        this.checkBufferAndFieldPosition(buffer, position);
        if (number instanceof BigInteger) {
            BigInteger bigInteger = (BigInteger)number;
            char[] chars = bigInteger.bitLength() < 64 ? this.ndf.formatLong(bigInteger.longValue(), position) : this.ndf.formatBigInteger(bigInteger, position);
            buffer.append(chars);
            return buffer;
        }
        if (number instanceof BigDecimal) {
            buffer.append(this.ndf.formatBigDecimal((BigDecimal)number, position));
            return buffer;
        }
        return super.format(number, buffer, position);
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return (DecimalFormatSymbols)this.symbols.clone();
    }

    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    public int getGroupingSize() {
        return this.ndf.getGroupingSize();
    }

    public String getNegativePrefix() {
        return this.ndf.getNegativePrefix();
    }

    public String getNegativeSuffix() {
        return this.ndf.getNegativeSuffix();
    }

    public String getPositivePrefix() {
        return this.ndf.getPositivePrefix();
    }

    public String getPositiveSuffix() {
        return this.ndf.getPositiveSuffix();
    }

    public int hashCode() {
        return this.getPositivePrefix().hashCode();
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.ndf.isDecimalSeparatorAlwaysShown();
    }

    public boolean isParseBigDecimal() {
        return this.ndf.isParseBigDecimal();
    }

    public void setParseIntegerOnly(boolean value) {
        super.setParseIntegerOnly(value);
        this.ndf.setParseIntegerOnly(value);
    }

    public boolean isParseIntegerOnly() {
        return this.ndf.isParseIntegerOnly();
    }

    public Number parse(String string2, ParsePosition position) {
        Number number = this.ndf.parse(string2, position);
        if (number == null) {
            return null;
        }
        if (this.isParseBigDecimal()) {
            if (number instanceof Long) {
                return new BigDecimal(number.longValue());
            }
            if (number instanceof Double && !((Double)number).isInfinite() && !((Double)number).isNaN()) {
                return new BigDecimal(number.toString());
            }
            if (number instanceof BigInteger) {
                return new BigDecimal(number.toString());
            }
            return number;
        }
        if (number instanceof BigDecimal || number instanceof BigInteger) {
            return new Double(number.doubleValue());
        }
        if (this.isParseIntegerOnly() && number.equals(NEGATIVE_ZERO_DOUBLE)) {
            return 0L;
        }
        return number;
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols value) {
        if (value != null) {
            this.symbols = (DecimalFormatSymbols)value.clone();
            this.ndf.setDecimalFormatSymbols(this.symbols);
        }
    }

    public void setCurrency(Currency currency) {
        this.ndf.setCurrency(Currency.getInstance(currency.getCurrencyCode()));
        this.symbols.setCurrency(currency);
    }

    public void setDecimalSeparatorAlwaysShown(boolean value) {
        this.ndf.setDecimalSeparatorAlwaysShown(value);
    }

    public void setGroupingSize(int value) {
        this.ndf.setGroupingSize(value);
    }

    public void setGroupingUsed(boolean value) {
        this.ndf.setGroupingUsed(value);
    }

    public boolean isGroupingUsed() {
        return this.ndf.isGroupingUsed();
    }

    public void setMaximumFractionDigits(int value) {
        super.setMaximumFractionDigits(value);
        this.ndf.setMaximumFractionDigits(this.getMaximumFractionDigits());
        this.setRoundingMode(this.roundingMode);
    }

    public void setMaximumIntegerDigits(int value) {
        super.setMaximumIntegerDigits(value);
        this.ndf.setMaximumIntegerDigits(this.getMaximumIntegerDigits());
    }

    public void setMinimumFractionDigits(int value) {
        super.setMinimumFractionDigits(value);
        this.ndf.setMinimumFractionDigits(this.getMinimumFractionDigits());
    }

    public void setMinimumIntegerDigits(int value) {
        super.setMinimumIntegerDigits(value);
        this.ndf.setMinimumIntegerDigits(this.getMinimumIntegerDigits());
    }

    public int getMultiplier() {
        return this.ndf.getMultiplier();
    }

    public void setMultiplier(int value) {
        this.ndf.setMultiplier(value);
    }

    public void setNegativePrefix(String value) {
        this.ndf.setNegativePrefix(value);
    }

    public void setNegativeSuffix(String value) {
        this.ndf.setNegativeSuffix(value);
    }

    public void setPositivePrefix(String value) {
        this.ndf.setPositivePrefix(value);
    }

    public void setPositiveSuffix(String value) {
        this.ndf.setPositiveSuffix(value);
    }

    public void setParseBigDecimal(boolean newValue) {
        this.ndf.setParseBigDecimal(newValue);
    }

    public String toLocalizedPattern() {
        return this.ndf.toLocalizedPattern();
    }

    public String toPattern() {
        return this.ndf.toPattern();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("positivePrefix", this.ndf.getPositivePrefix());
        fields.put("positiveSuffix", this.ndf.getPositiveSuffix());
        fields.put("negativePrefix", this.ndf.getNegativePrefix());
        fields.put("negativeSuffix", this.ndf.getNegativeSuffix());
        fields.put("posPrefixPattern", null);
        fields.put("posSuffixPattern", null);
        fields.put("negPrefixPattern", null);
        fields.put("negSuffixPattern", null);
        fields.put("multiplier", this.ndf.getMultiplier());
        fields.put("groupingSize", (byte)this.ndf.getGroupingSize());
        fields.put("groupingUsed", this.ndf.isGroupingUsed());
        fields.put("decimalSeparatorAlwaysShown", this.ndf.isDecimalSeparatorAlwaysShown());
        fields.put("parseBigDecimal", this.ndf.isParseBigDecimal());
        fields.put("roundingMode", (Object)this.roundingMode);
        fields.put("symbols", this.symbols);
        fields.put("useExponentialNotation", false);
        fields.put("minExponentDigits", (byte)0);
        fields.put("maximumIntegerDigits", this.ndf.getMaximumIntegerDigits());
        fields.put("minimumIntegerDigits", this.ndf.getMinimumIntegerDigits());
        fields.put("maximumFractionDigits", this.ndf.getMaximumFractionDigits());
        fields.put("minimumFractionDigits", this.ndf.getMinimumFractionDigits());
        fields.put("serialVersionOnStream", 4);
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.symbols = (DecimalFormatSymbols)fields.get("symbols", null);
        this.initNative("");
        this.ndf.setPositivePrefix((String)fields.get("positivePrefix", ""));
        this.ndf.setPositiveSuffix((String)fields.get("positiveSuffix", ""));
        this.ndf.setNegativePrefix((String)fields.get("negativePrefix", "-"));
        this.ndf.setNegativeSuffix((String)fields.get("negativeSuffix", ""));
        this.ndf.setMultiplier(fields.get("multiplier", 1));
        this.ndf.setGroupingSize(fields.get("groupingSize", (byte)3));
        this.ndf.setGroupingUsed(fields.get("groupingUsed", true));
        this.ndf.setDecimalSeparatorAlwaysShown(fields.get("decimalSeparatorAlwaysShown", false));
        this.setRoundingMode((RoundingMode)((Object)fields.get("roundingMode", (Object)RoundingMode.HALF_EVEN)));
        int maximumIntegerDigits = fields.get("maximumIntegerDigits", 309);
        int minimumIntegerDigits = fields.get("minimumIntegerDigits", 309);
        int maximumFractionDigits = fields.get("maximumFractionDigits", 340);
        int minimumFractionDigits = fields.get("minimumFractionDigits", 340);
        this.ndf.setMaximumIntegerDigits(maximumIntegerDigits);
        super.setMaximumIntegerDigits(this.ndf.getMaximumIntegerDigits());
        this.setMinimumIntegerDigits(minimumIntegerDigits);
        this.setMinimumFractionDigits(minimumFractionDigits);
        this.setMaximumFractionDigits(maximumFractionDigits);
        this.setParseBigDecimal(fields.get("parseBigDecimal", false));
        if (fields.get("serialVersionOnStream", 0) < 3) {
            this.setMaximumIntegerDigits(super.getMaximumIntegerDigits());
            this.setMinimumIntegerDigits(super.getMinimumIntegerDigits());
            this.setMaximumFractionDigits(super.getMaximumFractionDigits());
            this.setMinimumFractionDigits(super.getMinimumFractionDigits());
        }
    }

    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(RoundingMode roundingMode) {
        if (roundingMode == null) {
            throw new NullPointerException("roundingMode == null");
        }
        this.roundingMode = roundingMode;
        if (roundingMode != RoundingMode.UNNECESSARY) {
            double roundingIncrement = 1.0 / Math.pow(10.0, Math.max(0, this.getMaximumFractionDigits()));
            this.ndf.setRoundingMode(roundingMode, roundingIncrement);
        }
    }

    public String toString() {
        return this.ndf.toString();
    }
}

