/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.CharacterIterator;
import java.text.CollationElementIterator;
import java.text.CollationKey;
import java.text.Collator;
import java.text.ParseException;
import libcore.icu.RuleBasedCollatorICU;

public class RuleBasedCollator
extends Collator {
    RuleBasedCollator(RuleBasedCollatorICU wrapper) {
        super(wrapper);
    }

    public RuleBasedCollator(String rules) throws ParseException {
        if (rules == null) {
            throw new NullPointerException("rules == null");
        }
        if (rules.isEmpty()) {
            throw new ParseException("empty rules", 0);
        }
        try {
            this.icuColl = new RuleBasedCollatorICU(rules);
        }
        catch (Exception e) {
            if (e instanceof ParseException) {
                throw (ParseException)e;
            }
            throw new ParseException(e.getMessage(), -1);
        }
    }

    public CollationElementIterator getCollationElementIterator(CharacterIterator source) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        return new CollationElementIterator(this.icuColl.getCollationElementIterator(source));
    }

    public CollationElementIterator getCollationElementIterator(String source) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        return new CollationElementIterator(this.icuColl.getCollationElementIterator(source));
    }

    public String getRules() {
        return this.icuColl.getRules();
    }

    public Object clone() {
        RuleBasedCollator clone = (RuleBasedCollator)super.clone();
        return clone;
    }

    public int compare(String source, String target) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        if (target == null) {
            throw new NullPointerException("target == null");
        }
        return this.icuColl.compare(source, target);
    }

    public CollationKey getCollationKey(String source) {
        return this.icuColl.getCollationKey(source);
    }

    public int hashCode() {
        return this.icuColl.getRules().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Collator)) {
            return false;
        }
        return super.equals(obj);
    }
}

