/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IllformedLocaleException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import libcore.icu.ICU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Locale
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 9149081749638150636L;
    public static final Locale CANADA = new Locale(true, "en", "CA");
    public static final Locale CANADA_FRENCH = new Locale(true, "fr", "CA");
    public static final Locale CHINA = new Locale(true, "zh", "CN");
    public static final Locale CHINESE = new Locale(true, "zh", "");
    public static final Locale ENGLISH = new Locale(true, "en", "");
    public static final Locale FRANCE = new Locale(true, "fr", "FR");
    public static final Locale FRENCH = new Locale(true, "fr", "");
    public static final Locale GERMAN = new Locale(true, "de", "");
    public static final Locale GERMANY = new Locale(true, "de", "DE");
    public static final Locale ITALIAN = new Locale(true, "it", "");
    public static final Locale ITALY = new Locale(true, "it", "IT");
    public static final Locale JAPAN = new Locale(true, "ja", "JP");
    public static final Locale JAPANESE = new Locale(true, "ja", "");
    public static final Locale KOREA = new Locale(true, "ko", "KR");
    public static final Locale KOREAN = new Locale(true, "ko", "");
    public static final Locale PRC = new Locale(true, "zh", "CN");
    public static final Locale ROOT = new Locale(true, "", "");
    public static final Locale SIMPLIFIED_CHINESE = new Locale(true, "zh", "CN");
    public static final Locale TAIWAN = new Locale(true, "zh", "TW");
    public static final Locale TRADITIONAL_CHINESE = new Locale(true, "zh", "TW");
    public static final Locale UK = new Locale(true, "en", "GB");
    public static final Locale US;
    public static final char PRIVATE_USE_EXTENSION = 'x';
    public static final char UNICODE_LOCALE_EXTENSION = 'u';
    private static Locale defaultLocale;
    private transient String countryCode;
    private transient String languageCode;
    private transient String variantCode;
    private transient String scriptCode;
    private transient String cachedToStringResult;
    private transient String cachedLanguageTag;
    private transient String cachedIcuLocaleId;
    private transient Set<String> unicodeAttributes;
    private transient Map<String, String> unicodeKeywords;
    private transient Map<Character, String> extensions;
    private static final ObjectStreamField[] serialPersistentFields;

    public static Locale forLanguageTag(String languageTag) {
        if (languageTag == null) {
            throw new NullPointerException("languageTag == null");
        }
        return ICU.forLanguageTag(languageTag, false);
    }

    private Locale(boolean unused, String lowerCaseLanguageCode, String upperCaseCountryCode) {
        this.languageCode = lowerCaseLanguageCode;
        this.countryCode = upperCaseCountryCode;
        this.variantCode = "";
        this.scriptCode = "";
        this.unicodeAttributes = Collections.EMPTY_SET;
        this.unicodeKeywords = Collections.EMPTY_MAP;
        this.extensions = Collections.EMPTY_MAP;
    }

    public Locale(String language) {
        this(language, "", "", "", Collections.EMPTY_SET, Collections.EMPTY_MAP, Collections.EMPTY_MAP, true);
    }

    public Locale(String language, String country) {
        this(language, country, "", "", Collections.EMPTY_SET, Collections.EMPTY_MAP, Collections.EMPTY_MAP, true);
    }

    public Locale(String language, String country, String variant, String scriptCode, Set<String> unicodeAttributes, Map<String, String> unicodeKeywords, Map<Character, String> extensions, boolean fromPublicConstructor) {
        if (language == null || country == null || variant == null) {
            throw new NullPointerException("language=" + language + ",country=" + country + ",variant=" + variant);
        }
        if (fromPublicConstructor) {
            if (language.isEmpty() && country.isEmpty()) {
                this.languageCode = "";
                this.countryCode = "";
                this.variantCode = variant;
            } else {
                this.languageCode = Locale.adjustLanguageCode(language);
                this.countryCode = country.toUpperCase(US);
                this.variantCode = variant;
            }
        } else {
            this.languageCode = Locale.adjustLanguageCode(language);
            this.countryCode = country;
            this.variantCode = variant;
        }
        this.scriptCode = scriptCode;
        if (fromPublicConstructor) {
            this.unicodeAttributes = unicodeAttributes;
            this.unicodeKeywords = unicodeKeywords;
            this.extensions = extensions;
        } else {
            TreeSet<String> attribsCopy = new TreeSet<String>(unicodeAttributes);
            TreeMap<String, String> keywordsCopy = new TreeMap<String, String>(unicodeKeywords);
            TreeMap<Character, String> extensionsCopy = new TreeMap<Character, String>(extensions);
            Locale.addUnicodeExtensionToExtensionsMap(attribsCopy, keywordsCopy, extensionsCopy);
            this.unicodeAttributes = Collections.unmodifiableSet(attribsCopy);
            this.unicodeKeywords = Collections.unmodifiableMap(keywordsCopy);
            this.extensions = Collections.unmodifiableMap(extensionsCopy);
        }
    }

    public Locale(String language, String country, String variant) {
        this(language, country, variant, "", Collections.EMPTY_SET, Collections.EMPTY_MAP, Collections.EMPTY_MAP, true);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Locale) {
            Locale o = (Locale)object;
            return this.languageCode.equals(o.languageCode) && this.countryCode.equals(o.countryCode) && this.variantCode.equals(o.variantCode) && this.scriptCode.equals(o.scriptCode) && ((Object)this.extensions).equals(o.extensions);
        }
        return false;
    }

    public static Locale[] getAvailableLocales() {
        return ICU.getAvailableLocales();
    }

    public String getCountry() {
        return this.countryCode;
    }

    public static Locale getDefault() {
        return defaultLocale;
    }

    public final String getDisplayCountry() {
        return this.getDisplayCountry(Locale.getDefault());
    }

    public String getDisplayCountry(Locale locale) {
        if (this.countryCode.isEmpty()) {
            return "";
        }
        String result = ICU.getDisplayCountryNative(this.getIcuLocaleId(), locale.getIcuLocaleId());
        if (result == null) {
            result = ICU.getDisplayCountryNative(this.getIcuLocaleId(), Locale.getDefault().getIcuLocaleId());
        }
        return result;
    }

    public final String getDisplayLanguage() {
        return this.getDisplayLanguage(Locale.getDefault());
    }

    public String getDisplayLanguage(Locale locale) {
        String result;
        if (this.languageCode.isEmpty()) {
            return "";
        }
        String localeString = this.toString();
        if (this.languageCode.equals("tl")) {
            localeString = Locale.toNewString("fil", this.countryCode, this.variantCode, this.scriptCode, this.extensions);
        }
        if ((result = ICU.getDisplayLanguageNative(localeString, locale.getIcuLocaleId())) == null) {
            result = ICU.getDisplayLanguageNative(localeString, Locale.getDefault().getIcuLocaleId());
        }
        return result;
    }

    public final String getDisplayName() {
        return this.getDisplayName(Locale.getDefault());
    }

    public String getDisplayName(Locale locale) {
        int count = 0;
        StringBuilder buffer = new StringBuilder();
        if (!this.languageCode.isEmpty()) {
            String displayLanguage = this.getDisplayLanguage(locale);
            buffer.append(displayLanguage.isEmpty() ? this.languageCode : displayLanguage);
            ++count;
        }
        if (!this.scriptCode.isEmpty()) {
            String displayScript;
            if (count == 1) {
                buffer.append(" (");
            }
            buffer.append((displayScript = this.getDisplayScript(locale)).isEmpty() ? this.countryCode : displayScript);
            ++count;
        }
        if (!this.countryCode.isEmpty()) {
            String displayCountry;
            if (count == 1) {
                buffer.append(" (");
            }
            buffer.append((displayCountry = this.getDisplayCountry(locale)).isEmpty() ? this.countryCode : displayCountry);
            ++count;
        }
        if (!this.variantCode.isEmpty()) {
            if (count == 1) {
                buffer.append(" (");
            } else if (count == 2) {
                buffer.append(",");
            }
            String displayVariant = this.getDisplayVariant(locale);
            buffer.append(displayVariant.isEmpty() ? this.variantCode : displayVariant);
            ++count;
        }
        if (count > 1) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    public final String getDisplayVariant() {
        return this.getDisplayVariant(Locale.getDefault());
    }

    public String getDisplayVariant(Locale locale) {
        if (this.variantCode.length() == 0) {
            return this.variantCode;
        }
        String result = ICU.getDisplayVariantNative(this.getIcuLocaleId(), locale.getIcuLocaleId());
        if (result == null) {
            result = ICU.getDisplayVariantNative(this.getIcuLocaleId(), Locale.getDefault().getIcuLocaleId());
        }
        return result;
    }

    public String getISO3Country() {
        String code = ICU.getISO3CountryNative(this.getIcuLocaleId());
        if (!this.countryCode.isEmpty() && code.isEmpty()) {
            throw new MissingResourceException("No 3-letter country code for locale: " + this, "FormatData_" + this, "ShortCountry");
        }
        return code;
    }

    public String getISO3Language() {
        String code = ICU.getISO3LanguageNative(this.getIcuLocaleId());
        if (!this.languageCode.isEmpty() && code.isEmpty()) {
            throw new MissingResourceException("No 3-letter language code for locale: " + this, "FormatData_" + this, "ShortLanguage");
        }
        return code;
    }

    public static String[] getISOCountries() {
        return ICU.getISOCountries();
    }

    public static String[] getISOLanguages() {
        return ICU.getISOLanguages();
    }

    public String getLanguage() {
        return this.languageCode;
    }

    public String getVariant() {
        return this.variantCode;
    }

    public String getScript() {
        return this.scriptCode;
    }

    public String getDisplayScript() {
        return this.getDisplayScript(Locale.getDefault());
    }

    public String getDisplayScript(Locale locale) {
        if (this.scriptCode.isEmpty()) {
            return "";
        }
        String result = ICU.getDisplayScriptNative(this.getIcuLocaleId(), locale.getIcuLocaleId());
        if (result == null) {
            result = ICU.getDisplayScriptNative(this.getIcuLocaleId(), Locale.getDefault().getIcuLocaleId());
        }
        return result;
    }

    public String toLanguageTag() {
        if (this.cachedLanguageTag == null) {
            this.cachedLanguageTag = ICU.toLanguageTag(this);
        }
        return this.cachedLanguageTag;
    }

    public Set<Character> getExtensionKeys() {
        return this.extensions.keySet();
    }

    public String getExtension(char extensionKey) {
        return this.extensions.get(Character.valueOf(extensionKey));
    }

    public String getUnicodeLocaleType(String keyWord) {
        return this.unicodeKeywords.get(keyWord);
    }

    public Set<String> getUnicodeLocaleAttributes() {
        return this.unicodeAttributes;
    }

    public Set<String> getUnicodeLocaleKeys() {
        return this.unicodeKeywords.keySet();
    }

    public synchronized int hashCode() {
        return this.countryCode.hashCode() + this.languageCode.hashCode() + this.variantCode.hashCode() + this.scriptCode.hashCode() + ((Object)this.extensions).hashCode();
    }

    public static synchronized void setDefault(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale == null");
        }
        defaultLocale = locale;
    }

    public final String toString() {
        String result = this.cachedToStringResult;
        if (result == null) {
            result = this.cachedToStringResult = Locale.toNewString(this.languageCode, this.countryCode, this.variantCode, this.scriptCode, this.extensions);
        }
        return result;
    }

    private String getIcuLocaleId() {
        if (this.cachedIcuLocaleId == null) {
            this.cachedIcuLocaleId = ICU.localeIdFromLocale(this);
        }
        return this.cachedIcuLocaleId;
    }

    private static String toNewString(String languageCode, String countryCode, String variantCode, String scriptCode, Map<Character, String> extensions) {
        boolean hasScriptOrExtensions;
        if (languageCode.length() == 0 && countryCode.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder(11);
        result.append(languageCode);
        boolean bl = hasScriptOrExtensions = !scriptCode.isEmpty() || !extensions.isEmpty();
        if (!countryCode.isEmpty() || !variantCode.isEmpty() || hasScriptOrExtensions) {
            result.append('_');
        }
        result.append(countryCode);
        if (!variantCode.isEmpty() || hasScriptOrExtensions) {
            result.append('_');
        }
        result.append(variantCode);
        if (hasScriptOrExtensions) {
            if (!variantCode.isEmpty()) {
                result.append('_');
            }
            result.append("#");
            if (!scriptCode.isEmpty()) {
                result.append(scriptCode);
            }
            if (!extensions.isEmpty()) {
                if (!scriptCode.isEmpty()) {
                    result.append('-');
                }
                result.append(Locale.serializeExtensions(extensions));
            }
        }
        return result.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ObjectOutputStream.PutField fields = stream.putFields();
        fields.put("country", this.countryCode);
        fields.put("hashcode", -1);
        fields.put("language", this.languageCode);
        fields.put("variant", this.variantCode);
        fields.put("script", this.scriptCode);
        if (!this.extensions.isEmpty()) {
            fields.put("extensions", Locale.serializeExtensions(this.extensions));
        }
        stream.writeFields();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = stream.readFields();
        this.countryCode = (String)fields.get("country", "");
        this.languageCode = (String)fields.get("language", "");
        this.variantCode = (String)fields.get("variant", "");
        this.scriptCode = (String)fields.get("script", "");
        this.unicodeKeywords = Collections.EMPTY_MAP;
        this.unicodeAttributes = Collections.EMPTY_SET;
        this.extensions = Collections.EMPTY_MAP;
        String extensions = (String)fields.get("extensions", null);
        if (extensions != null) {
            this.readExtensions(extensions);
        }
    }

    private void readExtensions(String extensions) {
        TreeMap<Character, String> extensionsMap = new TreeMap<Character, String>();
        Locale.parseSerializedExtensions(extensions, extensionsMap);
        this.extensions = Collections.unmodifiableMap(extensionsMap);
        if (extensionsMap.containsKey(Character.valueOf('u'))) {
            String unicodeExtension = (String)extensionsMap.get(Character.valueOf('u'));
            String[] subTags = unicodeExtension.split("-");
            TreeMap<String, String> unicodeKeywords = new TreeMap<String, String>();
            TreeSet<String> unicodeAttributes = new TreeSet<String>();
            Locale.parseUnicodeExtension(subTags, unicodeKeywords, unicodeAttributes);
            this.unicodeKeywords = Collections.unmodifiableMap(unicodeKeywords);
            this.unicodeAttributes = Collections.unmodifiableSet(unicodeAttributes);
        }
    }

    public static String serializeExtensions(Map<Character, String> extensionsMap) {
        Iterator<Map.Entry<Character, String>> entryIterator = extensionsMap.entrySet().iterator();
        StringBuilder sb = new StringBuilder(64);
        while (true) {
            Map.Entry<Character, String> entry = entryIterator.next();
            sb.append(entry.getKey());
            sb.append('-');
            sb.append(entry.getValue());
            if (!entryIterator.hasNext()) break;
            sb.append('-');
        }
        return sb.toString();
    }

    public static void parseSerializedExtensions(String extString, Map<Character, String> outputMap) {
        String[] subTags = extString.split("-");
        int[] typeStartIndices = new int[subTags.length / 2];
        int length = 0;
        int count = 0;
        for (String subTag : subTags) {
            if (subTag.length() > 0) {
                length += subTag.length() + 1;
            }
            if (subTag.length() != 1) continue;
            typeStartIndices[count++] = length;
        }
        for (int i = 0; i < count; ++i) {
            int valueStart = typeStartIndices[i];
            int valueEnd = i == count - 1 ? extString.length() : typeStartIndices[i + 1] - 3;
            outputMap.put(Character.valueOf(extString.charAt(typeStartIndices[i] - 2)), extString.substring(valueStart, valueEnd));
        }
    }

    private static boolean isUnM49AreaCode(String code) {
        if (code.length() != 3) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            char character = code.charAt(i);
            if (character >= '0' && character <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isAsciiAlphaNum(String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            char character = string2.charAt(i);
            if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z' || character >= '0' && character <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBcp47Alpha(String string2, int lowerBound, int upperBound) {
        int length = string2.length();
        if (length < lowerBound || length > upperBound) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char character = string2.charAt(i);
            if (character >= 'a' && character <= 'z' || character >= 'A' && character <= 'Z') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidBcp47Alphanum(String attributeOrType, int lowerBound, int upperBound) {
        if (attributeOrType.length() < lowerBound || attributeOrType.length() > upperBound) {
            return false;
        }
        return Locale.isAsciiAlphaNum(attributeOrType);
    }

    private static String titleCaseAsciiWord(String word) {
        try {
            byte[] chars = word.toLowerCase(ROOT).getBytes(StandardCharsets.US_ASCII);
            chars[0] = (byte)(chars[0] + 65 - 97);
            return new String(chars, StandardCharsets.US_ASCII);
        }
        catch (UnsupportedOperationException uoe) {
            throw new AssertionError((Object)uoe);
        }
    }

    private static boolean isValidTypeList(String lowerCaseTypeList) {
        String[] splitList;
        for (String type : splitList = lowerCaseTypeList.split("-")) {
            if (Locale.isValidBcp47Alphanum(type, 3, 8)) continue;
            return false;
        }
        return true;
    }

    private static void addUnicodeExtensionToExtensionsMap(Set<String> attributes, Map<String, String> keywords, Map<Character, String> extensions) {
        if (attributes.isEmpty() && keywords.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder(32);
        if (!attributes.isEmpty()) {
            Iterator<String> attributesIterator = attributes.iterator();
            while (true) {
                sb.append(attributesIterator.next());
                if (!attributesIterator.hasNext()) break;
                sb.append('-');
            }
        }
        if (!keywords.isEmpty()) {
            if (!attributes.isEmpty()) {
                sb.append('-');
            }
            Iterator<Map.Entry<String, String>> keywordsIterator = keywords.entrySet().iterator();
            while (true) {
                Map.Entry<String, String> keyWord = keywordsIterator.next();
                sb.append(keyWord.getKey());
                sb.append('-');
                sb.append(keyWord.getValue());
                if (!keywordsIterator.hasNext()) break;
                sb.append('-');
            }
        }
        extensions.put(Character.valueOf('u'), sb.toString());
    }

    public static void parseUnicodeExtension(String[] subtags, Map<String, String> keywords, Set<String> attributes) {
        String lastKeyword = null;
        ArrayList<String> subtagsForKeyword = new ArrayList<String>();
        for (String subtag : subtags) {
            if (subtag.length() == 2) {
                if (subtagsForKeyword.size() > 0) {
                    keywords.put(lastKeyword, Locale.joinBcp47Subtags(subtagsForKeyword));
                    subtagsForKeyword.clear();
                }
                lastKeyword = subtag;
                continue;
            }
            if (subtag.length() <= 2) continue;
            if (lastKeyword == null) {
                attributes.add(subtag);
                continue;
            }
            subtagsForKeyword.add(subtag);
        }
        if (subtagsForKeyword.size() > 0) {
            keywords.put(lastKeyword, Locale.joinBcp47Subtags(subtagsForKeyword));
        }
    }

    private static String joinBcp47Subtags(List<String> strings) {
        int size = strings.size();
        StringBuilder sb = new StringBuilder(strings.get(0).length());
        for (int i = 0; i < size; ++i) {
            sb.append(strings.get(i));
            if (i == size - 1) continue;
            sb.append('-');
        }
        return sb.toString();
    }

    private static String adjustLanguageCode(String languageCode) {
        String adjusted = languageCode.toLowerCase(US);
        if (languageCode.equals("he")) {
            adjusted = "iw";
        } else if (languageCode.equals("id")) {
            adjusted = "in";
        } else if (languageCode.equals("yi")) {
            adjusted = "ji";
        }
        return adjusted;
    }

    static {
        defaultLocale = US = new Locale(true, "en", "US");
        String language = System.getProperty("user.language", "en");
        String region = System.getProperty("user.region", "US");
        String variant = System.getProperty("user.variant", "");
        defaultLocale = new Locale(language, region, variant);
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("country", String.class), new ObjectStreamField("hashcode", Integer.TYPE), new ObjectStreamField("language", String.class), new ObjectStreamField("variant", String.class), new ObjectStreamField("script", String.class), new ObjectStreamField("extensions", String.class)};
    }

    public static final class Builder {
        private String language = "";
        private String region = "";
        private String variant = "";
        private String script = "";
        private final Set<String> attributes = new TreeSet<String>();
        private final Map<String, String> keywords = new TreeMap<String, String>();
        private final Map<Character, String> extensions = new TreeMap<Character, String>();

        public Builder setLanguage(String language) {
            if (language == null || language.isEmpty()) {
                this.language = "";
                return this;
            }
            String lowercaseLanguage = language.toLowerCase(ROOT);
            if (!Locale.isValidBcp47Alpha(lowercaseLanguage, 2, 3)) {
                throw new IllformedLocaleException("Invalid language: " + language);
            }
            this.language = lowercaseLanguage;
            return this;
        }

        public Builder setLanguageTag(String languageTag) {
            if (languageTag == null || languageTag.isEmpty()) {
                this.clear();
                return this;
            }
            Locale fromIcu = ICU.forLanguageTag(languageTag, true);
            if (fromIcu == null) {
                throw new IllformedLocaleException("Invalid languageTag: " + languageTag);
            }
            this.setLocale(fromIcu);
            return this;
        }

        public Builder setRegion(String region) {
            if (region == null || region.isEmpty()) {
                this.region = "";
                return this;
            }
            String uppercaseRegion = region.toUpperCase(ROOT);
            if (!Locale.isValidBcp47Alpha(uppercaseRegion, 2, 2) && !Locale.isUnM49AreaCode(uppercaseRegion)) {
                throw new IllformedLocaleException("Invalid region: " + region);
            }
            this.region = uppercaseRegion;
            return this;
        }

        public Builder setVariant(String variant) {
            String[] subTags;
            if (variant == null || variant.isEmpty()) {
                this.variant = "";
                return this;
            }
            String normalizedVariant = variant.replace('-', '_');
            for (String subTag : subTags = normalizedVariant.split("_")) {
                if (subTag.length() >= 5 && subTag.length() <= 8) {
                    if (Locale.isAsciiAlphaNum(subTag)) continue;
                    throw new IllformedLocaleException("Invalid variant: " + variant);
                }
                if (subTag.length() == 4) {
                    char firstChar = subTag.charAt(0);
                    if (firstChar >= '0' && firstChar <= '9' && Locale.isAsciiAlphaNum(subTag)) continue;
                    throw new IllformedLocaleException("Invalid variant: " + variant);
                }
                throw new IllformedLocaleException("Invalid variant: " + variant);
            }
            this.variant = normalizedVariant;
            return this;
        }

        public Builder setScript(String script) {
            if (script == null || script.isEmpty()) {
                this.script = "";
                return this;
            }
            if (!Locale.isValidBcp47Alpha(script, 4, 4)) {
                throw new IllformedLocaleException("Invalid script: " + script);
            }
            this.script = Locale.titleCaseAsciiWord(script);
            return this;
        }

        public Builder setLocale(Locale locale) {
            if (locale == null) {
                throw new NullPointerException("locale == null");
            }
            String backupLanguage = this.language;
            String backupRegion = this.region;
            String backupVariant = this.variant;
            try {
                this.setLanguage(locale.getLanguage());
                this.setRegion(locale.getCountry());
                this.setVariant(locale.getVariant());
            }
            catch (IllformedLocaleException ifle) {
                this.language = backupLanguage;
                this.region = backupRegion;
                this.variant = backupVariant;
                throw ifle;
            }
            this.script = locale.getScript();
            this.extensions.clear();
            this.extensions.putAll(locale.extensions);
            this.keywords.clear();
            this.keywords.putAll(locale.unicodeKeywords);
            this.attributes.clear();
            this.attributes.addAll(locale.unicodeAttributes);
            return this;
        }

        public Builder addUnicodeLocaleAttribute(String attribute) {
            if (attribute == null) {
                throw new NullPointerException("attribute == null");
            }
            String lowercaseAttribute = attribute.toLowerCase(ROOT);
            if (!Locale.isValidBcp47Alphanum(lowercaseAttribute, 3, 8)) {
                throw new IllformedLocaleException("Invalid locale attribute: " + attribute);
            }
            this.attributes.add(lowercaseAttribute);
            return this;
        }

        public Builder removeUnicodeLocaleAttribute(String attribute) {
            if (attribute == null) {
                throw new NullPointerException("attribute == null");
            }
            String lowercaseAttribute = attribute.toLowerCase(ROOT);
            if (!Locale.isValidBcp47Alphanum(lowercaseAttribute, 3, 8)) {
                throw new IllformedLocaleException("Invalid locale attribute: " + attribute);
            }
            this.attributes.remove(attribute);
            return this;
        }

        public Builder setExtension(char key, String value) {
            if (value == null || value.isEmpty()) {
                this.extensions.remove(Character.valueOf(key));
                return this;
            }
            String normalizedValue = value.toLowerCase(ROOT).replace('_', '-');
            String[] subtags = normalizedValue.split("-");
            int minimumLength = key == 'x' ? 1 : 2;
            for (String subtag : subtags) {
                if (Locale.isValidBcp47Alphanum(subtag, minimumLength, 8)) continue;
                throw new IllformedLocaleException("Invalid private use extension : " + value);
            }
            if (key == 'u') {
                this.extensions.clear();
                this.attributes.clear();
                Locale.parseUnicodeExtension(subtags, this.keywords, this.attributes);
            } else {
                this.extensions.put(Character.valueOf(key), normalizedValue);
            }
            return this;
        }

        public Builder clearExtensions() {
            this.extensions.clear();
            this.attributes.clear();
            this.keywords.clear();
            return this;
        }

        public Builder setUnicodeLocaleKeyword(String key, String type) {
            if (key == null) {
                throw new NullPointerException("key == null");
            }
            if (type == null && this.keywords != null) {
                this.keywords.remove(key);
                return this;
            }
            String lowerCaseKey = key.toLowerCase(ROOT);
            if (lowerCaseKey.length() != 2 || !Locale.isAsciiAlphaNum(lowerCaseKey)) {
                throw new IllformedLocaleException("Invalid unicode locale keyword: " + key);
            }
            String lowerCaseType = type.toLowerCase(ROOT).replace("_", "-");
            if (!Locale.isValidTypeList(lowerCaseType)) {
                throw new IllformedLocaleException("Invalid unicode locale type: " + type);
            }
            this.keywords.put(lowerCaseKey, lowerCaseType);
            return this;
        }

        public Builder clear() {
            this.clearExtensions();
            this.script = "";
            this.variant = "";
            this.region = "";
            this.language = "";
            return this;
        }

        public Locale build() {
            return new Locale(this.language, this.region, this.variant, this.script, this.attributes, this.keywords, this.extensions, false);
        }
    }
}

