/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Scanner
implements Closeable,
Iterator<String> {
    private static final String NL = "\n|\r\n|\r|\u0085|\u2028|\u2029";
    private static final Pattern DEFAULT_DELIMITER = Pattern.compile("\\p{javaWhitespace}+");
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("true|false", 2);
    private static final Pattern LINE_TERMINATOR = Pattern.compile("\n|\r\n|\r|\u0085|\u2028|\u2029");
    private static final Pattern MULTI_LINE_TERMINATOR = Pattern.compile("(\n|\r\n|\r|\u0085|\u2028|\u2029)+");
    private static final Pattern LINE_PATTERN = Pattern.compile(".*(\n|\r\n|\r|\u0085|\u2028|\u2029)|.+$");
    private static final Pattern ANY_PATTERN = Pattern.compile("(?s).*");
    private static final int DEFAULT_RADIX = 10;
    private Readable input;
    private CharBuffer buffer = CharBuffer.allocate(1024);
    private Pattern delimiter = DEFAULT_DELIMITER;
    private Matcher matcher;
    private int currentRadix = 10;
    private Locale locale = Locale.getDefault();
    private int findStartIndex;
    private int preStartIndex = this.findStartIndex = 0;
    private int bufferLength = 0;
    private boolean closed = false;
    private IOException lastIOException;
    private boolean matchSuccessful = false;
    private DecimalFormat decimalFormat;
    private boolean inputExhausted = false;
    private Object cachedNextValue = null;
    private int cachedNextIndex = -1;
    private Pattern cachedFloatPattern = null;
    private int cachedIntegerPatternRadix = -1;
    private Pattern cachedIntegerPattern = null;

    public Scanner(File src) throws FileNotFoundException {
        this(src, Charset.defaultCharset().name());
    }

    public Scanner(File src, String charsetName) throws FileNotFoundException {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        FileInputStream fis = new FileInputStream(src);
        if (charsetName == null) {
            throw new IllegalArgumentException("charsetName == null");
        }
        try {
            this.setInput(new InputStreamReader((InputStream)fis, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            IoUtils.closeQuietly(fis);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Scanner(String src) {
        this.setInput(new StringReader(src));
    }

    public Scanner(InputStream src) {
        this(src, Charset.defaultCharset().name());
    }

    public Scanner(InputStream src, String charsetName) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        try {
            this.setInput(new InputStreamReader(src, charsetName));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public Scanner(Readable src) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        this.setInput(src);
    }

    public Scanner(ReadableByteChannel src) {
        this(src, Charset.defaultCharset().name());
    }

    public Scanner(ReadableByteChannel src, String charsetName) {
        if (src == null) {
            throw new NullPointerException("src == null");
        }
        if (charsetName == null) {
            throw new IllegalArgumentException("charsetName == null");
        }
        this.setInput(Channels.newReader(src, charsetName));
    }

    private void setInput(Readable input) {
        this.input = input;
        this.buffer.limit(0);
        this.matcher = this.delimiter.matcher(this.buffer);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        if (this.input instanceof Closeable) {
            try {
                ((Closeable)((Object)this.input)).close();
            }
            catch (IOException e) {
                this.lastIOException = e;
            }
        }
        this.closed = true;
    }

    public Pattern delimiter() {
        return this.delimiter;
    }

    public String findInLine(Pattern pattern) {
        this.checkOpen();
        this.checkNotNull(pattern);
        int horizonLineSeparator = 0;
        this.matcher.usePattern(MULTI_LINE_TERMINATOR);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        boolean findComplete = false;
        int terminatorLength = 0;
        while (!findComplete) {
            if (this.matcher.find()) {
                horizonLineSeparator = this.matcher.start();
                terminatorLength = this.matcher.end() - this.matcher.start();
                findComplete = true;
                continue;
            }
            if (!this.inputExhausted) {
                this.readMore();
                this.resetMatcher();
                continue;
            }
            horizonLineSeparator = this.bufferLength;
            findComplete = true;
        }
        this.matcher.usePattern(pattern);
        int oldLimit = this.buffer.limit();
        this.buffer.limit(horizonLineSeparator + terminatorLength);
        this.matcher.region(this.findStartIndex, horizonLineSeparator + terminatorLength);
        if (this.matcher.find()) {
            this.findStartIndex = this.matcher.end();
            if (horizonLineSeparator == this.matcher.end()) {
                this.findStartIndex += terminatorLength;
            }
            if (horizonLineSeparator != this.bufferLength && horizonLineSeparator + terminatorLength == this.matcher.end()) {
                this.buffer.limit(oldLimit);
                this.matchSuccessful = false;
                return null;
            }
            this.matchSuccessful = true;
            this.buffer.limit(oldLimit);
            return this.matcher.group();
        }
        this.buffer.limit(oldLimit);
        this.matchSuccessful = false;
        return null;
    }

    public String findInLine(String pattern) {
        return this.findInLine(Pattern.compile(pattern));
    }

    public String findWithinHorizon(Pattern pattern, int horizon) {
        this.checkOpen();
        this.checkNotNull(pattern);
        if (horizon < 0) {
            throw new IllegalArgumentException("horizon < 0");
        }
        this.matcher.usePattern(pattern);
        String result = null;
        int horizonEndIndex = horizon == 0 ? Integer.MAX_VALUE : this.findStartIndex + horizon;
        while (true) {
            int findEndIndex = Math.min(horizonEndIndex, this.bufferLength);
            boolean isHorizonInBuffer = horizonEndIndex <= this.bufferLength;
            this.matcher.region(this.findStartIndex, findEndIndex);
            if (this.matcher.find()) {
                if (horizon == 0 && !this.matcher.hitEnd() || isHorizonInBuffer || this.inputExhausted) {
                    result = this.matcher.group();
                    break;
                }
            } else if (isHorizonInBuffer || this.inputExhausted) break;
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        if (result != null) {
            this.findStartIndex = this.matcher.end();
            this.matchSuccessful = true;
        } else {
            this.matchSuccessful = false;
        }
        return result;
    }

    public String findWithinHorizon(String pattern, int horizon) {
        return this.findWithinHorizon(Pattern.compile(pattern), horizon);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext(ANY_PATTERN);
    }

    public boolean hasNext(Pattern pattern) {
        this.checkOpen();
        this.checkNotNull(pattern);
        this.matchSuccessful = false;
        this.saveCurrentStatus();
        if (!this.setTokenRegion()) {
            this.recoverPreviousStatus();
            return false;
        }
        this.matcher.usePattern(pattern);
        boolean hasNext = false;
        if (this.matcher.matches()) {
            this.cachedNextIndex = this.findStartIndex;
            this.matchSuccessful = true;
            hasNext = true;
        }
        this.recoverPreviousStatus();
        return hasNext;
    }

    public boolean hasNext(String pattern) {
        return this.hasNext(Pattern.compile(pattern));
    }

    public boolean hasNextBigDecimal() {
        Pattern floatPattern = this.getFloatPattern();
        boolean isBigDecimalValue = false;
        if (this.hasNext(floatPattern)) {
            String floatString = this.matcher.group();
            floatString = this.removeLocaleInfoFromFloat(floatString);
            try {
                this.cachedNextValue = new BigDecimal(floatString);
                isBigDecimalValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isBigDecimalValue;
    }

    public boolean hasNextBigInteger() {
        return this.hasNextBigInteger(this.currentRadix);
    }

    public boolean hasNextBigInteger(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isBigIntegerValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, Integer.TYPE);
            try {
                this.cachedNextValue = new BigInteger(intString, radix);
                isBigIntegerValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isBigIntegerValue;
    }

    public boolean hasNextBoolean() {
        return this.hasNext(BOOLEAN_PATTERN);
    }

    public boolean hasNextByte() {
        return this.hasNextByte(this.currentRadix);
    }

    public boolean hasNextByte(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isByteValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, Integer.TYPE);
            try {
                this.cachedNextValue = Byte.valueOf(intString, radix);
                isByteValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isByteValue;
    }

    public boolean hasNextDouble() {
        Pattern floatPattern = this.getFloatPattern();
        boolean isDoubleValue = false;
        if (this.hasNext(floatPattern)) {
            String floatString = this.matcher.group();
            floatString = this.removeLocaleInfoFromFloat(floatString);
            try {
                this.cachedNextValue = Double.valueOf(floatString);
                isDoubleValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isDoubleValue;
    }

    public boolean hasNextFloat() {
        Pattern floatPattern = this.getFloatPattern();
        boolean isFloatValue = false;
        if (this.hasNext(floatPattern)) {
            String floatString = this.matcher.group();
            floatString = this.removeLocaleInfoFromFloat(floatString);
            try {
                this.cachedNextValue = Float.valueOf(floatString);
                isFloatValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isFloatValue;
    }

    public boolean hasNextInt() {
        return this.hasNextInt(this.currentRadix);
    }

    public boolean hasNextInt(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isIntValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, Integer.TYPE);
            try {
                this.cachedNextValue = Integer.valueOf(intString, radix);
                isIntValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isIntValue;
    }

    public boolean hasNextLine() {
        this.saveCurrentStatus();
        String result = this.findWithinHorizon(LINE_PATTERN, 0);
        this.recoverPreviousStatus();
        return result != null;
    }

    public boolean hasNextLong() {
        return this.hasNextLong(this.currentRadix);
    }

    public boolean hasNextLong(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isLongValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, Integer.TYPE);
            try {
                this.cachedNextValue = Long.valueOf(intString, radix);
                isLongValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isLongValue;
    }

    public boolean hasNextShort() {
        return this.hasNextShort(this.currentRadix);
    }

    public boolean hasNextShort(int radix) {
        Pattern integerPattern = this.getIntegerPattern(radix);
        boolean isShortValue = false;
        if (this.hasNext(integerPattern)) {
            String intString = this.matcher.group();
            intString = this.removeLocaleInfo(intString, Integer.TYPE);
            try {
                this.cachedNextValue = Short.valueOf(intString, radix);
                isShortValue = true;
            }
            catch (NumberFormatException e) {
                this.matchSuccessful = false;
            }
        }
        return isShortValue;
    }

    public IOException ioException() {
        return this.lastIOException;
    }

    public Locale locale() {
        return this.locale;
    }

    private void setLocale(Locale locale) {
        this.locale = locale;
        this.decimalFormat = null;
        this.cachedFloatPattern = null;
        this.cachedIntegerPatternRadix = -1;
        this.cachedIntegerPattern = null;
    }

    public MatchResult match() {
        if (!this.matchSuccessful) {
            throw new IllegalStateException();
        }
        return this.matcher.toMatchResult();
    }

    @Override
    public String next() {
        return this.next(ANY_PATTERN);
    }

    public String next(Pattern pattern) {
        this.checkOpen();
        this.checkNotNull(pattern);
        this.matchSuccessful = false;
        this.saveCurrentStatus();
        if (!this.setTokenRegion()) {
            this.recoverPreviousStatus();
            throw new NoSuchElementException();
        }
        this.matcher.usePattern(pattern);
        if (!this.matcher.matches()) {
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        this.matchSuccessful = true;
        return this.matcher.group();
    }

    public String next(String pattern) {
        return this.next(Pattern.compile(pattern));
    }

    public BigDecimal nextBigDecimal() {
        BigDecimal bigDecimalValue;
        this.checkOpen();
        Object obj = this.cachedNextValue;
        this.cachedNextValue = null;
        if (obj instanceof BigDecimal) {
            this.findStartIndex = this.cachedNextIndex;
            return (BigDecimal)obj;
        }
        Pattern floatPattern = this.getFloatPattern();
        String floatString = this.next(floatPattern);
        floatString = this.removeLocaleInfoFromFloat(floatString);
        try {
            bigDecimalValue = new BigDecimal(floatString);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return bigDecimalValue;
    }

    public BigInteger nextBigInteger() {
        return this.nextBigInteger(this.currentRadix);
    }

    public BigInteger nextBigInteger(int radix) {
        BigInteger bigIntegerValue;
        this.checkOpen();
        Object obj = this.cachedNextValue;
        this.cachedNextValue = null;
        if (obj instanceof BigInteger) {
            this.findStartIndex = this.cachedNextIndex;
            return (BigInteger)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, Integer.TYPE);
        try {
            bigIntegerValue = new BigInteger(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return bigIntegerValue;
    }

    public boolean nextBoolean() {
        return Boolean.parseBoolean(this.next(BOOLEAN_PATTERN));
    }

    public byte nextByte() {
        return this.nextByte(this.currentRadix);
    }

    public byte nextByte(int radix) {
        this.checkOpen();
        Object obj = this.cachedNextValue;
        this.cachedNextValue = null;
        if (obj instanceof Byte) {
            this.findStartIndex = this.cachedNextIndex;
            return (Byte)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, Integer.TYPE);
        byte byteValue = 0;
        try {
            byteValue = Byte.parseByte(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return byteValue;
    }

    public double nextDouble() {
        this.checkOpen();
        Object obj = this.cachedNextValue;
        this.cachedNextValue = null;
        if (obj instanceof Double) {
            this.findStartIndex = this.cachedNextIndex;
            return (Double)obj;
        }
        Pattern floatPattern = this.getFloatPattern();
        String floatString = this.next(floatPattern);
        floatString = this.removeLocaleInfoFromFloat(floatString);
        double doubleValue = 0.0;
        try {
            doubleValue = Double.parseDouble(floatString);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return doubleValue;
    }

    public float nextFloat() {
        this.checkOpen();
        Object obj = this.cachedNextValue;
        this.cachedNextValue = null;
        if (obj instanceof Float) {
            this.findStartIndex = this.cachedNextIndex;
            return ((Float)obj).floatValue();
        }
        Pattern floatPattern = this.getFloatPattern();
        String floatString = this.next(floatPattern);
        floatString = this.removeLocaleInfoFromFloat(floatString);
        float floatValue = 0.0f;
        try {
            floatValue = Float.parseFloat(floatString);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return floatValue;
    }

    public int nextInt() {
        return this.nextInt(this.currentRadix);
    }

    public int nextInt(int radix) {
        this.checkOpen();
        Object obj = this.cachedNextValue;
        this.cachedNextValue = null;
        if (obj instanceof Integer) {
            this.findStartIndex = this.cachedNextIndex;
            return (Integer)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, Integer.TYPE);
        int intValue = 0;
        try {
            intValue = Integer.parseInt(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return intValue;
    }

    public String nextLine() {
        Matcher terminatorMatcher;
        this.checkOpen();
        this.matcher.usePattern(LINE_PATTERN);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        String result = null;
        while (true) {
            if (this.matcher.find()) {
                if (this.inputExhausted || this.matcher.end() != this.bufferLength || this.bufferLength < this.buffer.capacity()) {
                    break;
                }
            } else if (this.inputExhausted) {
                this.matchSuccessful = false;
                throw new NoSuchElementException();
            }
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        this.matchSuccessful = true;
        this.findStartIndex = this.matcher.end();
        result = this.matcher.group();
        if (result != null && (terminatorMatcher = LINE_TERMINATOR.matcher(result)).find()) {
            result = result.substring(0, terminatorMatcher.start());
        }
        return result;
    }

    public long nextLong() {
        return this.nextLong(this.currentRadix);
    }

    public long nextLong(int radix) {
        this.checkOpen();
        Object obj = this.cachedNextValue;
        this.cachedNextValue = null;
        if (obj instanceof Long) {
            this.findStartIndex = this.cachedNextIndex;
            return (Long)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, Integer.TYPE);
        long longValue = 0L;
        try {
            longValue = Long.parseLong(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return longValue;
    }

    public short nextShort() {
        return this.nextShort(this.currentRadix);
    }

    public short nextShort(int radix) {
        this.checkOpen();
        Object obj = this.cachedNextValue;
        this.cachedNextValue = null;
        if (obj instanceof Short) {
            this.findStartIndex = this.cachedNextIndex;
            return (Short)obj;
        }
        Pattern integerPattern = this.getIntegerPattern(radix);
        String intString = this.next(integerPattern);
        intString = this.removeLocaleInfo(intString, Integer.TYPE);
        short shortValue = 0;
        try {
            shortValue = Short.parseShort(intString, radix);
        }
        catch (NumberFormatException e) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return shortValue;
    }

    public int radix() {
        return this.currentRadix;
    }

    public Scanner skip(Pattern pattern) {
        this.checkOpen();
        this.checkNotNull(pattern);
        this.matcher.usePattern(pattern);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        while (true) {
            if (this.matcher.lookingAt()) {
                boolean matchInBuffer;
                boolean bl = matchInBuffer = this.matcher.end() < this.bufferLength || this.matcher.end() == this.bufferLength && this.inputExhausted;
                if (matchInBuffer) {
                    break;
                }
            } else if (this.inputExhausted) {
                this.matchSuccessful = false;
                throw new NoSuchElementException();
            }
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        this.matchSuccessful = true;
        this.findStartIndex = this.matcher.end();
        return this;
    }

    public Scanner skip(String pattern) {
        return this.skip(Pattern.compile(pattern));
    }

    public String toString() {
        return this.getClass().getName() + "[delimiter=" + this.delimiter + ",findStartIndex=" + this.findStartIndex + ",matchSuccessful=" + this.matchSuccessful + ",closed=" + this.closed + "]";
    }

    public Scanner useDelimiter(Pattern pattern) {
        this.delimiter = pattern;
        return this;
    }

    public Scanner useDelimiter(String pattern) {
        return this.useDelimiter(Pattern.compile(pattern));
    }

    public Scanner useLocale(Locale l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        this.setLocale(l);
        return this;
    }

    public Scanner useRadix(int radix) {
        this.checkRadix(radix);
        this.currentRadix = radix;
        return this;
    }

    private void checkRadix(int radix) {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("Invalid radix: " + radix);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void checkOpen() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    private void checkNotNull(Pattern pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern == null");
        }
    }

    private void resetMatcher() {
        if (this.matcher == null) {
            this.matcher = this.delimiter.matcher(this.buffer);
        } else {
            this.matcher.reset(this.buffer);
        }
        this.matcher.useTransparentBounds(true);
        this.matcher.useAnchoringBounds(false);
        this.matcher.region(this.findStartIndex, this.bufferLength);
    }

    private void saveCurrentStatus() {
        this.preStartIndex = this.findStartIndex;
    }

    private void recoverPreviousStatus() {
        this.findStartIndex = this.preStartIndex;
    }

    private Pattern getIntegerPattern(int radix) {
        this.checkRadix(radix);
        if (this.decimalFormat == null) {
            this.decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.locale);
        }
        if (this.cachedIntegerPatternRadix == radix) {
            return this.cachedIntegerPattern;
        }
        String digits = "0123456789abcdefghijklmnopqrstuvwxyz";
        String ASCIIDigit = digits.substring(0, radix);
        String nonZeroASCIIDigit = digits.substring(1, radix);
        String digit = "((?i)[" + ASCIIDigit + "]|\\p{javaDigit})";
        String nonZeroDigit = "((?i)[" + nonZeroASCIIDigit + "]|([\\p{javaDigit}&&[^0]]))";
        String numeral = this.getNumeral(digit, nonZeroDigit);
        String regex = "(([-+]?(" + numeral + ")))|" + "(" + this.addPositiveSign(numeral) + ")|" + "(" + this.addNegativeSign(numeral) + ")";
        this.cachedIntegerPatternRadix = radix;
        this.cachedIntegerPattern = Pattern.compile(regex);
        return this.cachedIntegerPattern;
    }

    private Pattern getFloatPattern() {
        if (this.decimalFormat == null) {
            this.decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.locale);
        }
        if (this.cachedFloatPattern != null) {
            return this.cachedFloatPattern;
        }
        DecimalFormatSymbols dfs = this.decimalFormat.getDecimalFormatSymbols();
        String digit = "([0-9]|(\\p{javaDigit}))";
        String nonZeroDigit = "[\\p{javaDigit}&&[^0]]";
        String numeral = this.getNumeral(digit, nonZeroDigit);
        String decimalSeparator = "\\" + dfs.getDecimalSeparator();
        String decimalNumeral = "(" + numeral + "|" + numeral + decimalSeparator + digit + "*+|" + decimalSeparator + digit + "++)";
        String exponent = "([eE][+-]?" + digit + "+)?";
        String decimal = "(([-+]?" + decimalNumeral + "(" + exponent + "?)" + ")|" + "(" + this.addPositiveSign(decimalNumeral) + "(" + exponent + "?)" + ")|" + "(" + this.addNegativeSign(decimalNumeral) + "(" + exponent + "?)" + "))";
        String hexFloat = "([-+]?0[xX][0-9a-fA-F]*\\.[0-9a-fA-F]+([pP][-+]?[0-9]+)?)";
        String localNaN = dfs.getNaN();
        String localeInfinity = dfs.getInfinity();
        String nonNumber = "(NaN|\\Q" + localNaN + "\\E|Infinity|\\Q" + localeInfinity + "\\E)";
        String signedNonNumber = "((([-+]?(" + nonNumber + ")))|" + "(" + this.addPositiveSign(nonNumber) + ")|" + "(" + this.addNegativeSign(nonNumber) + "))";
        this.cachedFloatPattern = Pattern.compile(decimal + "|" + hexFloat + "|" + signedNonNumber);
        return this.cachedFloatPattern;
    }

    private String getNumeral(String digit, String nonZeroDigit) {
        String groupSeparator = "\\" + this.decimalFormat.getDecimalFormatSymbols().getGroupingSeparator();
        String groupedNumeral = "(" + nonZeroDigit + digit + "?" + digit + "?" + "(" + groupSeparator + digit + digit + digit + ")+)";
        return "((" + digit + "++)|" + groupedNumeral + ")";
    }

    private String addPositiveSign(String unsignedNumeral) {
        String positivePrefix = "";
        String positiveSuffix = "";
        if (!this.decimalFormat.getPositivePrefix().isEmpty()) {
            positivePrefix = "\\Q" + this.decimalFormat.getPositivePrefix() + "\\E";
        }
        if (!this.decimalFormat.getPositiveSuffix().isEmpty()) {
            positiveSuffix = "\\Q" + this.decimalFormat.getPositiveSuffix() + "\\E";
        }
        return positivePrefix + unsignedNumeral + positiveSuffix;
    }

    private String addNegativeSign(String unsignedNumeral) {
        String negativePrefix = "";
        String negativeSuffix = "";
        if (!this.decimalFormat.getNegativePrefix().isEmpty()) {
            negativePrefix = "\\Q" + this.decimalFormat.getNegativePrefix() + "\\E";
        }
        if (!this.decimalFormat.getNegativeSuffix().isEmpty()) {
            negativeSuffix = "\\Q" + this.decimalFormat.getNegativeSuffix() + "\\E";
        }
        return negativePrefix + unsignedNumeral + negativeSuffix;
    }

    private String removeLocaleInfoFromFloat(String floatString) {
        if (floatString.indexOf(120) != -1 || floatString.indexOf(88) != -1) {
            return floatString;
        }
        int exponentIndex = floatString.indexOf(101);
        if (exponentIndex != -1 || (exponentIndex = floatString.indexOf(69)) != -1) {
            String decimalNumeralString = floatString.substring(0, exponentIndex);
            String exponentString = floatString.substring(exponentIndex + 1, floatString.length());
            decimalNumeralString = this.removeLocaleInfo(decimalNumeralString, Float.TYPE);
            return decimalNumeralString + "e" + exponentString;
        }
        return this.removeLocaleInfo(floatString, Float.TYPE);
    }

    private String removeLocaleInfo(String token, Class<?> type) {
        DecimalFormatSymbols dfs = this.decimalFormat.getDecimalFormatSymbols();
        StringBuilder tokenBuilder = new StringBuilder(token);
        boolean negative = this.removeLocaleSign(tokenBuilder);
        String groupSeparator = String.valueOf(dfs.getGroupingSeparator());
        int separatorIndex = -1;
        while ((separatorIndex = tokenBuilder.indexOf(groupSeparator)) != -1) {
            tokenBuilder.delete(separatorIndex, separatorIndex + 1);
        }
        String decimalSeparator = String.valueOf(dfs.getDecimalSeparator());
        separatorIndex = tokenBuilder.indexOf(decimalSeparator);
        StringBuilder result = new StringBuilder("");
        if (type == Integer.TYPE) {
            for (int i = 0; i < tokenBuilder.length(); ++i) {
                if (Character.digit(tokenBuilder.charAt(i), 36) == -1) continue;
                result.append(tokenBuilder.charAt(i));
            }
        } else if (type == Float.TYPE) {
            if (tokenBuilder.toString().equals(dfs.getNaN())) {
                result.append("NaN");
            } else if (tokenBuilder.toString().equals(dfs.getInfinity())) {
                result.append("Infinity");
            } else {
                for (int i = 0; i < tokenBuilder.length(); ++i) {
                    if (Character.digit(tokenBuilder.charAt(i), 10) == -1) continue;
                    result.append(Character.digit(tokenBuilder.charAt(i), 10));
                }
            }
        } else {
            throw new AssertionError((Object)("Unsupported type: " + type));
        }
        if (result.length() == 0) {
            result = tokenBuilder;
        }
        if (separatorIndex != -1) {
            result.insert(separatorIndex, ".");
        }
        if (negative) {
            result.insert(0, '-');
        }
        return result.toString();
    }

    private boolean removeLocaleSign(StringBuilder tokenBuilder) {
        String positivePrefix = this.decimalFormat.getPositivePrefix();
        String positiveSuffix = this.decimalFormat.getPositiveSuffix();
        String negativePrefix = this.decimalFormat.getNegativePrefix();
        String negativeSuffix = this.decimalFormat.getNegativeSuffix();
        if (tokenBuilder.indexOf("+") == 0) {
            tokenBuilder.delete(0, 1);
        }
        if (!positivePrefix.isEmpty() && tokenBuilder.indexOf(positivePrefix) == 0) {
            tokenBuilder.delete(0, positivePrefix.length());
        }
        if (!positiveSuffix.isEmpty() && tokenBuilder.indexOf(positiveSuffix) != -1) {
            tokenBuilder.delete(tokenBuilder.length() - positiveSuffix.length(), tokenBuilder.length());
        }
        boolean negative = false;
        if (tokenBuilder.indexOf("-") == 0) {
            tokenBuilder.delete(0, 1);
            negative = true;
        }
        if (!negativePrefix.isEmpty() && tokenBuilder.indexOf(negativePrefix) == 0) {
            tokenBuilder.delete(0, negativePrefix.length());
            negative = true;
        }
        if (!negativeSuffix.isEmpty() && tokenBuilder.indexOf(negativeSuffix) != -1) {
            tokenBuilder.delete(tokenBuilder.length() - negativeSuffix.length(), tokenBuilder.length());
            negative = true;
        }
        return negative;
    }

    private boolean setTokenRegion() {
        int tokenStartIndex = 0;
        int tokenEndIndex = 0;
        this.matcher.usePattern(this.delimiter);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        tokenStartIndex = this.findPreDelimiter();
        if (this.setHeadTokenRegion(tokenStartIndex)) {
            return true;
        }
        tokenEndIndex = this.findDelimiterAfter();
        if (tokenEndIndex == -1) {
            if (this.findStartIndex == this.bufferLength) {
                return false;
            }
            tokenEndIndex = this.bufferLength;
            this.findStartIndex = this.bufferLength;
        }
        this.matcher.region(tokenStartIndex, tokenEndIndex);
        return true;
    }

    private int findPreDelimiter() {
        boolean findComplete = false;
        while (!findComplete) {
            if (this.matcher.find()) {
                findComplete = true;
                if (this.matcher.start() != this.findStartIndex || this.matcher.end() != this.bufferLength || this.inputExhausted) continue;
                this.readMore();
                this.resetMatcher();
                findComplete = false;
                continue;
            }
            if (!this.inputExhausted) {
                this.readMore();
                this.resetMatcher();
                continue;
            }
            return -1;
        }
        int tokenStartIndex = this.matcher.end();
        this.findStartIndex = this.matcher.end();
        return tokenStartIndex;
    }

    private boolean setHeadTokenRegion(int findIndex) {
        int tokenEndIndex;
        int tokenStartIndex;
        boolean setSuccess = false;
        if (findIndex == -1 && this.preStartIndex != this.bufferLength) {
            tokenStartIndex = this.preStartIndex;
            tokenEndIndex = this.bufferLength;
            this.findStartIndex = this.bufferLength;
            this.matcher.region(tokenStartIndex, tokenEndIndex);
            setSuccess = true;
        }
        if (-1 != findIndex && this.preStartIndex != this.matcher.start()) {
            tokenStartIndex = this.preStartIndex;
            tokenEndIndex = this.matcher.start();
            this.findStartIndex = this.matcher.start();
            this.matcher.region(tokenStartIndex, tokenEndIndex);
            setSuccess = true;
        }
        return setSuccess;
    }

    private int findDelimiterAfter() {
        int tokenEndIndex = 0;
        boolean findComplete = false;
        while (!findComplete) {
            if (this.matcher.find()) {
                findComplete = true;
                if (this.matcher.start() != this.findStartIndex || this.matcher.start() != this.matcher.end()) continue;
                findComplete = false;
                continue;
            }
            if (!this.inputExhausted) {
                this.readMore();
                this.resetMatcher();
                continue;
            }
            return -1;
        }
        tokenEndIndex = this.matcher.start();
        this.findStartIndex = this.matcher.start();
        return tokenEndIndex;
    }

    private void readMore() {
        int oldPosition = this.buffer.position();
        int oldBufferLength = this.bufferLength;
        if (this.bufferLength >= this.buffer.capacity()) {
            this.expandBuffer();
        }
        int readCount = 0;
        try {
            this.buffer.limit(this.buffer.capacity());
            this.buffer.position(oldBufferLength);
            while ((readCount = this.input.read(this.buffer)) == 0) {
            }
        }
        catch (IOException e) {
            this.bufferLength = this.buffer.position();
            readCount = -1;
            this.lastIOException = e;
        }
        this.buffer.flip();
        this.buffer.position(oldPosition);
        if (readCount == -1) {
            this.inputExhausted = true;
        } else {
            this.bufferLength = readCount + this.bufferLength;
        }
    }

    private void expandBuffer() {
        int oldPosition = this.buffer.position();
        int oldCapacity = this.buffer.capacity();
        int oldLimit = this.buffer.limit();
        int newCapacity = oldCapacity * 2;
        char[] newBuffer = new char[newCapacity];
        System.arraycopy(this.buffer.array(), 0, newBuffer, 0, oldLimit);
        this.buffer = CharBuffer.wrap(newBuffer, 0, newCapacity);
        this.buffer.position(oldPosition);
        this.buffer.limit(oldLimit);
    }

    public Scanner reset() {
        this.delimiter = DEFAULT_DELIMITER;
        this.setLocale(Locale.getDefault());
        this.currentRadix = 10;
        return this;
    }
}

