/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import libcore.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFile
extends ZipFile {
    public static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    static final String META_DIR = "META-INF/";
    private Manifest manifest;
    private byte[] manifestBytes;
    JarVerifier verifier;
    private boolean closed = false;

    public JarFile(File file) throws IOException {
        this(file, true);
    }

    public JarFile(File file, boolean verify) throws IOException {
        this(file, verify, 1);
    }

    public JarFile(File file, boolean verify, int mode) throws IOException {
        super(file, mode);
        HashMap<String, byte[]> metaEntries = JarFile.readMetaEntries(this, verify);
        if (verify && metaEntries.containsKey(MANIFEST_NAME) && metaEntries.size() > 1) {
            this.manifest = new Manifest(metaEntries.get(MANIFEST_NAME), true);
            this.verifier = new JarVerifier(this.getName(), this.manifest, metaEntries);
        } else {
            this.verifier = null;
            this.manifestBytes = metaEntries.get(MANIFEST_NAME);
        }
    }

    public JarFile(String filename) throws IOException {
        this(filename, true);
    }

    public JarFile(String filename, boolean verify) throws IOException {
        this(new File(filename), verify, 1);
    }

    public Enumeration<JarEntry> entries() {
        return new JarFileEnumerator(super.entries(), this);
    }

    public JarEntry getJarEntry(String name) {
        return (JarEntry)this.getEntry(name);
    }

    public Manifest getManifest() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("JarFile has been closed");
        }
        if (this.manifest != null) {
            return this.manifest;
        }
        if (this.manifestBytes == null) {
            return null;
        }
        this.manifest = new Manifest(this.manifestBytes, false);
        this.manifestBytes = null;
        return this.manifest;
    }

    static HashMap<String, byte[]> readMetaEntries(ZipFile zipFile, boolean verificationRequired) throws IOException {
        List<ZipEntry> metaEntries = JarFile.getMetaEntries(zipFile);
        HashMap<String, byte[]> metaEntriesMap = new HashMap<String, byte[]>();
        for (ZipEntry entry : metaEntries) {
            String entryName = entry.getName();
            if (entryName.equalsIgnoreCase(MANIFEST_NAME) && !metaEntriesMap.containsKey(MANIFEST_NAME)) {
                metaEntriesMap.put(MANIFEST_NAME, Streams.readFully(zipFile.getInputStream(entry)));
                if (verificationRequired) continue;
                break;
            }
            if (!verificationRequired || !JarFile.endsWithIgnoreCase(entryName, ".SF") && !JarFile.endsWithIgnoreCase(entryName, ".DSA") && !JarFile.endsWithIgnoreCase(entryName, ".RSA") && !JarFile.endsWithIgnoreCase(entryName, ".EC")) continue;
            InputStream is = zipFile.getInputStream(entry);
            metaEntriesMap.put(entryName.toUpperCase(Locale.US), Streams.readFully(is));
        }
        return metaEntriesMap;
    }

    private static boolean endsWithIgnoreCase(String s, String suffix) {
        return s.regionMatches(true, s.length() - suffix.length(), suffix, 0, suffix.length());
    }

    @Override
    public InputStream getInputStream(ZipEntry ze) throws IOException {
        InputStream in;
        if (this.manifestBytes != null) {
            this.getManifest();
        }
        if (this.verifier != null && this.verifier.readCertificates()) {
            this.verifier.removeMetaEntries();
            this.manifest.removeChunks();
            if (!this.verifier.isSignedJar()) {
                this.verifier = null;
            }
        }
        if ((in = super.getInputStream(ze)) == null) {
            return null;
        }
        if (this.verifier == null || ze.getSize() == -1L) {
            return in;
        }
        JarVerifier.VerifierEntry entry = this.verifier.initEntry(ze.getName());
        if (entry == null) {
            return in;
        }
        return new JarFileInputStream(in, ze.getSize(), entry);
    }

    @Override
    public ZipEntry getEntry(String name) {
        ZipEntry ze = super.getEntry(name);
        if (ze == null) {
            return ze;
        }
        return new JarEntry(ze, this);
    }

    private static List<ZipEntry> getMetaEntries(ZipFile zipFile) {
        ArrayList<ZipEntry> list = new ArrayList<ZipEntry>(8);
        Enumeration<? extends ZipEntry> allEntries = zipFile.entries();
        while (allEntries.hasMoreElements()) {
            ZipEntry ze = allEntries.nextElement();
            if (!ze.getName().startsWith(META_DIR) || ze.getName().length() <= META_DIR.length()) continue;
            list.add(ze);
        }
        return list;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.closed = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class JarFileEnumerator
    implements Enumeration<JarEntry> {
        final Enumeration<? extends ZipEntry> ze;
        final JarFile jf;

        JarFileEnumerator(Enumeration<? extends ZipEntry> zenum, JarFile jf) {
            this.ze = zenum;
            this.jf = jf;
        }

        @Override
        public boolean hasMoreElements() {
            return this.ze.hasMoreElements();
        }

        @Override
        public JarEntry nextElement() {
            return new JarEntry(this.ze.nextElement(), this.jf);
        }
    }

    static final class JarFileInputStream
    extends FilterInputStream {
        private final JarVerifier.VerifierEntry entry;
        private long count;
        private boolean done = false;

        JarFileInputStream(InputStream is, long size, JarVerifier.VerifierEntry e) {
            super(is);
            this.entry = e;
            this.count = size;
        }

        public int read() throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read();
                if (r != -1) {
                    this.entry.write(r);
                    --this.count;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                    this.entry.verify();
                }
                return r;
            }
            this.done = true;
            this.entry.verify();
            return -1;
        }

        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            if (this.done) {
                return -1;
            }
            if (this.count > 0L) {
                int r = super.read(buffer, byteOffset, byteCount);
                if (r != -1) {
                    int size = r;
                    if (this.count < (long)size) {
                        size = (int)this.count;
                    }
                    this.entry.write(buffer, byteOffset, size);
                    this.count -= (long)size;
                } else {
                    this.count = 0L;
                }
                if (this.count == 0L) {
                    this.done = true;
                    this.entry.verify();
                }
                return r;
            }
            this.done = true;
            this.entry.verify();
            return -1;
        }

        public int available() throws IOException {
            if (this.done) {
                return 0;
            }
            return super.available();
        }

        public long skip(long byteCount) throws IOException {
            return Streams.skipByReading(this, byteCount);
        }
    }
}

