/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import dalvik.system.CloseGuard;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarFile;
import java.util.jar.JarVerifier;
import java.util.jar.Manifest;
import java.util.zip.Inflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import libcore.io.IoUtils;
import libcore.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StrictJarFile {
    private final long nativeHandle;
    private final RandomAccessFile raf;
    private final Manifest manifest;
    private final JarVerifier verifier;
    private final boolean isSigned;
    private final CloseGuard guard = CloseGuard.get();
    private boolean closed;

    public StrictJarFile(String fileName) throws IOException {
        this.nativeHandle = StrictJarFile.nativeOpenJarFile(fileName);
        this.raf = new RandomAccessFile(fileName, "r");
        try {
            HashMap<String, byte[]> metaEntries = this.getMetaEntries();
            this.manifest = new Manifest(metaEntries.get("META-INF/MANIFEST.MF"), true);
            this.verifier = new JarVerifier(fileName, this.manifest, metaEntries);
            this.isSigned = this.verifier.readCertificates() && this.verifier.isSignedJar();
        }
        catch (IOException ioe) {
            StrictJarFile.nativeClose(this.nativeHandle);
            throw ioe;
        }
        this.guard.open("close");
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public Iterator<ZipEntry> iterator() throws IOException {
        return new EntryIterator(this.nativeHandle, "");
    }

    public ZipEntry findEntry(String name) {
        return StrictJarFile.nativeFindEntry(this.nativeHandle, name);
    }

    public Certificate[] getCertificates(ZipEntry ze) {
        if (this.isSigned) {
            return this.verifier.getCertificates(ze.getName());
        }
        return null;
    }

    public InputStream getInputStream(ZipEntry ze) {
        InputStream is = this.getZipInputStream(ze);
        if (this.isSigned) {
            JarVerifier.VerifierEntry entry = this.verifier.initEntry(ze.getName());
            if (entry == null) {
                return is;
            }
            return new JarFile.JarFileInputStream(is, ze.getSize(), entry);
        }
        return is;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.guard.close();
            StrictJarFile.nativeClose(this.nativeHandle);
            IoUtils.closeQuietly(this.raf);
            this.closed = true;
        }
    }

    private InputStream getZipInputStream(ZipEntry ze) {
        if (ze.getMethod() == 0) {
            return new ZipFile.RAFStream(this.raf, ze.getDataOffset(), ze.getDataOffset() + ze.getSize());
        }
        ZipFile.RAFStream wrapped = new ZipFile.RAFStream(this.raf, ze.getDataOffset(), ze.getDataOffset() + ze.getCompressedSize());
        int bufSize = Math.max(1024, (int)Math.min(ze.getSize(), 65535L));
        return new ZipFile.ZipInflaterInputStream(wrapped, new Inflater(true), bufSize, ze);
    }

    private HashMap<String, byte[]> getMetaEntries() throws IOException {
        HashMap<String, byte[]> metaEntries = new HashMap<String, byte[]>();
        EntryIterator entryIterator = new EntryIterator(this.nativeHandle, "META-INF/");
        while (entryIterator.hasNext()) {
            ZipEntry entry = (ZipEntry)entryIterator.next();
            metaEntries.put(entry.getName(), Streams.readFully(this.getInputStream(entry)));
        }
        return metaEntries;
    }

    private static native long nativeOpenJarFile(String var0) throws IOException;

    private static native long nativeStartIteration(long var0, String var2);

    private static native ZipEntry nativeNextEntry(long var0);

    private static native ZipEntry nativeFindEntry(long var0, String var2);

    private static native void nativeClose(long var0);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class EntryIterator
    implements Iterator<ZipEntry> {
        private final long iterationHandle;
        private ZipEntry nextEntry;

        EntryIterator(long nativeHandle, String prefix) throws IOException {
            this.iterationHandle = StrictJarFile.nativeStartIteration(nativeHandle, prefix);
        }

        @Override
        public ZipEntry next() {
            if (this.nextEntry != null) {
                ZipEntry ze = this.nextEntry;
                this.nextEntry = null;
                return ze;
            }
            return StrictJarFile.nativeNextEntry(this.iterationHandle);
        }

        @Override
        public boolean hasNext() {
            if (this.nextEntry != null) {
                return true;
            }
            ZipEntry ze = StrictJarFile.nativeNextEntry(this.iterationHandle);
            if (ze == null) {
                return false;
            }
            this.nextEntry = ze;
            return true;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

