/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;
import libcore.io.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogManager {
    private static final LoggingPermission perm = new LoggingPermission("control", null);
    static LogManager manager;
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";
    private Hashtable<String, Logger> loggers = new Hashtable();
    private Properties props = new Properties();
    private PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    public static LoggingMXBean getLoggingMXBean() {
        throw new UnsupportedOperationException();
    }

    protected LogManager() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                LogManager.this.reset();
            }
        });
    }

    public void checkAccess() {
    }

    public synchronized boolean addLogger(Logger logger) {
        String name = logger.getName();
        if (this.loggers.get(name) != null) {
            return false;
        }
        this.addToFamilyTree(logger, name);
        this.loggers.put(name, logger);
        logger.setManager(this);
        return true;
    }

    private void addToFamilyTree(Logger logger, String name) {
        int lastSeparator;
        Logger parent = null;
        String parentName = name;
        while ((lastSeparator = parentName.lastIndexOf(46)) != -1) {
            parent = this.loggers.get(parentName = parentName.substring(0, lastSeparator));
            if (parent != null) {
                this.setParent(logger, parent);
                break;
            }
            if (this.getProperty(parentName + ".level") == null && this.getProperty(parentName + ".handlers") == null) continue;
            parent = Logger.getLogger(parentName);
            this.setParent(logger, parent);
            break;
        }
        if (parent == null && (parent = this.loggers.get("")) != null) {
            this.setParent(logger, parent);
        }
        String nameDot = name + '.';
        Collection<Logger> allLoggers = this.loggers.values();
        for (Logger child : allLoggers) {
            Logger oldParent = child.getParent();
            if (parent != oldParent || name.length() != 0 && !child.getName().startsWith(nameDot)) continue;
            Logger thisLogger = logger;
            child.setParent(thisLogger);
            if (oldParent == null) continue;
            oldParent.children.remove(child);
        }
    }

    public synchronized Logger getLogger(String name) {
        return this.loggers.get(name);
    }

    public synchronized Enumeration<String> getLoggerNames() {
        return this.loggers.keys();
    }

    public static LogManager getLogManager() {
        return manager;
    }

    public String getProperty(String name) {
        return this.props.getProperty(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration() throws IOException {
        String configClassName = System.getProperty("java.util.logging.config.class");
        if (configClassName == null || LogManager.getInstanceByClass(configClassName) == null) {
            String configFile = System.getProperty("java.util.logging.config.file");
            if (configFile == null) {
                configFile = System.getProperty("java.home") + File.separator + "lib" + File.separator + "logging.properties";
            }
            InputStream input = null;
            try {
                block6: {
                    try {
                        input = new FileInputStream(configFile);
                    }
                    catch (IOException exception) {
                        input = LogManager.class.getResourceAsStream("logging.properties");
                        if (input != null) break block6;
                        throw exception;
                    }
                }
                this.readConfiguration(new BufferedInputStream(input));
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                IoUtils.closeQuietly(input);
                throw throwable;
            }
            IoUtils.closeQuietly(input);
            {
            }
        }
    }

    static Object getInstanceByClass(String className) {
        try {
            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(className);
            return clazz.newInstance();
        }
        catch (Exception e) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                return clazz.newInstance();
            }
            catch (Exception innerE) {
                System.err.println("Loading class '" + className + "' failed");
                System.err.println(innerE);
                return null;
            }
        }
    }

    private synchronized void readConfigurationImpl(InputStream ins) throws IOException {
        String configs;
        this.reset();
        this.props.load(ins);
        Logger root = this.loggers.get("");
        if (root != null) {
            root.setManager(this);
        }
        if ((configs = this.props.getProperty("config")) != null) {
            StringTokenizer st = new StringTokenizer(configs, " ");
            while (st.hasMoreTokens()) {
                String configerName = st.nextToken();
                LogManager.getInstanceByClass(configerName);
            }
        }
        Collection<Logger> allLoggers = this.loggers.values();
        for (Logger logger : allLoggers) {
            String property = this.props.getProperty(logger.getName() + ".level");
            if (property == null) continue;
            logger.setLevel(Level.parse(property));
        }
        this.listeners.firePropertyChange(null, null, null);
    }

    public void readConfiguration(InputStream ins) throws IOException {
        this.checkAccess();
        this.readConfigurationImpl(ins);
    }

    public synchronized void reset() {
        this.checkAccess();
        this.props = new Properties();
        Enumeration<String> names = this.getLoggerNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            Logger logger = this.getLogger(name);
            if (logger == null) continue;
            logger.reset();
        }
        Logger root = this.loggers.get("");
        if (root != null) {
            root.setLevel(Level.INFO);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (l == null) {
            throw new NullPointerException("l == null");
        }
        this.checkAccess();
        this.listeners.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.checkAccess();
        this.listeners.removePropertyChangeListener(l);
    }

    synchronized Logger getOrCreate(String name, String resourceBundleName) {
        Logger result = this.getLogger(name);
        if (result == null) {
            result = new Logger(name, resourceBundleName);
            this.addLogger(result);
        }
        return result;
    }

    synchronized void setParent(Logger logger, Logger newParent) {
        logger.parent = newParent;
        if (logger.levelObjVal == null) {
            this.setLevelRecursively(logger, null);
        }
        newParent.children.add(logger);
        logger.updateDalvikLogHandler();
    }

    synchronized void setLevelRecursively(Logger logger, Level newLevel) {
        int previous = logger.levelIntVal;
        logger.levelObjVal = newLevel;
        logger.levelIntVal = newLevel == null ? (logger.parent != null ? logger.parent.levelIntVal : Level.INFO.intValue()) : newLevel.intValue();
        if (previous != logger.levelIntVal) {
            for (Logger child : logger.children) {
                if (child.levelObjVal != null) continue;
                this.setLevelRecursively(child, null);
            }
        }
    }

    static {
        String className = System.getProperty("java.util.logging.manager");
        if (className != null) {
            manager = (LogManager)LogManager.getInstanceByClass(className);
        }
        if (manager == null) {
            manager = new LogManager();
        }
        try {
            manager.readConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logger root = new Logger("", null);
        root.setLevel(Level.INFO);
        Logger.global.setParent(root);
        manager.addLogger(root);
        manager.addLogger(Logger.global);
    }
}

