/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import dalvik.system.CloseGuard;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import libcore.io.BufferIterator;
import libcore.io.HeapBufferIterator;
import libcore.io.Streams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFile
implements Closeable,
ZipConstants {
    static final int GPBF_ENCRYPTED_FLAG = 1;
    static final int GPBF_DATA_DESCRIPTOR_FLAG = 8;
    static final int GPBF_UTF8_FLAG = 2048;
    static final int GPBF_UNSUPPORTED_MASK = 1;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private final String filename;
    private File fileToDeleteOnClose;
    private RandomAccessFile raf;
    private final LinkedHashMap<String, ZipEntry> entries = new LinkedHashMap();
    private String comment;
    private final CloseGuard guard = CloseGuard.get();

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    public ZipFile(File file, int mode) throws IOException {
        this.filename = file.getPath();
        if (mode != 1 && mode != 5) {
            throw new IllegalArgumentException("Bad mode: " + mode);
        }
        if ((mode & 4) != 0) {
            this.fileToDeleteOnClose = file;
            this.fileToDeleteOnClose.deleteOnExit();
        } else {
            this.fileToDeleteOnClose = null;
        }
        this.raf = new RandomAccessFile(this.filename, "r");
        this.readCentralDir();
        this.guard.open("close");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws IOException {
        try {
            if (this.guard != null) {
                this.guard.warnIfOpen();
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                super.finalize();
            }
            catch (Throwable t) {
                throw new AssertionError((Object)t);
            }
            throw throwable;
        }
        try {
            super.finalize();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.guard.close();
        RandomAccessFile localRaf = this.raf;
        if (localRaf != null) {
            RandomAccessFile randomAccessFile = localRaf;
            synchronized (randomAccessFile) {
                this.raf = null;
                localRaf.close();
            }
            if (this.fileToDeleteOnClose != null) {
                this.fileToDeleteOnClose.delete();
                this.fileToDeleteOnClose = null;
            }
        }
    }

    private void checkNotClosed() {
        if (this.raf == null) {
            throw new IllegalStateException("Zip file closed");
        }
    }

    public Enumeration<? extends ZipEntry> entries() {
        this.checkNotClosed();
        final Iterator iterator = this.entries.values().iterator();
        return new Enumeration<ZipEntry>(){

            @Override
            public boolean hasMoreElements() {
                ZipFile.this.checkNotClosed();
                return iterator.hasNext();
            }

            @Override
            public ZipEntry nextElement() {
                ZipFile.this.checkNotClosed();
                return (ZipEntry)iterator.next();
            }
        };
    }

    public String getComment() {
        this.checkNotClosed();
        return this.comment;
    }

    public ZipEntry getEntry(String entryName) {
        this.checkNotClosed();
        if (entryName == null) {
            throw new NullPointerException("entryName == null");
        }
        ZipEntry ze = this.entries.get(entryName);
        if (ze == null) {
            ze = this.entries.get(entryName + "/");
        }
        return ze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        RandomAccessFile localRaf;
        if ((entry = this.getEntry(entry.getName())) == null) {
            return null;
        }
        RandomAccessFile randomAccessFile = localRaf = this.raf;
        synchronized (randomAccessFile) {
            RAFStream rafStream = new RAFStream(localRaf, entry.localHeaderRelOffset);
            DataInputStream is = new DataInputStream(rafStream);
            int localMagic = Integer.reverseBytes(is.readInt());
            if ((long)localMagic != 67324752L) {
                ZipFile.throwZipException("Local File Header", localMagic);
            }
            is.skipBytes(2);
            int gpbf = Short.reverseBytes(is.readShort()) & 0xFFFF;
            if ((gpbf & 1) != 0) {
                throw new ZipException("Invalid General Purpose Bit Flag: " + gpbf);
            }
            is.skipBytes(18);
            int fileNameLength = Short.reverseBytes(is.readShort()) & 0xFFFF;
            int extraFieldLength = Short.reverseBytes(is.readShort()) & 0xFFFF;
            is.close();
            rafStream.skip(fileNameLength + extraFieldLength);
            if (entry.compressionMethod == 0) {
                rafStream.endOffset = rafStream.offset + entry.size;
                return rafStream;
            }
            rafStream.endOffset = rafStream.offset + entry.compressedSize;
            int bufSize = Math.max(1024, (int)Math.min(entry.getSize(), 65535L));
            return new ZipInflaterInputStream(rafStream, new Inflater(true), bufSize, entry);
        }
    }

    public String getName() {
        return this.filename;
    }

    public int size() {
        this.checkNotClosed();
        return this.entries.size();
    }

    private void readCentralDir() throws IOException {
        block8: {
            long scanOffset = this.raf.length() - 22L;
            if (scanOffset < 0L) {
                throw new ZipException("File too short to be a zip file: " + this.raf.length());
            }
            this.raf.seek(0L);
            int headerMagic = Integer.reverseBytes(this.raf.readInt());
            if ((long)headerMagic != 67324752L) {
                throw new ZipException("Not a zip archive");
            }
            long stopOffset = scanOffset - 65536L;
            if (stopOffset < 0L) {
                stopOffset = 0L;
            }
            do {
                this.raf.seek(scanOffset);
                if ((long)Integer.reverseBytes(this.raf.readInt()) == 101010256L) break block8;
            } while (--scanOffset >= stopOffset);
            throw new ZipException("End Of Central Directory signature not found");
        }
        byte[] eocd = new byte[18];
        this.raf.readFully(eocd);
        BufferIterator it = HeapBufferIterator.iterator(eocd, 0, eocd.length, ByteOrder.LITTLE_ENDIAN);
        int diskNumber = it.readShort() & 0xFFFF;
        int diskWithCentralDir = it.readShort() & 0xFFFF;
        int numEntries = it.readShort() & 0xFFFF;
        int totalNumEntries = it.readShort() & 0xFFFF;
        it.skip(4);
        long centralDirOffset = (long)it.readInt() & 0xFFFFFFFFL;
        int commentLength = it.readShort() & 0xFFFF;
        if (numEntries != totalNumEntries || diskNumber != 0 || diskWithCentralDir != 0) {
            throw new ZipException("Spanned archives not supported");
        }
        if (commentLength > 0) {
            byte[] commentBytes = new byte[commentLength];
            this.raf.readFully(commentBytes);
            this.comment = new String(commentBytes, 0, commentBytes.length, StandardCharsets.UTF_8);
        }
        RAFStream rafStream = new RAFStream(this.raf, centralDirOffset);
        BufferedInputStream bufferedStream = new BufferedInputStream(rafStream, 4096);
        byte[] hdrBuf = new byte[46];
        for (int i = 0; i < numEntries; ++i) {
            ZipEntry newEntry = new ZipEntry(hdrBuf, bufferedStream);
            if (newEntry.localHeaderRelOffset >= centralDirOffset) {
                throw new ZipException("Local file header offset is after central directory");
            }
            String entryName = newEntry.getName();
            if (this.entries.put(entryName, newEntry) == null) continue;
            throw new ZipException("Duplicate entry name: " + entryName);
        }
    }

    static void throwZipException(String msg, int magic) throws ZipException {
        String hexString = IntegralToString.intToHexString(magic, true, 8);
        throw new ZipException(msg + " signature not found; was " + hexString);
    }

    public static class ZipInflaterInputStream
    extends InflaterInputStream {
        private final ZipEntry entry;
        private long bytesRead = 0L;

        public ZipInflaterInputStream(InputStream is, Inflater inf, int bsize, ZipEntry entry) {
            super(is, inf, bsize);
            this.entry = entry;
        }

        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            int i;
            try {
                i = super.read(buffer, byteOffset, byteCount);
            }
            catch (IOException e) {
                throw new IOException("Error reading data for " + this.entry.getName() + " near offset " + this.bytesRead, e);
            }
            if (i == -1) {
                if (this.entry.size != this.bytesRead) {
                    throw new IOException("Size mismatch on inflated file: " + this.bytesRead + " vs " + this.entry.size);
                }
            } else {
                this.bytesRead += (long)i;
            }
            return i;
        }

        public int available() throws IOException {
            if (this.closed) {
                return 0;
            }
            return super.available() == 0 ? 0 : (int)(this.entry.getSize() - this.bytesRead);
        }
    }

    public static class RAFStream
    extends InputStream {
        private final RandomAccessFile sharedRaf;
        private long endOffset;
        private long offset;

        public RAFStream(RandomAccessFile raf, long initialOffset, long endOffset) {
            this.sharedRaf = raf;
            this.offset = initialOffset;
            this.endOffset = endOffset;
        }

        public RAFStream(RandomAccessFile raf, long initialOffset) throws IOException {
            this(raf, initialOffset, raf.length());
        }

        public int available() throws IOException {
            return this.offset < this.endOffset ? 1 : 0;
        }

        public int read() throws IOException {
            return Streams.readSingleByte(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int read(byte[] buffer, int byteOffset, int byteCount) throws IOException {
            RandomAccessFile randomAccessFile = this.sharedRaf;
            synchronized (randomAccessFile) {
                long length = this.endOffset - this.offset;
                if ((long)byteCount > length) {
                    byteCount = (int)length;
                }
                this.sharedRaf.seek(this.offset);
                int count = this.sharedRaf.read(buffer, byteOffset, byteCount);
                if (count > 0) {
                    this.offset += (long)count;
                    return count;
                }
                return -1;
            }
        }

        public long skip(long byteCount) throws IOException {
            if (byteCount > this.endOffset - this.offset) {
                byteCount = this.endOffset - this.offset;
            }
            this.offset += byteCount;
            return byteCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int fill(Inflater inflater, int nativeEndBufSize) throws IOException {
            RandomAccessFile randomAccessFile = this.sharedRaf;
            synchronized (randomAccessFile) {
                int len = Math.min((int)(this.endOffset - this.offset), nativeEndBufSize);
                int cnt = inflater.setFileInput(this.sharedRaf.getFD(), this.offset, nativeEndBufSize);
                this.skip(cnt);
                return len;
            }
        }
    }
}

