/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import java.io.IOException;
import java.net.Socket;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.net.SocketFactory;
import javax.net.ssl.DefaultSSLSocketFactory;
import javax.net.ssl.SSLContext;

public abstract class SSLSocketFactory
extends SocketFactory {
    private static SocketFactory defaultSocketFactory;
    private static String defaultName;

    public static synchronized SocketFactory getDefault() {
        if (defaultSocketFactory != null) {
            return defaultSocketFactory;
        }
        if (defaultName == null && (defaultName = Security.getProperty("ssl.SocketFactory.provider")) != null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            try {
                Class<?> sfc = Class.forName(defaultName, true, cl);
                defaultSocketFactory = (SocketFactory)sfc.newInstance();
            }
            catch (Exception e) {
                System.logE("Problem creating " + defaultName, e);
            }
        }
        if (defaultSocketFactory == null) {
            SSLContext context;
            try {
                context = SSLContext.getDefault();
            }
            catch (NoSuchAlgorithmException e) {
                context = null;
            }
            if (context != null) {
                defaultSocketFactory = context.getSocketFactory();
            }
        }
        if (defaultSocketFactory == null) {
            defaultSocketFactory = new DefaultSSLSocketFactory("No SSLSocketFactory installed");
        }
        return defaultSocketFactory;
    }

    public abstract String[] getDefaultCipherSuites();

    public abstract String[] getSupportedCipherSuites();

    public abstract Socket createSocket(Socket var1, String var2, int var3, boolean var4) throws IOException;
}

