/*
 * Decompiled with CFR 0.152.
 */
package javax.obex;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.BaseStream;
import javax.obex.ClientSession;
import javax.obex.HeaderSet;
import javax.obex.ObexHelper;
import javax.obex.Operation;
import javax.obex.PrivateInputStream;
import javax.obex.PrivateOutputStream;

public final class ClientOperation
implements Operation,
BaseStream {
    private ClientSession mParent;
    private boolean mInputOpen;
    private PrivateInputStream mPrivateInput;
    private boolean mPrivateInputOpen;
    private PrivateOutputStream mPrivateOutput;
    private boolean mPrivateOutputOpen;
    private String mExceptionMessage;
    private int mMaxPacketSize;
    private boolean mOperationDone;
    private boolean mGetOperation;
    private HeaderSet mRequestHeader;
    private HeaderSet mReplyHeader;
    private boolean mEndOfBodySent;

    public ClientOperation(int maxSize, ClientSession p, HeaderSet header, boolean type) throws IOException {
        this.mParent = p;
        this.mEndOfBodySent = false;
        this.mInputOpen = true;
        this.mOperationDone = false;
        this.mMaxPacketSize = maxSize;
        this.mGetOperation = type;
        this.mPrivateInputOpen = false;
        this.mPrivateOutputOpen = false;
        this.mPrivateInput = null;
        this.mPrivateOutput = null;
        this.mReplyHeader = new HeaderSet();
        this.mRequestHeader = new HeaderSet();
        int[] headerList = header.getHeaderList();
        if (headerList != null) {
            for (int i = 0; i < headerList.length; ++i) {
                this.mRequestHeader.setHeader(headerList[i], header.getHeader(headerList[i]));
            }
        }
        if (header.mAuthChall != null) {
            this.mRequestHeader.mAuthChall = new byte[header.mAuthChall.length];
            System.arraycopy(header.mAuthChall, 0, this.mRequestHeader.mAuthChall, 0, header.mAuthChall.length);
        }
        if (header.mAuthResp != null) {
            this.mRequestHeader.mAuthResp = new byte[header.mAuthResp.length];
            System.arraycopy(header.mAuthResp, 0, this.mRequestHeader.mAuthResp, 0, header.mAuthResp.length);
        }
        if (header.mConnectionID != null) {
            this.mRequestHeader.mConnectionID = new byte[4];
            System.arraycopy(header.mConnectionID, 0, this.mRequestHeader.mConnectionID, 0, 4);
        }
    }

    public synchronized void abort() throws IOException {
        this.ensureOpen();
        if (this.mOperationDone && this.mReplyHeader.responseCode != 144) {
            throw new IOException("Operation has already ended");
        }
        this.mExceptionMessage = "Operation aborted";
        if (!this.mOperationDone && this.mReplyHeader.responseCode == 144) {
            this.mOperationDone = true;
            this.mParent.sendRequest(255, null, this.mReplyHeader, null);
            if (this.mReplyHeader.responseCode != 160) {
                throw new IOException("Invalid response code from server");
            }
            this.mExceptionMessage = null;
        }
        this.close();
    }

    public synchronized int getResponseCode() throws IOException {
        if (this.mReplyHeader.responseCode == -1 || this.mReplyHeader.responseCode == 144) {
            this.validateConnection();
        }
        return this.mReplyHeader.responseCode;
    }

    public String getEncoding() {
        return null;
    }

    public String getType() {
        try {
            return (String)this.mReplyHeader.getHeader(66);
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getLength() {
        try {
            Long temp = (Long)this.mReplyHeader.getHeader(195);
            if (temp == null) {
                return -1L;
            }
            return temp;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public InputStream openInputStream() throws IOException {
        this.ensureOpen();
        if (this.mPrivateInputOpen) {
            throw new IOException("no more input streams available");
        }
        if (this.mGetOperation) {
            this.validateConnection();
        } else if (this.mPrivateInput == null) {
            this.mPrivateInput = new PrivateInputStream(this);
        }
        this.mPrivateInputOpen = true;
        return this.mPrivateInput;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        this.ensureOpen();
        this.ensureNotDone();
        if (this.mPrivateOutputOpen) {
            throw new IOException("no more output streams available");
        }
        if (this.mPrivateOutput == null) {
            this.mPrivateOutput = new PrivateOutputStream(this, this.getMaxPacketSize());
        }
        this.mPrivateOutputOpen = true;
        return this.mPrivateOutput;
    }

    public int getMaxPacketSize() {
        return this.mMaxPacketSize - 6 - this.getHeaderLength();
    }

    public int getHeaderLength() {
        byte[] headerArray = ObexHelper.createHeader(this.mRequestHeader, false);
        return headerArray.length;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        this.mInputOpen = false;
        this.mPrivateInputOpen = false;
        this.mPrivateOutputOpen = false;
        this.mParent.setRequestInactive();
    }

    public HeaderSet getReceivedHeader() throws IOException {
        this.ensureOpen();
        return this.mReplyHeader;
    }

    public void sendHeaders(HeaderSet headers) throws IOException {
        this.ensureOpen();
        if (this.mOperationDone) {
            throw new IOException("Operation has already exchanged all data");
        }
        if (headers == null) {
            throw new IOException("Headers may not be null");
        }
        int[] headerList = headers.getHeaderList();
        if (headerList != null) {
            for (int i = 0; i < headerList.length; ++i) {
                this.mRequestHeader.setHeader(headerList[i], headers.getHeader(headerList[i]));
            }
        }
    }

    public void ensureNotDone() throws IOException {
        if (this.mOperationDone) {
            throw new IOException("Operation has completed");
        }
    }

    public void ensureOpen() throws IOException {
        this.mParent.ensureOpen();
        if (this.mExceptionMessage != null) {
            throw new IOException(this.mExceptionMessage);
        }
        if (!this.mInputOpen) {
            throw new IOException("Operation has already ended");
        }
    }

    private void validateConnection() throws IOException {
        this.ensureOpen();
        if (this.mPrivateInput == null) {
            this.startProcessing();
        }
    }

    private boolean sendRequest(int opCode) throws IOException {
        boolean returnValue = false;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int bodyLength = -1;
        byte[] headerArray = ObexHelper.createHeader(this.mRequestHeader, true);
        if (this.mPrivateOutput != null) {
            bodyLength = this.mPrivateOutput.size();
        }
        if (3 + headerArray.length > this.mMaxPacketSize) {
            int end = 0;
            int start = 0;
            while (end != headerArray.length) {
                end = ObexHelper.findHeaderEnd(headerArray, start, this.mMaxPacketSize - 3);
                if (end == -1) {
                    this.mOperationDone = true;
                    this.abort();
                    this.mExceptionMessage = "Header larger then can be sent in a packet";
                    this.mInputOpen = false;
                    if (this.mPrivateInput != null) {
                        this.mPrivateInput.close();
                    }
                    if (this.mPrivateOutput != null) {
                        this.mPrivateOutput.close();
                    }
                    throw new IOException("OBEX Packet exceeds max packet size");
                }
                byte[] sendHeader = new byte[end - start];
                System.arraycopy(headerArray, start, sendHeader, 0, sendHeader.length);
                if (!this.mParent.sendRequest(opCode, sendHeader, this.mReplyHeader, this.mPrivateInput)) {
                    return false;
                }
                if (this.mReplyHeader.responseCode != 144) {
                    return false;
                }
                start = end;
            }
            return bodyLength > 0;
        }
        out.write(headerArray);
        if (bodyLength > 0) {
            if (bodyLength > this.mMaxPacketSize - headerArray.length - 6) {
                returnValue = true;
                bodyLength = this.mMaxPacketSize - headerArray.length - 6;
            }
            byte[] body = this.mPrivateOutput.readBytes(bodyLength);
            if (this.mPrivateOutput.isClosed() && !returnValue && !this.mEndOfBodySent && (opCode & 0x80) != 0) {
                out.write(73);
                this.mEndOfBodySent = true;
            } else {
                out.write(72);
            }
            out.write((byte)((bodyLength += 3) >> 8));
            out.write((byte)bodyLength);
            if (body != null) {
                out.write(body);
            }
        }
        if (this.mPrivateOutputOpen && bodyLength <= 0 && !this.mEndOfBodySent) {
            if ((opCode & 0x80) == 0) {
                out.write(72);
            } else {
                out.write(73);
                this.mEndOfBodySent = true;
            }
            bodyLength = 3;
            out.write((byte)(bodyLength >> 8));
            out.write((byte)bodyLength);
        }
        if (out.size() == 0) {
            if (!this.mParent.sendRequest(opCode, null, this.mReplyHeader, this.mPrivateInput)) {
                return false;
            }
            return returnValue;
        }
        if (out.size() > 0 && !this.mParent.sendRequest(opCode, out.toByteArray(), this.mReplyHeader, this.mPrivateInput)) {
            return false;
        }
        if (this.mPrivateOutput != null && this.mPrivateOutput.size() > 0) {
            returnValue = true;
        }
        return returnValue;
    }

    private synchronized void startProcessing() throws IOException {
        if (this.mPrivateInput == null) {
            this.mPrivateInput = new PrivateInputStream(this);
        }
        boolean more = true;
        if (this.mGetOperation) {
            if (!this.mOperationDone) {
                this.mReplyHeader.responseCode = 144;
                while (more && this.mReplyHeader.responseCode == 144) {
                    more = this.sendRequest(3);
                }
                if (this.mReplyHeader.responseCode == 144) {
                    this.mParent.sendRequest(131, null, this.mReplyHeader, this.mPrivateInput);
                }
                if (this.mReplyHeader.responseCode != 144) {
                    this.mOperationDone = true;
                }
            }
        } else {
            if (!this.mOperationDone) {
                this.mReplyHeader.responseCode = 144;
                while (more && this.mReplyHeader.responseCode == 144) {
                    more = this.sendRequest(2);
                }
            }
            if (this.mReplyHeader.responseCode == 144) {
                this.mParent.sendRequest(130, null, this.mReplyHeader, this.mPrivateInput);
            }
            if (this.mReplyHeader.responseCode != 144) {
                this.mOperationDone = true;
            }
        }
    }

    public synchronized boolean continueOperation(boolean sendEmpty, boolean inStream) throws IOException {
        if (this.mGetOperation) {
            if (inStream && !this.mOperationDone) {
                this.mParent.sendRequest(131, null, this.mReplyHeader, this.mPrivateInput);
                if (this.mReplyHeader.responseCode != 144) {
                    this.mOperationDone = true;
                }
                return true;
            }
            if (!inStream && !this.mOperationDone) {
                if (this.mPrivateInput == null) {
                    this.mPrivateInput = new PrivateInputStream(this);
                }
                this.sendRequest(3);
                return true;
            }
            if (this.mOperationDone) {
                return false;
            }
        } else {
            if (!inStream && !this.mOperationDone) {
                if (this.mReplyHeader.responseCode == -1) {
                    this.mReplyHeader.responseCode = 144;
                }
                this.sendRequest(2);
                return true;
            }
            if (inStream && !this.mOperationDone) {
                return false;
            }
            if (this.mOperationDone) {
                return false;
            }
        }
        return false;
    }

    public void streamClosed(boolean inStream) throws IOException {
        if (!this.mGetOperation) {
            if (!inStream && !this.mOperationDone) {
                byte[] headerArray;
                boolean more = true;
                if (this.mPrivateOutput != null && this.mPrivateOutput.size() <= 0 && (headerArray = ObexHelper.createHeader(this.mRequestHeader, false)).length <= 0) {
                    more = false;
                }
                if (this.mReplyHeader.responseCode == -1) {
                    this.mReplyHeader.responseCode = 144;
                }
                while (more && this.mReplyHeader.responseCode == 144) {
                    more = this.sendRequest(2);
                }
                while (this.mReplyHeader.responseCode == 144) {
                    this.sendRequest(130);
                }
                this.mOperationDone = true;
            } else if (inStream && this.mOperationDone) {
                this.mOperationDone = true;
            }
        } else if (inStream && !this.mOperationDone) {
            if (this.mReplyHeader.responseCode == -1) {
                this.mReplyHeader.responseCode = 144;
            }
            while (this.mReplyHeader.responseCode == 144 && this.sendRequest(131)) {
            }
            while (this.mReplyHeader.responseCode == 144) {
                this.mParent.sendRequest(131, null, this.mReplyHeader, this.mPrivateInput);
            }
            this.mOperationDone = true;
        } else if (!inStream && !this.mOperationDone) {
            byte[] headerArray;
            boolean more = true;
            if (this.mPrivateOutput != null && this.mPrivateOutput.size() <= 0 && (headerArray = ObexHelper.createHeader(this.mRequestHeader, false)).length <= 0) {
                more = false;
            }
            if (this.mPrivateInput == null) {
                this.mPrivateInput = new PrivateInputStream(this);
            }
            if (this.mPrivateOutput != null && this.mPrivateOutput.size() <= 0) {
                more = false;
            }
            this.mReplyHeader.responseCode = 144;
            while (more && this.mReplyHeader.responseCode == 144) {
                more = this.sendRequest(3);
            }
            this.sendRequest(131);
            if (this.mReplyHeader.responseCode != 144) {
                this.mOperationDone = true;
            }
        }
    }

    public void noBodyHeader() {
    }
}

