/*
 * Decompiled with CFR 0.152.
 */
package javax.obex;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Calendar;
import javax.obex.ObexHelper;

public final class HeaderSet {
    public static final int COUNT = 192;
    public static final int NAME = 1;
    public static final int TYPE = 66;
    public static final int LENGTH = 195;
    public static final int TIME_ISO_8601 = 68;
    public static final int TIME_4_BYTE = 196;
    public static final int DESCRIPTION = 5;
    public static final int TARGET = 70;
    public static final int HTTP = 71;
    public static final int BODY = 72;
    public static final int END_OF_BODY = 73;
    public static final int WHO = 74;
    public static final int CONNECTION_ID = 203;
    public static final int APPLICATION_PARAMETER = 76;
    public static final int AUTH_CHALLENGE = 77;
    public static final int AUTH_RESPONSE = 78;
    public static final int OBJECT_CLASS = 79;
    private Long mCount;
    private String mName;
    private String mType;
    private Long mLength;
    private Calendar mIsoTime;
    private Calendar mByteTime;
    private String mDescription;
    private byte[] mTarget;
    private byte[] mHttpHeader;
    private byte[] mWho;
    private byte[] mAppParam;
    private byte[] mObjectClass;
    private String[] mUnicodeUserDefined = new String[16];
    private byte[][] mSequenceUserDefined = new byte[16][];
    private Byte[] mByteUserDefined = new Byte[16];
    private Long[] mIntegerUserDefined = new Long[16];
    private final SecureRandom mRandom = new SecureRandom();
    byte[] nonce;
    public byte[] mAuthChall;
    public byte[] mAuthResp;
    public byte[] mConnectionID;
    public int responseCode = -1;

    public void setHeader(int headerID, Object headerValue) {
        long temp = -1L;
        switch (headerID) {
            case 192: {
                if (!(headerValue instanceof Long)) {
                    if (headerValue == null) {
                        this.mCount = null;
                        break;
                    }
                    throw new IllegalArgumentException("Count must be a Long");
                }
                temp = (Long)headerValue;
                if (temp < 0L || temp > 0xFFFFFFFFL) {
                    throw new IllegalArgumentException("Count must be between 0 and 0xFFFFFFFF");
                }
                this.mCount = (Long)headerValue;
                break;
            }
            case 1: {
                if (headerValue != null && !(headerValue instanceof String)) {
                    throw new IllegalArgumentException("Name must be a String");
                }
                this.mName = (String)headerValue;
                break;
            }
            case 66: {
                if (headerValue != null && !(headerValue instanceof String)) {
                    throw new IllegalArgumentException("Type must be a String");
                }
                this.mType = (String)headerValue;
                break;
            }
            case 195: {
                if (!(headerValue instanceof Long)) {
                    if (headerValue == null) {
                        this.mLength = null;
                        break;
                    }
                    throw new IllegalArgumentException("Length must be a Long");
                }
                temp = (Long)headerValue;
                if (temp < 0L || temp > 0xFFFFFFFFL) {
                    throw new IllegalArgumentException("Length must be between 0 and 0xFFFFFFFF");
                }
                this.mLength = (Long)headerValue;
                break;
            }
            case 68: {
                if (headerValue != null && !(headerValue instanceof Calendar)) {
                    throw new IllegalArgumentException("Time ISO 8601 must be a Calendar");
                }
                this.mIsoTime = (Calendar)headerValue;
                break;
            }
            case 196: {
                if (headerValue != null && !(headerValue instanceof Calendar)) {
                    throw new IllegalArgumentException("Time 4 Byte must be a Calendar");
                }
                this.mByteTime = (Calendar)headerValue;
                break;
            }
            case 5: {
                if (headerValue != null && !(headerValue instanceof String)) {
                    throw new IllegalArgumentException("Description must be a String");
                }
                this.mDescription = (String)headerValue;
                break;
            }
            case 70: {
                if (headerValue == null) {
                    this.mTarget = null;
                    break;
                }
                if (!(headerValue instanceof byte[])) {
                    throw new IllegalArgumentException("Target must be a byte array");
                }
                this.mTarget = new byte[((byte[])headerValue).length];
                System.arraycopy(headerValue, 0, this.mTarget, 0, this.mTarget.length);
                break;
            }
            case 71: {
                if (headerValue == null) {
                    this.mHttpHeader = null;
                    break;
                }
                if (!(headerValue instanceof byte[])) {
                    throw new IllegalArgumentException("HTTP must be a byte array");
                }
                this.mHttpHeader = new byte[((byte[])headerValue).length];
                System.arraycopy(headerValue, 0, this.mHttpHeader, 0, this.mHttpHeader.length);
                break;
            }
            case 74: {
                if (headerValue == null) {
                    this.mWho = null;
                    break;
                }
                if (!(headerValue instanceof byte[])) {
                    throw new IllegalArgumentException("WHO must be a byte array");
                }
                this.mWho = new byte[((byte[])headerValue).length];
                System.arraycopy(headerValue, 0, this.mWho, 0, this.mWho.length);
                break;
            }
            case 79: {
                if (headerValue == null) {
                    this.mObjectClass = null;
                    break;
                }
                if (!(headerValue instanceof byte[])) {
                    throw new IllegalArgumentException("Object Class must be a byte array");
                }
                this.mObjectClass = new byte[((byte[])headerValue).length];
                System.arraycopy(headerValue, 0, this.mObjectClass, 0, this.mObjectClass.length);
                break;
            }
            case 76: {
                if (headerValue == null) {
                    this.mAppParam = null;
                    break;
                }
                if (!(headerValue instanceof byte[])) {
                    throw new IllegalArgumentException("Application Parameter must be a byte array");
                }
                this.mAppParam = new byte[((byte[])headerValue).length];
                System.arraycopy(headerValue, 0, this.mAppParam, 0, this.mAppParam.length);
                break;
            }
            default: {
                if (headerID >= 48 && headerID <= 63) {
                    if (headerValue != null && !(headerValue instanceof String)) {
                        throw new IllegalArgumentException("Unicode String User Defined must be a String");
                    }
                    this.mUnicodeUserDefined[headerID - 48] = (String)headerValue;
                    break;
                }
                if (headerID >= 112 && headerID <= 127) {
                    if (headerValue == null) {
                        this.mSequenceUserDefined[headerID - 112] = null;
                        break;
                    }
                    if (!(headerValue instanceof byte[])) {
                        throw new IllegalArgumentException("Byte Sequence User Defined must be a byte array");
                    }
                    this.mSequenceUserDefined[headerID - 112] = new byte[((byte[])headerValue).length];
                    System.arraycopy(headerValue, 0, this.mSequenceUserDefined[headerID - 112], 0, this.mSequenceUserDefined[headerID - 112].length);
                    break;
                }
                if (headerID >= 176 && headerID <= 191) {
                    if (headerValue != null && !(headerValue instanceof Byte)) {
                        throw new IllegalArgumentException("ByteUser Defined must be a Byte");
                    }
                    this.mByteUserDefined[headerID - 176] = (Byte)headerValue;
                    break;
                }
                if (headerID >= 240 && headerID <= 255) {
                    if (!(headerValue instanceof Long)) {
                        if (headerValue == null) {
                            this.mIntegerUserDefined[headerID - 240] = null;
                            break;
                        }
                        throw new IllegalArgumentException("Integer User Defined must be a Long");
                    }
                    temp = (Long)headerValue;
                    if (temp < 0L || temp > 0xFFFFFFFFL) {
                        throw new IllegalArgumentException("Integer User Defined must be between 0 and 0xFFFFFFFF");
                    }
                    this.mIntegerUserDefined[headerID - 240] = (Long)headerValue;
                    break;
                }
                throw new IllegalArgumentException("Invalid Header Identifier");
            }
        }
    }

    public Object getHeader(int headerID) throws IOException {
        switch (headerID) {
            case 192: {
                return this.mCount;
            }
            case 1: {
                return this.mName;
            }
            case 66: {
                return this.mType;
            }
            case 195: {
                return this.mLength;
            }
            case 68: {
                return this.mIsoTime;
            }
            case 196: {
                return this.mByteTime;
            }
            case 5: {
                return this.mDescription;
            }
            case 70: {
                return this.mTarget;
            }
            case 71: {
                return this.mHttpHeader;
            }
            case 74: {
                return this.mWho;
            }
            case 203: {
                return this.mConnectionID;
            }
            case 79: {
                return this.mObjectClass;
            }
            case 76: {
                return this.mAppParam;
            }
        }
        if (headerID >= 48 && headerID <= 63) {
            return this.mUnicodeUserDefined[headerID - 48];
        }
        if (headerID >= 112 && headerID <= 127) {
            return this.mSequenceUserDefined[headerID - 112];
        }
        if (headerID >= 176 && headerID <= 191) {
            return this.mByteUserDefined[headerID - 176];
        }
        if (headerID >= 240 && headerID <= 255) {
            return this.mIntegerUserDefined[headerID - 240];
        }
        throw new IllegalArgumentException("Invalid Header Identifier");
    }

    public int[] getHeaderList() throws IOException {
        int i;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.mCount != null) {
            out.write(192);
        }
        if (this.mName != null) {
            out.write(1);
        }
        if (this.mType != null) {
            out.write(66);
        }
        if (this.mLength != null) {
            out.write(195);
        }
        if (this.mIsoTime != null) {
            out.write(68);
        }
        if (this.mByteTime != null) {
            out.write(196);
        }
        if (this.mDescription != null) {
            out.write(5);
        }
        if (this.mTarget != null) {
            out.write(70);
        }
        if (this.mHttpHeader != null) {
            out.write(71);
        }
        if (this.mWho != null) {
            out.write(74);
        }
        if (this.mAppParam != null) {
            out.write(76);
        }
        if (this.mObjectClass != null) {
            out.write(79);
        }
        for (i = 48; i < 64; ++i) {
            if (this.mUnicodeUserDefined[i - 48] == null) continue;
            out.write(i);
        }
        for (i = 112; i < 128; ++i) {
            if (this.mSequenceUserDefined[i - 112] == null) continue;
            out.write(i);
        }
        for (i = 176; i < 192; ++i) {
            if (this.mByteUserDefined[i - 176] == null) continue;
            out.write(i);
        }
        for (i = 240; i < 256; ++i) {
            if (this.mIntegerUserDefined[i - 240] == null) continue;
            out.write(i);
        }
        byte[] headers = out.toByteArray();
        out.close();
        if (headers == null || headers.length == 0) {
            return null;
        }
        int[] result = new int[headers.length];
        for (int i2 = 0; i2 < headers.length; ++i2) {
            result[i2] = headers[i2] & 0xFF;
        }
        return result;
    }

    public void createAuthenticationChallenge(String realm, boolean userID, boolean access) throws IOException {
        this.nonce = new byte[16];
        for (int i = 0; i < 16; ++i) {
            this.nonce[i] = (byte)this.mRandom.nextInt();
        }
        this.mAuthChall = ObexHelper.computeAuthenticationChallenge(this.nonce, realm, access, userID);
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode == -1) {
            throw new IOException("May not be called on a server");
        }
        return this.responseCode;
    }
}

