/*
 * Decompiled with CFR 0.152.
 */
package javax.obex;

import java.io.IOException;
import java.io.InputStream;
import javax.obex.BaseStream;

public final class PrivateInputStream
extends InputStream {
    private BaseStream mParent;
    private byte[] mData;
    private int mIndex;
    private boolean mOpen;

    public PrivateInputStream(BaseStream p) {
        this.mParent = p;
        this.mData = new byte[0];
        this.mIndex = 0;
        this.mOpen = true;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.mData.length - this.mIndex;
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        while (this.mData.length == this.mIndex) {
            if (this.mParent.continueOperation(true, true)) continue;
            return -1;
        }
        return this.mData[this.mIndex++] & 0xFF;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int offset, int length) throws IOException {
        int remainReadLength;
        if (b == null) {
            throw new IOException("buffer is null");
        }
        if ((offset | length) < 0 || length > b.length - offset) {
            throw new ArrayIndexOutOfBoundsException("index outof bound");
        }
        this.ensureOpen();
        int currentDataLength = this.mData.length - this.mIndex;
        int offset1 = offset;
        int result = 0;
        for (remainReadLength = length; currentDataLength <= remainReadLength; remainReadLength -= currentDataLength) {
            System.arraycopy(this.mData, this.mIndex, b, offset1, currentDataLength);
            this.mIndex += currentDataLength;
            offset1 += currentDataLength;
            result += currentDataLength;
            if (!this.mParent.continueOperation(true, true)) {
                return result == 0 ? -1 : result;
            }
            currentDataLength = this.mData.length - this.mIndex;
        }
        if (remainReadLength > 0) {
            System.arraycopy(this.mData, this.mIndex, b, offset1, remainReadLength);
            this.mIndex += remainReadLength;
            result += remainReadLength;
        }
        return result;
    }

    public synchronized void writeBytes(byte[] body, int start) {
        int length = body.length - start + (this.mData.length - this.mIndex);
        byte[] temp = new byte[length];
        System.arraycopy(this.mData, this.mIndex, temp, 0, this.mData.length - this.mIndex);
        System.arraycopy(body, start, temp, this.mData.length - this.mIndex, body.length - start);
        this.mData = temp;
        this.mIndex = 0;
        this.notifyAll();
    }

    private void ensureOpen() throws IOException {
        this.mParent.ensureOpen();
        if (!this.mOpen) {
            throw new IOException("Input stream is closed");
        }
    }

    public void close() throws IOException {
        this.mOpen = false;
        this.mParent.streamClosed(true);
    }
}

