/*
 * Decompiled with CFR 0.152.
 */
package javax.obex;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.obex.BaseStream;
import javax.obex.HeaderSet;
import javax.obex.ObexHelper;
import javax.obex.Operation;
import javax.obex.PrivateInputStream;
import javax.obex.PrivateOutputStream;
import javax.obex.ServerRequestHandler;
import javax.obex.ServerSession;

public final class ServerOperation
implements Operation,
BaseStream {
    public boolean isAborted = false;
    public HeaderSet requestHeader;
    public HeaderSet replyHeader;
    public boolean finalBitSet;
    private InputStream mInput;
    private ServerSession mParent;
    private int mMaxPacketLength;
    private int mResponseSize;
    private boolean mClosed;
    private boolean mGetOperation;
    private PrivateInputStream mPrivateInput;
    private PrivateOutputStream mPrivateOutput;
    private boolean mPrivateOutputOpen;
    private String mExceptionString;
    private ServerRequestHandler mListener;
    private boolean mRequestFinished;
    private boolean mHasBody;
    private boolean mSendBodyHeader = true;

    public ServerOperation(ServerSession p, InputStream in, int request, int maxSize, ServerRequestHandler listen) throws IOException {
        this.mParent = p;
        this.mInput = in;
        this.mMaxPacketLength = maxSize;
        this.mClosed = false;
        this.requestHeader = new HeaderSet();
        this.replyHeader = new HeaderSet();
        this.mPrivateInput = new PrivateInputStream(this);
        this.mResponseSize = 3;
        this.mListener = listen;
        this.mRequestFinished = false;
        this.mPrivateOutputOpen = false;
        this.mHasBody = false;
        if (request == 2 || request == 130) {
            this.mGetOperation = false;
            if ((request & 0x80) == 0) {
                this.finalBitSet = false;
            } else {
                this.finalBitSet = true;
                this.mRequestFinished = true;
            }
        } else if (request == 3 || request == 131) {
            this.mGetOperation = true;
            this.finalBitSet = false;
            if (request == 131) {
                this.mRequestFinished = true;
            }
        } else {
            throw new IOException("ServerOperation can not handle such request");
        }
        int length = in.read();
        length = (length << 8) + in.read();
        if (length > 65534) {
            this.mParent.sendResponse(206, null);
            throw new IOException("Packet received was too large");
        }
        if (length > 3) {
            byte[] data = new byte[length - 3];
            for (int bytesReceived = in.read(data); bytesReceived != data.length; bytesReceived += in.read(data, bytesReceived, data.length - bytesReceived)) {
            }
            byte[] body = ObexHelper.updateHeaderSet(this.requestHeader, data);
            if (body != null) {
                this.mHasBody = true;
            }
            if (this.mListener.getConnectionId() != -1L && this.requestHeader.mConnectionID != null) {
                this.mListener.setConnectionId(ObexHelper.convertToLong(this.requestHeader.mConnectionID));
            } else {
                this.mListener.setConnectionId(1L);
            }
            if (this.requestHeader.mAuthResp != null && !this.mParent.handleAuthResp(this.requestHeader.mAuthResp)) {
                this.mExceptionString = "Authentication Failed";
                this.mParent.sendResponse(193, null);
                this.mClosed = true;
                this.requestHeader.mAuthResp = null;
                return;
            }
            if (this.requestHeader.mAuthChall != null) {
                this.mParent.handleAuthChall(this.requestHeader);
                this.replyHeader.mAuthResp = new byte[this.requestHeader.mAuthResp.length];
                System.arraycopy(this.requestHeader.mAuthResp, 0, this.replyHeader.mAuthResp, 0, this.replyHeader.mAuthResp.length);
                this.requestHeader.mAuthResp = null;
                this.requestHeader.mAuthChall = null;
            }
            if (body != null) {
                this.mPrivateInput.writeBytes(body, 1);
            } else {
                while (!this.mGetOperation && !this.finalBitSet) {
                    this.sendReply(144);
                    if (this.mPrivateInput.available() <= 0) continue;
                }
            }
        }
        while (!this.mGetOperation && !this.finalBitSet && this.mPrivateInput.available() == 0) {
            this.sendReply(144);
            if (this.mPrivateInput.available() <= 0) continue;
        }
        while (this.mGetOperation && !this.mRequestFinished) {
            this.sendReply(144);
        }
    }

    public boolean isValidBody() {
        return this.mHasBody;
    }

    public synchronized boolean continueOperation(boolean sendEmpty, boolean inStream) throws IOException {
        if (!this.mGetOperation) {
            if (!this.finalBitSet) {
                if (sendEmpty) {
                    this.sendReply(144);
                    return true;
                }
                if (this.mResponseSize > 3 || this.mPrivateOutput.size() > 0) {
                    this.sendReply(144);
                    return true;
                }
                return false;
            }
            return false;
        }
        this.sendReply(144);
        return true;
    }

    public synchronized boolean sendReply(int type) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        long id2 = this.mListener.getConnectionId();
        this.replyHeader.mConnectionID = (byte[])(id2 == -1L ? null : ObexHelper.convertToByteArray(id2));
        byte[] headerArray = ObexHelper.createHeader(this.replyHeader, true);
        int bodyLength = -1;
        int orginalBodyLength = -1;
        if (this.mPrivateOutput != null) {
            orginalBodyLength = bodyLength = this.mPrivateOutput.size();
        }
        if (3 + headerArray.length > this.mMaxPacketLength) {
            int end = 0;
            int start = 0;
            while (end != headerArray.length) {
                end = ObexHelper.findHeaderEnd(headerArray, start, this.mMaxPacketLength - 3);
                if (end == -1) {
                    this.mClosed = true;
                    if (this.mPrivateInput != null) {
                        this.mPrivateInput.close();
                    }
                    if (this.mPrivateOutput != null) {
                        this.mPrivateOutput.close();
                    }
                    this.mParent.sendResponse(208, null);
                    throw new IOException("OBEX Packet exceeds max packet size");
                }
                byte[] sendHeader = new byte[end - start];
                System.arraycopy(headerArray, start, sendHeader, 0, sendHeader.length);
                this.mParent.sendResponse(type, sendHeader);
                start = end;
            }
            return bodyLength > 0;
        }
        out.write(headerArray);
        if (this.mGetOperation && type == 160) {
            this.finalBitSet = true;
        }
        if ((this.finalBitSet || headerArray.length < this.mMaxPacketLength - 20) && bodyLength > 0) {
            if (bodyLength > this.mMaxPacketLength - headerArray.length - 6) {
                bodyLength = this.mMaxPacketLength - headerArray.length - 6;
            }
            byte[] body = this.mPrivateOutput.readBytes(bodyLength);
            if (this.finalBitSet || this.mPrivateOutput.isClosed()) {
                if (this.mSendBodyHeader) {
                    out.write(73);
                    out.write((byte)((bodyLength += 3) >> 8));
                    out.write((byte)bodyLength);
                    out.write(body);
                }
            } else if (this.mSendBodyHeader) {
                out.write(72);
                out.write((byte)((bodyLength += 3) >> 8));
                out.write((byte)bodyLength);
                out.write(body);
            }
        }
        if (this.finalBitSet && type == 160 && orginalBodyLength <= 0 && this.mSendBodyHeader) {
            out.write(73);
            orginalBodyLength = 3;
            out.write((byte)(orginalBodyLength >> 8));
            out.write((byte)orginalBodyLength);
        }
        this.mResponseSize = 3;
        this.mParent.sendResponse(type, out.toByteArray());
        if (type == 144) {
            int headerID = this.mInput.read();
            int length = this.mInput.read();
            length = (length << 8) + this.mInput.read();
            if (headerID != 2 && headerID != 130 && headerID != 3 && headerID != 131) {
                if (length > 3) {
                    byte[] temp = new byte[length - 3];
                    for (int bytesReceived = this.mInput.read(temp); bytesReceived != temp.length; bytesReceived += this.mInput.read(temp, bytesReceived, temp.length - bytesReceived)) {
                    }
                }
                if (headerID == 255) {
                    this.mParent.sendResponse(160, null);
                    this.mClosed = true;
                    this.isAborted = true;
                    this.mExceptionString = "Abort Received";
                    throw new IOException("Abort Received");
                }
                this.mParent.sendResponse(192, null);
                this.mClosed = true;
                this.mExceptionString = "Bad Request Received";
                throw new IOException("Bad Request Received");
            }
            if (headerID == 130) {
                this.finalBitSet = true;
            } else if (headerID == 131) {
                this.mRequestFinished = true;
            }
            if (length > 65534) {
                this.mParent.sendResponse(206, null);
                throw new IOException("Packet received was too large");
            }
            if (length > 3) {
                byte[] data = new byte[length - 3];
                for (int bytesReceived = this.mInput.read(data); bytesReceived != data.length; bytesReceived += this.mInput.read(data, bytesReceived, data.length - bytesReceived)) {
                }
                byte[] body = ObexHelper.updateHeaderSet(this.requestHeader, data);
                if (body != null) {
                    this.mHasBody = true;
                }
                if (this.mListener.getConnectionId() != -1L && this.requestHeader.mConnectionID != null) {
                    this.mListener.setConnectionId(ObexHelper.convertToLong(this.requestHeader.mConnectionID));
                } else {
                    this.mListener.setConnectionId(1L);
                }
                if (this.requestHeader.mAuthResp != null) {
                    if (!this.mParent.handleAuthResp(this.requestHeader.mAuthResp)) {
                        this.mExceptionString = "Authentication Failed";
                        this.mParent.sendResponse(193, null);
                        this.mClosed = true;
                        this.requestHeader.mAuthResp = null;
                        return false;
                    }
                    this.requestHeader.mAuthResp = null;
                }
                if (this.requestHeader.mAuthChall != null) {
                    this.mParent.handleAuthChall(this.requestHeader);
                    this.replyHeader.mAuthResp = new byte[this.requestHeader.mAuthResp.length];
                    System.arraycopy(this.requestHeader.mAuthResp, 0, this.replyHeader.mAuthResp, 0, this.replyHeader.mAuthResp.length);
                    this.requestHeader.mAuthResp = null;
                    this.requestHeader.mAuthChall = null;
                }
                if (body != null) {
                    this.mPrivateInput.writeBytes(body, 1);
                }
            }
            return true;
        }
        return false;
    }

    public void abort() throws IOException {
        throw new IOException("Called from a server");
    }

    public HeaderSet getReceivedHeader() throws IOException {
        this.ensureOpen();
        return this.requestHeader;
    }

    public void sendHeaders(HeaderSet headers) throws IOException {
        this.ensureOpen();
        if (headers == null) {
            throw new IOException("Headers may not be null");
        }
        int[] headerList = headers.getHeaderList();
        if (headerList != null) {
            for (int i = 0; i < headerList.length; ++i) {
                this.replyHeader.setHeader(headerList[i], headers.getHeader(headerList[i]));
            }
        }
    }

    public int getResponseCode() throws IOException {
        throw new IOException("Called from a server");
    }

    public String getEncoding() {
        return null;
    }

    public String getType() {
        try {
            return (String)this.requestHeader.getHeader(66);
        }
        catch (IOException e) {
            return null;
        }
    }

    public long getLength() {
        try {
            Long temp = (Long)this.requestHeader.getHeader(195);
            if (temp == null) {
                return -1L;
            }
            return temp;
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public int getMaxPacketSize() {
        return this.mMaxPacketLength - 6 - this.getHeaderLength();
    }

    public int getHeaderLength() {
        long id2 = this.mListener.getConnectionId();
        this.replyHeader.mConnectionID = (byte[])(id2 == -1L ? null : ObexHelper.convertToByteArray(id2));
        byte[] headerArray = ObexHelper.createHeader(this.replyHeader, false);
        return headerArray.length;
    }

    public InputStream openInputStream() throws IOException {
        this.ensureOpen();
        return this.mPrivateInput;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        this.ensureOpen();
        if (this.mPrivateOutputOpen) {
            throw new IOException("no more input streams available, stream already opened");
        }
        if (!this.mRequestFinished) {
            throw new IOException("no  output streams available ,request not finished");
        }
        if (this.mPrivateOutput == null) {
            this.mPrivateOutput = new PrivateOutputStream(this, this.getMaxPacketSize());
        }
        this.mPrivateOutputOpen = true;
        return this.mPrivateOutput;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(this.openOutputStream());
    }

    public void close() throws IOException {
        this.ensureOpen();
        this.mClosed = true;
    }

    public void ensureOpen() throws IOException {
        if (this.mExceptionString != null) {
            throw new IOException(this.mExceptionString);
        }
        if (this.mClosed) {
            throw new IOException("Operation has already ended");
        }
    }

    public void ensureNotDone() throws IOException {
    }

    public void streamClosed(boolean inStream) throws IOException {
    }

    public void noBodyHeader() {
        this.mSendBodyHeader = false;
    }
}

