/*
 * Decompiled with CFR 0.152.
 */
package libcore.net.url;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import libcore.net.UriCodec;

public class JarURLConnectionImpl
extends JarURLConnection {
    private static final HashMap<URL, JarFile> jarCache = new HashMap();
    private URL jarFileURL = this.getJarFileURL();
    private InputStream jarInput;
    private JarFile jarFile;
    private JarEntry jarEntry;
    private boolean closed;

    public JarURLConnectionImpl(URL url) throws MalformedURLException, IOException {
        super(url);
        this.jarFileURLConnection = this.jarFileURL.openConnection();
    }

    public void connect() throws IOException {
        if (!this.connected) {
            this.findJarFile();
            this.findJarEntry();
            this.connected = true;
        }
    }

    public JarFile getJarFile() throws IOException {
        this.connect();
        return this.jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findJarFile() throws IOException {
        if (this.getUseCaches()) {
            HashMap<URL, JarFile> hashMap = jarCache;
            synchronized (hashMap) {
                this.jarFile = jarCache.get(this.jarFileURL);
            }
            if (this.jarFile == null) {
                JarFile jar = this.openJarFile();
                HashMap<URL, JarFile> hashMap2 = jarCache;
                synchronized (hashMap2) {
                    this.jarFile = jarCache.get(this.jarFileURL);
                    if (this.jarFile == null) {
                        jarCache.put(this.jarFileURL, jar);
                        this.jarFile = jar;
                    } else {
                        jar.close();
                    }
                }
            }
        } else {
            this.jarFile = this.openJarFile();
        }
        if (this.jarFile == null) {
            throw new IOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JarFile openJarFile() throws IOException {
        if (this.jarFileURL.getProtocol().equals("file")) {
            decodedFile = UriCodec.decode(this.jarFileURL.getFile());
            return new JarFile(new File(decodedFile), true, 1);
        }
        is = this.jarFileURL.openConnection().getInputStream();
        try {
            fos = null;
            result = null;
            try {
                tempJar = File.createTempFile("hyjar_", ".tmp", null);
                tempJar.deleteOnExit();
                fos = new FileOutputStream(tempJar);
                buf = new byte[4096];
                nbytes = 0;
                while ((nbytes = is.read(buf)) > -1) {
                    fos.write(buf, 0, nbytes);
                }
                fos.close();
                var7_10 = new JarFile(tempJar, true, 5);
                var9_11 = null;
                if (fos == null) ** GOTO lbl70
                ** GOTO lbl-1000
            }
            catch (IOException e) {
                block15: {
                    block14: {
                        try {
                            var5_8 = null;
                            var9_12 = null;
                            if (fos != null) {
                            }
                            break block14;
                        }
                        catch (Throwable var8_26) {
                            var9_13 = null;
                            if (fos == null) throw var8_26;
                            try {
                                fos.close();
                                throw var8_26;
                            }
                            catch (IOException ex) {
                                var11_19 = null;
                                var13_24 = null;
                                if (is == null) return var11_19;
                                is.close();
                                return var11_19;
                            }
                        }
lbl-1000:
                        // 1 sources

                        try {}
                        catch (IOException ex) {
                            var11_17 = null;
                            var13_20 = null;
                            if (is == null) return var11_17;
                            is.close();
                            return var11_17;
                        }
                        fos.close();
                        break block15;
                        try {}
                        catch (IOException ex) {
                            var11_18 = null;
                            var13_22 = null;
                            if (is == null) return var11_18;
                            is.close();
                            return var11_18;
                        }
                        fos.close();
                    }
                    var13_23 = null;
                    if (is == null) return var5_8;
                    is.close();
                    return var5_8;
                }
                var13_21 = null;
                if (is == null) return var7_10;
            }
        }
        catch (Throwable var12_27) {
            var13_25 = null;
            if (is == null) throw var12_27;
            is.close();
            throw var12_27;
        }
        is.close();
        return var7_10;
    }

    public JarEntry getJarEntry() throws IOException {
        this.connect();
        return this.jarEntry;
    }

    private void findJarEntry() throws IOException {
        if (this.getEntryName() == null) {
            return;
        }
        this.jarEntry = this.jarFile.getJarEntry(this.getEntryName());
        if (this.jarEntry == null) {
            throw new FileNotFoundException(this.getEntryName());
        }
    }

    public InputStream getInputStream() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("JarURLConnection InputStream has been closed");
        }
        this.connect();
        if (this.jarInput != null) {
            return this.jarInput;
        }
        if (this.jarEntry == null) {
            throw new IOException("Jar entry not specified");
        }
        this.jarInput = new JarURLConnectionInputStream(this.jarFile.getInputStream(this.jarEntry), this.jarFile);
        return this.jarInput;
    }

    public String getContentType() {
        if (this.url.getFile().endsWith("!/")) {
            return "x-java/jar";
        }
        String cType = null;
        String entryName = this.getEntryName();
        if (entryName != null) {
            cType = JarURLConnectionImpl.guessContentTypeFromName(entryName);
        } else {
            try {
                this.connect();
                cType = this.jarFileURLConnection.getContentType();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (cType == null) {
            cType = "content/unknown";
        }
        return cType;
    }

    public int getContentLength() {
        try {
            this.connect();
            if (this.jarEntry == null) {
                return this.jarFileURLConnection.getContentLength();
            }
            return (int)this.getJarEntry().getSize();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public Object getContent() throws IOException {
        this.connect();
        if (this.jarEntry == null) {
            return this.jarFile;
        }
        return super.getContent();
    }

    public Permission getPermission() throws IOException {
        return this.jarFileURLConnection.getPermission();
    }

    public boolean getUseCaches() {
        return this.jarFileURLConnection.getUseCaches();
    }

    public void setUseCaches(boolean usecaches) {
        this.jarFileURLConnection.setUseCaches(usecaches);
    }

    public boolean getDefaultUseCaches() {
        return this.jarFileURLConnection.getDefaultUseCaches();
    }

    public void setDefaultUseCaches(boolean defaultusecaches) {
        this.jarFileURLConnection.setDefaultUseCaches(defaultusecaches);
    }

    private class JarURLConnectionInputStream
    extends FilterInputStream {
        final JarFile jarFile;

        protected JarURLConnectionInputStream(InputStream in, JarFile file) {
            super(in);
            this.jarFile = file;
        }

        public void close() throws IOException {
            super.close();
            if (!JarURLConnectionImpl.this.getUseCaches()) {
                JarURLConnectionImpl.this.closed = true;
                this.jarFile.close();
            }
        }
    }
}

