/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.security.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.apache.harmony.security.asn1.ASN1OctetString;
import org.apache.harmony.security.asn1.BerInputStream;
import org.apache.harmony.security.pkcs7.ContentInfo;
import org.apache.harmony.security.pkcs7.SignedData;
import org.apache.harmony.security.pkcs7.SignerInfo;
import org.apache.harmony.security.x501.AttributeTypeAndValue;

public class JarUtils {
    private static final int[] MESSAGE_DIGEST_OID = new int[]{1, 2, 840, 113549, 1, 9, 4};

    public static Certificate[] verifySignature(InputStream signature, InputStream signatureBlock) throws IOException, GeneralSecurityException {
        String deaName;
        BerInputStream bis = new BerInputStream(signatureBlock);
        ContentInfo info = (ContentInfo)ContentInfo.ASN1.decode(bis);
        SignedData signedData = info.getSignedData();
        if (signedData == null) {
            throw new IOException("No SignedData found");
        }
        List<org.apache.harmony.security.x509.Certificate> encCerts = signedData.getCertificates();
        if (encCerts.isEmpty()) {
            return null;
        }
        X509Certificate[] certs = new X509Certificate[encCerts.size()];
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        int i = 0;
        for (org.apache.harmony.security.x509.Certificate encCert : encCerts) {
            ByteArrayInputStream is = new ByteArrayInputStream(encCert.getEncoded());
            certs[i++] = (X509Certificate)cf.generateCertificate(is);
        }
        List<SignerInfo> sigInfos = signedData.getSignerInfos();
        if (sigInfos.isEmpty()) {
            return null;
        }
        SignerInfo sigInfo = sigInfos.get(0);
        X500Principal issuer = sigInfo.getIssuer();
        BigInteger snum = sigInfo.getSerialNumber();
        int issuerSertIndex = 0;
        for (i = 0; i < certs.length; ++i) {
            if (!issuer.equals(certs[i].getIssuerDN()) || !snum.equals(certs[i].getSerialNumber())) continue;
            issuerSertIndex = i;
            break;
        }
        if (i == certs.length) {
            return null;
        }
        if (certs[issuerSertIndex].hasUnsupportedCriticalExtension()) {
            throw new SecurityException("Can not recognize a critical extension");
        }
        String daOid = sigInfo.getDigestAlgorithm();
        String daName = sigInfo.getDigestAlgorithmName();
        String deaOid = sigInfo.getDigestEncryptionAlgorithm();
        String alg = null;
        Signature sig = null;
        if (deaOid != null) {
            alg = deaOid;
            try {
                sig = Signature.getInstance(alg);
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
            deaName = sigInfo.getDigestEncryptionAlgorithmName();
            if (sig == null && deaName != null) {
                alg = deaName;
                try {
                    sig = Signature.getInstance(alg);
                }
                catch (NoSuchAlgorithmException e) {
                    // empty catch block
                }
            }
        }
        if (sig == null && daOid != null && deaOid != null) {
            alg = daOid + "with" + deaOid;
            try {
                sig = Signature.getInstance(alg);
            }
            catch (NoSuchAlgorithmException e) {
                // empty catch block
            }
            if (sig == null) {
                deaName = sigInfo.getDigestEncryptionAlgorithmName();
                alg = daName + "with" + deaName;
                try {
                    sig = Signature.getInstance(alg);
                }
                catch (NoSuchAlgorithmException e) {
                    // empty catch block
                }
            }
        }
        if (sig == null) {
            return null;
        }
        sig.initVerify(certs[issuerSertIndex]);
        List<AttributeTypeAndValue> atr = sigInfo.getAuthenticatedAttributes();
        byte[] sfBytes = new byte[signature.available()];
        signature.read(sfBytes);
        if (atr == null) {
            sig.update(sfBytes);
        } else {
            sig.update(sigInfo.getEncodedAuthenticatedAttributes());
            byte[] existingDigest = null;
            for (AttributeTypeAndValue a : atr) {
                if (!Arrays.equals(a.getType().getOid(), MESSAGE_DIGEST_OID)) continue;
                if (existingDigest != null) {
                    throw new SecurityException("Too many MessageDigest attributes");
                }
                Collection<?> entries = a.getValue().getValues(ASN1OctetString.getInstance());
                if (entries.size() != 1) {
                    throw new SecurityException("Too many values for MessageDigest attribute");
                }
                existingDigest = (byte[])entries.iterator().next();
            }
            if (existingDigest == null) {
                throw new SecurityException("Missing MessageDigest in Authenticated Attributes");
            }
            MessageDigest md = null;
            if (daOid != null) {
                md = MessageDigest.getInstance(daOid);
            }
            if (md == null && daName != null) {
                md = MessageDigest.getInstance(daName);
            }
            if (md == null) {
                return null;
            }
            byte[] computedDigest = md.digest(sfBytes);
            if (!Arrays.equals(existingDigest, computedDigest)) {
                throw new SecurityException("Incorrect MD");
            }
        }
        if (!sig.verify(sigInfo.getEncryptedDigest())) {
            throw new SecurityException("Incorrect signature");
        }
        return JarUtils.createChain(certs[issuerSertIndex], certs);
    }

    private static X509Certificate[] createChain(X509Certificate signer, X509Certificate[] candidates) {
        X509Certificate issuerCert;
        Principal issuer = signer.getIssuerDN();
        if (((Object)signer.getSubjectDN()).equals(issuer)) {
            return new X509Certificate[]{signer};
        }
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>(candidates.length + 1);
        chain.add(0, signer);
        int count = 1;
        while ((issuerCert = JarUtils.findCert(issuer, candidates)) != null) {
            chain.add(issuerCert);
            ++count;
            issuer = issuerCert.getIssuerDN();
            if (!((Object)issuerCert.getSubjectDN()).equals(issuer)) continue;
            break;
        }
        return chain.toArray(new X509Certificate[count]);
    }

    private static X509Certificate findCert(Principal issuer, X509Certificate[] candidates) {
        for (int i = 0; i < candidates.length; ++i) {
            if (!((Object)issuer).equals(candidates[i].getSubjectDN())) continue;
            return candidates[i];
        }
        return null;
    }
}

