/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.extensions;

class ObjectFactory {
    ObjectFactory() {
    }

    static ClassLoader findClassLoader() throws ConfigurationError {
        return Thread.currentThread().getContextClassLoader();
    }

    static Class findProviderClass(String className, ClassLoader cl, boolean doFallback) throws ClassNotFoundException, ConfigurationError {
        Class<?> providerClass;
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            int lastDot = className.lastIndexOf(".");
            String packageName = className;
            if (lastDot != -1) {
                packageName = className.substring(0, lastDot);
            }
            security.checkPackageAccess(packageName);
        }
        if (cl == null) {
            providerClass = Class.forName(className);
        } else {
            try {
                providerClass = cl.loadClass(className);
            }
            catch (ClassNotFoundException x) {
                if (doFallback) {
                    ClassLoader current = ObjectFactory.class.getClassLoader();
                    if (current == null) {
                        providerClass = Class.forName(className);
                    }
                    if (cl != current) {
                        cl = current;
                        providerClass = cl.loadClass(className);
                    }
                    throw x;
                }
                throw x;
            }
        }
        return providerClass;
    }

    static class ConfigurationError
    extends Error {
        static final long serialVersionUID = 8564305128443551853L;
        private Exception exception;

        ConfigurationError(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

