/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.WNafUtil;

public class ECAlgorithms {
    public static ECPoint sumOfTwoMultiplies(ECPoint P, BigInteger a, ECPoint Q, BigInteger b) {
        ECCurve.F2m f2mCurve;
        ECCurve cp = P.getCurve();
        Q = ECAlgorithms.importPoint(cp, Q);
        if (cp instanceof ECCurve.F2m && (f2mCurve = (ECCurve.F2m)cp).isKoblitz()) {
            return P.multiply(a).add(Q.multiply(b));
        }
        return ECAlgorithms.implShamirsTrick(P, a, Q, b);
    }

    public static ECPoint shamirsTrick(ECPoint P, BigInteger k, ECPoint Q, BigInteger l) {
        ECCurve cp = P.getCurve();
        Q = ECAlgorithms.importPoint(cp, Q);
        return ECAlgorithms.implShamirsTrick(P, k, Q, l);
    }

    public static ECPoint importPoint(ECCurve c, ECPoint p) {
        ECCurve cp = p.getCurve();
        if (!c.equals(cp)) {
            throw new IllegalArgumentException("Point must be on the same curve");
        }
        return c.importPoint(p);
    }

    static void implMontgomeryTrick(ECFieldElement[] zs, int off, int len) {
        ECFieldElement[] c = new ECFieldElement[len];
        c[0] = zs[off];
        int i = 0;
        while (++i < len) {
            c[i] = c[i - 1].multiply(zs[off + i]);
        }
        ECFieldElement u = c[--i].invert();
        while (i > 0) {
            int j = off + i--;
            ECFieldElement tmp = zs[j];
            zs[j] = c[i].multiply(u);
            u = u.multiply(tmp);
        }
        zs[off] = u;
    }

    static ECPoint implShamirsTrick(ECPoint P, BigInteger k, ECPoint Q, BigInteger l) {
        ECCurve curve = P.getCurve();
        ECPoint infinity = curve.getInfinity();
        ECPoint PaddQ = P.add(Q);
        ECPoint PsubQ = P.subtract(Q);
        ECPoint[] points = new ECPoint[]{Q, PsubQ, P, PaddQ};
        curve.normalizeAll(points);
        ECPoint[] table = new ECPoint[]{points[3].negate(), points[2].negate(), points[1].negate(), points[0].negate(), infinity, points[0], points[1], points[2], points[3]};
        byte[] jsf = WNafUtil.generateJSF(k, l);
        ECPoint R2 = infinity;
        int i = jsf.length;
        while (--i >= 0) {
            byte jsfi = jsf[i];
            int kDigit = jsfi >> 4;
            int lDigit = jsfi << 28 >> 28;
            int index = 4 + kDigit * 3 + lDigit;
            R2 = R2.twicePlus(table[index]);
        }
        return R2;
    }
}

