/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.view.ViewGroup;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.ui.autofill.AutofillPopup;
import org.chromium.ui.autofill.AutofillSuggestion;

@JNINamespace(value="android_webview")
public class AwAutofillManagerDelegate {
    private final int mNativeAwAutofillManagerDelegate;
    private AutofillPopup mAutofillPopup;
    private ViewGroup mContainerView;
    private ContentViewCore mContentViewCore;

    @CalledByNative
    public static AwAutofillManagerDelegate create(int nativeDelegate) {
        return new AwAutofillManagerDelegate(nativeDelegate);
    }

    private AwAutofillManagerDelegate(int nativeAwAutofillManagerDelegate) {
        this.mNativeAwAutofillManagerDelegate = nativeAwAutofillManagerDelegate;
    }

    public void init(ContentViewCore contentViewCore) {
        this.mContentViewCore = contentViewCore;
        this.mContainerView = contentViewCore.getContainerView();
    }

    @CalledByNative
    private void showAutofillPopup(float x, float y, float width, float height, AutofillSuggestion[] suggestions) {
        if (this.mContentViewCore == null) {
            return;
        }
        if (this.mAutofillPopup == null) {
            this.mAutofillPopup = new AutofillPopup(this.mContentViewCore.getContext(), this.mContentViewCore.getViewAndroidDelegate(), new AutofillPopup.AutofillPopupDelegate(){

                public void requestHide() {
                }

                public void suggestionSelected(int listIndex) {
                    AwAutofillManagerDelegate.this.nativeSuggestionSelected(AwAutofillManagerDelegate.this.mNativeAwAutofillManagerDelegate, listIndex);
                }
            });
        }
        this.mAutofillPopup.setAnchorRect(x, y, width, height);
        this.mAutofillPopup.show(suggestions);
    }

    @CalledByNative
    public void hideAutofillPopup() {
        if (this.mAutofillPopup == null) {
            return;
        }
        this.mAutofillPopup.hide();
        this.mAutofillPopup = null;
    }

    @CalledByNative
    private static AutofillSuggestion[] createAutofillSuggestionArray(int size) {
        return new AutofillSuggestion[size];
    }

    @CalledByNative
    private static void addToAutofillSuggestionArray(AutofillSuggestion[] array2, int index, String name, String label, int uniqueId) {
        array2[index] = new AutofillSuggestion(name, label, uniqueId);
    }

    private native void nativeSuggestionSelected(int var1, int var2);
}

