/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.app.Activity;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.Rect;
import android.net.http.SslCertificate;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.webkit.GeolocationPermissions;
import android.webkit.ValueCallback;
import android.widget.OverScroller;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.chromium.android_webview.AwAutofillManagerDelegate;
import org.chromium.android_webview.AwBrowserContext;
import org.chromium.android_webview.AwContentsClient;
import org.chromium.android_webview.AwContentsClientBridge;
import org.chromium.android_webview.AwContentsIoThreadClient;
import org.chromium.android_webview.AwGeolocationPermissions;
import org.chromium.android_webview.AwHttpAuthHandler;
import org.chromium.android_webview.AwLayoutSizer;
import org.chromium.android_webview.AwPdfExporter;
import org.chromium.android_webview.AwPicture;
import org.chromium.android_webview.AwScrollOffsetManager;
import org.chromium.android_webview.AwSettings;
import org.chromium.android_webview.AwWebContentsDelegate;
import org.chromium.android_webview.AwWebContentsDelegateAdapter;
import org.chromium.android_webview.AwZoomControls;
import org.chromium.android_webview.DefaultVideoPosterRequestHandler;
import org.chromium.android_webview.InterceptedRequestData;
import org.chromium.android_webview.OverScrollGlow;
import org.chromium.android_webview.ScrollAccessibilityHelper;
import org.chromium.android_webview.SslUtil;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.components.navigation_interception.InterceptNavigationDelegate;
import org.chromium.components.navigation_interception.NavigationParams;
import org.chromium.content.browser.ContentSettings;
import org.chromium.content.browser.ContentViewClient;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.ContentViewStatics;
import org.chromium.content.browser.LoadUrlParams;
import org.chromium.content.browser.NavigationHistory;
import org.chromium.content.common.CleanupReference;
import org.chromium.ui.ActivityWindowAndroid;
import org.chromium.ui.WindowAndroid;
import org.chromium.ui.gfx.DeviceDisplayInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="android_webview")
public class AwContents {
    private static final String TAG = "AwContents";
    private static final String WEB_ARCHIVE_EXTENSION = ".mht";
    private static final float ZOOM_CONTROLS_EPSILON = 0.007f;
    private int mNativeAwContents;
    private final AwBrowserContext mBrowserContext;
    private final ViewGroup mContainerView;
    private ContentViewCore mContentViewCore;
    private final AwContentsClient mContentsClient;
    private final AwContentsClientBridge mContentsClientBridge;
    private final AwWebContentsDelegate mWebContentsDelegate;
    private final AwContentsIoThreadClient mIoThreadClient;
    private final InterceptNavigationDelegateImpl mInterceptNavigationDelegate;
    private final InternalAccessDelegate mInternalAccessAdapter;
    private final AwLayoutSizer mLayoutSizer;
    private final AwZoomControls mZoomControls;
    private final AwScrollOffsetManager mScrollOffsetManager;
    private OverScrollGlow mOverScrollGlow;
    private final AwSettings mSettings;
    private final ScrollAccessibilityHelper mScrollAccessibilityHelper;
    private boolean mIsPaused;
    private boolean mIsViewVisible;
    private boolean mIsWindowVisible;
    private boolean mIsAttachedToWindow;
    private Bitmap mFavicon;
    private boolean mHasRequestedVisitedHistoryFromClient;
    private final double mDIPScale;
    private int mBaseBackgroundColor = -1;
    private final HitTestData mPossiblyStaleHitTestData = new HitTestData();
    private DefaultVideoPosterRequestHandler mDefaultVideoPosterRequestHandler;
    private Callable<Picture> mPictureListenerContentProvider;
    private boolean mContainerViewFocused;
    private boolean mWindowFocused;
    private boolean mClearViewActive;
    private boolean mPictureListenerEnabled;
    private float mPageScaleFactor = 1.0f;
    private float mContentWidthDip;
    private float mContentHeightDip;
    private AwAutofillManagerDelegate mAwAutofillManagerDelegate;
    private ComponentCallbacks2 mComponentCallbacks;
    private boolean mDeferredShouldOverrideUrlLoadingIsPendingForPopup;
    private CleanupReference mCleanupReference;
    private List<CleanupReference> mPendingDetachCleanupReferences;
    private AwPdfExporter mAwPdfExporter;
    private static final Rect sLocalGlobalVisibleRect = new Rect();
    private final Rect mClipBoundsTemporary = new Rect();
    private boolean mOverlayHorizontalScrollbar = true;
    private boolean mOverlayVerticalScrollbar = false;
    public static final String SAVE_RESTORE_STATE_KEY = "WEBVIEW_CHROMIUM_STATE";
    private static final boolean SUPPORTS_ON_ANIMATION = Build.VERSION.SDK_INT >= 16;

    public AwContents(AwBrowserContext browserContext, ViewGroup containerView, InternalAccessDelegate internalAccessAdapter, AwContentsClient contentsClient, boolean isAccessFromFileURLsGrantedByDefault) {
        this(browserContext, containerView, internalAccessAdapter, contentsClient, isAccessFromFileURLsGrantedByDefault, new AwLayoutSizer());
    }

    public AwContents(AwBrowserContext browserContext, ViewGroup containerView, InternalAccessDelegate internalAccessAdapter, AwContentsClient contentsClient, boolean isAccessFromFileURLsGrantedByDefault, AwLayoutSizer layoutSizer) {
        this(browserContext, containerView, internalAccessAdapter, contentsClient, isAccessFromFileURLsGrantedByDefault, layoutSizer, false);
    }

    private static ContentViewCore createAndInitializeContentViewCore(ViewGroup containerView, InternalAccessDelegate internalDispatcher, int nativeWebContents, ContentViewCore.GestureStateListener pinchGestureStateListener, ContentViewClient contentViewClient, ContentViewCore.ZoomControlsDelegate zoomControlsDelegate) {
        Context context = containerView.getContext();
        ContentViewCore contentViewCore = new ContentViewCore(context);
        contentViewCore.initialize(containerView, internalDispatcher, nativeWebContents, context instanceof Activity ? new ActivityWindowAndroid((Activity)context) : new WindowAndroid(context), 0);
        contentViewCore.setGestureStateListener(pinchGestureStateListener);
        contentViewCore.setContentViewClient(contentViewClient);
        contentViewCore.setZoomControlsDelegate(zoomControlsDelegate);
        return contentViewCore;
    }

    public AwContents(AwBrowserContext browserContext, ViewGroup containerView, InternalAccessDelegate internalAccessAdapter, AwContentsClient contentsClient, boolean isAccessFromFileURLsGrantedByDefault, AwLayoutSizer layoutSizer, boolean supportsLegacyQuirks) {
        this(browserContext, containerView, internalAccessAdapter, contentsClient, layoutSizer, new AwSettings(containerView.getContext(), isAccessFromFileURLsGrantedByDefault, supportsLegacyQuirks));
    }

    public AwContents(AwBrowserContext browserContext, ViewGroup containerView, InternalAccessDelegate internalAccessAdapter, AwContentsClient contentsClient, AwLayoutSizer layoutSizer, AwSettings settings) {
        this.mBrowserContext = browserContext;
        this.mContainerView = containerView;
        this.mInternalAccessAdapter = internalAccessAdapter;
        this.mContentsClient = contentsClient;
        this.mLayoutSizer = layoutSizer;
        this.mSettings = settings;
        this.mDIPScale = DeviceDisplayInfo.create(this.mContainerView.getContext()).getDIPScale();
        this.mLayoutSizer.setDelegate(new AwLayoutSizerDelegate());
        this.mLayoutSizer.setDIPScale(this.mDIPScale);
        this.mWebContentsDelegate = new AwWebContentsDelegateAdapter(contentsClient, this.mContainerView);
        this.mContentsClientBridge = new AwContentsClientBridge(contentsClient);
        this.mZoomControls = new AwZoomControls(this);
        this.mIoThreadClient = new IoThreadClientImpl();
        this.mInterceptNavigationDelegate = new InterceptNavigationDelegateImpl();
        AwSettings.ZoomSupportChangeListener zoomListener = new AwSettings.ZoomSupportChangeListener(){

            public void onGestureZoomSupportChanged(boolean supportsGestureZoom) {
                AwContents.this.mContentViewCore.updateMultiTouchZoomSupport(supportsGestureZoom);
                AwContents.this.mContentViewCore.updateDoubleTapDragSupport(supportsGestureZoom);
            }
        };
        this.mSettings.setZoomListener(zoomListener);
        this.mDefaultVideoPosterRequestHandler = new DefaultVideoPosterRequestHandler(this.mContentsClient);
        this.mSettings.setDefaultVideoPosterURL(this.mDefaultVideoPosterRequestHandler.getDefaultVideoPosterURL());
        this.mSettings.setDIPScale(this.mDIPScale);
        this.mScrollOffsetManager = new AwScrollOffsetManager(new AwScrollOffsetManagerDelegate(), new OverScroller(this.mContainerView.getContext()));
        this.mScrollAccessibilityHelper = new ScrollAccessibilityHelper(this.mContainerView);
        this.setOverScrollMode(this.mContainerView.getOverScrollMode());
        this.setScrollBarStyle(this.mInternalAccessAdapter.super_getScrollBarStyle());
        this.mContainerView.addOnLayoutChangeListener(new AwLayoutChangeListener());
        this.setNewAwContents(AwContents.nativeInit(this.mBrowserContext));
        this.onVisibilityChanged(this.mContainerView, this.mContainerView.getVisibility());
        this.onWindowVisibilityChanged(this.mContainerView.getWindowVisibility());
    }

    private void setNewAwContents(int newAwContentsPtr) {
        if (this.mNativeAwContents != 0) {
            this.destroy();
            this.mContentViewCore = null;
        }
        assert (this.mNativeAwContents == 0 && this.mCleanupReference == null && this.mContentViewCore == null);
        this.mNativeAwContents = newAwContentsPtr;
        this.mCleanupReference = new CleanupReference(this, new DestroyRunnable(this.mNativeAwContents));
        int nativeWebContents = this.nativeGetWebContents(this.mNativeAwContents);
        this.mContentViewCore = AwContents.createAndInitializeContentViewCore(this.mContainerView, this.mInternalAccessAdapter, nativeWebContents, new AwGestureStateListener(), this.mContentsClient.getContentViewClient(), this.mZoomControls);
        this.nativeSetJavaPeers(this.mNativeAwContents, this, this.mWebContentsDelegate, this.mContentsClientBridge, this.mIoThreadClient, this.mInterceptNavigationDelegate);
        this.mContentsClient.installWebContentsObserver(this.mContentViewCore, this.mSettings);
        this.mSettings.setWebContents(nativeWebContents);
        this.nativeSetDipScale(this.mNativeAwContents, (float)this.mDIPScale);
        this.updateGlobalVisibleRect();
        this.mContentViewCore.onShow();
    }

    public void supplyContentsForPopup(AwContents newContents) {
        int popupNativeAwContents = this.nativeReleasePopupAwContents(this.mNativeAwContents);
        if (popupNativeAwContents == 0) {
            Log.w(TAG, "Popup WebView bind failed: no pending content.");
            if (newContents != null) {
                newContents.destroy();
            }
            return;
        }
        if (newContents == null) {
            AwContents.nativeDestroy(popupNativeAwContents);
            return;
        }
        newContents.receivePopupContents(popupNativeAwContents);
    }

    private void receivePopupContents(int popupNativeAwContents) {
        this.mDeferredShouldOverrideUrlLoadingIsPendingForPopup = true;
        boolean wasAttached = this.mIsAttachedToWindow;
        boolean wasViewVisible = this.mIsViewVisible;
        boolean wasWindowVisible = this.mIsWindowVisible;
        boolean wasPaused = this.mIsPaused;
        boolean wasFocused = this.mContainerViewFocused;
        boolean wasWindowFocused = this.mWindowFocused;
        if (wasFocused) {
            this.onFocusChanged(false, 0, null);
        }
        if (wasWindowFocused) {
            this.onWindowFocusChanged(false);
        }
        if (wasViewVisible) {
            this.setViewVisibilityInternal(false);
        }
        if (wasWindowVisible) {
            this.setWindowVisibilityInternal(false);
        }
        if (!wasPaused) {
            this.onPause();
        }
        this.setNewAwContents(popupNativeAwContents);
        if (!wasPaused) {
            this.onResume();
        }
        if (wasAttached) {
            this.onAttachedToWindow();
        }
        this.onSizeChanged(this.mContainerView.getWidth(), this.mContainerView.getHeight(), 0, 0);
        if (wasWindowVisible) {
            this.setWindowVisibilityInternal(true);
        }
        if (wasViewVisible) {
            this.setViewVisibilityInternal(true);
        }
        if (wasWindowFocused) {
            this.onWindowFocusChanged(wasWindowFocused);
        }
        if (wasFocused) {
            this.onFocusChanged(true, 0, null);
        }
    }

    public void destroy() {
        if (this.mCleanupReference != null) {
            this.mContentViewCore.destroy();
            this.mNativeAwContents = 0;
            if (this.mIsAttachedToWindow) {
                if (this.mPendingDetachCleanupReferences == null) {
                    this.mPendingDetachCleanupReferences = new ArrayList<CleanupReference>();
                }
                this.mPendingDetachCleanupReferences.add(this.mCleanupReference);
            } else {
                this.mCleanupReference.cleanupNow();
            }
            this.mCleanupReference = null;
        }
        assert (!this.mContentViewCore.isAlive());
        assert (this.mNativeAwContents == 0);
    }

    @VisibleForTesting
    public ContentViewCore getContentViewCore() {
        return this.mContentViewCore;
    }

    public AwSettings getSettings() {
        return this.mSettings;
    }

    public AwPdfExporter getPdfExporter() {
        if (this.mNativeAwContents == 0) {
            return null;
        }
        if (this.mAwPdfExporter == null) {
            this.mAwPdfExporter = new AwPdfExporter(this.mContainerView);
            this.nativeCreatePdfExporter(this.mNativeAwContents, this.mAwPdfExporter);
        }
        return this.mAwPdfExporter;
    }

    private native void nativeCreatePdfExporter(int var1, AwPdfExporter var2);

    public static void setAwDrawSWFunctionTable(int functionTablePointer) {
        AwContents.nativeSetAwDrawSWFunctionTable(functionTablePointer);
    }

    public static void setAwDrawGLFunctionTable(int functionTablePointer) {
        AwContents.nativeSetAwDrawGLFunctionTable(functionTablePointer);
    }

    public static int getAwDrawGLFunction() {
        return AwContents.nativeGetAwDrawGLFunction();
    }

    public static void setShouldDownloadFavicons() {
        AwContents.nativeSetShouldDownloadFavicons();
    }

    @VisibleForTesting
    public static int getNativeInstanceCount() {
        return AwContents.nativeGetNativeInstanceCount();
    }

    public int getAwDrawGLViewContext() {
        assert (this.mNativeAwContents != 0);
        return this.nativeGetAwDrawGLViewContext(this.mNativeAwContents);
    }

    @CalledByNative
    private void updateGlobalVisibleRect() {
        if (this.mNativeAwContents == 0) {
            return;
        }
        if (!this.mContainerView.getGlobalVisibleRect(sLocalGlobalVisibleRect)) {
            sLocalGlobalVisibleRect.setEmpty();
        }
        this.nativeSetGlobalVisibleRect(this.mNativeAwContents, AwContents.sLocalGlobalVisibleRect.left, AwContents.sLocalGlobalVisibleRect.top, AwContents.sLocalGlobalVisibleRect.right, AwContents.sLocalGlobalVisibleRect.bottom);
    }

    public void onDraw(Canvas canvas) {
        if (this.mNativeAwContents == 0) {
            canvas.drawColor(this.getEffectiveBackgroundColor());
            return;
        }
        this.mScrollOffsetManager.syncScrollOffsetFromOnDraw();
        canvas.getClipBounds(this.mClipBoundsTemporary);
        if (this.mClearViewActive) {
            canvas.drawColor(this.getEffectiveBackgroundColor());
        } else if (!this.nativeOnDraw(this.mNativeAwContents, canvas, canvas.isHardwareAccelerated(), this.mContainerView.getScrollX(), this.mContainerView.getScrollY(), this.mClipBoundsTemporary.left, this.mClipBoundsTemporary.top, this.mClipBoundsTemporary.right, this.mClipBoundsTemporary.bottom)) {
            Log.w(TAG, "nativeOnDraw failed; clearing to background color.");
            canvas.drawColor(this.getEffectiveBackgroundColor());
        }
        if (this.mOverScrollGlow != null && this.mOverScrollGlow.drawEdgeGlows(canvas, this.mScrollOffsetManager.computeMaximumHorizontalScrollOffset(), this.mScrollOffsetManager.computeMaximumVerticalScrollOffset())) {
            this.mContainerView.invalidate();
        }
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.mLayoutSizer.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public int getContentHeightCss() {
        return (int)Math.ceil(this.mContentHeightDip);
    }

    public int getContentWidthCss() {
        return (int)Math.ceil(this.mContentWidthDip);
    }

    public Picture capturePicture() {
        if (this.mNativeAwContents == 0) {
            return null;
        }
        return new AwPicture(this.nativeCapturePicture(this.mNativeAwContents, this.mScrollOffsetManager.computeHorizontalScrollRange(), this.mScrollOffsetManager.computeVerticalScrollRange()));
    }

    public void clearView() {
        this.mClearViewActive = true;
        this.syncOnNewPictureStateToNative();
        this.mContainerView.invalidate();
    }

    public void enableOnNewPicture(boolean enabled, boolean invalidationOnly) {
        if (this.mNativeAwContents == 0) {
            return;
        }
        if (invalidationOnly) {
            this.mPictureListenerContentProvider = null;
        } else if (enabled && this.mPictureListenerContentProvider == null) {
            this.mPictureListenerContentProvider = new Callable<Picture>(){

                @Override
                public Picture call() {
                    return AwContents.this.capturePicture();
                }
            };
        }
        this.mPictureListenerEnabled = enabled;
        this.syncOnNewPictureStateToNative();
    }

    private void syncOnNewPictureStateToNative() {
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.nativeEnableOnNewPicture(this.mNativeAwContents, this.mPictureListenerEnabled || this.mClearViewActive);
    }

    public void findAllAsync(String searchString) {
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.nativeFindAllAsync(this.mNativeAwContents, searchString);
    }

    public void findNext(boolean forward) {
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.nativeFindNext(this.mNativeAwContents, forward);
    }

    public void clearMatches() {
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.nativeClearMatches(this.mNativeAwContents);
    }

    public int getMostRecentProgress() {
        return this.mWebContentsDelegate.getMostRecentProgress();
    }

    public Bitmap getFavicon() {
        return this.mFavicon;
    }

    private void requestVisitedHistoryFromClient() {
        ValueCallback<String[]> callback = new ValueCallback<String[]>(){

            @Override
            public void onReceiveValue(final String[] value) {
                ThreadUtils.runOnUiThread(new Runnable(){

                    public void run() {
                        if (AwContents.this.mNativeAwContents == 0) {
                            return;
                        }
                        AwContents.this.nativeAddVisitedLinks(AwContents.this.mNativeAwContents, value);
                    }
                });
            }
        };
        this.mContentsClient.getVisitedHistory(callback);
    }

    public void loadUrl(LoadUrlParams params) {
        if (params.getLoadUrlType() == LoadUrlParams.LOAD_TYPE_DATA && !params.isBaseUrlDataScheme()) {
            params.setCanLoadLocalResources(true);
        }
        if (params.getUrl() != null && params.getUrl().equals(this.mContentViewCore.getUrl()) && params.getTransitionType() == 0) {
            params.setTransitionType(8);
        }
        params.setTransitionType(params.getTransitionType() | 0x8000000);
        params.setOverrideUserAgent(LoadUrlParams.UA_OVERRIDE_TRUE);
        this.mContentViewCore.loadUrl(params);
        if (!this.mHasRequestedVisitedHistoryFromClient) {
            this.mHasRequestedVisitedHistoryFromClient = true;
            this.requestVisitedHistoryFromClient();
        }
    }

    public String getUrl() {
        String url = this.mContentViewCore.getUrl();
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        return url;
    }

    public void requestFocus() {
        if (this.mNativeAwContents == 0) {
            return;
        }
        if (!this.mContainerView.isInTouchMode() && this.mSettings.shouldFocusFirstNode()) {
            this.nativeFocusFirstNode(this.mNativeAwContents);
        }
    }

    public void setBackgroundColor(int color2) {
        this.mBaseBackgroundColor = color2;
        if (this.mNativeAwContents != 0) {
            this.nativeSetBackgroundColor(this.mNativeAwContents, color2);
        }
    }

    private int getEffectiveBackgroundColor() {
        if (this.mNativeAwContents == 0 || !this.mContentsClient.isCachedRendererBackgroundColorValid()) {
            return this.mBaseBackgroundColor;
        }
        return this.mContentsClient.getCachedRendererBackgroundColor();
    }

    public boolean isMultiTouchZoomSupported() {
        return this.mSettings.supportsGestureZoom();
    }

    public View getZoomControlsForTest() {
        return this.mZoomControls.getZoomControlsViewForTest();
    }

    public ContentSettings getContentSettings() {
        return this.mContentViewCore.getContentSettings();
    }

    public void setOverScrollMode(int mode) {
        this.mOverScrollGlow = mode != 2 ? new OverScrollGlow(this.mContainerView) : null;
    }

    public void setScrollBarStyle(int style2) {
        if (style2 == 0 || style2 == 0x2000000) {
            this.mOverlayVerticalScrollbar = true;
            this.mOverlayHorizontalScrollbar = true;
        } else {
            this.mOverlayVerticalScrollbar = false;
            this.mOverlayHorizontalScrollbar = false;
        }
    }

    public void setHorizontalScrollbarOverlay(boolean overlay) {
        this.mOverlayHorizontalScrollbar = overlay;
    }

    public void setVerticalScrollbarOverlay(boolean overlay) {
        this.mOverlayVerticalScrollbar = overlay;
    }

    public boolean overlayHorizontalScrollbar() {
        return this.mOverlayHorizontalScrollbar;
    }

    public boolean overlayVerticalScrollbar() {
        return this.mOverlayVerticalScrollbar;
    }

    public void onContainerViewScrollChanged(int l, int t, int oldl, int oldt) {
        this.mScrollAccessibilityHelper.removePostedViewScrolledAccessibilityEventCallback();
        this.mScrollOffsetManager.onContainerViewScrollChanged(l, t);
    }

    public void onContainerViewOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        int oldX = this.mContainerView.getScrollX();
        int oldY = this.mContainerView.getScrollY();
        this.mScrollOffsetManager.onContainerViewOverScrolled(scrollX, scrollY, clampedX, clampedY);
        if (this.mOverScrollGlow != null) {
            this.mOverScrollGlow.pullGlow(this.mContainerView.getScrollX(), this.mContainerView.getScrollY(), oldX, oldY, this.mScrollOffsetManager.computeMaximumHorizontalScrollOffset(), this.mScrollOffsetManager.computeMaximumVerticalScrollOffset());
        }
    }

    public boolean requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        return this.mScrollOffsetManager.requestChildRectangleOnScreen(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY(), rect, immediate);
    }

    public void computeScroll() {
        this.mScrollOffsetManager.computeScrollAndAbsorbGlow(this.mOverScrollGlow);
    }

    public int computeHorizontalScrollRange() {
        return this.mScrollOffsetManager.computeHorizontalScrollRange();
    }

    public int computeHorizontalScrollOffset() {
        return this.mScrollOffsetManager.computeHorizontalScrollOffset();
    }

    public int computeVerticalScrollRange() {
        return this.mScrollOffsetManager.computeVerticalScrollRange();
    }

    public int computeVerticalScrollOffset() {
        return this.mScrollOffsetManager.computeVerticalScrollOffset();
    }

    public int computeVerticalScrollExtent() {
        return this.mScrollOffsetManager.computeVerticalScrollExtent();
    }

    public void stopLoading() {
        this.mContentViewCore.stopLoading();
    }

    public void reload() {
        this.mContentViewCore.reload();
    }

    public boolean canGoBack() {
        return this.mContentViewCore.canGoBack();
    }

    public void goBack() {
        this.mContentViewCore.goBack();
    }

    public boolean canGoForward() {
        return this.mContentViewCore.canGoForward();
    }

    public void goForward() {
        this.mContentViewCore.goForward();
    }

    public boolean canGoBackOrForward(int steps) {
        return this.mContentViewCore.canGoToOffset(steps);
    }

    public void goBackOrForward(int steps) {
        this.mContentViewCore.goToOffset(steps);
    }

    public void pauseTimers() {
        ContentViewStatics.setWebKitSharedTimersSuspended(true);
    }

    public void resumeTimers() {
        ContentViewStatics.setWebKitSharedTimersSuspended(false);
    }

    public void onPause() {
        if (this.mIsPaused || this.mNativeAwContents == 0) {
            return;
        }
        this.mIsPaused = true;
        this.nativeSetIsPaused(this.mNativeAwContents, this.mIsPaused);
    }

    public void onResume() {
        if (!this.mIsPaused || this.mNativeAwContents == 0) {
            return;
        }
        this.mIsPaused = false;
        this.nativeSetIsPaused(this.mNativeAwContents, this.mIsPaused);
    }

    public boolean isPaused() {
        return this.mIsPaused;
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return this.mContentViewCore.onCreateInputConnection(outAttrs);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.mContentViewCore.onKeyUp(keyCode, event);
    }

    private boolean isDpadEvent(KeyEvent event) {
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.isDpadEvent(event)) {
            this.mSettings.setSpatialNavigationEnabled(true);
        }
        return this.mContentViewCore.dispatchKeyEvent(event);
    }

    public void clearCache(boolean includeDiskFiles) {
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.nativeClearCache(this.mNativeAwContents, includeDiskFiles);
    }

    public void documentHasImages(Message message) {
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.nativeDocumentHasImages(this.mNativeAwContents, message);
    }

    public void saveWebArchive(final String basename, boolean autoname, final ValueCallback<String> callback) {
        if (!autoname) {
            this.saveWebArchiveInternal(basename, callback);
            return;
        }
        new AsyncTask<Void, Void, String>(){

            protected String doInBackground(Void ... params) {
                return AwContents.generateArchiveAutoNamePath(AwContents.this.getOriginalUrl(), basename);
            }

            @Override
            protected void onPostExecute(String result) {
                AwContents.this.saveWebArchiveInternal(result, callback);
            }
        }.execute(new Void[0]);
    }

    public String getOriginalUrl() {
        NavigationHistory history = this.mContentViewCore.getNavigationHistory();
        int currentIndex = history.getCurrentEntryIndex();
        if (currentIndex >= 0 && currentIndex < history.getEntryCount()) {
            return history.getEntryAtIndex(currentIndex).getOriginalUrl();
        }
        return null;
    }

    public NavigationHistory getNavigationHistory() {
        return this.mContentViewCore.getNavigationHistory();
    }

    public String getTitle() {
        return this.mContentViewCore.getTitle();
    }

    public void clearHistory() {
        this.mContentViewCore.clearHistory();
    }

    public String[] getHttpAuthUsernamePassword(String host, String realm) {
        return this.mBrowserContext.getHttpAuthDatabase(this.mContentViewCore.getContext()).getHttpAuthUsernamePassword(host, realm);
    }

    public void setHttpAuthUsernamePassword(String host, String realm, String username, String password) {
        this.mBrowserContext.getHttpAuthDatabase(this.mContentViewCore.getContext()).setHttpAuthUsernamePassword(host, realm, username, password);
    }

    public SslCertificate getCertificate() {
        if (this.mNativeAwContents == 0) {
            return null;
        }
        return SslUtil.getCertificateFromDerBytes(this.nativeGetCertificate(this.mNativeAwContents));
    }

    public void clearSslPreferences() {
        this.mContentViewCore.clearSslPreferences();
    }

    public HitTestData getLastHitTestResult() {
        if (this.mNativeAwContents == 0) {
            return null;
        }
        this.nativeUpdateLastHitTestData(this.mNativeAwContents);
        return this.mPossiblyStaleHitTestData;
    }

    public void requestFocusNodeHref(Message msg) {
        if (msg == null || this.mNativeAwContents == 0) {
            return;
        }
        this.nativeUpdateLastHitTestData(this.mNativeAwContents);
        Bundle data = msg.getData();
        data.putString("url", this.mPossiblyStaleHitTestData.hitTestResultExtraData);
        data.putString("title", this.mPossiblyStaleHitTestData.anchorText);
        data.putString("src", this.mPossiblyStaleHitTestData.imgSrc);
        msg.setData(data);
        msg.sendToTarget();
    }

    public void requestImageRef(Message msg) {
        if (msg == null || this.mNativeAwContents == 0) {
            return;
        }
        this.nativeUpdateLastHitTestData(this.mNativeAwContents);
        Bundle data = msg.getData();
        data.putString("url", this.mPossiblyStaleHitTestData.imgSrc);
        msg.setData(data);
        msg.sendToTarget();
    }

    public float getScale() {
        return (float)((double)this.mPageScaleFactor * this.mDIPScale);
    }

    public void flingScroll(int velocityX, int velocityY) {
        this.mScrollOffsetManager.flingScroll(velocityX, velocityY);
    }

    public boolean pageUp(boolean top) {
        return this.mScrollOffsetManager.pageUp(top);
    }

    public boolean pageDown(boolean bottom) {
        return this.mScrollOffsetManager.pageDown(bottom);
    }

    public boolean canZoomIn() {
        float zoomInExtent = this.mContentViewCore.getRenderCoordinates().getMaxPageScaleFactor() - this.mPageScaleFactor;
        return zoomInExtent > 0.007f;
    }

    public boolean canZoomOut() {
        float zoomOutExtent = this.mPageScaleFactor - this.mContentViewCore.getRenderCoordinates().getMinPageScaleFactor();
        return zoomOutExtent > 0.007f;
    }

    public boolean zoomIn() {
        if (!this.canZoomIn()) {
            return false;
        }
        return this.mContentViewCore.pinchByDelta(1.25f);
    }

    public boolean zoomOut() {
        if (!this.canZoomOut()) {
            return false;
        }
        return this.mContentViewCore.pinchByDelta(0.8f);
    }

    public void invokeZoomPicker() {
        this.mContentViewCore.invokeZoomPicker();
    }

    public void evaluateJavaScript(String script, final ValueCallback<String> callback) {
        ContentViewCore.JavaScriptCallback jsCallback = null;
        if (callback != null) {
            jsCallback = new ContentViewCore.JavaScriptCallback(){

                public void handleJavaScriptResult(String jsonResult) {
                    callback.onReceiveValue(jsonResult);
                }
            };
        }
        this.mContentViewCore.evaluateJavaScript(script, jsCallback);
    }

    public void evaluateJavaScriptEvenIfNotYetNavigated(String script) {
        this.mContentViewCore.evaluateJavaScriptEvenIfNotYetNavigated(script);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mNativeAwContents == 0) {
            return false;
        }
        if (event.getActionMasked() == 0) {
            this.mSettings.setSpatialNavigationEnabled(false);
        }
        this.mScrollOffsetManager.setProcessingTouchEvent(true);
        boolean rv = this.mContentViewCore.onTouchEvent(event);
        this.mScrollOffsetManager.setProcessingTouchEvent(false);
        if (event.getActionMasked() == 0) {
            int actionIndex = event.getActionIndex();
            this.nativeRequestNewHitTestDataAt(this.mNativeAwContents, (int)Math.round((double)event.getX(actionIndex) / this.mDIPScale), (int)Math.round((double)event.getY(actionIndex) / this.mDIPScale));
        }
        if (this.mOverScrollGlow != null && event.getActionMasked() == 1) {
            this.mOverScrollGlow.releaseAll();
        }
        return rv;
    }

    public boolean onHoverEvent(MotionEvent event) {
        return this.mContentViewCore.onHoverEvent(event);
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return this.mContentViewCore.onGenericMotionEvent(event);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        this.mContentViewCore.onConfigurationChanged(newConfig);
    }

    public void onAttachedToWindow() {
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.mIsAttachedToWindow = true;
        this.mContentViewCore.onAttachedToWindow();
        this.nativeOnAttachedToWindow(this.mNativeAwContents, this.mContainerView.getWidth(), this.mContainerView.getHeight());
        if (this.mComponentCallbacks != null) {
            return;
        }
        this.mComponentCallbacks = new AwComponentCallbacks();
        this.mContainerView.getContext().registerComponentCallbacks(this.mComponentCallbacks);
    }

    public void onDetachedFromWindow() {
        this.mIsAttachedToWindow = false;
        this.hideAutofillPopup();
        if (this.mNativeAwContents != 0) {
            AwContents.nativeOnDetachedFromWindow(this.mNativeAwContents);
        }
        this.mContentViewCore.onDetachedFromWindow();
        if (this.mComponentCallbacks != null) {
            this.mContainerView.getContext().unregisterComponentCallbacks(this.mComponentCallbacks);
            this.mComponentCallbacks = null;
        }
        this.mScrollAccessibilityHelper.removePostedCallbacks();
        if (this.mPendingDetachCleanupReferences != null) {
            for (int i = 0; i < this.mPendingDetachCleanupReferences.size(); ++i) {
                this.mPendingDetachCleanupReferences.get(i).cleanupNow();
            }
            this.mPendingDetachCleanupReferences = null;
        }
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        this.mWindowFocused = hasWindowFocus;
        this.mContentViewCore.onWindowFocusChanged(hasWindowFocus);
    }

    public void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        this.mContainerViewFocused = focused;
        this.mContentViewCore.onFocusChanged(focused);
    }

    public void onSizeChanged(int w, int h, int ow, int oh) {
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.mScrollOffsetManager.setContainerViewSize(w, h);
        this.mLayoutSizer.onSizeChanged(w, h, ow, oh);
        this.mContentViewCore.onPhysicalBackingSizeChanged(w, h);
        this.mContentViewCore.onSizeChanged(w, h, ow, oh);
        this.nativeOnSizeChanged(this.mNativeAwContents, w, h, ow, oh);
    }

    public void onVisibilityChanged(View changedView, int visibility) {
        boolean viewVisible;
        boolean bl = viewVisible = this.mContainerView.getVisibility() == 0;
        if (this.mIsViewVisible == viewVisible) {
            return;
        }
        this.setViewVisibilityInternal(viewVisible);
    }

    public void onWindowVisibilityChanged(int visibility) {
        boolean windowVisible;
        boolean bl = windowVisible = visibility == 0;
        if (this.mIsWindowVisible == windowVisible) {
            return;
        }
        this.setWindowVisibilityInternal(windowVisible);
    }

    private void setViewVisibilityInternal(boolean visible) {
        this.mIsViewVisible = visible;
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.nativeSetViewVisibility(this.mNativeAwContents, this.mIsViewVisible);
    }

    private void setWindowVisibilityInternal(boolean visible) {
        this.mIsWindowVisible = visible;
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.nativeSetWindowVisibility(this.mNativeAwContents, this.mIsWindowVisible);
    }

    public boolean saveState(Bundle outState) {
        if (this.mNativeAwContents == 0 || outState == null) {
            return false;
        }
        byte[] state = this.nativeGetOpaqueState(this.mNativeAwContents);
        if (state == null) {
            return false;
        }
        outState.putByteArray(SAVE_RESTORE_STATE_KEY, state);
        return true;
    }

    public boolean restoreState(Bundle inState) {
        if (this.mNativeAwContents == 0 || inState == null) {
            return false;
        }
        byte[] state = inState.getByteArray(SAVE_RESTORE_STATE_KEY);
        if (state == null) {
            return false;
        }
        boolean result = this.nativeRestoreFromOpaqueState(this.mNativeAwContents, state);
        if (result) {
            this.mContentsClient.onReceivedTitle(this.mContentViewCore.getTitle());
        }
        return result;
    }

    public void addPossiblyUnsafeJavascriptInterface(Object object, String name, Class<? extends Annotation> requiredAnnotation) {
        this.mContentViewCore.addPossiblyUnsafeJavascriptInterface(object, name, requiredAnnotation);
    }

    public void removeJavascriptInterface(String interfaceName) {
        this.mContentViewCore.removeJavascriptInterface(interfaceName);
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        return this.mContentViewCore.getAccessibilityNodeProvider();
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        this.mContentViewCore.onInitializeAccessibilityNodeInfo(info);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        this.mContentViewCore.onInitializeAccessibilityEvent(event);
    }

    public boolean supportsAccessibilityAction(int action) {
        return this.mContentViewCore.supportsAccessibilityAction(action);
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        return this.mContentViewCore.performAccessibilityAction(action, arguments);
    }

    public void hideAutofillPopup() {
        if (this.mAwAutofillManagerDelegate != null) {
            this.mAwAutofillManagerDelegate.hideAutofillPopup();
        }
    }

    public void setNetworkAvailable(boolean networkUp) {
        if (this.mNativeAwContents == 0) {
            return;
        }
        this.nativeSetJsOnlineProperty(this.mNativeAwContents, networkUp);
    }

    @CalledByNative
    private static void onDocumentHasImagesResponse(boolean result, Message message) {
        message.arg1 = result ? 1 : 0;
        message.sendToTarget();
    }

    @CalledByNative
    private void onReceivedTouchIconUrl(String url, boolean precomposed) {
        this.mContentsClient.onReceivedTouchIconUrl(url, precomposed);
    }

    @CalledByNative
    private void onReceivedIcon(Bitmap bitmap) {
        this.mContentsClient.onReceivedIcon(bitmap);
        this.mFavicon = bitmap;
    }

    @CalledByNative
    private static void generateMHTMLCallback(String path, long size, ValueCallback<String> callback) {
        if (callback == null) {
            return;
        }
        callback.onReceiveValue(size < 0L ? null : path);
    }

    @CalledByNative
    private void onReceivedHttpAuthRequest(AwHttpAuthHandler handler, String host, String realm) {
        this.mContentsClient.onReceivedHttpAuthRequest(handler, host, realm);
    }

    @CalledByNative
    private void onGeolocationPermissionsShowPrompt(String origin) {
        if (this.mNativeAwContents == 0) {
            return;
        }
        AwGeolocationPermissions permissions = this.mBrowserContext.getGeolocationPermissions();
        if (!this.mSettings.getGeolocationEnabled()) {
            this.nativeInvokeGeolocationCallback(this.mNativeAwContents, false, origin);
            return;
        }
        if (permissions.hasOrigin(origin)) {
            this.nativeInvokeGeolocationCallback(this.mNativeAwContents, permissions.isOriginAllowed(origin), origin);
            return;
        }
        this.mContentsClient.onGeolocationPermissionsShowPrompt(origin, new AwGeolocationCallback());
    }

    @CalledByNative
    private void onGeolocationPermissionsHidePrompt() {
        this.mContentsClient.onGeolocationPermissionsHidePrompt();
    }

    @CalledByNative
    public void onFindResultReceived(int activeMatchOrdinal, int numberOfMatches, boolean isDoneCounting) {
        this.mContentsClient.onFindResultReceived(activeMatchOrdinal, numberOfMatches, isDoneCounting);
    }

    @CalledByNative
    public void onNewPicture() {
        if (this.mClearViewActive) {
            this.mClearViewActive = false;
            this.mContainerView.invalidate();
            this.syncOnNewPictureStateToNative();
        }
        this.mContentsClient.getCallbackHelper().postOnNewPicture(this.mPictureListenerContentProvider);
    }

    @CalledByNative
    private void updateHitTestData(int type, String extra, String href, String anchorText, String imgSrc) {
        this.mPossiblyStaleHitTestData.hitTestResultType = type;
        this.mPossiblyStaleHitTestData.hitTestResultExtraData = extra;
        this.mPossiblyStaleHitTestData.href = href;
        this.mPossiblyStaleHitTestData.anchorText = anchorText;
        this.mPossiblyStaleHitTestData.imgSrc = imgSrc;
    }

    @CalledByNative
    private boolean requestDrawGL(Canvas canvas) {
        return this.mInternalAccessAdapter.requestDrawGL(canvas);
    }

    @CalledByNative
    private void postInvalidateOnAnimation() {
        if (SUPPORTS_ON_ANIMATION) {
            this.mContainerView.postInvalidateOnAnimation();
        } else {
            this.mContainerView.postInvalidate();
        }
    }

    @CalledByNative
    private int[] getLocationOnScreen() {
        int[] result = new int[2];
        this.mContainerView.getLocationOnScreen(result);
        return result;
    }

    @CalledByNative
    private void onWebLayoutPageScaleFactorChanged(float webLayoutPageScaleFactor) {
        this.mLayoutSizer.onPageScaleChanged(webLayoutPageScaleFactor);
    }

    @CalledByNative
    private void onWebLayoutContentsSizeChanged(int widthCss, int heightCss) {
        this.mLayoutSizer.onContentSizeChanged(widthCss, heightCss);
    }

    @CalledByNative
    private void setMaxContainerViewScrollOffset(int maxX, int maxY) {
        this.mScrollOffsetManager.setMaxScrollOffset(maxX, maxY);
    }

    @CalledByNative
    private void scrollContainerViewTo(int x, int y) {
        this.mScrollOffsetManager.scrollContainerViewTo(x, y);
    }

    @CalledByNative
    private boolean isFlingActive() {
        return this.mScrollOffsetManager.isFlingActive();
    }

    @CalledByNative
    private void setContentsSize(int widthDip, int heightDip) {
        this.mContentWidthDip = widthDip;
        this.mContentHeightDip = heightDip;
    }

    @CalledByNative
    private void setPageScaleFactor(float pageScaleFactor) {
        if (this.mPageScaleFactor == pageScaleFactor) {
            return;
        }
        float oldPageScaleFactor = this.mPageScaleFactor;
        this.mPageScaleFactor = pageScaleFactor;
        this.mContentsClient.getCallbackHelper().postOnScaleChangedScaled((float)((double)oldPageScaleFactor * this.mDIPScale), (float)((double)this.mPageScaleFactor * this.mDIPScale));
    }

    @CalledByNative
    private void setAwAutofillManagerDelegate(AwAutofillManagerDelegate delegate) {
        this.mAwAutofillManagerDelegate = delegate;
        delegate.init(this.mContentViewCore);
    }

    @CalledByNative
    private void didOverscroll(int deltaX, int deltaY) {
        if (this.mOverScrollGlow != null) {
            this.mOverScrollGlow.setOverScrollDeltas(deltaX, deltaY);
        }
        this.mScrollOffsetManager.overScrollBy(deltaX, deltaY);
        if (this.mOverScrollGlow != null && this.mOverScrollGlow.isAnimating()) {
            this.mContainerView.invalidate();
        }
    }

    private void saveWebArchiveInternal(String path, final ValueCallback<String> callback) {
        if (path == null || this.mNativeAwContents == 0) {
            ThreadUtils.runOnUiThread(new Runnable(){

                public void run() {
                    callback.onReceiveValue(null);
                }
            });
        } else {
            this.nativeGenerateMHTML(this.mNativeAwContents, path, callback);
        }
    }

    private static String generateArchiveAutoNamePath(String originalUrl, String baseName) {
        String testName;
        String name = null;
        if (originalUrl != null && !originalUrl.isEmpty()) {
            try {
                String path = new URL(originalUrl).getPath();
                int lastSlash = path.lastIndexOf(47);
                name = lastSlash > 0 ? path.substring(lastSlash + 1) : path;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (TextUtils.isEmpty(name)) {
            name = "index";
        }
        if (!new File(testName = baseName + name + WEB_ARCHIVE_EXTENSION).exists()) {
            return testName;
        }
        for (int i = 1; i < 100; ++i) {
            testName = baseName + name + "-" + i + WEB_ARCHIVE_EXTENSION;
            if (new File(testName).exists()) continue;
            return testName;
        }
        Log.e(TAG, "Unable to auto generate archive name for path: " + baseName);
        return null;
    }

    private static native int nativeInit(AwBrowserContext var0);

    private static native void nativeDestroy(int var0);

    private static native void nativeSetAwDrawSWFunctionTable(int var0);

    private static native void nativeSetAwDrawGLFunctionTable(int var0);

    private static native int nativeGetAwDrawGLFunction();

    private static native int nativeGetNativeInstanceCount();

    private static native void nativeSetShouldDownloadFavicons();

    private native void nativeSetJavaPeers(int var1, AwContents var2, AwWebContentsDelegate var3, AwContentsClientBridge var4, AwContentsIoThreadClient var5, InterceptNavigationDelegate var6);

    private native int nativeGetWebContents(int var1);

    private native void nativeDocumentHasImages(int var1, Message var2);

    private native void nativeGenerateMHTML(int var1, String var2, ValueCallback<String> var3);

    private native void nativeAddVisitedLinks(int var1, String[] var2);

    private native boolean nativeOnDraw(int var1, Canvas var2, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9);

    private native void nativeSetGlobalVisibleRect(int var1, int var2, int var3, int var4, int var5);

    private native void nativeFindAllAsync(int var1, String var2);

    private native void nativeFindNext(int var1, boolean var2);

    private native void nativeClearMatches(int var1);

    private native void nativeClearCache(int var1, boolean var2);

    private native byte[] nativeGetCertificate(int var1);

    private native void nativeRequestNewHitTestDataAt(int var1, int var2, int var3);

    private native void nativeUpdateLastHitTestData(int var1);

    private native void nativeOnSizeChanged(int var1, int var2, int var3, int var4, int var5);

    private native void nativeScrollTo(int var1, int var2, int var3);

    private native void nativeSetViewVisibility(int var1, boolean var2);

    private native void nativeSetWindowVisibility(int var1, boolean var2);

    private native void nativeSetIsPaused(int var1, boolean var2);

    private native void nativeOnAttachedToWindow(int var1, int var2, int var3);

    private static native void nativeOnDetachedFromWindow(int var0);

    private native void nativeSetDipScale(int var1, float var2);

    private native void nativeSetFixedLayoutSize(int var1, int var2, int var3);

    private native byte[] nativeGetOpaqueState(int var1);

    private native boolean nativeRestoreFromOpaqueState(int var1, byte[] var2);

    private native int nativeReleasePopupAwContents(int var1);

    private native void nativeFocusFirstNode(int var1);

    private native void nativeSetBackgroundColor(int var1, int var2);

    private native int nativeGetAwDrawGLViewContext(int var1);

    private native int nativeCapturePicture(int var1, int var2, int var3);

    private native void nativeEnableOnNewPicture(int var1, boolean var2);

    private native void nativeInvokeGeolocationCallback(int var1, boolean var2, String var3);

    private native void nativeSetJsOnlineProperty(int var1, boolean var2);

    private native void nativeTrimMemory(int var1, int var2);

    private class AwGeolocationCallback
    implements GeolocationPermissions.Callback {
        private AwGeolocationCallback() {
        }

        public void invoke(final String origin, final boolean allow, final boolean retain) {
            ThreadUtils.runOnUiThread(new Runnable(){

                public void run() {
                    if (retain) {
                        if (allow) {
                            AwContents.this.mBrowserContext.getGeolocationPermissions().allow(origin);
                        } else {
                            AwContents.this.mBrowserContext.getGeolocationPermissions().deny(origin);
                        }
                    }
                    if (AwContents.this.mNativeAwContents == 0) {
                        return;
                    }
                    AwContents.this.nativeInvokeGeolocationCallback(AwContents.this.mNativeAwContents, allow, origin);
                }
            });
        }
    }

    private class AwLayoutChangeListener
    implements View.OnLayoutChangeListener {
        private AwLayoutChangeListener() {
        }

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            assert (v == AwContents.this.mContainerView);
            AwContents.this.mLayoutSizer.onLayoutChange();
        }
    }

    private class AwComponentCallbacks
    implements ComponentCallbacks2 {
        private AwComponentCallbacks() {
        }

        public void onTrimMemory(int level) {
            if (AwContents.this.mNativeAwContents == 0) {
                return;
            }
            AwContents.this.nativeTrimMemory(AwContents.this.mNativeAwContents, level);
        }

        public void onLowMemory() {
        }

        public void onConfigurationChanged(Configuration configuration) {
        }
    }

    private class AwGestureStateListener
    implements ContentViewCore.GestureStateListener {
        private AwGestureStateListener() {
        }

        public void onPinchGestureStart() {
            AwContents.this.mLayoutSizer.freezeLayoutRequests();
        }

        public void onPinchGestureEnd() {
            AwContents.this.mLayoutSizer.unfreezeLayoutRequests();
        }

        public void onFlingStartGesture(int velocityX, int velocityY) {
            AwContents.this.mScrollOffsetManager.onFlingStartGesture(velocityX, velocityY);
        }

        public void onFlingCancelGesture() {
            AwContents.this.mScrollOffsetManager.onFlingCancelGesture();
        }

        public void onUnhandledFlingStartEvent() {
            AwContents.this.mScrollOffsetManager.onUnhandledFlingStartEvent();
        }

        public void onScrollUpdateGestureConsumed() {
            AwContents.this.mScrollAccessibilityHelper.postViewScrolledAccessibilityEventCallback();
        }
    }

    private class AwScrollOffsetManagerDelegate
    implements AwScrollOffsetManager.Delegate {
        private AwScrollOffsetManagerDelegate() {
        }

        public void overScrollContainerViewBy(int deltaX, int deltaY, int scrollX, int scrollY, int scrollRangeX, int scrollRangeY, boolean isTouchEvent) {
            AwContents.this.mInternalAccessAdapter.overScrollBy(deltaX, deltaY, scrollX, scrollY, scrollRangeX, scrollRangeY, 0, 0, isTouchEvent);
        }

        public void scrollContainerViewTo(int x, int y) {
            AwContents.this.mInternalAccessAdapter.super_scrollTo(x, y);
        }

        public void scrollNativeTo(int x, int y) {
            if (AwContents.this.mNativeAwContents == 0) {
                return;
            }
            AwContents.this.nativeScrollTo(AwContents.this.mNativeAwContents, x, y);
        }

        public int getContainerViewScrollX() {
            return AwContents.this.mContainerView.getScrollX();
        }

        public int getContainerViewScrollY() {
            return AwContents.this.mContainerView.getScrollY();
        }

        public void invalidate() {
            AwContents.this.mContainerView.invalidate();
        }
    }

    private class AwLayoutSizerDelegate
    implements AwLayoutSizer.Delegate {
        private AwLayoutSizerDelegate() {
        }

        public void requestLayout() {
            AwContents.this.mContainerView.requestLayout();
        }

        public void setMeasuredDimension(int measuredWidth, int measuredHeight) {
            AwContents.this.mInternalAccessAdapter.setMeasuredDimension(measuredWidth, measuredHeight);
        }

        public void setFixedLayoutSize(int widthDip, int heightDip) {
            if (AwContents.this.mNativeAwContents == 0) {
                return;
            }
            AwContents.this.nativeSetFixedLayoutSize(AwContents.this.mNativeAwContents, widthDip, heightDip);
        }

        public boolean isLayoutParamsHeightWrapContent() {
            return AwContents.this.mContainerView.getLayoutParams() != null && ((AwContents)AwContents.this).mContainerView.getLayoutParams().height == -2;
        }
    }

    private class InterceptNavigationDelegateImpl
    implements InterceptNavigationDelegate {
        private InterceptNavigationDelegateImpl() {
        }

        public boolean shouldIgnoreNavigation(NavigationParams navigationParams) {
            String url = navigationParams.url;
            boolean ignoreNavigation = false;
            if (AwContents.this.mDeferredShouldOverrideUrlLoadingIsPendingForPopup) {
                AwContents.this.mDeferredShouldOverrideUrlLoadingIsPendingForPopup = false;
                if (!navigationParams.isPost) {
                    ignoreNavigation = AwContents.this.mContentsClient.shouldOverrideUrlLoading(url);
                }
            }
            if (!ignoreNavigation) {
                AwContents.this.mContentsClient.getCallbackHelper().postOnPageStarted(url);
            }
            return ignoreNavigation;
        }
    }

    private class IoThreadClientImpl
    implements AwContentsIoThreadClient {
        private IoThreadClientImpl() {
        }

        public int getCacheMode() {
            return AwContents.this.mSettings.getCacheMode();
        }

        public InterceptedRequestData shouldInterceptRequest(String url, boolean isMainFrame) {
            InterceptedRequestData interceptedRequestData = AwContents.this.mDefaultVideoPosterRequestHandler.shouldInterceptRequest(url);
            if (interceptedRequestData != null) {
                return interceptedRequestData;
            }
            interceptedRequestData = AwContents.this.mContentsClient.shouldInterceptRequest(url);
            if (interceptedRequestData == null) {
                AwContents.this.mContentsClient.getCallbackHelper().postOnLoadResource(url);
            }
            if (isMainFrame && interceptedRequestData != null && interceptedRequestData.getData() == null) {
                AwContents.this.mContentsClient.getCallbackHelper().postOnReceivedError(-1, null, url);
            }
            return interceptedRequestData;
        }

        public boolean shouldBlockContentUrls() {
            return !AwContents.this.mSettings.getAllowContentAccess();
        }

        public boolean shouldBlockFileUrls() {
            return !AwContents.this.mSettings.getAllowFileAccess();
        }

        public boolean shouldBlockNetworkLoads() {
            return AwContents.this.mSettings.getBlockNetworkLoads();
        }

        public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimeType, long contentLength) {
            AwContents.this.mContentsClient.getCallbackHelper().postOnDownloadStart(url, userAgent, contentDisposition, mimeType, contentLength);
        }

        public void newLoginRequest(String realm, String account, String args) {
            AwContents.this.mContentsClient.getCallbackHelper().postOnReceivedLoginRequest(realm, account, args);
        }
    }

    private static final class DestroyRunnable
    implements Runnable {
        private int mNativeAwContents;

        private DestroyRunnable(int nativeAwContents) {
            this.mNativeAwContents = nativeAwContents;
        }

        public void run() {
            AwContents.nativeOnDetachedFromWindow(this.mNativeAwContents);
            AwContents.nativeDestroy(this.mNativeAwContents);
        }
    }

    public static interface InternalAccessDelegate
    extends ContentViewCore.InternalAccessDelegate {
        public void onScrollChanged(int var1, int var2, int var3, int var4);

        public void overScrollBy(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

        public void super_scrollTo(int var1, int var2);

        public void setMeasuredDimension(int var1, int var2);

        public int super_getScrollBarStyle();

        public boolean requestDrawGL(Canvas var1);
    }

    public static class HitTestData {
        public int hitTestResultType;
        public String hitTestResultExtraData;
        public String href;
        public String anchorText;
        public String imgSrc;
    }
}

