/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Picture;
import android.net.http.SslError;
import android.os.Message;
import android.view.KeyEvent;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.GeolocationPermissions;
import android.webkit.URLUtil;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import org.chromium.android_webview.AwContentsClientCallbackHelper;
import org.chromium.android_webview.AwHttpAuthHandler;
import org.chromium.android_webview.AwSettings;
import org.chromium.android_webview.ErrorCodeConversionHelper;
import org.chromium.android_webview.InterceptedRequestData;
import org.chromium.android_webview.JsPromptResultReceiver;
import org.chromium.android_webview.JsResultReceiver;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.ContentVideoView;
import org.chromium.content.browser.ContentVideoViewClient;
import org.chromium.content.browser.ContentVideoViewControls;
import org.chromium.content.browser.ContentViewClient;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.WebContentsObserverAndroid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AwContentsClient {
    private static final String TAG = "AwContentsClient";
    private final AwContentsClientCallbackHelper mCallbackHelper = new AwContentsClientCallbackHelper(this);
    private AwWebContentsObserver mWebContentsObserver;
    private AwContentViewClient mContentViewClient = new AwContentViewClient();
    private int mCachedRendererBackgroundColor = 0;
    private static final int INVALID_COLOR = 0;
    private AwSettings mSettings;

    final void installWebContentsObserver(ContentViewCore contentViewCore, AwSettings settings) {
        if (this.mWebContentsObserver != null) {
            this.mWebContentsObserver.detachFromWebContents();
        }
        this.mWebContentsObserver = new AwWebContentsObserver(contentViewCore);
        this.mSettings = settings;
    }

    final AwContentsClientCallbackHelper getCallbackHelper() {
        return this.mCallbackHelper;
    }

    final ContentViewClient getContentViewClient() {
        return this.mContentViewClient;
    }

    final int getCachedRendererBackgroundColor() {
        assert (this.isCachedRendererBackgroundColorValid());
        return this.mCachedRendererBackgroundColor;
    }

    final boolean isCachedRendererBackgroundColorValid() {
        return this.mCachedRendererBackgroundColor != 0;
    }

    public abstract void getVisitedHistory(ValueCallback<String[]> var1);

    public abstract void doUpdateVisitedHistory(String var1, boolean var2);

    public abstract void onProgressChanged(int var1);

    public abstract InterceptedRequestData shouldInterceptRequest(String var1);

    public abstract boolean shouldOverrideKeyEvent(KeyEvent var1);

    public abstract boolean shouldOverrideUrlLoading(String var1);

    public abstract void onLoadResource(String var1);

    public abstract void onUnhandledKeyEvent(KeyEvent var1);

    public abstract boolean onConsoleMessage(ConsoleMessage var1);

    public abstract void onReceivedHttpAuthRequest(AwHttpAuthHandler var1, String var2, String var3);

    public abstract void onReceivedSslError(ValueCallback<Boolean> var1, SslError var2);

    public abstract void onReceivedLoginRequest(String var1, String var2, String var3);

    public abstract void onFormResubmission(Message var1, Message var2);

    public abstract void onDownloadStart(String var1, String var2, String var3, String var4, long var5);

    public void showFileChooser(ValueCallback<String[]> uploadFilePathsCallback, FileChooserParams fileChooserParams) {
    }

    public abstract void onGeolocationPermissionsShowPrompt(String var1, GeolocationPermissions.Callback var2);

    public abstract void onGeolocationPermissionsHidePrompt();

    public abstract void onScaleChangedScaled(float var1, float var2);

    protected abstract void handleJsAlert(String var1, String var2, JsResultReceiver var3);

    protected abstract void handleJsBeforeUnload(String var1, String var2, JsResultReceiver var3);

    protected abstract void handleJsConfirm(String var1, String var2, JsResultReceiver var3);

    protected abstract void handleJsPrompt(String var1, String var2, String var3, JsPromptResultReceiver var4);

    protected abstract boolean onCreateWindow(boolean var1, boolean var2);

    protected abstract void onCloseWindow();

    public abstract void onReceivedTouchIconUrl(String var1, boolean var2);

    public abstract void onReceivedIcon(Bitmap var1);

    public abstract void onReceivedTitle(String var1);

    protected abstract void onRequestFocus();

    protected abstract View getVideoLoadingProgressView();

    public abstract void onPageStarted(String var1);

    public abstract void onPageFinished(String var1);

    public abstract void onReceivedError(int var1, String var2, String var3);

    public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
    }

    public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        this.onShowCustomView(view, -1, callback);
    }

    public abstract void onHideCustomView();

    public abstract Bitmap getDefaultVideoPoster();

    public abstract void onFindResultReceived(int var1, int var2, boolean var3);

    public abstract void onNewPicture(Picture var1);

    public static class FileChooserParams {
        public int mode;
        public String acceptTypes;
        public String title;
        public String defaultFilename;
        public boolean capture;
    }

    private class AwContentVideoViewClient
    implements ContentVideoViewClient {
        private AwContentVideoViewClient() {
        }

        public void onShowCustomView(View view) {
            WebChromeClient.CustomViewCallback cb = new WebChromeClient.CustomViewCallback(){

                public void onCustomViewHidden() {
                    ContentVideoView contentVideoView = ContentVideoView.getContentVideoView();
                    if (contentVideoView != null) {
                        contentVideoView.exitFullscreen(false);
                    }
                }
            };
            AwContentsClient.this.onShowCustomView(view, cb);
        }

        public void onDestroyContentVideoView() {
            AwContentsClient.this.onHideCustomView();
        }

        public View getVideoLoadingProgressView() {
            return AwContentsClient.this.getVideoLoadingProgressView();
        }

        public ContentVideoViewControls createControls() {
            return null;
        }
    }

    private class AwContentViewClient
    extends ContentViewClient {
        private AwContentViewClient() {
        }

        public void onBackgroundColorChanged(int color2) {
            AwContentsClient.this.mCachedRendererBackgroundColor = color2 == 0 ? 1 : color2;
        }

        public void onStartContentIntent(Context context, String contentUrl) {
            AwContentsClient.this.shouldOverrideUrlLoading(contentUrl);
        }

        public void onRendererCrash(boolean crashedWhileOomProtected) {
            throw new RuntimeException("Renderer crash reported.");
        }

        public void onUpdateTitle(String title) {
            AwContentsClient.this.onReceivedTitle(title);
        }

        public boolean shouldOverrideKeyEvent(KeyEvent event) {
            return AwContentsClient.this.shouldOverrideKeyEvent(event);
        }

        public final ContentVideoViewClient getContentVideoViewClient() {
            return new AwContentVideoViewClient();
        }

        public boolean shouldBlockMediaRequest(String url) {
            return AwContentsClient.this.mSettings != null ? AwContentsClient.this.mSettings.getBlockNetworkLoads() && URLUtil.isNetworkUrl(url) : true;
        }
    }

    class AwWebContentsObserver
    extends WebContentsObserverAndroid {
        public AwWebContentsObserver(ContentViewCore contentViewCore) {
            super(contentViewCore);
        }

        public void didStopLoading(final String url) {
            ThreadUtils.postOnUiThread(new Runnable(){

                public void run() {
                    AwContentsClient.this.onPageFinished(url);
                }
            });
        }

        public void didFailLoad(boolean isProvisionalLoad, boolean isMainFrame, int errorCode, String description, String failingUrl) {
            if (errorCode == -3) {
                return;
            }
            if (!isMainFrame) {
                return;
            }
            AwContentsClient.this.onReceivedError(ErrorCodeConversionHelper.convertErrorCode(errorCode), description, failingUrl);
        }

        public void didNavigateAnyFrame(String url, String baseUrl, boolean isReload) {
            AwContentsClient.this.doUpdateVisitedHistory(url, isReload);
        }
    }
}

