/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.net.http.SslCertificate;
import android.net.http.SslError;
import android.webkit.ValueCallback;
import org.chromium.android_webview.AwContentsClient;
import org.chromium.android_webview.JsResultHandler;
import org.chromium.android_webview.SslUtil;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="android_webview")
public class AwContentsClientBridge {
    private AwContentsClient mClient;
    private int mNativeContentsClientBridge;

    public AwContentsClientBridge(AwContentsClient client) {
        assert (client != null);
        this.mClient = client;
    }

    @CalledByNative
    private void setNativeContentsClientBridge(int nativeContentsClientBridge) {
        this.mNativeContentsClientBridge = nativeContentsClientBridge;
    }

    @CalledByNative
    private boolean allowCertificateError(int certError, byte[] derBytes, String url, final int id2) {
        SslCertificate cert = SslUtil.getCertificateFromDerBytes(derBytes);
        if (cert == null) {
            return false;
        }
        SslError sslError = SslUtil.sslErrorFromNetErrorCode(certError, cert, url);
        ValueCallback<Boolean> callback = new ValueCallback<Boolean>(){

            @Override
            public void onReceiveValue(Boolean value) {
                AwContentsClientBridge.this.proceedSslError(value, id2);
            }
        };
        this.mClient.onReceivedSslError(callback, sslError);
        return true;
    }

    private void proceedSslError(boolean proceed, int id2) {
        if (this.mNativeContentsClientBridge == 0) {
            return;
        }
        this.nativeProceedSslError(this.mNativeContentsClientBridge, proceed, id2);
    }

    @CalledByNative
    private void handleJsAlert(String url, String message, int id2) {
        JsResultHandler handler = new JsResultHandler(this, id2);
        this.mClient.handleJsAlert(url, message, handler);
    }

    @CalledByNative
    private void handleJsConfirm(String url, String message, int id2) {
        JsResultHandler handler = new JsResultHandler(this, id2);
        this.mClient.handleJsConfirm(url, message, handler);
    }

    @CalledByNative
    private void handleJsPrompt(String url, String message, String defaultValue, int id2) {
        JsResultHandler handler = new JsResultHandler(this, id2);
        this.mClient.handleJsPrompt(url, message, defaultValue, handler);
    }

    @CalledByNative
    private void handleJsBeforeUnload(String url, String message, int id2) {
        JsResultHandler handler = new JsResultHandler(this, id2);
        this.mClient.handleJsBeforeUnload(url, message, handler);
    }

    @CalledByNative
    private boolean shouldOverrideUrlLoading(String url) {
        return this.mClient.shouldOverrideUrlLoading(url);
    }

    void confirmJsResult(int id2, String prompt) {
        if (this.mNativeContentsClientBridge == 0) {
            return;
        }
        this.nativeConfirmJsResult(this.mNativeContentsClientBridge, id2, prompt);
    }

    void cancelJsResult(int id2) {
        if (this.mNativeContentsClientBridge == 0) {
            return;
        }
        this.nativeCancelJsResult(this.mNativeContentsClientBridge, id2);
    }

    private native void nativeProceedSslError(int var1, boolean var2, int var3);

    private native void nativeConfirmJsResult(int var1, int var2, String var3);

    private native void nativeCancelJsResult(int var1, int var2);
}

