/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

@JNINamespace(value="android_webview")
public class AwHttpAuthHandler {
    private int mNativeAwHttpAuthHandler;
    private final boolean mFirstAttempt;

    public void proceed(String username, String password) {
        if (this.mNativeAwHttpAuthHandler != 0) {
            this.nativeProceed(this.mNativeAwHttpAuthHandler, username, password);
            this.mNativeAwHttpAuthHandler = 0;
        }
    }

    public void cancel() {
        if (this.mNativeAwHttpAuthHandler != 0) {
            this.nativeCancel(this.mNativeAwHttpAuthHandler);
            this.mNativeAwHttpAuthHandler = 0;
        }
    }

    public boolean isFirstAttempt() {
        return this.mFirstAttempt;
    }

    @CalledByNative
    public static AwHttpAuthHandler create(int nativeAwAuthHandler, boolean firstAttempt) {
        return new AwHttpAuthHandler(nativeAwAuthHandler, firstAttempt);
    }

    private AwHttpAuthHandler(int nativeAwHttpAuthHandler, boolean firstAttempt) {
        this.mNativeAwHttpAuthHandler = nativeAwHttpAuthHandler;
        this.mFirstAttempt = firstAttempt;
    }

    @CalledByNative
    void handlerDestroyed() {
        this.mNativeAwHttpAuthHandler = 0;
    }

    private native void nativeProceed(int var1, String var2, String var3);

    private native void nativeCancel(int var1);
}

