/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.view.ViewGroup;
import android.webkit.ValueCallback;
import org.chromium.android_webview.AwPdfExportAttributes;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="android_webview")
public class AwPdfExporter {
    private static final String TAG = "AwPdfExporter";
    private int mNativeAwPdfExporter;
    private ValueCallback<Boolean> mResultCallback;
    private AwPdfExportAttributes mAttributes;
    private ParcelFileDescriptor mFd;
    private final ViewGroup mContainerView;

    AwPdfExporter(ViewGroup containerView) {
        this.mContainerView = containerView;
    }

    public void exportToPdf(ParcelFileDescriptor fd, AwPdfExportAttributes attributes, ValueCallback<Boolean> resultCallback, CancellationSignal cancellationSignal) {
        if (fd == null) {
            throw new IllegalArgumentException("fd cannot be null");
        }
        if (resultCallback == null) {
            throw new IllegalArgumentException("resultCallback cannot be null");
        }
        if (this.mResultCallback != null) {
            throw new IllegalStateException("printing is already pending");
        }
        if (this.mNativeAwPdfExporter == 0) {
            resultCallback.onReceiveValue(false);
            return;
        }
        this.mResultCallback = resultCallback;
        this.mAttributes = attributes;
        this.mFd = fd;
        this.nativeExportToPdf(this.mNativeAwPdfExporter, this.mFd.getFd(), cancellationSignal);
    }

    @CalledByNative
    private void setNativeAwPdfExporter(int nativePdfExporter) {
        this.mNativeAwPdfExporter = nativePdfExporter;
        if (nativePdfExporter == 0 && this.mResultCallback != null) {
            this.mResultCallback.onReceiveValue(false);
            this.mResultCallback = null;
        }
    }

    @CalledByNative
    private void didExportPdf(boolean success) {
        this.mResultCallback.onReceiveValue(success);
        this.mResultCallback = null;
        this.mAttributes = null;
        this.mFd = null;
    }

    @CalledByNative
    private int getPageWidth() {
        return this.mAttributes.pageWidth;
    }

    @CalledByNative
    private int getPageHeight() {
        return this.mAttributes.pageHeight;
    }

    @CalledByNative
    private int getDpi() {
        return this.mAttributes.dpi;
    }

    @CalledByNative
    private int getLeftMargin() {
        return this.mAttributes.leftMargin;
    }

    @CalledByNative
    private int getRightMargin() {
        return this.mAttributes.rightMargin;
    }

    @CalledByNative
    private int getTopMargin() {
        return this.mAttributes.topMargin;
    }

    @CalledByNative
    private int getBottomMargin() {
        return this.mAttributes.bottomMargin;
    }

    private native void nativeExportToPdf(int var1, int var2, CancellationSignal var3);
}

