/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.print.PageRange;
import android.print.PrintAttributes;
import android.print.PrintDocumentAdapter;
import android.print.PrintDocumentInfo;
import android.util.Log;
import android.webkit.ValueCallback;
import org.chromium.android_webview.AwPdfExportAttributes;
import org.chromium.android_webview.AwPdfExporter;

public class AwPrintDocumentAdapter
extends PrintDocumentAdapter {
    private static final String TAG = "AwPrintDocumentAdapter";
    private AwPdfExporter mPdfExporter;
    private PrintAttributes mAttributes;

    public AwPrintDocumentAdapter(AwPdfExporter pdfExporter) {
        this.mPdfExporter = pdfExporter;
    }

    public void onLayout(PrintAttributes oldAttributes, PrintAttributes newAttributes, CancellationSignal cancellationSignal, PrintDocumentAdapter.LayoutResultCallback callback, Bundle metadata) {
        this.mAttributes = newAttributes;
        PrintDocumentInfo documentInfo = new PrintDocumentInfo.Builder("webview").build();
        callback.onLayoutFinished(documentInfo, true);
    }

    public void onWrite(PageRange[] pages, ParcelFileDescriptor destination, CancellationSignal cancellationSignal, PrintDocumentAdapter.WriteResultCallback callback) {
        if (this.mAttributes.getMediaSize() == null) {
            throw new IllegalArgumentException("attributes must specify a media size");
        }
        if (this.mAttributes.getResolution() == null) {
            throw new IllegalArgumentException("attributes must specify print resolution");
        }
        if (this.mAttributes.getMinMargins() == null) {
            throw new IllegalArgumentException("attributes must specify margins");
        }
        AwPdfExportAttributes pdfAttributes = new AwPdfExportAttributes();
        pdfAttributes.pageWidth = this.mAttributes.getMediaSize().getWidthMils();
        pdfAttributes.pageHeight = this.mAttributes.getMediaSize().getHeightMils();
        pdfAttributes.dpi = AwPrintDocumentAdapter.getPrintDpi(this.mAttributes);
        pdfAttributes.leftMargin = this.mAttributes.getMinMargins().getLeftMils();
        pdfAttributes.rightMargin = this.mAttributes.getMinMargins().getRightMils();
        pdfAttributes.topMargin = this.mAttributes.getMinMargins().getTopMils();
        pdfAttributes.bottomMargin = this.mAttributes.getMinMargins().getBottomMils();
        this.exportPdf(destination, pdfAttributes, cancellationSignal, callback);
    }

    private static int getPrintDpi(PrintAttributes attributes) {
        int verticalDpi;
        int horizontalDpi = attributes.getResolution().getHorizontalDpi();
        if (horizontalDpi != (verticalDpi = attributes.getResolution().getVerticalDpi())) {
            Log.w(TAG, "Horizontal and vertical DPIs differ. Using horizontal DPI  hDpi=" + horizontalDpi + " vDPI=" + verticalDpi);
        }
        return horizontalDpi;
    }

    private void exportPdf(ParcelFileDescriptor destination, AwPdfExportAttributes attributes, CancellationSignal signal, final PrintDocumentAdapter.WriteResultCallback callback) {
        this.mPdfExporter.exportToPdf(destination, attributes, new ValueCallback<Boolean>(){

            @Override
            public void onReceiveValue(Boolean value) {
                if (value.booleanValue()) {
                    callback.onWriteFinished(new PageRange[]{PageRange.ALL_PAGES});
                } else {
                    callback.onWriteFailed(null);
                }
            }
        }, signal);
    }
}

