/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.android_webview;

import android.os.Handler;
import android.os.Message;
import android.view.View;

class ScrollAccessibilityHelper {
    private static final long SEND_RECURRING_ACCESSIBILITY_EVENTS_INTERVAL_MILLIS = 100L;
    private Handler mHandler;
    private boolean mMsgViewScrolledQueued;

    public ScrollAccessibilityHelper(View eventSender) {
        this.mHandler = new Handler(new HandlerCallback(eventSender));
    }

    public void postViewScrolledAccessibilityEventCallback() {
        if (this.mMsgViewScrolledQueued) {
            return;
        }
        this.mMsgViewScrolledQueued = true;
        Message msg = this.mHandler.obtainMessage(1);
        this.mHandler.sendMessageDelayed(msg, 100L);
    }

    public void removePostedViewScrolledAccessibilityEventCallback() {
        if (!this.mMsgViewScrolledQueued) {
            return;
        }
        this.mMsgViewScrolledQueued = false;
        this.mHandler.removeMessages(1);
    }

    public void removePostedCallbacks() {
        this.removePostedViewScrolledAccessibilityEventCallback();
    }

    private class HandlerCallback
    implements Handler.Callback {
        public static final int MSG_VIEW_SCROLLED = 1;
        private View mEventSender;

        public HandlerCallback(View eventSender) {
            this.mEventSender = eventSender;
        }

        public boolean handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    ScrollAccessibilityHelper.this.mMsgViewScrolledQueued = false;
                    this.mEventSender.sendAccessibilityEvent(4096);
                    break;
                }
                default: {
                    throw new IllegalStateException("AccessibilityInjector: unhandled message: " + msg.what);
                }
            }
            return true;
        }
    }
}

