/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.base;

import android.content.Context;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.chromium.base.CalledByNative;

public class ContextTypes {
    public static final int CONTEXT_TYPE_NORMAL = 1;
    public static final int CONTEXT_TYPE_WEBAPP = 2;
    private final Map<Context, Integer> mContextMap = new ConcurrentHashMap<Context, Integer>();

    private ContextTypes() {
    }

    public static ContextTypes getInstance() {
        return ContextTypesHolder.INSTANCE;
    }

    public void put(Context context, int type) throws IllegalArgumentException {
        if (type != 1 && type != 2) {
            throw new IllegalArgumentException("Wrong context type");
        }
        this.mContextMap.put(context, type);
    }

    public void remove(Context context) {
        this.mContextMap.remove(context);
    }

    public int getType(Context context) {
        Integer contextType = this.mContextMap.get(context);
        return contextType == null ? 1 : contextType;
    }

    @CalledByNative
    public static boolean isRunningInWebapp(Context appContext) {
        return ContextTypes.getInstance().getType(appContext) == 2;
    }

    public boolean contains(Context context) {
        return this.mContextMap.containsKey(context);
    }

    private static class ContextTypesHolder {
        private static final ContextTypes INSTANCE = new ContextTypes();

        private ContextTypesHolder() {
        }
    }
}

