/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.components.web_contents_delegate_android;

import android.content.Context;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.ui.ColorPickerDialog;
import org.chromium.ui.OnColorChangedListener;

@JNINamespace(value="web_contents_delegate_android")
public class ColorChooserAndroid {
    private final ColorPickerDialog mDialog;
    private final int mNativeColorChooserAndroid;

    private ColorChooserAndroid(int nativeColorChooserAndroid, Context context, int initialColor) {
        OnColorChangedListener listener = new OnColorChangedListener(){

            public void onColorChanged(int color2) {
                ColorChooserAndroid.this.mDialog.dismiss();
                ColorChooserAndroid.this.nativeOnColorChosen(ColorChooserAndroid.this.mNativeColorChooserAndroid, color2);
            }
        };
        this.mNativeColorChooserAndroid = nativeColorChooserAndroid;
        this.mDialog = new ColorPickerDialog(context, listener, initialColor);
    }

    private void openColorChooser() {
        this.mDialog.show();
    }

    @CalledByNative
    public void closeColorChooser() {
        this.mDialog.dismiss();
    }

    @CalledByNative
    public static ColorChooserAndroid createColorChooserAndroid(int nativeColorChooserAndroid, ContentViewCore contentViewCore, int initialColor) {
        ColorChooserAndroid chooser = new ColorChooserAndroid(nativeColorChooserAndroid, contentViewCore.getContext(), initialColor);
        chooser.openColorChooser();
        return chooser;
    }

    private native void nativeOnColorChosen(int var1, int var2);
}

