/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.app;

import android.util.Log;
import org.chromium.base.JNINamespace;
import org.chromium.content.app.NativeLibraries;
import org.chromium.content.common.CommandLine;
import org.chromium.content.common.ProcessInitException;
import org.chromium.content.common.TraceEvent;

@JNINamespace(value="content")
public class LibraryLoader {
    private static final String TAG = "LibraryLoader";
    private static final Object sLock = new Object();
    private static boolean sLoaded = false;
    private static boolean sInitialized = false;

    @Deprecated
    public static void setLibraryToLoad(String library) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureInitialized() throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            if (sInitialized) {
                return;
            }
            LibraryLoader.loadAlreadyLocked();
            LibraryLoader.initializeAlreadyLocked(CommandLine.getJavaSwitchesOrNull());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadNow() throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            LibraryLoader.loadAlreadyLocked();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initialize(String[] initCommandLine) throws ProcessInitException {
        Object object = sLock;
        synchronized (object) {
            LibraryLoader.initializeAlreadyLocked(initCommandLine);
        }
    }

    private static void loadAlreadyLocked() throws ProcessInitException {
        try {
            if (!sLoaded) {
                assert (!sInitialized);
                for (String sLibrary : NativeLibraries.libraries) {
                    Log.i(TAG, "loading: " + sLibrary);
                    System.loadLibrary(sLibrary);
                    Log.i(TAG, "loaded: " + sLibrary);
                }
                sLoaded = true;
            }
        }
        catch (UnsatisfiedLinkError e) {
            throw new ProcessInitException(5, (Throwable)e);
        }
    }

    private static void initializeAlreadyLocked(String[] initCommandLine) throws ProcessInitException {
        if (sInitialized) {
            return;
        }
        int resultCode = LibraryLoader.nativeLibraryLoaded(initCommandLine);
        if (resultCode != 0) {
            Log.e(TAG, "error calling nativeLibraryLoaded");
            throw new ProcessInitException(resultCode);
        }
        sInitialized = true;
        CommandLine.enableNativeProxy();
        TraceEvent.setEnabledToMatchNative();
    }

    private static native int nativeLibraryLoaded(String[] var0);
}

