/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.Context;
import android.util.Log;
import org.chromium.base.JNINamespace;
import org.chromium.content.app.ContentMain;
import org.chromium.content.app.LibraryLoader;
import org.chromium.content.browser.DeviceUtils;
import org.chromium.content.browser.PepperPluginManager;
import org.chromium.content.browser.ResourceExtractor;
import org.chromium.content.common.ProcessInitException;

@JNINamespace(value="content")
public class AndroidBrowserProcess {
    private static final String TAG = "BrowserProcessMain";
    private static boolean sInitialized = false;
    public static final int MAX_RENDERERS_SINGLE_PROCESS = 0;
    public static final int MAX_RENDERERS_LIMIT = 9;

    public static boolean init(Context context, int maxRendererProcesses) throws ProcessInitException {
        assert (maxRendererProcesses >= 0);
        assert (maxRendererProcesses <= 9);
        if (sInitialized) {
            return false;
        }
        sInitialized = true;
        Log.i(TAG, "Initializing chromium process, renderers=" + maxRendererProcesses);
        ResourceExtractor resourceExtractor = ResourceExtractor.get(context);
        resourceExtractor.startExtractingResources();
        LibraryLoader.ensureInitialized();
        DeviceUtils.addDeviceSpecificUserAgentSwitch(context);
        Context appContext = context.getApplicationContext();
        resourceExtractor.waitForCompletion();
        AndroidBrowserProcess.nativeSetCommandLineFlags(maxRendererProcesses, AndroidBrowserProcess.nativeIsPluginEnabled() ? AndroidBrowserProcess.getPlugins(context) : null);
        ContentMain.initApplicationContext(appContext);
        int result = ContentMain.start();
        if (result > 0) {
            throw new ProcessInitException(result);
        }
        return true;
    }

    public static void initChromiumBrowserProcessForTests(Context context) {
        ResourceExtractor resourceExtractor = ResourceExtractor.get(context);
        resourceExtractor.startExtractingResources();
        resourceExtractor.waitForCompletion();
        AndroidBrowserProcess.nativeSetCommandLineFlags(1, null);
    }

    private static String getPlugins(Context context) {
        return PepperPluginManager.getPlugins(context);
    }

    private static native void nativeSetCommandLineFlags(int var0, String var1);

    private static native boolean nativeIsOfficialBuild();

    private static native boolean nativeIsPluginEnabled();
}

