/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import org.chromium.base.CpuFeatures;
import org.chromium.base.SysUtils;
import org.chromium.base.ThreadUtils;
import org.chromium.content.app.ChildProcessService;
import org.chromium.content.browser.FileDescriptorInfo;
import org.chromium.content.common.IChildProcessCallback;
import org.chromium.content.common.IChildProcessService;
import org.chromium.content.common.TraceEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildProcessConnection {
    public static final String EXTRA_COMMAND_LINE = "com.google.android.apps.chrome.extra.command_line";
    public static final String EXTRA_FILES_PREFIX = "com.google.android.apps.chrome.extra.extraFile_";
    public static final String EXTRA_FILES_ID_SUFFIX = "_id";
    public static final String EXTRA_FILES_FD_SUFFIX = "_fd";
    public static final String EXTRA_CPU_COUNT = "com.google.android.apps.chrome.extra.cpu_count";
    public static final String EXTRA_CPU_FEATURES = "com.google.android.apps.chrome.extra.cpu_features";
    private final Context mContext;
    private final int mServiceNumber;
    private final boolean mInSandbox;
    private final DeathCallback mDeathCallback;
    private final Class<? extends ChildProcessService> mServiceClass;
    private final Object mUiThreadLock = new Object();
    private IChildProcessService mService = null;
    private boolean mServiceConnectComplete = false;
    private boolean mServiceDisconnected = false;
    private int mPID = 0;
    private ChildServiceConnection mInitialBinding = null;
    private ChildServiceConnection mStrongBinding = null;
    private ChildServiceConnection mWaivedBinding = null;
    private int mAttachAsActiveCount = 0;
    private static final String TAG = "ChildProcessConnection";
    private ConnectionParams mConnectionParams;
    private ConnectionCallbacks mConnectionCallbacks;
    private static final long REMOVE_INITIAL_BINDING_DELAY_MILLIS = 1000L;
    private static final long DETACH_AS_ACTIVE_HIGH_END_DELAY_MILLIS = 5000L;

    ChildProcessConnection(Context context, int number, boolean inSandbox, DeathCallback deathCallback, Class<? extends ChildProcessService> serviceClass) {
        this.mContext = context;
        this.mServiceNumber = number;
        this.mInSandbox = inSandbox;
        this.mDeathCallback = deathCallback;
        this.mServiceClass = serviceClass;
        this.mInitialBinding = new ChildServiceConnection(1, true);
        this.mStrongBinding = new ChildServiceConnection(65, true);
        this.mWaivedBinding = new ChildServiceConnection(33, false);
    }

    int getServiceNumber() {
        return this.mServiceNumber;
    }

    boolean isInSandbox() {
        return this.mInSandbox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IChildProcessService getService() {
        Object object = this.mUiThreadLock;
        synchronized (object) {
            return this.mService;
        }
    }

    private Intent createServiceBindIntent() {
        Intent intent = new Intent();
        intent.setClassName(this.mContext, this.mServiceClass.getName() + this.mServiceNumber);
        intent.setPackage(this.mContext.getPackageName());
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start(String[] commandLine) {
        Object object = this.mUiThreadLock;
        synchronized (object) {
            TraceEvent.begin();
            assert (!ThreadUtils.runningOnUiThread());
            if (!this.mInitialBinding.bind(commandLine)) {
                this.onBindFailed();
            } else {
                this.mWaivedBinding.bind(null);
            }
            TraceEvent.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setupConnection(String[] commandLine, FileDescriptorInfo[] filesToBeMapped, IChildProcessCallback processCallback, ConnectionCallbacks connectionCallbacks) {
        Object object = this.mUiThreadLock;
        synchronized (object) {
            TraceEvent.begin();
            assert (this.mConnectionParams == null);
            this.mConnectionCallbacks = connectionCallbacks;
            this.mConnectionParams = new ConnectionParams(commandLine, filesToBeMapped, processCallback);
            if (this.mServiceConnectComplete) {
                this.doConnectionSetup();
            }
            TraceEvent.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.mUiThreadLock;
        synchronized (object) {
            this.mInitialBinding.unbind();
            this.mStrongBinding.unbind();
            this.mWaivedBinding.unbind();
            this.mAttachAsActiveCount = 0;
            if (this.mService != null) {
                this.mService = null;
                this.mPID = 0;
            }
            this.mConnectionParams = null;
            this.mServiceConnectComplete = false;
        }
    }

    private void onBindFailed() {
        this.mServiceConnectComplete = true;
        if (this.mConnectionParams != null) {
            this.doConnectionSetup();
        }
    }

    private void doConnectionSetup() {
        TraceEvent.begin();
        assert (this.mServiceConnectComplete && this.mConnectionParams != null);
        if (this.mService != null) {
            Bundle bundle = new Bundle();
            bundle.putStringArray(EXTRA_COMMAND_LINE, this.mConnectionParams.mCommandLine);
            FileDescriptorInfo[] fileInfos = this.mConnectionParams.mFilesToBeMapped;
            ParcelFileDescriptor[] parcelFiles = new ParcelFileDescriptor[fileInfos.length];
            for (int i = 0; i < fileInfos.length; ++i) {
                if (fileInfos[i].mFd == -1) {
                    Log.e(TAG, "Invalid FD (id=" + fileInfos[i].mId + ") for process connection, " + "aborting connection.");
                    return;
                }
                String idName = EXTRA_FILES_PREFIX + i + EXTRA_FILES_ID_SUFFIX;
                String fdName = EXTRA_FILES_PREFIX + i + EXTRA_FILES_FD_SUFFIX;
                if (fileInfos[i].mAutoClose) {
                    parcelFiles[i] = ParcelFileDescriptor.adoptFd(fileInfos[i].mFd);
                } else {
                    try {
                        parcelFiles[i] = ParcelFileDescriptor.fromFd(fileInfos[i].mFd);
                    }
                    catch (IOException e) {
                        Log.e(TAG, "Invalid FD provided for process connection, aborting connection.", e);
                        return;
                    }
                }
                bundle.putParcelable(fdName, parcelFiles[i]);
                bundle.putInt(idName, fileInfos[i].mId);
            }
            bundle.putInt(EXTRA_CPU_COUNT, CpuFeatures.getCount());
            bundle.putLong(EXTRA_CPU_FEATURES, CpuFeatures.getMask());
            try {
                this.mPID = this.mService.setupConnection(bundle, this.mConnectionParams.mCallback);
            }
            catch (RemoteException re) {
                Log.e(TAG, "Failed to setup connection.", re);
            }
            try {
                for (ParcelFileDescriptor parcelFile : parcelFiles) {
                    if (parcelFile == null) continue;
                    parcelFile.close();
                }
            }
            catch (IOException ioe) {
                Log.w(TAG, "Failed to close FD.", ioe);
            }
        }
        this.mConnectionParams = null;
        if (this.mConnectionCallbacks != null) {
            int oomBindingCount = (this.mInitialBinding.isBound() ? 1 : 0) + (this.mStrongBinding.isBound() ? 1 : 0);
            this.mConnectionCallbacks.onConnected(this.getPid(), oomBindingCount);
        }
        TraceEvent.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInitialBinding() {
        Object object = this.mUiThreadLock;
        synchronized (object) {
            if (!this.mInitialBinding.isBound()) {
                return;
            }
        }
        ThreadUtils.postOnUiThreadDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ChildProcessConnection.this.mUiThreadLock;
                synchronized (object) {
                    ChildProcessConnection.this.mInitialBinding.unbind();
                }
            }
        }, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void attachAsActive() {
        Object object = this.mUiThreadLock;
        synchronized (object) {
            if (this.mService == null) {
                Log.w(TAG, "The connection is not bound for " + this.mPID);
                return;
            }
            if (this.mAttachAsActiveCount == 0) {
                this.mStrongBinding.bind(null);
            }
            ++this.mAttachAsActiveCount;
        }
    }

    void detachAsActive() {
        ThreadUtils.postOnUiThreadDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ChildProcessConnection.this.mUiThreadLock;
                synchronized (object) {
                    if (ChildProcessConnection.this.mService == null) {
                        Log.w(ChildProcessConnection.TAG, "The connection is not bound for " + ChildProcessConnection.this.mPID);
                        return;
                    }
                    assert (ChildProcessConnection.this.mAttachAsActiveCount > 0);
                    ChildProcessConnection.this.mAttachAsActiveCount--;
                    if (ChildProcessConnection.this.mAttachAsActiveCount == 0) {
                        ChildProcessConnection.this.mStrongBinding.unbind();
                    }
                }
            }
        }, SysUtils.isLowEndDevice() ? 0L : 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getPid() {
        Object object = this.mUiThreadLock;
        synchronized (object) {
            return this.mPID;
        }
    }

    private class ChildServiceConnection
    implements ServiceConnection {
        private boolean mBound = false;
        private final int mBindFlags;
        private final boolean mProtectsFromOom;

        public ChildServiceConnection(int bindFlags, boolean protectsFromOom) {
            this.mBindFlags = bindFlags;
            this.mProtectsFromOom = protectsFromOom;
        }

        boolean bind(String[] commandLine) {
            if (!this.mBound) {
                Intent intent = ChildProcessConnection.this.createServiceBindIntent();
                if (commandLine != null) {
                    intent.putExtra(ChildProcessConnection.EXTRA_COMMAND_LINE, commandLine);
                }
                this.mBound = ChildProcessConnection.this.mContext.bindService(intent, this, this.mBindFlags);
                if (this.mBound && this.mProtectsFromOom && ChildProcessConnection.this.mConnectionCallbacks != null) {
                    ChildProcessConnection.this.mConnectionCallbacks.onOomBindingAdded(ChildProcessConnection.this.getPid());
                }
            }
            return this.mBound;
        }

        void unbind() {
            if (this.mBound) {
                ChildProcessConnection.this.mContext.unbindService(this);
                this.mBound = false;
                if (this.mProtectsFromOom && ChildProcessConnection.this.mConnectionCallbacks != null && !ChildProcessConnection.this.mServiceDisconnected) {
                    ChildProcessConnection.this.mConnectionCallbacks.onOomBindingRemoved(ChildProcessConnection.this.getPid());
                }
            }
        }

        boolean isBound() {
            return this.mBound;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ComponentName className, IBinder service) {
            Object object = ChildProcessConnection.this.mUiThreadLock;
            synchronized (object) {
                if (ChildProcessConnection.this.mServiceConnectComplete) {
                    return;
                }
                TraceEvent.begin();
                ChildProcessConnection.this.mServiceConnectComplete = true;
                ChildProcessConnection.this.mService = IChildProcessService.Stub.asInterface(service);
                if (ChildProcessConnection.this.mConnectionParams != null) {
                    ChildProcessConnection.this.doConnectionSetup();
                }
                TraceEvent.end();
            }
        }

        public void onServiceDisconnected(ComponentName className) {
            if (ChildProcessConnection.this.mServiceDisconnected) {
                return;
            }
            ChildProcessConnection.this.mServiceDisconnected = true;
            int pid = ChildProcessConnection.this.mPID;
            boolean disconnectedWhileBeingSetUp = ChildProcessConnection.this.mConnectionParams != null;
            Log.w(ChildProcessConnection.TAG, "onServiceDisconnected (crash or killed by oom): pid=" + pid);
            ChildProcessConnection.this.stop();
            if (pid != 0) {
                ChildProcessConnection.this.mDeathCallback.onChildProcessDied(pid);
            }
            if (disconnectedWhileBeingSetUp && ChildProcessConnection.this.mConnectionCallbacks != null) {
                ChildProcessConnection.this.mConnectionCallbacks.onConnected(0, 0);
            }
        }
    }

    private static class ConnectionParams {
        final String[] mCommandLine;
        final FileDescriptorInfo[] mFilesToBeMapped;
        final IChildProcessCallback mCallback;

        ConnectionParams(String[] commandLine, FileDescriptorInfo[] filesToBeMapped, IChildProcessCallback callback) {
            this.mCommandLine = commandLine;
            this.mFilesToBeMapped = filesToBeMapped;
            this.mCallback = callback;
        }
    }

    static interface ConnectionCallbacks {
        public void onConnected(int var1, int var2);

        public void onOomBindingAdded(int var1);

        public void onOomBindingRemoved(int var1);
    }

    static interface DeathCallback {
        public void onChildProcessDied(int var1);
    }
}

