/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.ThreadUtils;
import org.chromium.content.browser.ContentViewCore;

@JNINamespace(value="content")
public class ContentSettings {
    private static final String TAG = "ContentSettings";
    private int mNativeContentSettings = 0;
    private ContentViewCore mContentViewCore;

    ContentSettings(ContentViewCore contentViewCore, int nativeContentView) {
        ThreadUtils.assertOnUiThread();
        this.mContentViewCore = contentViewCore;
        this.mNativeContentSettings = this.nativeInit(nativeContentView);
        assert (this.mNativeContentSettings != 0);
    }

    @CalledByNative
    private void onNativeContentSettingsDestroyed(int nativeContentSettings) {
        assert (this.mNativeContentSettings == nativeContentSettings);
        this.mNativeContentSettings = 0;
    }

    public boolean getJavaScriptEnabled() {
        ThreadUtils.assertOnUiThread();
        return this.mNativeContentSettings != 0 ? this.nativeGetJavaScriptEnabled(this.mNativeContentSettings) : false;
    }

    private native int nativeInit(int var1);

    private native boolean nativeGetJavaScriptEnabled(int var1);
}

