/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.widget.FrameLayout;
import com.google.common.annotations.VisibleForTesting;
import org.chromium.content.browser.ContentSettings;
import org.chromium.content.browser.ContentViewClient;
import org.chromium.content.browser.ContentViewCore;
import org.chromium.content.browser.ContentViewDownloadDelegate;
import org.chromium.content.browser.JellyBeanContentView;
import org.chromium.content.browser.LoadUrlParams;
import org.chromium.content.browser.PageInfo;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.common.TraceEvent;
import org.chromium.ui.WindowAndroid;

public class ContentView
extends FrameLayout
implements ContentViewCore.InternalAccessDelegate,
PageInfo {
    private final ContentViewCore mContentViewCore;
    private float mCurrentTouchOffsetX;
    private float mCurrentTouchOffsetY;

    public static ContentView newInstance(Context context, int nativeWebContents, WindowAndroid windowAndroid) {
        return ContentView.newInstance(context, nativeWebContents, windowAndroid, null, 16842885);
    }

    public static ContentView newInstance(Context context, int nativeWebContents, WindowAndroid windowAndroid, AttributeSet attrs) {
        return ContentView.newInstance(context, nativeWebContents, windowAndroid, attrs, 16842885);
    }

    public static ContentView newInstance(Context context, int nativeWebContents, WindowAndroid windowAndroid, AttributeSet attrs, int defStyle) {
        if (Build.VERSION.SDK_INT < 16) {
            return new ContentView(context, nativeWebContents, windowAndroid, attrs, defStyle);
        }
        return new JellyBeanContentView(context, nativeWebContents, windowAndroid, attrs, defStyle);
    }

    protected ContentView(Context context, int nativeWebContents, WindowAndroid windowAndroid, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (this.getScrollBarStyle() == 0) {
            this.setHorizontalScrollBarEnabled(false);
            this.setVerticalScrollBarEnabled(false);
        }
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.mContentViewCore = new ContentViewCore(context);
        this.mContentViewCore.initialize(this, this, nativeWebContents, windowAndroid, Build.VERSION.SDK_INT >= 16 ? 1 : 0);
    }

    public String getUrl() {
        return this.mContentViewCore.getUrl();
    }

    public String getTitle() {
        return this.mContentViewCore.getTitle();
    }

    public boolean isReadyForSnapshot() {
        return !this.isCrashed() && this.isReady();
    }

    public Bitmap getBitmap() {
        return this.getBitmap(this.getWidth(), this.getHeight());
    }

    public Bitmap getBitmap(int width, int height) {
        return this.mContentViewCore.getBitmap(width, height);
    }

    public int getBackgroundColor() {
        return this.mContentViewCore.getBackgroundColor();
    }

    public View getView() {
        return this;
    }

    public ContentViewCore getContentViewCore() {
        return this.mContentViewCore;
    }

    public RenderCoordinates getRenderCoordinates() {
        return this.mContentViewCore.getRenderCoordinates();
    }

    public static boolean hasHardwareAcceleration(Activity activity) {
        return ContentViewCore.hasHardwareAcceleration(activity);
    }

    public void destroy() {
        this.mContentViewCore.destroy();
    }

    public boolean isAlive() {
        return this.mContentViewCore.isAlive();
    }

    void checkIsAlive() throws IllegalStateException {
        this.mContentViewCore.checkIsAlive();
    }

    public void setContentViewClient(ContentViewClient client) {
        this.mContentViewCore.setContentViewClient(client);
    }

    @VisibleForTesting
    public ContentViewClient getContentViewClient() {
        return this.mContentViewCore.getContentViewClient();
    }

    public void loadUrl(LoadUrlParams params) {
        this.mContentViewCore.loadUrl(params);
    }

    public void stopLoading() {
        this.mContentViewCore.stopLoading();
    }

    public boolean canGoBack() {
        return this.mContentViewCore.canGoBack();
    }

    public boolean canGoForward() {
        return this.mContentViewCore.canGoForward();
    }

    public boolean canGoToOffset(int offset) {
        return this.mContentViewCore.canGoToOffset(offset);
    }

    public void goToOffset(int offset) {
        this.mContentViewCore.goToOffset(offset);
    }

    public void goBack() {
        this.mContentViewCore.goBack();
    }

    public void goForward() {
        this.mContentViewCore.goForward();
    }

    public void reload() {
        this.mContentViewCore.reload();
    }

    public void clearHistory() {
        this.mContentViewCore.clearHistory();
    }

    @VisibleForTesting
    public void startFpsProfiling() {
    }

    @VisibleForTesting
    public float stopFpsProfiling() {
        return 0.0f;
    }

    @VisibleForTesting
    public void fling(long timeMs, int x, int y, int velocityX, int velocityY) {
        this.mContentViewCore.getContentViewGestureHandler().fling(timeMs, x, y, velocityX, velocityY);
    }

    @VisibleForTesting
    public void pinchBegin(long timeMs, int x, int y) {
        this.mContentViewCore.getContentViewGestureHandler().pinchBegin(timeMs, x, y);
    }

    @VisibleForTesting
    public void pinchEnd(long timeMs) {
        this.mContentViewCore.getContentViewGestureHandler().pinchEnd(timeMs);
    }

    void setIgnoreSingleTap(boolean value) {
        this.mContentViewCore.getContentViewGestureHandler().setIgnoreSingleTap(value);
    }

    @VisibleForTesting
    public void pinchBy(long timeMs, int anchorX, int anchorY, float delta) {
        this.mContentViewCore.getContentViewGestureHandler().pinchBy(timeMs, anchorX, anchorY, delta);
    }

    public void evaluateJavaScript(String script) throws IllegalStateException {
        this.mContentViewCore.evaluateJavaScript(script, null);
    }

    public void onActivityPause() {
        this.mContentViewCore.onActivityPause();
    }

    public void onActivityResume() {
        this.mContentViewCore.onActivityResume();
    }

    public void onShow() {
        this.mContentViewCore.onShow();
    }

    public void onHide() {
        this.mContentViewCore.onHide();
    }

    public ContentSettings getContentSettings() {
        return this.mContentViewCore.getContentSettings();
    }

    public void hideSelectActionBar() {
        this.mContentViewCore.hideSelectActionBar();
    }

    public boolean drawChild(Canvas canvas, View child, long drawingTime) {
        return super.drawChild(canvas, child, drawingTime);
    }

    protected void onSizeChanged(int w, int h, int ow, int oh) {
        TraceEvent.begin();
        super.onSizeChanged(w, h, ow, oh);
        this.mContentViewCore.onSizeChanged(w, h, ow, oh);
        TraceEvent.end();
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        return this.mContentViewCore.onCreateInputConnection(outAttrs);
    }

    public boolean onCheckIsTextEditor() {
        return this.mContentViewCore.onCheckIsTextEditor();
    }

    protected void onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        TraceEvent.begin();
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        this.mContentViewCore.onFocusChanged(gainFocus);
        TraceEvent.end();
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        super.onWindowFocusChanged(hasWindowFocus);
        this.mContentViewCore.onWindowFocusChanged(hasWindowFocus);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.mContentViewCore.onKeyUp(keyCode, event);
    }

    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        return this.mContentViewCore.dispatchKeyEventPreIme(event);
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.isFocused()) {
            return this.mContentViewCore.dispatchKeyEvent(event);
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        MotionEvent offset = this.createOffsetMotionEvent(event);
        boolean consumed = this.mContentViewCore.onTouchEvent(offset);
        offset.recycle();
        return consumed;
    }

    public boolean onHoverEvent(MotionEvent event) {
        MotionEvent offset = this.createOffsetMotionEvent(event);
        boolean consumed = this.mContentViewCore.onHoverEvent(offset);
        offset.recycle();
        return consumed;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        return this.mContentViewCore.onGenericMotionEvent(event);
    }

    public boolean performLongClick() {
        return false;
    }

    public void setCurrentMotionEventOffsets(float dx, float dy) {
        this.mCurrentTouchOffsetX = dx;
        this.mCurrentTouchOffsetY = dy;
    }

    private MotionEvent createOffsetMotionEvent(MotionEvent src) {
        MotionEvent dst = MotionEvent.obtain(src);
        dst.offsetLocation(this.mCurrentTouchOffsetX, this.mCurrentTouchOffsetY);
        return dst;
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        this.mContentViewCore.onConfigurationChanged(newConfig);
    }

    public void scrollBy(int x, int y) {
        this.mContentViewCore.scrollBy(x, y);
    }

    public void scrollTo(int x, int y) {
        this.mContentViewCore.scrollTo(x, y);
    }

    protected int computeHorizontalScrollExtent() {
        return this.mContentViewCore.computeHorizontalScrollExtent();
    }

    protected int computeHorizontalScrollOffset() {
        return this.mContentViewCore.computeHorizontalScrollOffset();
    }

    protected int computeHorizontalScrollRange() {
        return this.mContentViewCore.computeHorizontalScrollRange();
    }

    protected int computeVerticalScrollExtent() {
        return this.mContentViewCore.computeVerticalScrollExtent();
    }

    protected int computeVerticalScrollOffset() {
        return this.mContentViewCore.computeVerticalScrollOffset();
    }

    protected int computeVerticalScrollRange() {
        return this.mContentViewCore.computeVerticalScrollRange();
    }

    public boolean awakenScrollBars(int startDelay, boolean invalidate) {
        return this.mContentViewCore.awakenScrollBars(startDelay, invalidate);
    }

    public boolean awakenScrollBars() {
        return super.awakenScrollBars();
    }

    public int getSingleTapX() {
        return this.mContentViewCore.getContentViewGestureHandler().getSingleTapX();
    }

    public int getSingleTapY() {
        return this.mContentViewCore.getContentViewGestureHandler().getSingleTapY();
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        this.mContentViewCore.onInitializeAccessibilityNodeInfo(info);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        this.mContentViewCore.onInitializeAccessibilityEvent(event);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mContentViewCore.onAttachedToWindow();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mContentViewCore.onDetachedFromWindow();
    }

    protected void onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mContentViewCore.onVisibilityChanged(changedView, visibility);
    }

    public void setDownloadDelegate(ContentViewDownloadDelegate delegate) {
        this.mContentViewCore.setDownloadDelegate(delegate);
    }

    ContentViewDownloadDelegate getDownloadDelegate() {
        return this.mContentViewCore.getDownloadDelegate();
    }

    public boolean getUseDesktopUserAgent() {
        return this.mContentViewCore.getUseDesktopUserAgent();
    }

    public void setUseDesktopUserAgent(boolean override, boolean reloadOnChange) {
        this.mContentViewCore.setUseDesktopUserAgent(override, reloadOnChange);
    }

    public boolean isCrashed() {
        return this.mContentViewCore.isCrashed();
    }

    public boolean needsReload() {
        return this.mContentViewCore.needsReload();
    }

    public float getScale() {
        return this.mContentViewCore.getScale();
    }

    public boolean isReady() {
        return this.mContentViewCore.isReady();
    }

    public boolean isInjectingAccessibilityScript() {
        return this.mContentViewCore.isInjectingAccessibilityScript();
    }

    public void setAccessibilityState(boolean state) {
        this.mContentViewCore.setAccessibilityState(state);
    }

    public void stopCurrentAccessibilityNotifications() {
        this.mContentViewCore.stopCurrentAccessibilityNotifications();
    }

    public void exitFullscreen() {
        this.mContentViewCore.exitFullscreen();
    }

    public int getContentScrollY() {
        return this.mContentViewCore.computeVerticalScrollOffset();
    }

    public int getContentHeight() {
        return this.mContentViewCore.computeVerticalScrollRange();
    }

    public boolean super_onKeyUp(int keyCode, KeyEvent event) {
        return super.onKeyUp(keyCode, event);
    }

    public boolean super_dispatchKeyEventPreIme(KeyEvent event) {
        return super.dispatchKeyEventPreIme(event);
    }

    public boolean super_dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event);
    }

    public boolean super_onGenericMotionEvent(MotionEvent event) {
        return super.onGenericMotionEvent(event);
    }

    public void super_onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
    }

    public boolean super_awakenScrollBars(int startDelay, boolean invalidate) {
        return super.awakenScrollBars(startDelay, invalidate);
    }
}

