/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.content.browser;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.database.ContentObserver;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.RectF;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.provider.Settings;
import android.text.Editable;
import android.util.Log;
import android.util.Pair;
import android.view.ActionMode;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.AbsoluteLayout;
import android.widget.FrameLayout;
import com.google.common.annotations.VisibleForTesting;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.chromium.base.CalledByNative;
import org.chromium.base.JNINamespace;
import org.chromium.base.WeakContext;
import org.chromium.content.R;
import org.chromium.content.browser.ChildProcessLauncher;
import org.chromium.content.browser.ContentSettings;
import org.chromium.content.browser.ContentVideoViewClient;
import org.chromium.content.browser.ContentViewClient;
import org.chromium.content.browser.ContentViewDownloadDelegate;
import org.chromium.content.browser.ContentViewGestureHandler;
import org.chromium.content.browser.DeviceUtils;
import org.chromium.content.browser.HeapStatsLogger;
import org.chromium.content.browser.InterstitialPageDelegateAndroid;
import org.chromium.content.browser.JavascriptInterface;
import org.chromium.content.browser.LoadUrlParams;
import org.chromium.content.browser.NavigationClient;
import org.chromium.content.browser.NavigationEntry;
import org.chromium.content.browser.NavigationHistory;
import org.chromium.content.browser.PopupZoomer;
import org.chromium.content.browser.PositionObserver;
import org.chromium.content.browser.RenderCoordinates;
import org.chromium.content.browser.SelectActionModeCallback;
import org.chromium.content.browser.SmoothScroller;
import org.chromium.content.browser.TouchPoint;
import org.chromium.content.browser.VSyncManager;
import org.chromium.content.browser.ViewPositionObserver;
import org.chromium.content.browser.WebContentsObserverAndroid;
import org.chromium.content.browser.ZoomManager;
import org.chromium.content.browser.accessibility.AccessibilityInjector;
import org.chromium.content.browser.accessibility.BrowserAccessibilityManager;
import org.chromium.content.browser.input.AdapterInputConnection;
import org.chromium.content.browser.input.ImeAdapter;
import org.chromium.content.browser.input.InputMethodManagerWrapper;
import org.chromium.content.browser.input.InsertionHandleController;
import org.chromium.content.browser.input.SelectPopupDialog;
import org.chromium.content.browser.input.SelectionHandleController;
import org.chromium.content.common.TraceEvent;
import org.chromium.ui.ViewAndroid;
import org.chromium.ui.ViewAndroidDelegate;
import org.chromium.ui.WindowAndroid;
import org.chromium.ui.gfx.DeviceDisplayInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JNINamespace(value="content")
public class ContentViewCore
implements ContentViewGestureHandler.MotionEventDelegate,
NavigationClient,
AccessibilityManager.AccessibilityStateChangeListener {
    public static final int INPUT_EVENTS_DELIVERED_AT_VSYNC = 1;
    public static final int INPUT_EVENTS_DELIVERED_IMMEDIATELY = 0;
    private static final String TAG = "ContentViewCore";
    private static final int IS_LONG_PRESS = 1;
    private static final int IS_LONG_TAP = 2;
    private static final int TEXT_HANDLE_FADE_IN_DELAY = 300;
    private final Map<String, Object> mJavaScriptInterfaces = new HashMap<String, Object>();
    private final HashSet<Object> mRetainedJavaScriptObjects = new HashSet();
    private VSyncManager.Provider mVSyncProvider;
    private VSyncManager.Listener mVSyncListener;
    private int mVSyncSubscriberCount;
    private boolean mVSyncListenerRegistered;
    private boolean mDidSignalVSyncUsingInputEvent;
    private final Context mContext;
    private ViewGroup mContainerView;
    private InternalAccessDelegate mContainerViewInternals;
    private WebContentsObserverAndroid mWebContentsObserver;
    private ContentViewClient mContentViewClient;
    private ContentSettings mContentSettings;
    private int mNativeContentViewCore = 0;
    private boolean mAttachedToWindow = false;
    private int mPid = 0;
    private ContentViewGestureHandler mContentViewGestureHandler;
    private GestureStateListener mGestureStateListener;
    private ZoomManager mZoomManager;
    private ZoomControlsDelegate mZoomControlsDelegate;
    private PopupZoomer mPopupZoomer;
    private Runnable mFakeMouseMoveRunnable = null;
    private ImeAdapter mImeAdapter;
    private ImeAdapter.AdapterInputConnectionFactory mAdapterInputConnectionFactory;
    private AdapterInputConnection mInputConnection;
    private SelectionHandleController mSelectionHandleController;
    private InsertionHandleController mInsertionHandleController;
    private Runnable mDeferredHandleFadeInRunnable;
    private PositionObserver mPositionObserver;
    private PositionObserver.Listener mPositionListener;
    private int mViewportWidthPix;
    private int mViewportHeightPix;
    private int mPhysicalBackingWidthPix;
    private int mPhysicalBackingHeightPix;
    private int mOverdrawBottomHeightPix;
    private int mViewportSizeOffsetWidthPix;
    private int mViewportSizeOffsetHeightPix;
    private final RenderCoordinates mRenderCoordinates;
    private final RenderCoordinates.NormalizedPoint mStartHandlePoint;
    private final RenderCoordinates.NormalizedPoint mEndHandlePoint;
    private final RenderCoordinates.NormalizedPoint mInsertionHandlePoint;
    private boolean mHasSelection;
    private String mLastSelectedText;
    private boolean mSelectionEditable;
    private ActionMode mActionMode;
    private boolean mUnselectAllOnActionModeDismiss;
    private ContentViewDownloadDelegate mDownloadDelegate;
    private AccessibilityInjector mAccessibilityInjector;
    private boolean mNativeAccessibilityAllowed;
    private boolean mNativeAccessibilityEnabled;
    private BrowserAccessibilityManager mBrowserAccessibilityManager;
    private final AccessibilityManager mAccessibilityManager;
    private ContentObserver mAccessibilityScriptInjectionObserver;
    private boolean mUnfocusOnNextSizeChanged = false;
    private final Rect mFocusPreOSKViewportRect = new Rect();
    private boolean mNeedUpdateOrientationChanged;
    private boolean mScrolledAndZoomedFocusedEditableNode = false;
    private boolean mHardwareAccelerated = false;
    private boolean mPendingRendererFrame = false;
    private boolean mNeedAnimate = false;
    private ViewAndroid mViewAndroid;

    public VSyncManager.Listener getVSyncListener(VSyncManager.Provider vsyncProvider) {
        if (this.mVSyncProvider != null && this.mVSyncListenerRegistered) {
            this.mVSyncProvider.unregisterVSyncListener(this.mVSyncListener);
            this.mVSyncListenerRegistered = false;
        }
        this.mVSyncProvider = vsyncProvider;
        this.mVSyncListener = new VSyncManager.Listener(){

            public void updateVSync(long tickTimeMicros, long intervalMicros) {
                if (ContentViewCore.this.mNativeContentViewCore != 0) {
                    ContentViewCore.this.nativeUpdateVSyncParameters(ContentViewCore.this.mNativeContentViewCore, tickTimeMicros, intervalMicros);
                }
            }

            public void onVSync(long frameTimeMicros) {
                ContentViewCore.this.animateIfNecessary(frameTimeMicros);
                if (ContentViewCore.this.mDidSignalVSyncUsingInputEvent) {
                    TraceEvent.instant("ContentViewCore::onVSync ignored");
                    ContentViewCore.this.mDidSignalVSyncUsingInputEvent = false;
                    return;
                }
                if (ContentViewCore.this.mNativeContentViewCore != 0) {
                    ContentViewCore.this.nativeOnVSync(ContentViewCore.this.mNativeContentViewCore, frameTimeMicros);
                }
            }
        };
        if (this.mVSyncSubscriberCount > 0) {
            vsyncProvider.registerVSyncListener(this.mVSyncListener);
            this.mVSyncListenerRegistered = true;
        }
        return this.mVSyncListener;
    }

    @CalledByNative
    void setVSyncNotificationEnabled(boolean enabled) {
        if (!this.isVSyncNotificationEnabled() && enabled) {
            this.mDidSignalVSyncUsingInputEvent = false;
        }
        if (this.mVSyncProvider != null) {
            if (!this.mVSyncListenerRegistered && enabled) {
                this.mVSyncProvider.registerVSyncListener(this.mVSyncListener);
                this.mVSyncListenerRegistered = true;
            } else if (this.mVSyncSubscriberCount == 1 && !enabled) {
                assert (this.mVSyncListenerRegistered);
                this.mVSyncProvider.unregisterVSyncListener(this.mVSyncListener);
                this.mVSyncListenerRegistered = false;
            }
        }
        this.mVSyncSubscriberCount += enabled ? 1 : -1;
        assert (this.mVSyncSubscriberCount >= 0);
    }

    @CalledByNative
    private void resetVSyncNotification() {
        while (this.isVSyncNotificationEnabled()) {
            this.setVSyncNotificationEnabled(false);
        }
        this.mVSyncSubscriberCount = 0;
        this.mVSyncListenerRegistered = false;
        this.mNeedAnimate = false;
    }

    private boolean isVSyncNotificationEnabled() {
        return this.mVSyncProvider != null && this.mVSyncListenerRegistered;
    }

    @CalledByNative
    private void setNeedsAnimate() {
        if (!this.mNeedAnimate) {
            this.mNeedAnimate = true;
            this.setVSyncNotificationEnabled(true);
        }
    }

    public ContentViewCore(Context context) {
        this.mContext = context;
        WeakContext.initializeWeakContext(context);
        HeapStatsLogger.init(this.mContext.getApplicationContext());
        this.mAdapterInputConnectionFactory = new ImeAdapter.AdapterInputConnectionFactory();
        this.mRenderCoordinates = new RenderCoordinates();
        this.mRenderCoordinates.setDeviceScaleFactor(this.getContext().getResources().getDisplayMetrics().density);
        this.mStartHandlePoint = this.mRenderCoordinates.createNormalizedPoint();
        this.mEndHandlePoint = this.mRenderCoordinates.createNormalizedPoint();
        this.mInsertionHandlePoint = this.mRenderCoordinates.createNormalizedPoint();
        this.mAccessibilityManager = (AccessibilityManager)this.getContext().getSystemService("accessibility");
    }

    @CalledByNative
    public Context getContext() {
        return this.mContext;
    }

    public ViewGroup getContainerView() {
        return this.mContainerView;
    }

    public void setViewportSizeOffset(int offsetXPix, int offsetYPix) {
        if (offsetXPix != this.mViewportSizeOffsetWidthPix || offsetYPix != this.mViewportSizeOffsetHeightPix) {
            this.mViewportSizeOffsetWidthPix = offsetXPix;
            this.mViewportSizeOffsetHeightPix = offsetYPix;
            if (this.mNativeContentViewCore != 0) {
                this.nativeWasResized(this.mNativeContentViewCore);
            }
        }
    }

    @VisibleForTesting
    public ViewAndroidDelegate getViewAndroidDelegate() {
        return new ViewAndroidDelegate(){

            public View acquireAnchorView() {
                View anchorView = new View(ContentViewCore.this.getContext());
                ContentViewCore.this.mContainerView.addView(anchorView);
                return anchorView;
            }

            public void setAnchorViewPosition(View view, float x, float y, float width, float height) {
                assert (view.getParent() == ContentViewCore.this.mContainerView);
                float scale = (float)DeviceDisplayInfo.create(ContentViewCore.this.getContext()).getDIPScale();
                int leftMargin = Math.round(x * scale);
                int topMargin = Math.round(ContentViewCore.this.mRenderCoordinates.getContentOffsetYPix() + y * scale);
                int scaledWidth = Math.round(width * scale);
                if (ContentViewCore.this.mContainerView instanceof FrameLayout) {
                    if (scaledWidth + leftMargin > ContentViewCore.this.mContainerView.getWidth()) {
                        scaledWidth = ContentViewCore.this.mContainerView.getWidth() - leftMargin;
                    }
                    FrameLayout.LayoutParams lp = new FrameLayout.LayoutParams(scaledWidth, Math.round(height * scale));
                    lp.leftMargin = leftMargin;
                    lp.topMargin = topMargin;
                    view.setLayoutParams(lp);
                } else if (ContentViewCore.this.mContainerView instanceof AbsoluteLayout) {
                    AbsoluteLayout.LayoutParams lp = new AbsoluteLayout.LayoutParams(scaledWidth, (int)(height * scale), leftMargin += ContentViewCore.this.mRenderCoordinates.getScrollXPixInt(), topMargin += ContentViewCore.this.mRenderCoordinates.getScrollYPixInt());
                    view.setLayoutParams(lp);
                } else {
                    Log.e(ContentViewCore.TAG, "Unknown layout " + ContentViewCore.this.mContainerView.getClass().getName());
                }
            }

            public void releaseAnchorView(View anchorView) {
                ContentViewCore.this.mContainerView.removeView(anchorView);
            }
        };
    }

    @VisibleForTesting
    public ImeAdapter getImeAdapterForTest() {
        return this.mImeAdapter;
    }

    @VisibleForTesting
    public void setAdapterInputConnectionFactory(ImeAdapter.AdapterInputConnectionFactory factory) {
        this.mAdapterInputConnectionFactory = factory;
    }

    @VisibleForTesting
    public AdapterInputConnection getInputConnectionForTest() {
        return this.mInputConnection;
    }

    private ImeAdapter createImeAdapter(Context context) {
        return new ImeAdapter(new InputMethodManagerWrapper(context), new ImeAdapter.ImeAdapterDelegate(){

            public void onImeEvent(boolean isFinish) {
                ContentViewCore.this.getContentViewClient().onImeEvent();
                if (!isFinish) {
                    ContentViewCore.this.hideHandles();
                    ContentViewCore.this.undoScrollFocusedEditableNodeIntoViewIfNeeded(false);
                }
            }

            public void onSetFieldValue() {
                ContentViewCore.this.scrollFocusedEditableNodeIntoView();
            }

            public void onDismissInput() {
                ContentViewCore.this.getContentViewClient().onImeStateChangeRequested(false);
            }

            public View getAttachedView() {
                return ContentViewCore.this.mContainerView;
            }

            public ResultReceiver getNewShowKeyboardReceiver() {
                return new ResultReceiver(new Handler()){

                    public void onReceiveResult(int resultCode, Bundle resultData) {
                        ContentViewCore.this.getContentViewClient().onImeStateChangeRequested(resultCode == 2 || resultCode == 0);
                        if (resultCode == 2) {
                            ContentViewCore.this.getContainerView().getWindowVisibleDisplayFrame(ContentViewCore.this.mFocusPreOSKViewportRect);
                        } else if (resultCode == 0) {
                            ContentViewCore.this.scrollFocusedEditableNodeIntoView();
                        } else {
                            ContentViewCore.this.undoScrollFocusedEditableNodeIntoViewIfNeeded(false);
                        }
                    }
                };
            }
        });
    }

    public static boolean hasHardwareAcceleration(Activity activity) {
        Window window = activity.getWindow();
        if (window != null && (window.getAttributes().flags & 0x1000000) != 0) {
            return true;
        }
        try {
            ActivityInfo info = activity.getPackageManager().getActivityInfo(activity.getComponentName(), 0);
            if ((info.flags & 0x200) != 0) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("Chrome", "getActivityInfo(self) should not fail");
        }
        return false;
    }

    private static boolean hasHardwareAcceleration(Context context) {
        if (context instanceof Activity) {
            return ContentViewCore.hasHardwareAcceleration((Activity)context);
        }
        return false;
    }

    public void initialize(ViewGroup containerView, InternalAccessDelegate internalDispatcher, int nativeWebContents, WindowAndroid windowAndroid, int inputEventDeliveryMode) {
        this.mHardwareAccelerated = ContentViewCore.hasHardwareAcceleration(this.mContext);
        this.mContainerView = containerView;
        this.mPositionObserver = new ViewPositionObserver(this.mContainerView);
        this.mPositionListener = new PositionObserver.Listener(){

            public void onPositionChanged(int x, int y) {
                if (ContentViewCore.this.isSelectionHandleShowing() || ContentViewCore.this.isInsertionHandleShowing()) {
                    ContentViewCore.this.temporarilyHideTextHandles();
                }
            }
        };
        int windowNativePointer = windowAndroid != null ? windowAndroid.getNativePointer() : 0;
        int viewAndroidNativePointer = 0;
        if (windowNativePointer != 0) {
            this.mViewAndroid = new ViewAndroid(windowAndroid, this.getViewAndroidDelegate());
            viewAndroidNativePointer = this.mViewAndroid.getNativePointer();
        }
        this.mNativeContentViewCore = this.nativeInit(this.mHardwareAccelerated, nativeWebContents, viewAndroidNativePointer, windowNativePointer);
        this.mContentSettings = new ContentSettings(this, this.mNativeContentViewCore);
        this.initializeContainerView(internalDispatcher, inputEventDeliveryMode);
        this.mAccessibilityInjector = AccessibilityInjector.newInstance(this);
        String contentDescription = "Web View";
        if (R.string.accessibility_content_view == 0) {
            Log.w(TAG, "Setting contentDescription to 'Web View' as no value was specified.");
        } else {
            contentDescription = this.mContext.getResources().getString(R.string.accessibility_content_view);
        }
        this.mContainerView.setContentDescription(contentDescription);
        this.mWebContentsObserver = new WebContentsObserverAndroid(this){

            public void didStartLoading(String url) {
                ContentViewCore.this.hidePopupDialog();
                ContentViewCore.this.resetGestureDetectors();
            }
        };
        this.mPid = this.nativeGetCurrentRenderProcessId(this.mNativeContentViewCore);
    }

    @CalledByNative
    void onNativeContentViewCoreDestroyed(int nativeContentViewCore) {
        assert (nativeContentViewCore == this.mNativeContentViewCore);
        this.mNativeContentViewCore = 0;
    }

    private void initializeContainerView(InternalAccessDelegate internalDispatcher, int inputEventDeliveryMode) {
        TraceEvent.begin();
        this.mContainerViewInternals = internalDispatcher;
        this.mContainerView.setWillNotDraw(false);
        this.mContainerView.setClickable(true);
        this.mZoomManager = new ZoomManager(this.mContext, this);
        this.mContentViewGestureHandler = new ContentViewGestureHandler(this.mContext, this, this.mZoomManager, inputEventDeliveryMode);
        this.mZoomControlsDelegate = new ZoomControlsDelegate(){

            public void invokeZoomPicker() {
            }

            public void dismissZoomPicker() {
            }

            public void updateZoomControls() {
            }
        };
        this.mRenderCoordinates.reset();
        this.initPopupZoomer(this.mContext);
        this.mImeAdapter = this.createImeAdapter(this.mContext);
        TraceEvent.end();
    }

    private void initPopupZoomer(Context context) {
        this.mPopupZoomer = new PopupZoomer(context);
        this.mPopupZoomer.setOnVisibilityChangedListener(new PopupZoomer.OnVisibilityChangedListener(){

            public void onPopupZoomerShown(final PopupZoomer zoomer) {
                ContentViewCore.this.mContainerView.post(new Runnable(){

                    public void run() {
                        if (ContentViewCore.this.mContainerView.indexOfChild(zoomer) == -1) {
                            ContentViewCore.this.mContainerView.addView(zoomer);
                        } else assert (false) : "PopupZoomer should never be shown without being hidden";
                    }
                });
            }

            public void onPopupZoomerHidden(final PopupZoomer zoomer) {
                ContentViewCore.this.mContainerView.post(new Runnable(){

                    public void run() {
                        if (ContentViewCore.this.mContainerView.indexOfChild(zoomer) != -1) {
                            ContentViewCore.this.mContainerView.removeView(zoomer);
                            ContentViewCore.this.mContainerView.invalidate();
                        } else assert (false) : "PopupZoomer should never be hidden without being shown";
                    }
                });
            }
        });
        PopupZoomer.OnTapListener listener = new PopupZoomer.OnTapListener(){

            public boolean onSingleTap(View v, MotionEvent e) {
                ContentViewCore.this.mContainerView.requestFocus();
                if (ContentViewCore.this.mNativeContentViewCore != 0) {
                    ContentViewCore.this.nativeSingleTap(ContentViewCore.this.mNativeContentViewCore, e.getEventTime(), e.getX(), e.getY(), true);
                }
                return true;
            }

            public boolean onLongPress(View v, MotionEvent e) {
                if (ContentViewCore.this.mNativeContentViewCore != 0) {
                    ContentViewCore.this.nativeLongPress(ContentViewCore.this.mNativeContentViewCore, e.getEventTime(), e.getX(), e.getY(), true);
                }
                return true;
            }
        };
        this.mPopupZoomer.setOnTapListener(listener);
    }

    public void destroy() {
        if (this.mNativeContentViewCore != 0) {
            this.nativeOnJavaContentViewCoreDestroyed(this.mNativeContentViewCore);
        }
        this.resetVSyncNotification();
        this.mVSyncProvider = null;
        if (this.mViewAndroid != null) {
            this.mViewAndroid.destroy();
        }
        this.mNativeContentViewCore = 0;
        this.mContentSettings = null;
        this.mJavaScriptInterfaces.clear();
        this.mRetainedJavaScriptObjects.clear();
        this.unregisterAccessibilityContentObserver();
    }

    private void unregisterAccessibilityContentObserver() {
        if (this.mAccessibilityScriptInjectionObserver == null) {
            return;
        }
        this.getContext().getContentResolver().unregisterContentObserver(this.mAccessibilityScriptInjectionObserver);
        this.mAccessibilityScriptInjectionObserver = null;
    }

    public boolean isAlive() {
        return this.mNativeContentViewCore != 0;
    }

    @CalledByNative
    public int getNativeContentViewCore() {
        return this.mNativeContentViewCore;
    }

    void checkIsAlive() throws IllegalStateException {
        if (!this.isAlive()) {
            throw new IllegalStateException("ContentView used after destroy() was called");
        }
    }

    public void setContentViewClient(ContentViewClient client) {
        if (client == null) {
            throw new IllegalArgumentException("The client can't be null.");
        }
        this.mContentViewClient = client;
    }

    ContentViewClient getContentViewClient() {
        if (this.mContentViewClient == null) {
            this.mContentViewClient = new ContentViewClient();
        }
        return this.mContentViewClient;
    }

    public int getBackgroundColor() {
        if (this.mNativeContentViewCore != 0) {
            return this.nativeGetBackgroundColor(this.mNativeContentViewCore);
        }
        return -1;
    }

    @CalledByNative
    private void onBackgroundColorChanged(int color2) {
        this.getContentViewClient().onBackgroundColorChanged(color2);
    }

    public void loadUrl(LoadUrlParams params) {
        if (this.mNativeContentViewCore == 0) {
            return;
        }
        this.nativeLoadUrl(this.mNativeContentViewCore, params.mUrl, params.mLoadUrlType, params.mTransitionType, params.mUaOverrideOption, params.getExtraHeadersString(), params.mPostData, params.mBaseUrlForDataUrl, params.mVirtualUrlForDataUrl, params.mCanLoadLocalResources);
    }

    public void stopLoading() {
        if (this.mNativeContentViewCore != 0) {
            this.nativeStopLoading(this.mNativeContentViewCore);
        }
    }

    public String getUrl() {
        if (this.mNativeContentViewCore != 0) {
            return this.nativeGetURL(this.mNativeContentViewCore);
        }
        return null;
    }

    public String getTitle() {
        if (this.mNativeContentViewCore != 0) {
            return this.nativeGetTitle(this.mNativeContentViewCore);
        }
        return null;
    }

    @VisibleForTesting
    public void showInterstitialPage(String url, InterstitialPageDelegateAndroid delegate) {
        if (this.mNativeContentViewCore == 0) {
            return;
        }
        this.nativeShowInterstitialPage(this.mNativeContentViewCore, url, delegate.getNative());
    }

    public boolean isShowingInterstitialPage() {
        return this.mNativeContentViewCore == 0 ? false : this.nativeIsShowingInterstitialPage(this.mNativeContentViewCore);
    }

    public boolean consumePendingRendererFrame() {
        boolean hadPendingFrame = this.mPendingRendererFrame;
        this.mPendingRendererFrame = false;
        return hadPendingFrame;
    }

    @CalledByNative
    public int getViewportWidthPix() {
        return this.mViewportWidthPix;
    }

    @CalledByNative
    public int getViewportHeightPix() {
        return this.mViewportHeightPix;
    }

    @CalledByNative
    public int getPhysicalBackingWidthPix() {
        return this.mPhysicalBackingWidthPix;
    }

    @CalledByNative
    public int getPhysicalBackingHeightPix() {
        return this.mPhysicalBackingHeightPix;
    }

    @CalledByNative
    public int getOverdrawBottomHeightPix() {
        return this.mOverdrawBottomHeightPix;
    }

    @CalledByNative
    public int getViewportSizeOffsetWidthPix() {
        return this.mViewportSizeOffsetWidthPix;
    }

    @CalledByNative
    public int getViewportSizeOffsetHeightPix() {
        return this.mViewportSizeOffsetHeightPix;
    }

    public float getContentHeightCss() {
        return this.mRenderCoordinates.getContentHeightCss();
    }

    public float getContentWidthCss() {
        return this.mRenderCoordinates.getContentWidthCss();
    }

    public Bitmap getBitmap() {
        return this.getBitmap(this.getViewportWidthPix(), this.getViewportHeightPix());
    }

    public Bitmap getBitmap(int width, int height) {
        if (width == 0 || height == 0 || this.getViewportWidthPix() == 0 || this.getViewportHeightPix() == 0) {
            return null;
        }
        Bitmap b = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
        if (this.mNativeContentViewCore != 0 && this.nativePopulateBitmapFromCompositor(this.mNativeContentViewCore, b)) {
            if (this.mContainerView.getChildCount() > 0) {
                Canvas c = new Canvas(b);
                c.scale((float)width / (float)this.getViewportWidthPix(), (float)height / (float)this.getViewportHeightPix());
                this.mContainerView.draw(c);
            }
            return b;
        }
        return null;
    }

    public Pair<Bitmap, Float> getScaledPerformanceOptimizedBitmap(int width, int height) {
        float scale = 1.0f;
        if (DeviceUtils.isTablet(this.getContext())) {
            scale = this.getContext().getResources().getDisplayMetrics().density;
        }
        return Pair.create(this.getBitmap((int)((float)width / scale), (int)((float)height / scale)), Float.valueOf(scale));
    }

    public boolean canGoBack() {
        return this.mNativeContentViewCore != 0 && this.nativeCanGoBack(this.mNativeContentViewCore);
    }

    public boolean canGoForward() {
        return this.mNativeContentViewCore != 0 && this.nativeCanGoForward(this.mNativeContentViewCore);
    }

    public boolean canGoToOffset(int offset) {
        return this.mNativeContentViewCore != 0 && this.nativeCanGoToOffset(this.mNativeContentViewCore, offset);
    }

    public void goToOffset(int offset) {
        if (this.mNativeContentViewCore != 0) {
            this.nativeGoToOffset(this.mNativeContentViewCore, offset);
        }
    }

    @Override
    public void goToNavigationIndex(int index) {
        if (this.mNativeContentViewCore != 0) {
            this.nativeGoToNavigationIndex(this.mNativeContentViewCore, index);
        }
    }

    public void goBack() {
        if (this.mNativeContentViewCore != 0) {
            this.nativeGoBack(this.mNativeContentViewCore);
        }
    }

    public void goForward() {
        if (this.mNativeContentViewCore != 0) {
            this.nativeGoForward(this.mNativeContentViewCore);
        }
    }

    public void reload() {
        this.mAccessibilityInjector.addOrRemoveAccessibilityApisIfNecessary();
        if (this.mNativeContentViewCore != 0) {
            this.nativeReload(this.mNativeContentViewCore);
        }
    }

    public void cancelPendingReload() {
        if (this.mNativeContentViewCore != 0) {
            this.nativeCancelPendingReload(this.mNativeContentViewCore);
        }
    }

    public void continuePendingReload() {
        if (this.mNativeContentViewCore != 0) {
            this.nativeContinuePendingReload(this.mNativeContentViewCore);
        }
    }

    public void clearHistory() {
        if (this.mNativeContentViewCore != 0) {
            this.nativeClearHistory(this.mNativeContentViewCore);
        }
    }

    public String getSelectedText() {
        return this.mHasSelection ? this.mLastSelectedText : "";
    }

    public boolean isSelectionEditable() {
        return this.mHasSelection ? this.mSelectionEditable : false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.undoScrollFocusedEditableNodeIntoViewIfNeeded(false);
        return this.mContentViewGestureHandler.onTouchEvent(event);
    }

    ContentViewGestureHandler getContentViewGestureHandler() {
        return this.mContentViewGestureHandler;
    }

    @Override
    public boolean sendTouchEvent(long timeMs, int action, TouchPoint[] pts) {
        if (this.mNativeContentViewCore != 0) {
            return this.nativeSendTouchEvent(this.mNativeContentViewCore, timeMs, action, pts);
        }
        return false;
    }

    @CalledByNative
    private void hasTouchEventHandlers(boolean hasTouchHandlers) {
        this.mContentViewGestureHandler.hasTouchEventHandlers(hasTouchHandlers);
    }

    @CalledByNative
    private void confirmTouchEvent(int ackResult) {
        this.mContentViewGestureHandler.confirmTouchEvent(ackResult);
    }

    @CalledByNative
    private void unhandledFlingStartEvent() {
        if (this.mGestureStateListener != null) {
            this.mGestureStateListener.onUnhandledFlingStartEvent();
        }
    }

    @CalledByNative
    private void onScrollUpdateGestureConsumed() {
        if (this.mGestureStateListener != null) {
            this.mGestureStateListener.onScrollUpdateGestureConsumed();
        }
    }

    @Override
    public boolean sendGesture(int type, long timeMs, int x, int y, boolean lastInputEventForVSync, Bundle b) {
        if (this.offerGestureToEmbedder(type)) {
            return false;
        }
        if (this.mNativeContentViewCore == 0) {
            return false;
        }
        this.updateTextHandlesForGesture(type);
        this.updateGestureStateListener(type, b);
        if (lastInputEventForVSync && this.isVSyncNotificationEnabled()) {
            assert (type == 7 || type == 12);
            this.mDidSignalVSyncUsingInputEvent = true;
        }
        switch (type) {
            case 0: {
                this.nativeShowPressState(this.mNativeContentViewCore, timeMs, x, y);
                return true;
            }
            case 14: {
                this.nativeShowPressCancel(this.mNativeContentViewCore, timeMs, x, y);
                return true;
            }
            case 1: {
                this.nativeDoubleTap(this.mNativeContentViewCore, timeMs, x, y);
                return true;
            }
            case 2: {
                this.nativeSingleTap(this.mNativeContentViewCore, timeMs, x, y, false);
                return true;
            }
            case 3: {
                this.handleTapOrPress(timeMs, x, y, 0, b.getBoolean("ShowPress", false));
                return true;
            }
            case 4: {
                this.nativeSingleTapUnconfirmed(this.mNativeContentViewCore, timeMs, x, y);
                return true;
            }
            case 5: {
                this.handleTapOrPress(timeMs, x, y, 1, false);
                return true;
            }
            case 15: {
                this.handleTapOrPress(timeMs, x, y, 2, false);
                return true;
            }
            case 6: {
                this.nativeScrollBegin(this.mNativeContentViewCore, timeMs, x, y);
                return true;
            }
            case 7: {
                int dx = b.getInt("Distance X");
                int dy = b.getInt("Distance Y");
                this.nativeScrollBy(this.mNativeContentViewCore, timeMs, x, y, dx, dy, lastInputEventForVSync);
                return true;
            }
            case 8: {
                this.nativeScrollEnd(this.mNativeContentViewCore, timeMs);
                return true;
            }
            case 9: {
                this.nativeFlingStart(this.mNativeContentViewCore, timeMs, x, y, b.getInt("Velocity X", 0), b.getInt("Velocity Y", 0));
                return true;
            }
            case 10: {
                this.nativeFlingCancel(this.mNativeContentViewCore, timeMs);
                return true;
            }
            case 11: {
                this.nativePinchBegin(this.mNativeContentViewCore, timeMs, x, y);
                return true;
            }
            case 12: {
                this.nativePinchBy(this.mNativeContentViewCore, timeMs, x, y, b.getFloat("Delta", 0.0f), lastInputEventForVSync);
                return true;
            }
            case 13: {
                this.nativePinchEnd(this.mNativeContentViewCore, timeMs);
                return true;
            }
        }
        return false;
    }

    public void setGestureStateListener(GestureStateListener pinchGestureStateListener) {
        this.mGestureStateListener = pinchGestureStateListener;
    }

    void updateGestureStateListener(int gestureType, Bundle b) {
        if (this.mGestureStateListener == null) {
            return;
        }
        switch (gestureType) {
            case 11: {
                this.mGestureStateListener.onPinchGestureStart();
                break;
            }
            case 13: {
                this.mGestureStateListener.onPinchGestureEnd();
                break;
            }
            case 9: {
                this.mGestureStateListener.onFlingStartGesture(b.getInt("Velocity X", 0), b.getInt("Velocity Y", 0));
                break;
            }
            case 10: {
                this.mGestureStateListener.onFlingCancelGesture();
                break;
            }
        }
    }

    public void evaluateJavaScript(String script, JavaScriptCallback callback) {
        if (this.mNativeContentViewCore == 0) {
            return;
        }
        this.nativeEvaluateJavaScript(this.mNativeContentViewCore, script, callback, false);
    }

    public void evaluateJavaScriptEvenIfNotYetNavigated(String script) {
        if (this.mNativeContentViewCore == 0) {
            return;
        }
        this.nativeEvaluateJavaScript(this.mNativeContentViewCore, script, null, true);
    }

    public void onActivityPause() {
        TraceEvent.begin();
        this.hidePopupDialog();
        this.nativeOnHide(this.mNativeContentViewCore);
        TraceEvent.end();
    }

    public void onActivityResume() {
        this.nativeOnShow(this.mNativeContentViewCore);
        this.setAccessibilityState(this.mAccessibilityManager.isEnabled());
    }

    public void onShow() {
        this.nativeOnShow(this.mNativeContentViewCore);
        this.setAccessibilityState(this.mAccessibilityManager.isEnabled());
    }

    public void onHide() {
        this.hidePopupDialog();
        this.setInjectedAccessibility(false);
        this.nativeOnHide(this.mNativeContentViewCore);
    }

    public ContentSettings getContentSettings() {
        return this.mContentSettings;
    }

    @Override
    public boolean didUIStealScroll(float x, float y) {
        return this.getContentViewClient().shouldOverrideScroll(x, y, this.computeHorizontalScrollOffset(), this.computeVerticalScrollOffset());
    }

    @Override
    public boolean hasFixedPageScale() {
        return this.mRenderCoordinates.hasFixedPageScale();
    }

    private void hidePopupDialog() {
        SelectPopupDialog.hide(this);
        this.hideHandles();
        this.hideSelectActionBar();
    }

    void hideSelectActionBar() {
        if (this.mActionMode != null) {
            this.mActionMode.finish();
            this.mActionMode = null;
        }
    }

    public boolean isSelectActionBarShowing() {
        return this.mActionMode != null;
    }

    private void resetGestureDetectors() {
        this.mContentViewGestureHandler.resetGestureHandlers();
    }

    public void onAttachedToWindow() {
        this.mAttachedToWindow = true;
        if (this.mNativeContentViewCore != 0) {
            assert (this.mPid == this.nativeGetCurrentRenderProcessId(this.mNativeContentViewCore));
            ChildProcessLauncher.bindAsHighPriority(this.mPid);
            ChildProcessLauncher.removeInitialBinding(this.mPid);
        }
        this.setAccessibilityState(this.mAccessibilityManager.isEnabled());
    }

    public void onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        if (this.mNativeContentViewCore != 0) {
            assert (this.mPid == this.nativeGetCurrentRenderProcessId(this.mNativeContentViewCore));
            ChildProcessLauncher.unbindAsHighPriority(this.mPid);
        }
        this.setInjectedAccessibility(false);
        this.hidePopupDialog();
        this.mZoomControlsDelegate.dismissZoomPicker();
        this.unregisterAccessibilityContentObserver();
    }

    public void onVisibilityChanged(View changedView, int visibility) {
        if (visibility != 0) {
            this.mZoomControlsDelegate.dismissZoomPicker();
        }
    }

    public InputConnection onCreateInputConnection(EditorInfo outAttrs) {
        if (!this.mImeAdapter.hasTextInputType()) {
            outAttrs.imeOptions = 0x2000000;
        }
        this.mInputConnection = this.mAdapterInputConnectionFactory.get(this.mContainerView, this.mImeAdapter, outAttrs);
        return this.mInputConnection;
    }

    public Editable getEditableForTest() {
        return this.mInputConnection.getEditable();
    }

    public boolean onCheckIsTextEditor() {
        return this.mImeAdapter.hasTextInputType();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        TraceEvent.begin();
        if (newConfig.keyboard != 1) {
            this.mImeAdapter.attach(this.nativeGetNativeImeAdapter(this.mNativeContentViewCore), ImeAdapter.getTextInputTypeNone(), -1, -1);
            InputMethodManager manager = (InputMethodManager)this.getContext().getSystemService("input_method");
            manager.restartInput(this.mContainerView);
        }
        this.mContainerViewInternals.super_onConfigurationChanged(newConfig);
        this.mNeedUpdateOrientationChanged = true;
        TraceEvent.end();
    }

    public void onSizeChanged(int wPix, int hPix, int owPix, int ohPix) {
        if (this.getViewportWidthPix() == wPix && this.getViewportHeightPix() == hPix) {
            return;
        }
        this.mViewportWidthPix = wPix;
        this.mViewportHeightPix = hPix;
        if (this.mNativeContentViewCore != 0) {
            this.nativeWasResized(this.mNativeContentViewCore);
        }
        this.updateAfterSizeChanged();
    }

    public void onPhysicalBackingSizeChanged(int wPix, int hPix) {
        if (this.mPhysicalBackingWidthPix == wPix && this.mPhysicalBackingHeightPix == hPix) {
            return;
        }
        this.mPhysicalBackingWidthPix = wPix;
        this.mPhysicalBackingHeightPix = hPix;
        if (this.mNativeContentViewCore != 0) {
            this.nativeWasResized(this.mNativeContentViewCore);
        }
    }

    public void onOverdrawBottomHeightChanged(int overdrawHeightPix) {
        if (this.mOverdrawBottomHeightPix == overdrawHeightPix) {
            return;
        }
        this.mOverdrawBottomHeightPix = overdrawHeightPix;
        if (this.mNativeContentViewCore != 0) {
            this.nativeWasResized(this.mNativeContentViewCore);
        }
    }

    private void updateAfterSizeChanged() {
        this.mPopupZoomer.hide(false);
        if (!this.mFocusPreOSKViewportRect.isEmpty()) {
            Rect rect = new Rect();
            this.getContainerView().getWindowVisibleDisplayFrame(rect);
            if (!rect.equals(this.mFocusPreOSKViewportRect)) {
                if (rect.width() == this.mFocusPreOSKViewportRect.width()) {
                    this.scrollFocusedEditableNodeIntoView();
                }
                this.mFocusPreOSKViewportRect.setEmpty();
            }
        } else if (this.mUnfocusOnNextSizeChanged) {
            this.undoScrollFocusedEditableNodeIntoViewIfNeeded(true);
            this.mUnfocusOnNextSizeChanged = false;
        }
        if (this.mNeedUpdateOrientationChanged) {
            this.sendOrientationChangeEvent();
            this.mNeedUpdateOrientationChanged = false;
        }
    }

    private void scrollFocusedEditableNodeIntoView() {
        if (this.mNativeContentViewCore != 0) {
            Runnable scrollTask = new Runnable(){

                public void run() {
                    if (ContentViewCore.this.mNativeContentViewCore != 0) {
                        ContentViewCore.this.nativeScrollFocusedEditableNodeIntoView(ContentViewCore.this.mNativeContentViewCore);
                    }
                }
            };
            scrollTask.run();
            this.mScrolledAndZoomedFocusedEditableNode = true;
        }
    }

    private void undoScrollFocusedEditableNodeIntoViewIfNeeded(boolean backButtonPressed) {
        if (this.mScrolledAndZoomedFocusedEditableNode && backButtonPressed && this.mNativeContentViewCore != 0) {
            Runnable scrollTask = new Runnable(){

                public void run() {
                    if (ContentViewCore.this.mNativeContentViewCore != 0) {
                        ContentViewCore.this.nativeUndoScrollFocusedEditableNodeIntoView(ContentViewCore.this.mNativeContentViewCore);
                    }
                }
            };
            scrollTask.run();
        }
        this.mScrolledAndZoomedFocusedEditableNode = false;
    }

    public void onWindowFocusChanged(boolean hasWindowFocus) {
        if (!hasWindowFocus) {
            this.mContentViewGestureHandler.onWindowFocusLost();
        }
    }

    public void onFocusChanged(boolean gainFocus) {
        if (!gainFocus) {
            this.getContentViewClient().onImeStateChangeRequested(false);
        }
        if (this.mNativeContentViewCore != 0) {
            this.nativeSetFocus(this.mNativeContentViewCore, gainFocus);
        }
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.mPopupZoomer.isShowing() && keyCode == 4) {
            this.mPopupZoomer.hide(true);
            return true;
        }
        return this.mContainerViewInternals.super_onKeyUp(keyCode, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchKeyEventPreIme(KeyEvent event) {
        try {
            TraceEvent.begin();
            if (event.getKeyCode() == 4 && this.mImeAdapter.isActive()) {
                this.mUnfocusOnNextSizeChanged = true;
            } else {
                this.undoScrollFocusedEditableNodeIntoViewIfNeeded(false);
            }
            boolean bl = this.mContainerViewInternals.super_dispatchKeyEventPreIme(event);
            return bl;
        }
        finally {
            TraceEvent.end();
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.getContentViewClient().shouldOverrideKeyEvent(event)) {
            return this.mContainerViewInternals.super_dispatchKeyEvent(event);
        }
        if (this.mImeAdapter.dispatchKeyEvent(event)) {
            return true;
        }
        return this.mContainerViewInternals.super_dispatchKeyEvent(event);
    }

    public boolean onHoverEvent(MotionEvent event) {
        TraceEvent.begin("onHoverEvent");
        this.mContainerView.removeCallbacks(this.mFakeMouseMoveRunnable);
        if (this.mBrowserAccessibilityManager != null) {
            return this.mBrowserAccessibilityManager.onHoverEvent(event);
        }
        if (this.mNativeContentViewCore != 0) {
            this.nativeSendMouseMoveEvent(this.mNativeContentViewCore, event.getEventTime(), event.getX(), event.getY());
        }
        TraceEvent.end("onHoverEvent");
        return true;
    }

    public boolean onGenericMotionEvent(MotionEvent event) {
        if ((event.getSource() & 2) != 0) {
            switch (event.getAction()) {
                case 8: {
                    this.nativeSendMouseWheelEvent(this.mNativeContentViewCore, event.getEventTime(), event.getX(), event.getY(), event.getAxisValue(9));
                    this.mContainerView.removeCallbacks(this.mFakeMouseMoveRunnable);
                    final MotionEvent eventFakeMouseMove = MotionEvent.obtain(event);
                    this.mFakeMouseMoveRunnable = new Runnable(){

                        public void run() {
                            ContentViewCore.this.onHoverEvent(eventFakeMouseMove);
                        }
                    };
                    this.mContainerView.postDelayed(this.mFakeMouseMoveRunnable, 250L);
                    return true;
                }
            }
        }
        return this.mContainerViewInternals.super_onGenericMotionEvent(event);
    }

    public void scrollBy(int xPix, int yPix) {
        if (this.mNativeContentViewCore != 0) {
            this.nativeScrollBy(this.mNativeContentViewCore, System.currentTimeMillis(), 0.0f, 0.0f, xPix, yPix, false);
        }
    }

    public void scrollTo(int xPix, int yPix) {
        if (this.mNativeContentViewCore == 0) {
            return;
        }
        float xCurrentPix = this.mRenderCoordinates.getScrollXPix();
        float yCurrentPix = this.mRenderCoordinates.getScrollYPix();
        float dxPix = (float)xPix - xCurrentPix;
        float dyPix = (float)yPix - yCurrentPix;
        if (dxPix != 0.0f || dyPix != 0.0f) {
            long time = System.currentTimeMillis();
            this.nativeScrollBegin(this.mNativeContentViewCore, time, xCurrentPix, yCurrentPix);
            this.nativeScrollBy(this.mNativeContentViewCore, time, xCurrentPix, yCurrentPix, dxPix, dyPix, false);
            this.nativeScrollEnd(this.mNativeContentViewCore, time);
        }
    }

    public int getNativeScrollXForTest() {
        return this.mRenderCoordinates.getScrollXPixInt();
    }

    public int getNativeScrollYForTest() {
        return this.mRenderCoordinates.getScrollYPixInt();
    }

    public int computeHorizontalScrollExtent() {
        return this.mRenderCoordinates.getLastFrameViewportWidthPixInt();
    }

    public int computeHorizontalScrollOffset() {
        return this.mRenderCoordinates.getScrollXPixInt();
    }

    public int computeHorizontalScrollRange() {
        return this.mRenderCoordinates.getContentWidthPixInt();
    }

    public int computeVerticalScrollExtent() {
        return this.mRenderCoordinates.getLastFrameViewportHeightPixInt();
    }

    public int computeVerticalScrollOffset() {
        return this.mRenderCoordinates.getScrollYPixInt();
    }

    public int computeVerticalScrollRange() {
        return this.mRenderCoordinates.getContentHeightPixInt();
    }

    public boolean awakenScrollBars(int startDelay, boolean invalidate) {
        if (this.mContainerView.getScrollBarStyle() == 0) {
            return false;
        }
        return this.mContainerViewInternals.super_awakenScrollBars(startDelay, invalidate);
    }

    @CalledByNative
    private void onTabCrash(boolean alreadyCrashed) {
        assert (this.mPid != 0);
        if (!alreadyCrashed) {
            this.getContentViewClient().onRendererCrash(ChildProcessLauncher.isOomProtected(this.mPid));
        }
        this.mPid = 0;
    }

    private void handleTapOrPress(long timeMs, float xPix, float yPix, int isLongPressOrTap, boolean showPress) {
        if (this.mContainerView.isFocusable() && this.mContainerView.isFocusableInTouchMode() && !this.mContainerView.isFocused()) {
            this.mContainerView.requestFocus();
        }
        if (!this.mPopupZoomer.isShowing()) {
            this.mPopupZoomer.setLastTouch(xPix, yPix);
        }
        if (isLongPressOrTap == 1) {
            this.getInsertionHandleController().allowAutomaticShowing();
            this.getSelectionHandleController().allowAutomaticShowing();
            if (this.mNativeContentViewCore != 0) {
                this.nativeLongPress(this.mNativeContentViewCore, timeMs, xPix, yPix, false);
            }
        } else if (isLongPressOrTap == 2) {
            this.getInsertionHandleController().allowAutomaticShowing();
            this.getSelectionHandleController().allowAutomaticShowing();
            if (this.mNativeContentViewCore != 0) {
                this.nativeLongTap(this.mNativeContentViewCore, timeMs, xPix, yPix, false);
            }
        } else {
            if (!showPress && this.mNativeContentViewCore != 0) {
                this.nativeShowPressState(this.mNativeContentViewCore, timeMs, xPix, yPix);
            }
            if (this.mSelectionEditable) {
                this.getInsertionHandleController().allowAutomaticShowing();
            }
            if (this.mNativeContentViewCore != 0) {
                this.nativeSingleTap(this.mNativeContentViewCore, timeMs, xPix, yPix, false);
            }
        }
    }

    public void setZoomControlsDelegate(ZoomControlsDelegate zoomControlsDelegate) {
        this.mZoomControlsDelegate = zoomControlsDelegate;
    }

    public void updateMultiTouchZoomSupport(boolean supportsMultiTouchZoom) {
        this.mZoomManager.updateMultiTouchSupport(supportsMultiTouchZoom);
    }

    public void updateDoubleTapDragSupport(boolean supportsDoubleTapDrag) {
        this.mContentViewGestureHandler.updateDoubleTapDragSupport(supportsDoubleTapDrag);
    }

    public void selectPopupMenuItems(int[] indices) {
        if (this.mNativeContentViewCore != 0) {
            this.nativeSelectPopupMenuItems(this.mNativeContentViewCore, indices);
        }
    }

    private void sendOrientationChangeEvent() {
        if (this.mNativeContentViewCore == 0) {
            return;
        }
        WindowManager windowManager = (WindowManager)this.getContext().getSystemService("window");
        switch (windowManager.getDefaultDisplay().getRotation()) {
            case 1: {
                this.nativeSendOrientationChangeEvent(this.mNativeContentViewCore, 90);
                break;
            }
            case 2: {
                this.nativeSendOrientationChangeEvent(this.mNativeContentViewCore, 180);
                break;
            }
            case 3: {
                this.nativeSendOrientationChangeEvent(this.mNativeContentViewCore, -90);
                break;
            }
            case 0: {
                this.nativeSendOrientationChangeEvent(this.mNativeContentViewCore, 0);
                break;
            }
            default: {
                Log.w(TAG, "Unknown rotation!");
            }
        }
    }

    public void setDownloadDelegate(ContentViewDownloadDelegate delegate) {
        this.mDownloadDelegate = delegate;
    }

    ContentViewDownloadDelegate getDownloadDelegate() {
        return this.mDownloadDelegate;
    }

    private SelectionHandleController getSelectionHandleController() {
        if (this.mSelectionHandleController == null) {
            this.mSelectionHandleController = new SelectionHandleController(this.getContainerView(), this.mPositionObserver){

                public void selectBetweenCoordinates(int x1, int y1, int x2, int y2) {
                    if (ContentViewCore.this.mNativeContentViewCore != 0 && (x1 != x2 || y1 != y2)) {
                        ContentViewCore.this.nativeSelectBetweenCoordinates(ContentViewCore.this.mNativeContentViewCore, x1, (float)y1 - ContentViewCore.this.mRenderCoordinates.getContentOffsetYPix(), x2, (float)y2 - ContentViewCore.this.mRenderCoordinates.getContentOffsetYPix());
                    }
                }

                public void showHandles(int startDir, int endDir) {
                    super.showHandles(startDir, endDir);
                    ContentViewCore.this.showSelectActionBar();
                }
            };
            this.mSelectionHandleController.hideAndDisallowAutomaticShowing();
        }
        return this.mSelectionHandleController;
    }

    private InsertionHandleController getInsertionHandleController() {
        if (this.mInsertionHandleController == null) {
            this.mInsertionHandleController = new InsertionHandleController(this.getContainerView(), this.mPositionObserver){
                private static final int AVERAGE_LINE_HEIGHT = 14;

                public void setCursorPosition(int x, int y) {
                    if (ContentViewCore.this.mNativeContentViewCore != 0) {
                        ContentViewCore.this.nativeMoveCaret(ContentViewCore.this.mNativeContentViewCore, x, (float)y - ContentViewCore.this.mRenderCoordinates.getContentOffsetYPix());
                    }
                }

                public void paste() {
                    ContentViewCore.this.mImeAdapter.paste();
                    ContentViewCore.this.hideHandles();
                }

                public int getLineHeight() {
                    return (int)Math.ceil(ContentViewCore.this.mRenderCoordinates.fromLocalCssToPix(14.0f));
                }

                public void showHandle() {
                    super.showHandle();
                }
            };
            this.mInsertionHandleController.hideAndDisallowAutomaticShowing();
        }
        return this.mInsertionHandleController;
    }

    @VisibleForTesting
    public InsertionHandleController getInsertionHandleControllerForTest() {
        return this.mInsertionHandleController;
    }

    @VisibleForTesting
    public SelectionHandleController getSelectionHandleControllerForTest() {
        return this.mSelectionHandleController;
    }

    private void updateHandleScreenPositions() {
        if (this.isSelectionHandleShowing()) {
            this.mSelectionHandleController.setStartHandlePosition(this.mStartHandlePoint.getXPix(), this.mStartHandlePoint.getYPix());
            this.mSelectionHandleController.setEndHandlePosition(this.mEndHandlePoint.getXPix(), this.mEndHandlePoint.getYPix());
        }
        if (this.isInsertionHandleShowing()) {
            this.mInsertionHandleController.setHandlePosition(this.mInsertionHandlePoint.getXPix(), this.mInsertionHandlePoint.getYPix());
        }
    }

    private void hideHandles() {
        if (this.mSelectionHandleController != null) {
            this.mSelectionHandleController.hideAndDisallowAutomaticShowing();
        }
        if (this.mInsertionHandleController != null) {
            this.mInsertionHandleController.hideAndDisallowAutomaticShowing();
        }
        this.mPositionObserver.removeListener(this.mPositionListener);
    }

    private void showSelectActionBar() {
        if (this.mActionMode != null) {
            this.mActionMode.invalidate();
            return;
        }
        SelectActionModeCallback.ActionHandler actionHandler = new SelectActionModeCallback.ActionHandler(){

            public boolean selectAll() {
                return ContentViewCore.this.mImeAdapter.selectAll();
            }

            public boolean cut() {
                return ContentViewCore.this.mImeAdapter.cut();
            }

            public boolean copy() {
                return ContentViewCore.this.mImeAdapter.copy();
            }

            public boolean paste() {
                return ContentViewCore.this.mImeAdapter.paste();
            }

            public boolean isSelectionEditable() {
                return ContentViewCore.this.mSelectionEditable;
            }

            public String getSelectedText() {
                return ContentViewCore.this.getSelectedText();
            }

            public void onDestroyActionMode() {
                ContentViewCore.this.mActionMode = null;
                if (ContentViewCore.this.mUnselectAllOnActionModeDismiss) {
                    ContentViewCore.this.mImeAdapter.unselect();
                }
                ContentViewCore.this.getContentViewClient().onContextualActionBarHidden();
            }
        };
        this.mActionMode = null;
        if (this.mContainerView.getParent() != null) {
            this.mActionMode = this.mContainerView.startActionMode(this.getContentViewClient().getSelectActionModeCallback(this.getContext(), actionHandler, this.nativeIsIncognito(this.mNativeContentViewCore)));
        }
        this.mUnselectAllOnActionModeDismiss = true;
        if (this.mActionMode == null) {
            this.mImeAdapter.unselect();
        } else {
            this.getContentViewClient().onContextualActionBarShown();
        }
    }

    public boolean getUseDesktopUserAgent() {
        if (this.mNativeContentViewCore != 0) {
            return this.nativeGetUseDesktopUserAgent(this.mNativeContentViewCore);
        }
        return false;
    }

    public void setUseDesktopUserAgent(boolean override, boolean reloadOnChange) {
        if (this.mNativeContentViewCore != 0) {
            this.nativeSetUseDesktopUserAgent(this.mNativeContentViewCore, override, reloadOnChange);
        }
    }

    public void clearSslPreferences() {
        this.nativeClearSslPreferences(this.mNativeContentViewCore);
    }

    public boolean isCrashed() {
        if (this.mNativeContentViewCore == 0) {
            return false;
        }
        return this.nativeCrashed(this.mNativeContentViewCore);
    }

    private boolean isSelectionHandleShowing() {
        return this.mSelectionHandleController != null && this.mSelectionHandleController.isShowing();
    }

    private boolean isInsertionHandleShowing() {
        return this.mInsertionHandleController != null && this.mInsertionHandleController.isShowing();
    }

    private void updateTextHandlesForGesture(int type) {
        switch (type) {
            case 1: 
            case 6: 
            case 9: 
            case 11: {
                this.temporarilyHideTextHandles();
                break;
            }
        }
    }

    private void temporarilyHideTextHandles() {
        if (this.isSelectionHandleShowing() && !this.mSelectionHandleController.isDragging()) {
            this.mSelectionHandleController.setHandleVisibility(4);
        }
        if (this.isInsertionHandleShowing() && !this.mInsertionHandleController.isDragging()) {
            this.mInsertionHandleController.setHandleVisibility(4);
        }
        this.scheduleTextHandleFadeIn();
    }

    private boolean allowTextHandleFadeIn() {
        if (this.mContentViewGestureHandler.isNativeScrolling() || this.mContentViewGestureHandler.isNativePinching()) {
            return false;
        }
        return !this.mPopupZoomer.isShowing();
    }

    private void scheduleTextHandleFadeIn() {
        if (!this.isInsertionHandleShowing() && !this.isSelectionHandleShowing()) {
            return;
        }
        if (this.mDeferredHandleFadeInRunnable == null) {
            this.mDeferredHandleFadeInRunnable = new Runnable(){

                public void run() {
                    if (!ContentViewCore.this.allowTextHandleFadeIn()) {
                        ContentViewCore.this.scheduleTextHandleFadeIn();
                    } else {
                        if (ContentViewCore.this.isSelectionHandleShowing()) {
                            ContentViewCore.this.mSelectionHandleController.beginHandleFadeIn();
                        }
                        if (ContentViewCore.this.isInsertionHandleShowing()) {
                            ContentViewCore.this.mInsertionHandleController.beginHandleFadeIn();
                        }
                    }
                }
            };
        }
        this.mContainerView.removeCallbacks(this.mDeferredHandleFadeInRunnable);
        this.mContainerView.postDelayed(this.mDeferredHandleFadeInRunnable, 300L);
    }

    public void showImeIfNeeded() {
        if (this.mNativeContentViewCore != 0) {
            this.nativeShowImeIfNeeded(this.mNativeContentViewCore);
        }
    }

    @CalledByNative
    private void updateFrameInfo(float scrollOffsetX, float scrollOffsetY, float pageScaleFactor, float minPageScaleFactor, float maxPageScaleFactor, float contentWidth, float contentHeight, float viewportWidth, float viewportHeight, float controlsOffsetYCss, float contentOffsetYCss, float overdrawBottomHeightCss) {
        TraceEvent.instant("ContentViewCore:updateFrameInfo");
        contentWidth = Math.max(contentWidth, this.mRenderCoordinates.fromPixToLocalCss(this.mViewportWidthPix));
        contentHeight = Math.max(contentHeight, this.mRenderCoordinates.fromPixToLocalCss(this.mViewportHeightPix));
        float contentOffsetYPix = this.mRenderCoordinates.fromDipToPix(contentOffsetYCss);
        boolean contentSizeChanged = contentWidth != this.mRenderCoordinates.getContentWidthCss() || contentHeight != this.mRenderCoordinates.getContentHeightCss();
        boolean scaleLimitsChanged = minPageScaleFactor != this.mRenderCoordinates.getMinPageScaleFactor() || maxPageScaleFactor != this.mRenderCoordinates.getMaxPageScaleFactor();
        boolean pageScaleChanged = pageScaleFactor != this.mRenderCoordinates.getPageScaleFactor();
        boolean scrollChanged = pageScaleChanged || scrollOffsetX != this.mRenderCoordinates.getScrollX() || scrollOffsetY != this.mRenderCoordinates.getScrollY();
        boolean contentOffsetChanged = contentOffsetYPix != this.mRenderCoordinates.getContentOffsetYPix();
        boolean needHidePopupZoomer = contentSizeChanged || scrollChanged;
        boolean needUpdateZoomControls = scaleLimitsChanged || scrollChanged;
        boolean needTemporarilyHideHandles = scrollChanged;
        if (needHidePopupZoomer) {
            this.mPopupZoomer.hide(true);
        }
        this.mRenderCoordinates.updateFrameInfo(scrollOffsetX, scrollOffsetY, contentWidth, contentHeight, viewportWidth, viewportHeight, pageScaleFactor, minPageScaleFactor, maxPageScaleFactor, contentOffsetYPix);
        if (needTemporarilyHideHandles) {
            this.temporarilyHideTextHandles();
        }
        if (needUpdateZoomControls) {
            this.mZoomControlsDelegate.updateZoomControls();
        }
        if (contentOffsetChanged) {
            this.updateHandleScreenPositions();
        }
        float deviceScale = this.mRenderCoordinates.getDeviceScaleFactor();
        float controlsOffsetPix = controlsOffsetYCss * deviceScale;
        float overdrawBottomHeightPix = overdrawBottomHeightCss * deviceScale;
        this.getContentViewClient().onOffsetsForFullscreenChanged(controlsOffsetPix, contentOffsetYPix, overdrawBottomHeightPix);
        this.mPendingRendererFrame = true;
        if (this.mBrowserAccessibilityManager != null) {
            this.mBrowserAccessibilityManager.notifyFrameInfoInitialized();
        }
        this.getContentViewClient().onGeometryChanged(-1, null);
    }

    @CalledByNative
    private void updateImeAdapter(int nativeImeAdapterAndroid, int textInputType, String text, int selectionStart, int selectionEnd, int compositionStart, int compositionEnd, boolean showImeIfNeeded) {
        TraceEvent.begin();
        boolean bl = this.mSelectionEditable = textInputType != ImeAdapter.getTextInputTypeNone();
        if (this.mActionMode != null) {
            this.mActionMode.invalidate();
        }
        this.mImeAdapter.attachAndShowIfNeeded(nativeImeAdapterAndroid, textInputType, selectionStart, selectionEnd, showImeIfNeeded);
        if (this.mInputConnection != null) {
            this.mInputConnection.setEditableText(text, selectionStart, selectionEnd, compositionStart, compositionEnd);
        }
        TraceEvent.end();
    }

    @CalledByNative
    private void processImeBatchStateAck(boolean isBegin) {
        if (this.mInputConnection == null) {
            return;
        }
        this.mInputConnection.setIgnoreTextInputStateUpdates(isBegin);
    }

    @CalledByNative
    private void setTitle(String title) {
        this.getContentViewClient().onUpdateTitle(title);
    }

    @CalledByNative
    private void showSelectPopup(String[] items, int[] enabled, boolean multiple, int[] selectedIndices) {
        SelectPopupDialog.show(this, items, enabled, multiple, selectedIndices);
    }

    @CalledByNative
    private void showDisambiguationPopup(Rect targetRect, Bitmap zoomedBitmap) {
        this.mPopupZoomer.setBitmap(zoomedBitmap);
        this.mPopupZoomer.show(targetRect);
        this.temporarilyHideTextHandles();
    }

    @CalledByNative
    private SmoothScroller createSmoothScroller(boolean scrollDown, int mouseEventX, int mouseEventY) {
        return new SmoothScroller(this, scrollDown, mouseEventX, mouseEventY);
    }

    @CalledByNative
    private void onSelectionChanged(String text) {
        this.mLastSelectedText = text;
    }

    @CalledByNative
    private void onSelectionBoundsChanged(Rect anchorRectDip, int anchorDir, Rect focusRectDip, int focusDir, boolean isAnchorFirst) {
        int x1 = anchorRectDip.left;
        int y1 = anchorRectDip.bottom;
        int x2 = focusRectDip.left;
        int y2 = focusRectDip.bottom;
        if (x1 != x2 || y1 != y2 || this.mSelectionHandleController != null && this.mSelectionHandleController.isDragging()) {
            if (this.mInsertionHandleController != null) {
                this.mInsertionHandleController.hide();
            }
            if (isAnchorFirst) {
                this.mStartHandlePoint.setLocalDip(x1, y1);
                this.mEndHandlePoint.setLocalDip(x2, y2);
            } else {
                this.mStartHandlePoint.setLocalDip(x2, y2);
                this.mEndHandlePoint.setLocalDip(x1, y1);
            }
            boolean wereSelectionHandlesShowing = this.getSelectionHandleController().isShowing();
            this.getSelectionHandleController().onSelectionChanged(anchorDir, focusDir);
            this.updateHandleScreenPositions();
            this.mHasSelection = true;
            if (!wereSelectionHandlesShowing && this.getSelectionHandleController().isShowing()) {
                this.mContainerView.performHapticFeedback(0);
            }
        } else {
            this.mUnselectAllOnActionModeDismiss = false;
            this.hideSelectActionBar();
            if (x1 != 0 && y1 != 0 && this.mSelectionEditable) {
                if (this.mSelectionHandleController != null) {
                    this.mSelectionHandleController.hide();
                }
                this.mInsertionHandlePoint.setLocalDip(x1, y1);
                this.getInsertionHandleController().onCursorPositionChanged();
                this.updateHandleScreenPositions();
                InputMethodManager manager = (InputMethodManager)this.getContext().getSystemService("input_method");
                if (manager.isWatchingCursor(this.mContainerView)) {
                    int xPix = (int)this.mInsertionHandlePoint.getXPix();
                    int yPix = (int)this.mInsertionHandlePoint.getYPix();
                    manager.updateCursor(this.mContainerView, xPix, yPix, xPix, yPix);
                }
            } else {
                if (this.mSelectionHandleController != null) {
                    this.mSelectionHandleController.hideAndDisallowAutomaticShowing();
                }
                if (this.mInsertionHandleController != null) {
                    this.mInsertionHandleController.hideAndDisallowAutomaticShowing();
                }
            }
            this.mHasSelection = false;
        }
        if (this.isSelectionHandleShowing() || this.isInsertionHandleShowing()) {
            this.mPositionObserver.addListener(this.mPositionListener);
        }
    }

    @CalledByNative
    private static void onEvaluateJavaScriptResult(String jsonResult, JavaScriptCallback callback) {
        callback.handleJavaScriptResult(jsonResult);
    }

    @CalledByNative
    private void showPastePopup(int xDip, int yDip) {
        this.mInsertionHandlePoint.setLocalDip(xDip, yDip);
        this.getInsertionHandleController().showHandle();
        this.updateHandleScreenPositions();
        this.getInsertionHandleController().showHandleWithPastePopup();
    }

    @CalledByNative
    private void onRenderProcessSwap(int oldPid, int newPid) {
        assert (this.mPid == oldPid || this.mPid == newPid);
        if (this.mAttachedToWindow && oldPid != newPid) {
            ChildProcessLauncher.unbindAsHighPriority(oldPid);
            ChildProcessLauncher.bindAsHighPriority(newPid);
        }
        ChildProcessLauncher.removeInitialBinding(newPid);
        this.mPid = newPid;
    }

    @CalledByNative
    private void onWebContentsConnected() {
        this.attachImeAdapter();
    }

    @CalledByNative
    private void onWebContentsSwapped() {
        this.attachImeAdapter();
    }

    public void attachImeAdapter() {
        if (this.mImeAdapter != null && this.mNativeContentViewCore != 0) {
            this.mImeAdapter.attach(this.nativeGetNativeImeAdapter(this.mNativeContentViewCore));
        }
    }

    public boolean needsReload() {
        return this.mNativeContentViewCore != 0 && this.nativeNeedsReload(this.mNativeContentViewCore);
    }

    @CalledByNative
    public boolean hasFocus() {
        return this.mContainerView.hasFocus();
    }

    public boolean pinchByDelta(float delta) {
        if (this.mNativeContentViewCore == 0) {
            return false;
        }
        long timeMs = System.currentTimeMillis();
        int xPix = this.getViewportWidthPix() / 2;
        int yPix = this.getViewportHeightPix() / 2;
        this.getContentViewGestureHandler().pinchBegin(timeMs, xPix, yPix);
        this.getContentViewGestureHandler().pinchBy(timeMs, xPix, yPix, delta);
        this.getContentViewGestureHandler().pinchEnd(timeMs);
        return true;
    }

    @Override
    public void invokeZoomPicker() {
        this.mZoomControlsDelegate.invokeZoomPicker();
    }

    public void addJavascriptInterface(Object object, String name) {
        this.addPossiblyUnsafeJavascriptInterface(object, name, JavascriptInterface.class);
    }

    public void addPossiblyUnsafeJavascriptInterface(Object object, String name, Class<? extends Annotation> requiredAnnotation) {
        if (this.mNativeContentViewCore != 0 && object != null) {
            this.mJavaScriptInterfaces.put(name, object);
            this.nativeAddJavascriptInterface(this.mNativeContentViewCore, object, name, requiredAnnotation, this.mRetainedJavaScriptObjects);
        }
    }

    public void removeJavascriptInterface(String name) {
        this.mJavaScriptInterfaces.remove(name);
        if (this.mNativeContentViewCore != 0) {
            this.nativeRemoveJavascriptInterface(this.mNativeContentViewCore, name);
        }
    }

    public float getScale() {
        return this.mRenderCoordinates.getPageScaleFactor();
    }

    public boolean isReady() {
        return this.nativeIsRenderWidgetHostViewReady(this.mNativeContentViewCore);
    }

    @CalledByNative
    private void startContentIntent(String contentUrl) {
        this.getContentViewClient().onStartContentIntent(this.getContext(), contentUrl);
    }

    @Override
    public void onAccessibilityStateChanged(boolean enabled) {
        this.setAccessibilityState(enabled);
    }

    public boolean supportsAccessibilityAction(int action) {
        return this.mAccessibilityInjector.supportsAccessibilityAction(action);
    }

    public boolean performAccessibilityAction(int action, Bundle arguments) {
        if (this.mAccessibilityInjector.supportsAccessibilityAction(action)) {
            return this.mAccessibilityInjector.performAccessibilityAction(action, arguments);
        }
        return false;
    }

    public void setBrowserAccessibilityManager(BrowserAccessibilityManager manager) {
        this.mBrowserAccessibilityManager = manager;
    }

    public BrowserAccessibilityManager getBrowserAccessibilityManager() {
        return this.mBrowserAccessibilityManager;
    }

    public AccessibilityNodeProvider getAccessibilityNodeProvider() {
        if (this.mBrowserAccessibilityManager != null) {
            return this.mBrowserAccessibilityManager.getAccessibilityNodeProvider();
        }
        if (this.mNativeAccessibilityAllowed && !this.mNativeAccessibilityEnabled && this.mNativeContentViewCore != 0 && Build.VERSION.SDK_INT >= 16) {
            this.mNativeAccessibilityEnabled = true;
            this.nativeSetAccessibilityEnabled(this.mNativeContentViewCore, true);
        }
        return null;
    }

    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        this.mAccessibilityInjector.onInitializeAccessibilityNodeInfo(info);
    }

    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        event.setClassName(this.getClass().getName());
        event.setScrollX(this.mRenderCoordinates.getScrollXPixInt());
        event.setScrollY(this.mRenderCoordinates.getScrollYPixInt());
        int maxScrollXPix = Math.max(0, this.mRenderCoordinates.getMaxHorizontalScrollPixInt());
        int maxScrollYPix = Math.max(0, this.mRenderCoordinates.getMaxVerticalScrollPixInt());
        event.setScrollable(maxScrollXPix > 0 || maxScrollYPix > 0);
        int SDK_VERSION_REQUIRED_TO_SET_SCROLL = 15;
        if (Build.VERSION.SDK_INT >= 15) {
            event.setMaxScrollX(maxScrollXPix);
            event.setMaxScrollY(maxScrollYPix);
        }
    }

    public boolean isDeviceAccessibilityScriptInjectionEnabled() {
        try {
            if (!this.mContentSettings.getJavaScriptEnabled()) {
                return false;
            }
            int result = this.getContext().checkCallingOrSelfPermission("android.permission.INTERNET");
            if (result != 0) {
                return false;
            }
            Field field = Settings.Secure.class.getField("ACCESSIBILITY_SCRIPT_INJECTION");
            field.setAccessible(true);
            String accessibilityScriptInjection = (String)field.get(null);
            ContentResolver contentResolver = this.getContext().getContentResolver();
            if (this.mAccessibilityScriptInjectionObserver == null) {
                ContentObserver contentObserver = new ContentObserver(new Handler()){

                    public void onChange(boolean selfChange, Uri uri) {
                        ContentViewCore.this.setAccessibilityState(ContentViewCore.this.mAccessibilityManager.isEnabled());
                    }
                };
                contentResolver.registerContentObserver(Settings.Secure.getUriFor(accessibilityScriptInjection), false, contentObserver);
                this.mAccessibilityScriptInjectionObserver = contentObserver;
            }
            return Settings.Secure.getInt(contentResolver, accessibilityScriptInjection, 0) == 1;
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    public boolean isInjectingAccessibilityScript() {
        return this.mAccessibilityInjector.accessibilityIsAvailable();
    }

    public void setAccessibilityState(boolean state) {
        if (!state) {
            this.setInjectedAccessibility(false);
            this.mNativeAccessibilityAllowed = false;
        } else {
            boolean useScriptInjection = this.isDeviceAccessibilityScriptInjectionEnabled();
            this.setInjectedAccessibility(useScriptInjection);
            this.mNativeAccessibilityAllowed = !useScriptInjection;
        }
    }

    public void setInjectedAccessibility(boolean enabled) {
        this.mAccessibilityInjector.addOrRemoveAccessibilityApisIfNecessary();
        this.mAccessibilityInjector.setScriptEnabled(enabled);
    }

    public void stopCurrentAccessibilityNotifications() {
        this.mAccessibilityInjector.onPageLostFocus();
    }

    public void exitFullscreen() {
        this.nativeExitFullscreen(this.mNativeContentViewCore);
    }

    public void updateTopControlsState(boolean enableHiding, boolean enableShowing, boolean animate) {
        this.nativeUpdateTopControlsState(this.mNativeContentViewCore, enableHiding, enableShowing, animate);
    }

    @CalledByNative
    private void addToNavigationHistory(Object history, int index, String url, String virtualUrl, String originalUrl, String title, Bitmap favicon) {
        NavigationEntry entry = new NavigationEntry(index, url, virtualUrl, originalUrl, title, favicon);
        ((NavigationHistory)history).addEntry(entry);
    }

    public NavigationHistory getNavigationHistory() {
        NavigationHistory history = new NavigationHistory();
        if (this.mNativeContentViewCore != 0) {
            int currentIndex = this.nativeGetNavigationHistory(this.mNativeContentViewCore, history);
            history.setCurrentEntryIndex(currentIndex);
        }
        return history;
    }

    @Override
    public NavigationHistory getDirectedNavigationHistory(boolean isForward, int itemLimit) {
        NavigationHistory history = new NavigationHistory();
        if (this.mNativeContentViewCore != 0) {
            this.nativeGetDirectedNavigationHistory(this.mNativeContentViewCore, history, isForward, itemLimit);
        }
        return history;
    }

    public String getOriginalUrlForActiveNavigationEntry() {
        if (this.mNativeContentViewCore != 0) {
            return this.nativeGetOriginalUrlForActiveNavigationEntry(this.mNativeContentViewCore);
        }
        return "";
    }

    public RenderCoordinates getRenderCoordinates() {
        return this.mRenderCoordinates;
    }

    @CalledByNative
    private static Rect createRect(int x, int y, int right, int bottom) {
        return new Rect(x, y, right, bottom);
    }

    public void attachExternalVideoSurface(int playerId, Surface surface) {
        if (this.mNativeContentViewCore != 0) {
            this.nativeAttachExternalVideoSurface(this.mNativeContentViewCore, playerId, surface);
        }
    }

    public void detachExternalVideoSurface(int playerId) {
        if (this.mNativeContentViewCore != 0) {
            this.nativeDetachExternalVideoSurface(this.mNativeContentViewCore, playerId);
        }
    }

    private boolean onAnimate(long frameTimeMicros) {
        if (this.mNativeContentViewCore == 0) {
            return false;
        }
        return this.nativeOnAnimate(this.mNativeContentViewCore, frameTimeMicros);
    }

    private void animateIfNecessary(long frameTimeMicros) {
        if (this.mNeedAnimate) {
            this.mNeedAnimate = this.onAnimate(frameTimeMicros);
            if (!this.mNeedAnimate) {
                this.setVSyncNotificationEnabled(false);
            }
        }
    }

    @CalledByNative
    private void notifyExternalSurface(int playerId, boolean isRequest, float x, float y, float width, float height) {
        if (isRequest) {
            this.getContentViewClient().onExternalVideoSurfaceRequested(playerId);
        }
        this.getContentViewClient().onGeometryChanged(playerId, new RectF(x, y, x + width, y + height));
    }

    private boolean offerGestureToEmbedder(int type) {
        if (type == 5) {
            return this.mContainerView.performLongClick();
        }
        return false;
    }

    private native int nativeInit(boolean var1, int var2, int var3, int var4);

    @CalledByNative
    private ContentVideoViewClient getContentVideoViewClient() {
        return this.mContentViewClient.getContentVideoViewClient();
    }

    @CalledByNative
    private boolean shouldBlockMediaRequest(String url) {
        return this.mContentViewClient.shouldBlockMediaRequest(url);
    }

    private native void nativeOnJavaContentViewCoreDestroyed(int var1);

    private native void nativeLoadUrl(int var1, String var2, int var3, int var4, int var5, String var6, byte[] var7, String var8, String var9, boolean var10);

    private native String nativeGetURL(int var1);

    private native String nativeGetTitle(int var1);

    private native void nativeShowInterstitialPage(int var1, String var2, int var3);

    private native boolean nativeIsShowingInterstitialPage(int var1);

    private native boolean nativeIsIncognito(int var1);

    private native boolean nativeCrashed(int var1);

    private native void nativeSetFocus(int var1, boolean var2);

    private native void nativeSendOrientationChangeEvent(int var1, int var2);

    private native boolean nativeSendTouchEvent(int var1, long var2, int var4, TouchPoint[] var5);

    private native int nativeSendMouseMoveEvent(int var1, long var2, float var4, float var5);

    private native int nativeSendMouseWheelEvent(int var1, long var2, float var4, float var5, float var6);

    private native void nativeScrollBegin(int var1, long var2, float var4, float var5);

    private native void nativeScrollEnd(int var1, long var2);

    private native void nativeScrollBy(int var1, long var2, float var4, float var5, float var6, float var7, boolean var8);

    private native void nativeFlingStart(int var1, long var2, float var4, float var5, float var6, float var7);

    private native void nativeFlingCancel(int var1, long var2);

    private native void nativeSingleTap(int var1, long var2, float var4, float var5, boolean var6);

    private native void nativeSingleTapUnconfirmed(int var1, long var2, float var4, float var5);

    private native void nativeShowPressState(int var1, long var2, float var4, float var5);

    private native void nativeShowPressCancel(int var1, long var2, float var4, float var5);

    private native void nativeDoubleTap(int var1, long var2, float var4, float var5);

    private native void nativeLongPress(int var1, long var2, float var4, float var5, boolean var6);

    private native void nativeLongTap(int var1, long var2, float var4, float var5, boolean var6);

    private native void nativePinchBegin(int var1, long var2, float var4, float var5);

    private native void nativePinchEnd(int var1, long var2);

    private native void nativePinchBy(int var1, long var2, float var4, float var5, float var6, boolean var7);

    private native void nativeSelectBetweenCoordinates(int var1, float var2, float var3, float var4, float var5);

    private native void nativeMoveCaret(int var1, float var2, float var3);

    private native boolean nativeCanGoBack(int var1);

    private native boolean nativeCanGoForward(int var1);

    private native boolean nativeCanGoToOffset(int var1, int var2);

    private native void nativeGoBack(int var1);

    private native void nativeGoForward(int var1);

    private native void nativeGoToOffset(int var1, int var2);

    private native void nativeGoToNavigationIndex(int var1, int var2);

    private native void nativeStopLoading(int var1);

    private native void nativeReload(int var1);

    private native void nativeCancelPendingReload(int var1);

    private native void nativeContinuePendingReload(int var1);

    private native void nativeSelectPopupMenuItems(int var1, int[] var2);

    private native void nativeScrollFocusedEditableNodeIntoView(int var1);

    private native void nativeUndoScrollFocusedEditableNodeIntoView(int var1);

    private native boolean nativeNeedsReload(int var1);

    private native void nativeClearHistory(int var1);

    private native void nativeEvaluateJavaScript(int var1, String var2, JavaScriptCallback var3, boolean var4);

    private native int nativeGetNativeImeAdapter(int var1);

    private native int nativeGetCurrentRenderProcessId(int var1);

    private native int nativeGetBackgroundColor(int var1);

    private native void nativeOnShow(int var1);

    private native void nativeOnHide(int var1);

    private native void nativeSetUseDesktopUserAgent(int var1, boolean var2, boolean var3);

    private native boolean nativeGetUseDesktopUserAgent(int var1);

    private native void nativeClearSslPreferences(int var1);

    private native void nativeAddJavascriptInterface(int var1, Object var2, String var3, Class var4, HashSet<Object> var5);

    private native void nativeRemoveJavascriptInterface(int var1, String var2);

    private native int nativeGetNavigationHistory(int var1, Object var2);

    private native void nativeGetDirectedNavigationHistory(int var1, Object var2, boolean var3, int var4);

    private native String nativeGetOriginalUrlForActiveNavigationEntry(int var1);

    private native void nativeUpdateVSyncParameters(int var1, long var2, long var4);

    private native void nativeOnVSync(int var1, long var2);

    private native boolean nativeOnAnimate(int var1, long var2);

    private native boolean nativePopulateBitmapFromCompositor(int var1, Bitmap var2);

    private native void nativeWasResized(int var1);

    private native boolean nativeIsRenderWidgetHostViewReady(int var1);

    private native void nativeExitFullscreen(int var1);

    private native void nativeUpdateTopControlsState(int var1, boolean var2, boolean var3, boolean var4);

    private native void nativeShowImeIfNeeded(int var1);

    private native void nativeAttachExternalVideoSurface(int var1, int var2, Surface var3);

    private native void nativeDetachExternalVideoSurface(int var1, int var2);

    private native void nativeSetAccessibilityEnabled(int var1, boolean var2);

    public static interface JavaScriptCallback {
        public void handleJavaScriptResult(String var1);
    }

    public static interface UpdateFrameInfoListener {
        public void onFrameInfoUpdated(float var1);
    }

    public static interface ZoomControlsDelegate {
        public void invokeZoomPicker();

        public void dismissZoomPicker();

        public void updateZoomControls();
    }

    public static interface GestureStateListener {
        public void onPinchGestureStart();

        public void onPinchGestureEnd();

        public void onFlingStartGesture(int var1, int var2);

        public void onFlingCancelGesture();

        public void onUnhandledFlingStartEvent();

        public void onScrollUpdateGestureConsumed();
    }

    public static interface InternalAccessDelegate {
        public boolean drawChild(Canvas var1, View var2, long var3);

        public boolean super_onKeyUp(int var1, KeyEvent var2);

        public boolean super_dispatchKeyEventPreIme(KeyEvent var1);

        public boolean super_dispatchKeyEvent(KeyEvent var1);

        public boolean super_onGenericMotionEvent(MotionEvent var1);

        public void super_onConfigurationChanged(Configuration var1);

        public boolean awakenScrollBars();

        public boolean super_awakenScrollBars(int var1, boolean var2);
    }
}

